/*************************************************************************
 *
 *  $RCSfile: PGPMainDialog.java,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package com.sun.star.pgp.ui;

import java.util.ResourceBundle;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;
import javax.swing.*;
import javax.swing.event.*;

import com.sun.star.pgp.IPGP;
import com.sun.star.pgp.UserInfo;


//==================================================================================================
public class PGPMainDialog extends JPanel
{
	private static final boolean DEBUG = true;

	private ResourceBundle m_aBundle= null;
	private JList		_recipientsList;
	private JCheckBox	_convCheck;
	
	//______________________________________________________________________________________________
	public boolean useConvEncryption()
	{
		return _convCheck.isSelected();
	}
	//______________________________________________________________________________________________
	public UserInfo[] getRecipients()
	{
		Object objs[]    = _recipientsList.getSelectedValues();
		UserInfo infos[] = new UserInfo[objs.length];
		
		for ( int nPos = 0; nPos < infos.length; ++nPos )
			infos[nPos] = (UserInfo)objs[nPos];
		
		return infos;
	}

	// for internale use ( this file)
	boolean hasSelection()
	{
		Object objs[] = _recipientsList.getSelectedValues();
		return objs.length > 0 ? true : false;
	}
	//----------------------------------------------------------------------------------------------
	PGPMainDialog(ResourceBundle bundle, IPGP pgp, String recipientsMail[] )
	{
		
		super( new GridBagLayout() );
		m_aBundle= bundle;
		Insets insets = new Insets( 2, 2, 2, 2 );

		// Recipients d1_label1= "Recipients"
		add( new JLabel( m_aBundle.getString("d1_label1") ),
			 new JXGridBagConstraints( 0, 0, 2, 1, 1.0, 0.0,
									   GridBagConstraints.WEST, GridBagConstraints.NONE,
									   insets, 0, 0 ) );

		// Recipients list
		_recipientsList = new JList();
		
		UserInfo infos[] = pgp.getPublicUserInfos();
		_recipientsList.setListData( infos );

		UserInfo info = null;
		for ( int nPos = 0; nPos < recipientsMail.length; ++nPos )
		{
			info = UserInfo.getInfoFromEMail( recipientsMail[nPos], infos );
			if (info != null)
				_recipientsList.setSelectedValue( info, false );
		}
		if (info != null)
			_recipientsList.setSelectedValue( info, true ); // scroll to last selected value
		//d1_toolTip1="Select Recipients of your EMail"
		_recipientsList.setToolTipText( m_aBundle.getString("d1_toolTip1") );
		add( new JScrollPane( _recipientsList,
							  JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,
							  JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED ),
			 new JXGridBagConstraints( 0, 1, 2, 1, 1.0, 1.0,
									   GridBagConstraints.WEST, GridBagConstraints.BOTH,
									   insets, 0, 0 ) );

		// encryption type checkbox
		// d1_checkBox1= "Use Conventional Encryption"
		_convCheck = new JCheckBox( m_aBundle.getString("d1_checkBox1"));
		// d1_toolTip2= "Check this if you don't wnat public key encryption"
		_convCheck.setToolTipText( m_aBundle.getString("d1_toolTip2") );
		add( _convCheck,
			 new JXGridBagConstraints( 0, 2, 2, 1, 1.0, 0.0,
									   GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL,
									   insets, 0, 0 ) );
	}

	//##############################################################################################

	
	//==============================================================================================
	public   static PGPMainDialog invoke( ResourceBundle bundle,IPGP pgp, String recipientsMail[] )
	{
		PGPMainDialog dialog = new PGPMainDialog( bundle, pgp, recipientsMail );

		Object obj[]={ bundle.getString("g_ok"), bundle.getString("g_cancel")};
		JOptionPane pane= new JOptionPane(dialog, JOptionPane.QUESTION_MESSAGE,
										  JOptionPane.OK_CANCEL_OPTION, null,
										  obj, obj[0] );
		// d1_title1="Choose Recipients"		
		JDialog dlg= pane.createDialog(null, bundle.getString("d1_title1"));
		dlg.show();

		if( obj[0].equals( pane.getValue()) )
		{
			//check for a selection
			if(dialog.hasSelection() || dialog.useConvEncryption())
				return dialog;
			return
				null;
		}
		else
			return null;
	}
}
