/*************************************************************************
 *
 *  $RCSfile: ucbhelper_content.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:53 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _UCBHELPER_CONTENT_HXX_
#include <ucbhelper/content.hxx>
#endif


OSimpleContentIdentifier::OSimpleContentIdentifier( const OUString& rIdentifier, const OUString& rProviderScheme )
: Identifier( rIdentifier ), ProviderScheme( rProviderScheme )
{
}

#if	defined(TF_TYPE) || (SUPD >= 564)
Any OSimpleContentIdentifier::queryInterface( const Type &type ) throw( RuntimeException )
{
	Any	aRet = ::cppu::queryInterface(
		type, SAL_STATIC_CAST( XContentIdentifier*, this )	);

	return (aRet.hasValue() ? aRet : OWeakObject::queryInterface( type ));
}
#else
sal_Bool OSimpleContentIdentifier::queryInterface( const Uik& type, Any& ifc ) throw( RuntimeException )
{	
	return ::com::sun::star::uno::queryInterface(
		type, ifc, SAL_STATIC_CAST( XContentIdentifier*, this )	)
		|| OWeakObject::queryInterface( type, ifc );
}
#endif

void OSimpleContentIdentifier::acquire() throw(RuntimeException)
{
	OWeakObject::acquire();
}

void OSimpleContentIdentifier::release() throw(RuntimeException)
{
	OWeakObject::release();
}

OUString OSimpleContentIdentifier::getContentIdentifier() throw(RuntimeException)
{
	return Identifier;
}
    
OUString OSimpleContentIdentifier::getContentProviderScheme() throw(RuntimeException)
{
	return ProviderScheme;
}


//------------------------------------------------------------
//	Class methods
//------------------------------------------------------------

void OContent::broadcastContentEvent( const ContentEvent & crEvent )
{
	// listeners may remove themselves when called this way

	list< Reference< XContentEventListener > > aListenersCopy = m_aContentListeners;

	for( list< Reference< XContentEventListener > >::iterator it = aListenersCopy.begin();
		 it != aListenersCopy.end(); ++it )
		(*it)->contentEvent( crEvent );
}

//------------------------------------------------------------

Sequence< PropertyChangeEvent > OContent::matchListenerEvents( const Sequence< PropertyChangeEvent >& crEvents, const PropertyChangeListenerInfo & rInfo )
{
	long nMatches = 0;
	Sequence< PropertyChangeEvent >	aResult;

	for( int i = 0; i < crEvents.getLength(); i++ )
	{
		sal_Bool	bMatch = sal_False;

		if ( crEvents.getConstArray()[ i ].PropertyHandle >= 0 )
		{
			for ( list< PropertyChangeEventInfo >::const_iterator it = rInfo.aEventInfos.begin(); it != rInfo.aEventInfos.end() && !bMatch; it++ )
				bMatch = ( it->Handle == crEvents.getConstArray()[ i ].PropertyHandle );
		}
		else 
		// if ( !bMatch )
		{
			for ( list< PropertyChangeEventInfo >::const_iterator it = rInfo.aEventInfos.begin(); it != rInfo.aEventInfos.end() && !bMatch; it++ )
				bMatch = ( it->Name == crEvents.getConstArray()[ i ].PropertyName );
		}

		if ( bMatch )
		{
			aResult.realloc( nMatches + 1 );
			aResult[ nMatches++ ] = crEvents.getConstArray()[ i ];
		}
	}

	return aResult;
}

//------------------------------------------------------------

void OContent::broadcastPropertiesChangeEvents( const Sequence< PropertyChangeEvent >& crEvents )
{
	// listeners may remove themselves when called this way

	list< PropertyChangeListenerInfo > aListenersCopy = m_aPropertyChangeListeners;

	for( list< PropertyChangeListenerInfo >::iterator it = aListenersCopy.begin(); it != aListenersCopy.end(); it++ )
	{
		Sequence< PropertyChangeEvent >	aEvents = matchListenerEvents( crEvents, *it );

		if ( aEvents.getLength() )
			it->xListener->propertiesChange( aEvents );
	}
}

//------------------------------------------------------------
//	XInterface
//------------------------------------------------------------

void OContent::acquire() throw(RuntimeException)
{
	OWeakObject::acquire();
}

//------------------------------------------------------------

void OContent::release() throw(RuntimeException)
{
#if	defined(TF_TYPE) || (SUPD >= 564)
	if( m_refCount == 1 )
#else
	if( m_refCount.referenced() == 1 )
#endif
		dispose();
	OWeakObject::release();
}

//------------------------------------------------------------

#if	defined(TF_TYPE) || (SUPD >= 564)
Any OContent::queryInterface( const Type &type ) throw( RuntimeException )
{
	Any	aRet = ::cppu::queryInterface(
		type,
		SAL_STATIC_CAST( XContent*, this ),
		SAL_STATIC_CAST( XCommandTaskProcessor*, this ),
		SAL_STATIC_CAST( XPropertyTaskProcessor*, this ),
		SAL_STATIC_CAST( XCommandInfo*, this ),
		SAL_STATIC_CAST( XPropertySetInfo*, this )
		);

	return (aRet.hasValue() ? aRet : OWeakObject::queryInterface( type ));
}
#else
sal_Bool OContent::queryInterface( const Uik& type, Any& ifc ) throw( RuntimeException )
{
	return ::com::sun::star::uno::queryInterface(
		type, ifc,
		SAL_STATIC_CAST( XContent*, this ),
		SAL_STATIC_CAST( XCommandTaskProcessor*, this ),
		SAL_STATIC_CAST( XPropertyTaskProcessor*, this ),
		SAL_STATIC_CAST( XCommandInfo*, this ),
		SAL_STATIC_CAST( XPropertySetInfo*, this )
		)
		|| OWeakObject::queryInterface( type, ifc );
}
#endif

//------------------------------------------------------------
//	XComponent
//------------------------------------------------------------

void OContent::addEventListener( const Reference< XEventListener >& xListener ) throw()
{
	Guard< Mutex >	aGuard( m_aComponentListeners );

	m_aComponentListeners.push_back( xListener );
}

//------------------------------------------------------------

void OContent::removeEventListener( const Reference< XEventListener >& xListener ) throw()
{
	Guard< Mutex > aGuard( m_aComponentListeners );

	m_aComponentListeners.remove( xListener );
}

//------------------------------------------------------------

void OContent::dispose() throw()
{
	Guard< Mutex > aGuard( m_aComponentListeners );

	EventObject aEvent;
	aEvent.Source = (OWeakObject*)this;

	while( m_aComponentListeners.size() )
	{
		Reference< XEventListener > xListener = m_aComponentListeners.front();
		xListener->disposing( aEvent );
		m_aComponentListeners.pop_front();
	}
}

//------------------------------------------------------------
//	XContent
//------------------------------------------------------------

void OContent::addContentEventListener( const Reference< XContentEventListener >& rListener ) throw()
{
	Guard< Mutex > aGuard( m_aContentListeners );

	m_aContentListeners.push_back( rListener );
}

//------------------------------------------------------------

void OContent::removeContentEventListener( const Reference< XContentEventListener >& rListener ) throw()
{
	Guard< Mutex > aGuard( m_aContentListeners );

	m_aContentListeners.remove( rListener );
}

//------------------------------------------------------------
//	XCommandTaskProcessor
//------------------------------------------------------------

Reference< XCommandInfo > OContent::getCommandsInfo() throw()
{
	return (XCommandInfo*)this;
}

//------------------------------------------------------------
//	XCommandInfo
//------------------------------------------------------------

CommandInfo OContent::getCommandInfoByName( const rtl::OUString& rName )
		throw( UnsupportedCommandException )
{
	const Sequence< CommandInfo >& rCommands = getCommands();
	for( int i = 0; i < rCommands.getLength(); i++ )
		if( rCommands.getConstArray()[ i ].Name == rName )
			return CommandInfo( rCommands.getConstArray()[ i ] );
	throw UnsupportedCommandException();
}

//------------------------------------------------------------

CommandInfo OContent::getCommandInfoByHandle( long nHandle )
		throw( UnsupportedCommandException )
{
	const Sequence< CommandInfo >& rCommands = getCommands();
	for( int i = 0; i < rCommands.getLength(); i++ )
		if( rCommands.getConstArray()[ i ].Handle == nHandle )
			return CommandInfo( rCommands.getConstArray()[ i ] );
	throw UnsupportedCommandException();
}

//------------------------------------------------------------

sal_Bool OContent::hasCommandByName( const rtl::OUString& rName ) throw()
{
	const Sequence< CommandInfo >& rCommands = getCommands();
	for( int i = 0; i < rCommands.getLength(); i++ )
		if( rCommands.getConstArray()[ i ].Name == rName )
			return sal_True;
	return sal_False;
}

//------------------------------------------------------------

sal_Bool OContent::hasCommandByHandle( long nHandle ) throw()
{
	const Sequence< CommandInfo >& rCommands = getCommands();
	for( int i = 0; i < rCommands.getLength(); i++ )
		if( rCommands.getConstArray()[ i ].Handle == nHandle )
			return sal_True;
	return sal_False;
}

//------------------------------------------------------------
//	XPropertyTaskProcessor
//------------------------------------------------------------

Property OContent::getPropertyByName( const OUString& Name ) throw( ::com::sun::star::beans::UnknownPropertyException )
{
	const Sequence< Property >& rList = getProperties();
	for( int i = 0; i < rList.getLength(); i++ )
	{
		if( rList.getConstArray()[i].Name == Name )
			return rList.getConstArray()[i];
	}
	throw UnknownPropertyException();
}

//------------------------------------------------------------
//	XPropertySetInfo
//------------------------------------------------------------

sal_Bool OContent::hasPropertyByName( const OUString& Name ) throw()
{
	const Sequence< Property >& rList = getProperties();
	for( int i = 0; i < rList.getLength(); i++ )
	{
		if( rList.getConstArray()[i].Name == Name )
			return sal_True;
	}
	return sal_False;
}

Reference< XPropertySetInfo > OContent::getPropertySetInfo() throw()
{
	return this;
}

//------------------------------------------------------------

void OContent::addPropertiesChangeListener( const Sequence< OUString >& crNames, const Reference< XPropertiesChangeListener >& xListener ) throw()
{
	if( xListener.is() )
	{
		Guard< Mutex > aGuard( m_aPropertyChangeListeners );

		PropertyChangeListenerInfo aInfo;
		aInfo.xListener = xListener;

		for ( int i = 0; i < crNames.getLength(); i++ )
		{
			PropertyChangeEventInfo	aEventInfo;

			aEventInfo.Handle = -1;
			aEventInfo.Name = crNames[ i ];

			aInfo.aEventInfos.push_back( aEventInfo );
		}

		m_aPropertyChangeListeners.push_back( aInfo );
	}
}

//------------------------------------------------------------

void OContent::removePropertiesChangeListener( const Sequence< OUString >& Names, const Reference< ::com::sun::star::beans::XPropertiesChangeListener >& xListener ) throw()
{
	if( xListener.is() )
	{
		Guard< Mutex > aGuard( m_aPropertyChangeListeners );
	
		PropertyChangeListenerInfo aInfo;
		aInfo.xListener = xListener;

		m_aPropertyChangeListeners.remove( aInfo );
	}
}

