/*************************************************************************
 *
 *  $RCSfile: vfscontent.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:53 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop

#ifndef _COM_SUN_STAR_UCB_CONTENTACTION_HPP_
#include <com/sun/star/ucb/ContentAction.hpp>
#endif

#include <vfscontent.hxx>
#include <vfshelper.hxx>
#include <vfsfilecontent.hxx>
#include <vfsrootcontent.hxx>
#include <vfscommandtask.hxx>
#include <vfspropertytask.hxx>
#include <tools/debug.hxx>
#include <sot/storinfo.hxx>
#include <tools/datetime.hxx>


/* inline */ UNODateTime GetUNODateTime( const Date& rDate, const Time& rTime )
{
	UNODateTime aDateTime;

	aDateTime.HundredthSeconds = rTime.Get100Sec();
	aDateTime.Seconds = rTime.GetSec();
	aDateTime.Minutes = rTime.GetMin();
	aDateTime.Hours = rTime.GetHour();

	aDateTime.Day = rDate.GetDay();
	aDateTime.Month = rDate.GetMonth();
	aDateTime.Year = rDate.GetYear();

	return aDateTime;
}

inline Date GetDate( const UNODateTime& rDateTime )
{
	Date aDate;

	aDate.SetDay( rDateTime.Day );
	aDate.SetMonth(rDateTime.Month );
	aDate.SetYear(rDateTime.Year );

	return aDate;
}

inline Time GetTime( const UNODateTime& rDateTime )
{
	Time aTime;

	aTime.Set100Sec( rDateTime.HundredthSeconds );
	aTime.SetSec( rDateTime.Seconds );
	aTime.SetMin( rDateTime.Minutes );
	aTime.SetHour( rDateTime.Hours );

	return aTime;
}


// =====================================================
// VFSContent
// =====================================================
VFSContent::VFSContent( const OUString& rIdentifier, sal_Int32 nAttrs, VFSRootContent* pRoot )
{
	bReadExtendedAttributes = sal_True;
	bStoreExtendedAttributes = sal_False;
	bStoreSimpleAttributes = sal_False;
	bIsValid = sal_True;
	bIsOpen = sal_False;

	GetSimpleAttributes().bIsDocument = (nAttrs & STORE_ATTRIB_ISFILE ) ? sal_True : sal_False;
	GetSimpleAttributes().bIsFolder = (nAttrs & STORE_ATTRIB_ISDIR) ? sal_True : sal_False;
	GetSimpleAttributes().bIsReadOnly = (nAttrs & VFSSTORE_ATTRIB_READONLY ) ? sal_True : sal_False;
	GetSimpleAttributes().bIsHidden = (nAttrs & VFSSTORE_ATTRIB_HIDDEN ) ? sal_True : sal_False;
	GetSimpleAttributes().bIsArchive = (nAttrs & VFSSTORE_ATTRIB_ARCHIVE ) ? sal_True : sal_False;

	pRootContent = pRoot;
	xIdentifier = new OSimpleContentIdentifier( rIdentifier, VFSSCHEME );
}

VFSContent::~VFSContent()
{
	if ( IsValid() )
	{
		if ( bStoreSimpleAttributes )
			StoreSimpleAttributes();
		if ( bStoreExtendedAttributes )
			StoreExtendedAttributes();
	}

	if ( GetRoot() )
		GetRoot()->RemoveContent( this );
}

void VFSContent::CreatePathAndName( const String& rIdentifier, String& rPath, String& rName, const char* pPre )
{
	String aIdentifier ( rIdentifier );

	xub_StrLen nSep = aIdentifier.Search( '?' );
	if ( nSep != STRING_NOTFOUND )
		aIdentifier.Erase( 0, nSep+1 );

	if ( pPre )
		aIdentifier.Insert( pPre, 0 );
	
	nSep = aIdentifier.SearchBackward( '/' );
	if ( nSep != STRING_NOTFOUND )
	{
		rPath = aIdentifier.Copy( 0, nSep+1 );	// without leading '/'
		rName = aIdentifier.Copy( nSep+1 );
		if ( !rName.Len() && rPath.Len() )
		{
			nSep = aIdentifier.SearchBackward( '/', nSep-1 );
			if ( nSep != STRING_NOTFOUND )
			{
				rPath = aIdentifier.Copy( 0, nSep+1 );	// without leading '/'
				rName = aIdentifier.Copy( nSep+1 );
			}
		}
	}
	else
	{
		rPath.Erase();
		rName.Erase();
	}
}

UNODateTime VFSContent::GetCurrentDateTime()
{
	Date aDate;
	Time aTime;
	DateTime aDateTime( aDate, aTime );
	aDateTime.ConvertToUTC();
	return GetUNODateTime( aDateTime.GetDate(), aDateTime.GetTime() );
}

sal_Int32 VFSContent::GetCommandHandle( const Command& rCommand ) const
{
	sal_Int32 nCommand = rCommand.Handle;

	if ( !nCommand || ( nCommand == (-1) ) )
	{
		if ( rCommand.Name == L"open" )
			nCommand = VFSCOMMAND_OPEN;
		else if ( rCommand.Name == L"close" )
			nCommand = VFSCOMMAND_CLOSE;
		else if ( rCommand.Name == L"insert" )
			nCommand = VFSCOMMAND_INSERT;
		else if ( rCommand.Name == L"delete" )
			nCommand = VFSCOMMAND_DELETE;
	}

	return nCommand;
}

void VFSContent::StoreSimpleAttributes()
{
	DBG_ASSERT( bStoreSimpleAttributes, "StoreSimpleAttributes - Why?" );

	sal_uInt32 nSetMask = 0;
	sal_uInt32 nClearMask = 0;

	if ( aSimpleAttributes.bIsReadOnly )
		nSetMask |= VFSSTORE_ATTRIB_READONLY;
	else
		nClearMask |= VFSSTORE_ATTRIB_READONLY; 

	if ( aSimpleAttributes.bIsHidden )
		nSetMask |= VFSSTORE_ATTRIB_HIDDEN;
	else
		nClearMask |= VFSSTORE_ATTRIB_HIDDEN; 

	if ( aSimpleAttributes.bIsArchive )
		nSetMask |= VFSSTORE_ATTRIB_ARCHIVE;
	else
		nClearMask |= VFSSTORE_ATTRIB_ARCHIVE; 

	String aPath, aName;
	VFSContent::CreatePathAndName( getIdentifier()->getContentIdentifier(), aPath, aName, CONTENTDIR );
	GetRoot()->GetStorage().attrib( aPath, aName, nClearMask, nSetMask );

	bStoreSimpleAttributes = sal_False;
}

void VFSContent::StoreExtendedAttributes()
{
	DBG_ASSERT( bStoreExtendedAttributes, "StoreExtendedAttributes - Why?" );

	String aPath, aName;
	VFSContent::CreatePathAndName( getIdentifier()->getContentIdentifier(), aPath, aName, ATTRIBDIR );
	RemoveTrailingSlash( aName );

	OStoreStream aAttrStream;
	storeError eError = aAttrStream.create( GetRoot()->GetStorage(), aPath, aName, store_AccessReadCreate );
	if ( store_E_None == eError )
	{
		SvLockBytesRef xLockBytes = new OLockBytes( aAttrStream );
		SvStream aStream( xLockBytes ); 

		aStream << (ULONG) 100;		// Version

		String aTitle = OUStringToOString( GetExtendedAttributes().aTitle, RTL_TEXTENCODING_UTF8 ).getStr();
		aStream << aTitle;

		aStream << GetDate( GetExtendedAttributes().aDateCreated ).GetDate();
		aStream << GetTime( GetExtendedAttributes().aDateCreated ).GetTime();

		aStream << GetDate( GetExtendedAttributes().aDateModified ).GetDate();
		aStream << GetTime( GetExtendedAttributes().aDateModified ).GetTime();

		aStream << GetDate( GetExtendedAttributes().aDateAccessed ).GetDate();
		aStream << GetTime( GetExtendedAttributes().aDateAccessed ).GetTime();

		aAttrStream.flush();
		aAttrStream.close();

		DBG_ASSERT( !aStream.GetError(), "Error writing Attribs!" );
	}

	bStoreExtendedAttributes = sal_False;
}

void VFSContent::ReadExtendedAttributes()
{
	DBG_ASSERT( bReadExtendedAttributes, "ReadExtendedAttributes - Why?" );

	String aPath, aName;
	VFSContent::CreatePathAndName( getIdentifier()->getContentIdentifier(), aPath, aName, ATTRIBDIR );
	RemoveTrailingSlash( aName );

	aExtendedAttributes.aFileName = OStringToOUString( aName.GetStr(), RTL_TEXTENCODING_UTF8 );

	OStoreStream aAttrStream;
	storeError eError = aAttrStream.create( GetRoot()->GetStorage(), aPath, aName, store_AccessReadCreate );
	if ( store_E_None == eError )
	{
		SvLockBytesRef xLockBytes = new OLockBytes( aAttrStream );
		SvStream aStream( xLockBytes ); 

		ULONG nVersion;
		aStream >> nVersion;

		if ( aStream.GetError() )
		{
			DBG_ERROR( "Error - missing extended attribtes!" );
			InitAttributes();
		}
		else
		{
			String aTitle;

			aStream >> aTitle;
			aExtendedAttributes.aTitle = OStringToOUString( aTitle.GetStr(), RTL_TEXTENCODING_UTF8 );
			
			ULONG nD, nT;

			aStream >> nD;
			aStream >> nT;
			aExtendedAttributes.aDateCreated = GetUNODateTime( Date( nD ), Time( nT ) );

			aStream >> nD;
			aStream >> nT;
			aExtendedAttributes.aDateModified = GetUNODateTime( Date( nD ), Time( nT ) );

			aStream >> nD;
			aStream >> nT;
			aExtendedAttributes.aDateAccessed = GetUNODateTime( Date( nD ), Time( nT ) );

			DBG_ASSERT( !aStream.GetError(), "Error reading Attribs!" );
		}
		aAttrStream.close();
	}

	bReadExtendedAttributes = sal_False;
	bStoreExtendedAttributes = sal_False;
}

Any VFSContent::SetPropertyValue( PropertyValueInfo& rProperty )
{
	sal_Bool bSuccess = sal_False;
	Any	aOldValue;

	if ( this != GetRoot() )
	{
		sal_Int32 nPropId = GetVFSPropertyId( rProperty.Name );
		switch ( nPropId )
		{
			case VFSBASEPROPERTY_TITLE:
			{
				OUString aTitle = *(OUString*)rProperty.Value.getValue();
				aOldValue <<= GetTitle();
				bSuccess = SetTitle( aTitle );
			}
			break;
			case VFSBASEPROPERTY_FILENAME:
			{
				OUString aFileName = *(OUString*)rProperty.Value.getValue();
				aOldValue <<= GetFileName();
				bSuccess = SetFileName( aFileName );
			}
			break;
			case VFSBASEPROPERTY_ISREADONLY:
			{
				sal_Bool bReadOnly = *(sal_Bool*)rProperty.Value.getValue();
				aOldValue <<= IsReadOnly();
				SetReadOnly( bReadOnly );
				bSuccess = sal_True;
			}
			break;
			case VFSBASEPROPERTY_ISHIDDEN:
			{
				sal_Bool bHidden = *(sal_Bool*)rProperty.Value.getValue();
				aOldValue <<= IsHidden();
				SetHidden( bHidden );
				bSuccess = sal_True;
			}
			break;
		}
	}

	if ( bSuccess )
		rProperty.ValueState = PropertyValueState_PROCESSED;

	return aOldValue;
}

void VFSContent::GetPropertyValue( PropertyValueInfo& rProperty )
{
	sal_Int32 nPropId = GetVFSPropertyId( rProperty.Name );
	switch ( nPropId )
	{
		case VFSBASEPROPERTY_TITLE:
		{
			rProperty.Value <<= GetTitle();
		}
		break;
		case VFSBASEPROPERTY_FILENAME:
		{
			rProperty.Value <<= GetFileName();
		}
		break;
		case VFSBASEPROPERTY_ISREADONLY:
		{
			rProperty.Value <<= IsReadOnly();
		}
		break;
		case VFSBASEPROPERTY_ISHIDDEN:
		{
			rProperty.Value <<= IsHidden();
		}
		break;
		case VFSBASEPROPERTY_ISFOLDER:
		{
			rProperty.Value <<= IsFolder();
		}
		break;
		case VFSBASEPROPERTY_ISDOCUMENT:
		{
			rProperty.Value <<= IsDocument();
		}
		break;
		case VFSBASEPROPERTY_DATEMODIFIED:
		{
			rProperty.Value <<= GetDateModified();
		}
		break;
		case VFSBASEPROPERTY_DATECREATED:
		{
			rProperty.Value <<= GetDateCreated();
		}
		break;
		default:
		{
		}
	}
}

void VFSContent::InitAttributes()
{
	DBG_ASSERT( bReadExtendedAttributes, "InitAttributes - shure?!" );

	// Init extended Attributes...
	String aPath, aName;
	VFSContent::CreatePathAndName( getIdentifier()->getContentIdentifier(), aPath, aName, NULL );
	RemoveTrailingSlash( aName );
	OUString aNameAndTitle = OStringToOUString( aName.GetStr(), RTL_TEXTENCODING_UTF8 );
	aExtendedAttributes.aFileName = aNameAndTitle;
	if ( !aExtendedAttributes.aTitle.getLength() )	// Maybe set before (XContentCreator)
		aExtendedAttributes.aTitle = aNameAndTitle;

	UNODateTime aDateTime = GetCurrentDateTime();
	aExtendedAttributes.aDateCreated = aDateTime;
	aExtendedAttributes.aDateModified = aDateTime;
	aExtendedAttributes.aDateAccessed = aDateTime;
	bReadExtendedAttributes = sal_False;
	bStoreExtendedAttributes = sal_True;

	// Simple attributes are already init from VFSContent-CTOR, all sal_False.
	aSimpleAttributes.bIsArchive = sal_True;
	bStoreSimpleAttributes = sal_True;
}

void VFSContent::ChangeContentIdentifier( const OUString& rIdentifier )
{
	sal_Bool bCallListeners = xIdentifier.is();
	xIdentifier = new OSimpleContentIdentifier( rIdentifier, VFSSCHEME );
	if ( bCallListeners )
	{
		ContentEvent aContentEvent;
		aContentEvent.Source = (OWeakObject*)this;	// ???
		aContentEvent.Action = ContentAction::EXCHANGED;
		aContentEvent.Content = this;
		broadcastContentEvent( aContentEvent );
	}
}

OUString VFSContent::CreateContentIdentifier( const OUString& rPath, const OUString& rName ) const
{
	OUString aNewContentID = GetRoot()->getIdentifier()->getContentIdentifier();
	aNewContentID += rPath.copy( 1 );	// without '/'
	aNewContentID += rName;
	return aNewContentID;
}

sal_Bool VFSContent::SetFileName( const OUString& rFileName )
{
	sal_Bool bDone = sal_False;
	if ( IsValidName( rFileName ) && ( rFileName != GetExtendedAttributes().aFileName ) )
	{
		String aNewName = OUStringToOString( rFileName, RTL_TEXTENCODING_UTF8 ).getStr();
		String aPath, aOldName;
		VFSContent::CreatePathAndName( getIdentifier()->getContentIdentifier(), aPath, aOldName, NULL );
		sal_Bool bIsFolder = getContentType() == VFSFolderContent::GetContentType();
		if ( bIsFolder )
			aNewName += '/';

		if ( ( !IsValid() && !GetRoot()->Exists( aPath, aNewName ) ) ||
			 ( IsValid() && GetRoot()->Rename( aPath, aOldName, aNewName ) ) )
		{
 			GetExtendedAttributes().aFileName = rFileName;

			OUString aNewTitle = CalcTitle( rFileName );
			if ( aNewTitle != GetExtendedAttributes().aTitle )
			{
				GetExtendedAttributes().aTitle = aNewTitle;
				bStoreExtendedAttributes = sal_True;
			}
			
			if ( IsValid() )
			{
				OUString aContentIdentifier = CreateContentIdentifier( OStringToOUString( aPath.GetStr(), RTL_TEXTENCODING_UTF8 ), 
																		OStringToOUString( aNewName.GetStr(), RTL_TEXTENCODING_UTF8 ) );
				ChangeContentIdentifier( aContentIdentifier );
			}

			bDone = sal_True;
		}
	}
	return bDone;
}

sal_Bool VFSContent::SetTitle( const OUString& rTitle )
{
	sal_Bool bDone = sal_False;
	if ( IsValidName( rTitle ) && ( rTitle != GetExtendedAttributes().aTitle ) )
	{
		OUString aNewFileName = CalcFileName( rTitle );
		if ( ( aNewFileName == GetExtendedAttributes().aFileName ) || SetFileName( aNewFileName ) )
		{
			GetExtendedAttributes().aTitle = CalcTitle( rTitle );
			bStoreExtendedAttributes = sal_True;
			bDone = sal_True;
		}
	}
	return bDone;
}

sal_Bool VFSContent::IsValidName( const OUString& rName ) const
{
	return ( rName.getLength() && ( rName.indexOf( L'/' ) == (-1) ) );
}

OUString VFSContent::CalcTitle( const OUString& rFileName ) const
{
	return rFileName;	// !!!!!!!!!!!!
}

OUString VFSContent::CalcFileName( const OUString& rTitle ) const
{
	return rTitle; // !!!!!!!!!!!!!!!
}

Reference< XContentIdentifier > VFSContent::getIdentifier() throw()
{
	Guard< Mutex > aGuard( GetMutex() );

	return xIdentifier;
}

Reference< XCommandTask > VFSContent::createCommandTask(const Command& rCommand, const Reference< XResultAcceptor >& rResultAcceptor, const Reference< XContentTaskEnvironment >& rEnvironment ) throw()
{
	return new VFSCommandTask( rEnvironment, this, rCommand );
}

Reference< XPropertyTask > VFSContent::createPropertyTask( PropertyTaskType Type, const Sequence< PropertyValue >& Properties, const Reference< XContentTaskEnvironment >& Environment ) throw()
{
	return new VFSPropertyTask( Environment, this, Properties, Type );
}

Sequence< Property > VFSContent::getProperties() throw()
{
	Guard< Mutex > aGuard( GetMutex() );

	sal_Int16 nProps = GetVFSPropertyCount();
	Sequence< Property > aProperties( nProps );

	for ( sal_Int16 n = 0;n < nProps; n++ )
	{
		sal_Int16 nId = n+1;	
		aProperties.getArray()[n].Name = GetVFSPropertyName( nId );
		aProperties.getArray()[n].Handle = nId;
		aProperties.getArray()[n].Attributes = GetVFSPropertyAttributes( nId );
	}
	return aProperties;
}

