/*************************************************************************
 *
 *  $RCSfile: vfsfilecontent.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <vfsfilecontent.hxx>
#include <vfsrootcontent.hxx>
#include <vfshelper.hxx>

#ifndef _COM_SUN_STAR_UCB_OPENCOMMANDARGUMENT_HPP_
#include <com/sun/star/ucb/OpenCommandArgument.hpp>
#endif

#ifndef _COM_SUN_STAR_IO_XACTIVEDATASINK_HPP_
#include <com/sun/star/io/XActiveDataSink.hpp>
#endif

#ifndef _COM_SUN_STAR_IO_XACTIVEDATACONTROL_HPP_
#include <com/sun/star/io/XActiveDataControl.hpp>
#endif

#include <vfsfilecontentstream.hxx>

#include <tools/debug.hxx>


// =======================================================================
// VFSFileContent
// =======================================================================

VFSFileContent::VFSFileContent( const OUString& rIdentifier, sal_Int32 nAttrs, VFSRootContent* pRootContent ) 
 : VFSContent( rIdentifier, nAttrs, pRootContent )
{
}

VFSFileContent::~VFSFileContent()
{
	maFile.close();
}

OUString VFSFileContent::GetContentType()
{
	return L"File";	// !!!!!!!!
}

storeError VFSFileContent::OpenFile( storeAccessMode eMode )
{
	String aPath, aName;
	VFSContent::CreatePathAndName( getIdentifier()->getContentIdentifier(), aPath, aName, CONTENTDIR );
	RemoveTrailingSlash( aName );
	return maFile.create( GetRoot()->GetStorage(), aPath, aName, eMode );
}

storeError VFSFileContent::ReadFile( Reference<XOutputStream> xTo )
{
	storeError eError = OpenFile( store_AccessReadOnly );
	if ( store_E_None == eError )
	{
		const long nBufferSize = 8192;
		sal_Int8* pBuffer = new sal_Int8[ nBufferSize ];
		sal_uInt32 nOffset = 0;
		sal_uInt32 nBytes = nBufferSize;

		while ( ( nBytes == nBufferSize ) && ( store_E_None == eError ) )
		{
			eError = maFile.readAt( nOffset, pBuffer, nBufferSize, nBytes );
			nOffset += nBytes;
			if ( store_E_None == eError )
			{
				Sequence< sal_Int8 > aSeq( pBuffer, nBytes );
				xTo->writeBytes( aSeq );
			}
		}
		xTo->closeOutput();
		SetDateAccessed( VFSContent::GetCurrentDateTime() );
		delete pBuffer;
		CloseFile();
	}
	return eError;
}

storeError VFSFileContent::WriteFile( Reference<XInputStream> xFrom )
{
	storeError eError = OpenFile( store_AccessReadCreate );
	if ( store_E_None == eError )
	{
		const long nBufferSize = 8192;
		sal_uInt32 nOffset = 0;
		sal_uInt32 nBytes = nBufferSize;
		Sequence< sal_Int8 > aSeq( nBufferSize );
		
		maFile.setSize( 0 );
		while ( ( nBytes == nBufferSize ) && ( store_E_None == eError ) )
		{
			nBytes = xFrom->readBytes( aSeq, nBufferSize );
			eError = maFile.writeAt( nOffset, aSeq.getArray(), nBytes, nBytes );
			nOffset += nBytes;
		}
		xFrom->closeInput();
		UNODateTime aDateTime = VFSContent::GetCurrentDateTime();
		SetDateModified( aDateTime );
		SetDateAccessed( aDateTime );
		SetArchive( TRUE );
		CloseFile();
	}
	return eError;
}


void VFSFileContent::CloseFile()
{
	maFile.close();
}

Any VFSFileContent::doCommand( const Command& rCommand )
{
	Guard< Mutex > aGuard( GetMutex() );

	Any aReturnValue;

	sal_Int32 nCommand = GetCommandHandle( rCommand );
	switch ( nCommand )
	{
		case VFSCOMMAND_OPEN:
		{
			OpenCommandArgument aOpenArgument;
			rCommand.Argument >>= aOpenArgument;
			Reference<XOutputStream> xOStream = Reference<XOutputStream>::query( aOpenArgument.Sink );
			if ( xOStream.is() )
			{
				ReadFile( xOStream );
			}
			else
			{
				Reference< XActiveDataSink > xSink = Reference< XActiveDataSink >::query( aOpenArgument.Sink );
				if ( xSink.is() )
				{
					storeError eError = OpenFile( store_AccessReadOnly );
					if ( store_E_None == eError )
					{
						Reference<XInputStream> xIn = new VFSFileContentStream( this, maFile );
						xSink->setInputStream( xIn );
						Reference< XActiveDataControl > xControl( xSink, UNO_QUERY );
						if( xControl.is() )
							xControl->start();
					}
				}
			}
		}
		break;
		case VFSCOMMAND_CLOSE:
		{
			maFile.close(); 
		}
		break;
		case VFSCOMMAND_DELETE:
		{
			maFile.close();

			sal_Bool bMarkOnly = sal_False;	// !!!!!!!!!!

			String aFullName = OUStringToOString( getIdentifier()->getContentIdentifier(), RTL_TEXTENCODING_UTF8 ).getStr();
			GetRoot()->DeleteFile( aFullName, bMarkOnly );
		}
		break;
		case VFSCOMMAND_INSERT:
		{
			if ( !IsValid() )
				GetRoot()->InsertNewContent( this );
		
			if( rCommand.Argument.getValueType().getTypeName() == "com.sun.star.io.XInputStream" )
			{
				Reference< XInputStream > xIn;
				rCommand.Argument >>= xIn;
				WriteFile( xIn );
			}
		}
		break;
	}

	return aReturnValue;
}

// ----------------------------------------
// Interface XContent
// ----------------------------------------

OUString VFSFileContent::getContentType() throw()
{
	return VFSFileContent::GetContentType();
}

// ----------------------------------------
// Interface XCommandInfo
// ----------------------------------------

Sequence< CommandInfo > VFSFileContent::getCommands() throw()
{
	Sequence< CommandInfo >	aCommands( 4 );

	aCommands[0].Name = L"open";
	aCommands[0].Handle = VFSCOMMAND_OPEN;

	aCommands[1].Name = L"close";
	aCommands[1].Handle = VFSCOMMAND_CLOSE;

	aCommands[2].Name = L"insert";
	aCommands[2].Handle = VFSCOMMAND_INSERT;

	aCommands[3].Name = L"delete";
	aCommands[3].Handle = VFSCOMMAND_DELETE;

	return aCommands;
}

