/*************************************************************************
 *
 *  $RCSfile: vfsfoldercontent.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_UCB_OPENCOMMANDARGUMENT_HPP_
#include <com/sun/star/ucb/OpenCommandArgument.hpp>
#endif

#ifndef _COM_SUN_STAR_UCB_CONTENTACTION_HPP_
#include <com/sun/star/ucb/ContentAction.hpp>
#endif

#include <vfsfoldercontent.hxx>
#include <vfsfilecontent.hxx>
#include <vfsrootcontent.hxx>
#include <vfshelper.hxx>

#include <tools/debug.hxx>

// =======================================================================
// VFSFolderContent
// =======================================================================

VFSFolderContent::VFSFolderContent( const OUString& rIdentifier, sal_Int32 nAttrs, VFSRootContent* pRootContent ) 
 : VFSContent( rIdentifier, nAttrs, pRootContent )
{
}

VFSFolderContent::~VFSFolderContent()
{
	maDir.close();
}

OUString VFSFolderContent::GetContentType()
{
	return L"Folder";	// !!!!!!!!
}


// ----------------------------------------
// Interface XInterface
// ----------------------------------------

Any VFSFolderContent::queryInterface( const Type &type ) throw( RuntimeException )
{
	Any	aRet = ::cppu::queryInterface( type,
										SAL_STATIC_CAST( XIndexAccess*, this ),
										SAL_STATIC_CAST( XContentHierarchy*, this ), 
										SAL_STATIC_CAST( XContentCreator*, this )	);

	return (aRet.hasValue() ? aRet : OContent::queryInterface( type ));
}

void VFSFolderContent::acquire() throw(RuntimeException)
{
	VFSContent::acquire();
}

void VFSFolderContent::release() throw(RuntimeException)
{
	VFSContent::release();
}

// ----------------------------------------
// Interface XContent
// ----------------------------------------

OUString VFSFolderContent::getContentType() throw()
{
	return VFSFolderContent::GetContentType();
}

// ----------------------------------------
// Interface XElementAccess
// ----------------------------------------

Type VFSFolderContent::getElementType() throw(RuntimeException)
{
	Reference< XContent > xCon;
	return getCppuType( &xCon );
}

sal_Bool VFSFolderContent::hasElements() throw(RuntimeException)
{
	return getCount() ? TRUE : FALSE;
}

// ----------------------------------------
// Interface XIndexAccess
// ----------------------------------------

sal_Int32 VFSFolderContent::getCount() throw(RuntimeException)
{
	Guard< Mutex > aGuard( GetMutex() );

	sal_Int32 nCount = 0;

	String aPath, aName;
	VFSContent::CreatePathAndName( getIdentifier()->getContentIdentifier(), aPath, aName, CONTENTDIR );
	RemoveTrailingSlash( aName );
	if ( maDir.create( GetRoot()->GetStorage(), aPath, aName, store_AccessReadOnly ) == store_E_None )
	{
		storeFindData aIterator;
		storeError eError = maDir.first( aIterator);
		while ( eError == store_E_None )
		{
			nCount++;
			eError = maDir.next( aIterator);
		}
		maDir.close();
	}
	return nCount;
}

Any VFSFolderContent::getByIndex( sal_Int32 Index ) throw(IndexOutOfBoundsException, WrappedTargetException, RuntimeException)
{
	Guard< Mutex > aGuard( GetMutex() );

	Any aElement;
	String aPath, aName;
	VFSContent::CreatePathAndName( getIdentifier()->getContentIdentifier(), aPath, aName, CONTENTDIR );
	RemoveTrailingSlash( aName );
	if ( maDir.create( GetRoot()->GetStorage(), aPath, aName, store_AccessReadOnly ) == store_E_None )
	{
		storeFindData aIterator;
		long nElement = 0;
		storeError eError = maDir.first( aIterator);
		while ( eError == store_E_None )
		{
			if ( nElement == Index )
			{
				Reference<XContent> xC;
				OUString aCI = getIdentifier()->getContentIdentifier();
				aCI += OStringToOUString( OString( aIterator.m_pszName ), ENCODINGHACK );
				if ( aIterator.m_nAttrib & STORE_ATTRIB_ISDIR )
					aCI += L"/";
				if ( GetRoot()->QueryContent( aCI, xC ) )
				{
					aElement <<= xC;
				}
				break;
			}
			nElement++;
			eError = maDir.next( aIterator);
		}
		maDir.close();
	}
	return aElement;
}

// ----------------------------------------
// Interface XContentCreator
// ----------------------------------------

Sequence<ContentInfo > VFSFolderContent::queryCreatableContentsInfo() throw(RuntimeException)
{
	return Sequence<ContentInfo >();	// !!!!!
}

Reference< XContent > VFSFolderContent::createNewContent( const ContentInfo& rInfo ) throw( RuntimeException)
{
	Guard< Mutex > aGuard( GetMutex() );

	// createNewContent soll nur einen leeren XContent vom richtigen Typ anlegen.
	// Ueber die Property "FileName" oder "Title" wird dann der Name festgelegt,
	// eine Datei/Folder wird erst bei insertContent angelegt.

	VFSContent* pNewContent = NULL;
	if ( rInfo.Type == VFSFileContent::GetContentType() )
	{
		pNewContent = new VFSFileContent( getIdentifier()->getContentIdentifier(), STORE_ATTRIB_ISFILE, GetRoot() );
	}
	else if ( rInfo.Type == VFSFolderContent::GetContentType() )
	{
		pNewContent = new VFSFolderContent( getIdentifier()->getContentIdentifier(), STORE_ATTRIB_ISDIR, GetRoot() );
	}

	if ( pNewContent )
		pNewContent->SetValid( FALSE );

	return pNewContent;
}

// ----------------------------------------
// Interface XContentHierarchy
// ----------------------------------------

Sequence< Any > VFSFolderContent::getHierarchyIdentifierFromContent( const Reference< XContent >& xSubContent ) throw(IllegalArgumentException)
{
	Guard< Mutex > aGuard( GetMutex() );
	
	Sequence< Any > aIdentifiers;

	if ( xSubContent.is() )
	{
		OUString This = getIdentifier()->getContentIdentifier();
		OUString TheOther = xSubContent->getIdentifier()->getContentIdentifier();
		sal_Int32 nThisLen = This.getLength();
		if ( This.compareTo( TheOther, nThisLen ) == 0 )
		{
			OUString aRel = TheOther.copy( nThisLen );
			sal_Int32 nRelLen = aRel.getLength();
			sal_Int32 nStart = 0;
			sal_Int32 nEnd = aRel.indexOf( L'/', nStart+1 );
			while ( nStart < nRelLen )
			{
				if ( nEnd == (-1) )
					nEnd = nRelLen-1;

				OUString aPart = aRel.copy( nStart, nEnd-nStart+1 );
				aIdentifiers.realloc( aIdentifiers.getLength()+1 );
				aIdentifiers[aIdentifiers.getLength()-1] <<= aPart;

				nStart = nEnd+1;
				nEnd = aRel.indexOf( L'/', nStart+1 );
			}
		}
	}

	return aIdentifiers;
}

Reference< XContent > VFSFolderContent::getContentFromHierarchyIdentifier( const Sequence< Any >& relativeIdentifier ) throw(IllegalArgumentException)
{
	Guard< Mutex > aGuard( GetMutex() );

	OUString aId = getIdentifier()->getContentIdentifier();
	sal_Int32 nLen = relativeIdentifier.getLength();
	OUString aTmp;
	for ( sal_Int32 n = 0; n < nLen; n++ )
	{
		relativeIdentifier[n] >>= aTmp;
		aId += aTmp;
	}

	Reference< XContent > xContent;
	GetRoot()->QueryContent( aId, xContent );

	return xContent;
}

sal_Bool VFSFolderContent::compareHierarchyIdentifiers( const Sequence< Any >& aId1, const Sequence< Any >& aId2 ) throw(IllegalArgumentException)
{
	Guard< Mutex > aGuard( GetMutex() );
	sal_Bool bEqual = sal_False;
	sal_Int32 nLen = aId1.getLength();
	if ( aId2.getLength() == nLen )
	{
		bEqual = sal_True;
		OUString aTmp1, aTmp2;
		for ( sal_Int32 n = nLen; n && bEqual; )
		{
			n--;
			aId1[n] >>= aTmp1;
			aId2[n] >>= aTmp2;
			bEqual = (aTmp1 == aTmp2);
		}
	}
	return bEqual;
}

// ----------------------------------------
// Interface XCommandInfo
// ----------------------------------------

Sequence< CommandInfo > VFSFolderContent::getCommands() throw()
{
	Sequence< CommandInfo >	aCommands( 4 );

	aCommands[0].Name = L"open";
	aCommands[0].Handle = VFSCOMMAND_OPEN;

	aCommands[1].Name = L"close";
	aCommands[1].Handle = VFSCOMMAND_CLOSE;

	aCommands[2].Name = L"delete";
	aCommands[2].Handle = VFSCOMMAND_DELETE;

	aCommands[3].Name = L"insert";
	aCommands[3].Handle = VFSCOMMAND_INSERT;

	return aCommands;
}

Any VFSFolderContent::doCommand( const Command& rCommand )
{
	Guard< Mutex > aGuard( GetMutex() );

	Any aReturnValue;

	sal_Int32 nCommand = GetCommandHandle( rCommand );
	switch ( nCommand )
	{
		case VFSCOMMAND_OPEN:
		{
			OpenCommandArgument aOpenArgument;
			rCommand.Argument >>= aOpenArgument;
			sal_uInt32 nMask = 0;

			// defines in CHAOS, need them in UCB!
			if ( aOpenArgument.Mode == 0 )	// ALL
				nMask = STORE_ATTRIB_ISDIR|STORE_ATTRIB_ISFILE;
			else if ( aOpenArgument.Mode == 1 )	// FOLDERS
				nMask = STORE_ATTRIB_ISDIR;
			else if ( aOpenArgument.Mode == 3 )	// DOCUMENTS
				nMask = STORE_ATTRIB_ISFILE;

			if ( nMask )
			{
				String aPath, aName;
				VFSContent::CreatePathAndName( getIdentifier()->getContentIdentifier(), aPath, aName, CONTENTDIR );
				RemoveTrailingSlash( aName );
				if ( maDir.create( GetRoot()->GetStorage(), aPath, aName, store_AccessReadOnly ) == store_E_None )
				{
					storeFindData aIterator;
					long nElement = 0;
					storeError eError = maDir.first( aIterator);
					while ( eError == store_E_None )
					{
						if ( aIterator.m_nAttrib & nMask )
						{
							OUString aCI = getIdentifier()->getContentIdentifier();
							aCI += OStringToOUString( OString( aIterator.m_pszName ), RTL_TEXTENCODING_UTF8 );
							if ( aIterator.m_nAttrib & STORE_ATTRIB_ISDIR )
								aCI += L"/";

							Reference<XContent> xContent;
							if ( GetRoot()->QueryContent( aCI, xContent ) )
							{
								ContentEvent aEvent;
								aEvent.Action = ContentAction::INSERTED;	// ????????????
								aEvent.Content = xContent;
								broadcastContentEvent( aEvent );
							}
						}
						eError = maDir.next( aIterator);
					}
					maDir.close();
				}
			}
		}
		break;
		case VFSCOMMAND_CLOSE:
		{
			maDir.close(); 
		}
		break;
		case VFSCOMMAND_DELETE:
		{
			maDir.close();

			sal_Bool bMarkOnly = sal_False;	// !!!!!!!!!!

			String aFullName = OUStringToOString( getIdentifier()->getContentIdentifier(), RTL_TEXTENCODING_UTF8 ).getStr();
			GetRoot()->DeleteFolder( aFullName, bMarkOnly );
		}
		break;
		case VFSCOMMAND_INSERT:
		{
			DBG_ASSERT( !IsValid(), "VFSFolderContent INSERT: Already valid!" );
			GetRoot()->InsertNewContent( this );
		}
		break;
	}

	return aReturnValue;
}

