/*************************************************************************
 *
 *  $RCSfile: vfshelper.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define _EXTENSIONS_VFS2_CXX
	
#pragma hdrstop

#include <vfshelper.hxx>

#include <stdlib.h>	// qsort/bsearch

#ifndef _COM_SUN_STAR_BEANS_PROPERTY_HPP_
#include <com/sun/star/beans/Property.hpp>
#endif

// #ifndef _COM_SUN_STAR_BEANS_PROPERTYSTATE_HPP_
// #include <com/sun/star/beans/PropertyState.hpp>
// #endif

#ifndef _COM_SUN_STAR_BEANS_PROPERTYATTRIBUTE_HPP_
#include <com/sun/star/beans/PropertyAttribute.hpp>
#endif

#include <tools/debug.hxx>

using namespace com::sun::star::beans;

struct VFSPropertyInfo 
{
	OUString	aName;
	sal_Int32	nPropId;
	sal_Int16	nAttributes;
//	XIdlClass	aType;
	
	
	VFSPropertyInfo()
	 {
	 	nPropId = 0;
		nAttributes = 0;
	 }

	VFSPropertyInfo( const char* pName, sal_Int32 nId, sal_Int16 nAttrs )
	 {
		aName = OStringToOUString( OString(pName), RTL_TEXTENCODING_MS_1252 );
	 	nPropId = nId;
		nAttributes = nAttrs;
	 }
};

static VFSPropertyInfo aVFSPropertyInfos [] = 
{
VFSPropertyInfo( "Title",			VFSBASEPROPERTY_TITLE,			PropertyAttribute::BOUND ),
VFSPropertyInfo( "FileName",		VFSBASEPROPERTY_FILENAME,		PropertyAttribute::BOUND ),
VFSPropertyInfo( "IsFolder",		VFSBASEPROPERTY_ISFOLDER,		PropertyAttribute::READONLY ),
VFSPropertyInfo( "IsDocument",		VFSBASEPROPERTY_ISDOCUMENT,		PropertyAttribute::READONLY ),
VFSPropertyInfo( "DateModified",	VFSBASEPROPERTY_DATEMODIFIED,	PropertyAttribute::READONLY ),
VFSPropertyInfo( "DateCreated",		VFSBASEPROPERTY_DATECREATED,	PropertyAttribute::READONLY ),
VFSPropertyInfo( "IsReadOnly",		VFSBASEPROPERTY_ISREADONLY,		PropertyAttribute::BOUND ),
VFSPropertyInfo( "IsHidden",		VFSBASEPROPERTY_ISHIDDEN,		PropertyAttribute::BOUND ),
};

static int
#if defined( WNT )
 __cdecl
#endif
#if defined( ICC ) && defined( OS2 )
_Optlink
#endif
 	VFSPropertyInfoCompare( const void* pFirst, const void* pSecond)
{
	return ((VFSPropertyInfo*)pFirst)->aName.compareTo( ((VFSPropertyInfo*)pSecond)->aName );
}

void ImplAssertValidVFSPropertyArray()
{
	static sal_Bool bSorted = sal_False;
	if( !bSorted )
	{
		sal_Int32 nElements = sizeof( aVFSPropertyInfos ) / sizeof( VFSPropertyInfo );
		qsort( 	(void*) aVFSPropertyInfos,
				nElements, sizeof( VFSPropertyInfo ), VFSPropertyInfoCompare );
		bSorted = sal_True;
	}
}

sal_Int16 GetVFSPropertyCount()
{
	return sizeof( aVFSPropertyInfos ) / sizeof( VFSPropertyInfo );
}

sal_Int32 GetVFSPropertyId( const OUString& rPropertyName )
{
	ImplAssertValidVFSPropertyArray();
 
	VFSPropertyInfo aSearch;
	aSearch.aName = rPropertyName;

	VFSPropertyInfo* pInf = (VFSPropertyInfo*) bsearch( &aSearch,
						(void*) aVFSPropertyInfos,
						sizeof( aVFSPropertyInfos ) / sizeof( VFSPropertyInfo ),
						sizeof( VFSPropertyInfo ),
						VFSPropertyInfoCompare );
	
	return pInf ? pInf->nPropId: 0;
}

const VFSPropertyInfo* ImplGetVFSPropertyInfo( sal_Int32 nPropertyId )
{
	ImplAssertValidVFSPropertyArray();
	
	const VFSPropertyInfo* pPropertyInfo = NULL;
	
	sal_Int32 nElements = sizeof( aVFSPropertyInfos ) / sizeof( VFSPropertyInfo );
	for ( sal_Int32 n = nElements; n && !pPropertyInfo; ) 
	{
		if ( aVFSPropertyInfos[--n].nPropId == nPropertyId )
			pPropertyInfo = &aVFSPropertyInfos[n];
	}
	
	return pPropertyInfo;
}

const OUString& GetVFSPropertyName( sal_Int32 nPropertyId )
{
	const VFSPropertyInfo* pPropertyInfo = ImplGetVFSPropertyInfo( nPropertyId );
	DBG_ASSERT( pPropertyInfo, "Invalid VFSPropertyId!" );
	return pPropertyInfo->aName;
}

sal_Int16 GetVFSPropertyAttributes( sal_Int32 nPropertyId )
{
	const VFSPropertyInfo* pPropertyInfo = ImplGetVFSPropertyInfo( nPropertyId );
	DBG_ASSERT( pPropertyInfo, "Invalid VFSPropertyId!" );
	return pPropertyInfo->nAttributes;
}


// =================================================
// OLockBytes
// =================================================
ErrCode lcl_ConvertErrorCode( storeError eError )
{
	switch ( eError )
	{
		case store_E_None:				return ERRCODE_NONE;
		case store_E_AccessViolation:	return ERRCODE_IO_ACCESSDENIED;
		case store_E_LockingViolation:	return ERRCODE_IO_LOCKVIOLATION;
		case store_E_CantSeek:			return ERRCODE_IO_CANTSEEK;
		case store_E_CantRead:			return ERRCODE_IO_CANTREAD;
		case store_E_CantWrite:			return ERRCODE_IO_CANTWRITE;
		case store_E_InvalidAccess:		return ERRCODE_IO_INVALIDACCESS;
		case store_E_InvalidHandle:		return ERRCODE_IO_INVALIDDEVICE;
		case store_E_InvalidParameter:	return ERRCODE_IO_INVALIDPARAMETER;
		case store_E_InvalidChecksum:	return ERRCODE_IO_BADCRC;
		case store_E_AlreadyExists:		return ERRCODE_IO_ALREADYEXISTS;
		case store_E_NotExists:			return ERRCODE_IO_NOTEXISTS;
		case store_E_NotDirectory:		return ERRCODE_IO_NOTADIRECTORY;
		case store_E_NotFile:			return ERRCODE_IO_NOTAFILE;
		case store_E_NameTooLong:		return ERRCODE_IO_NAMETOOLONG;
		case store_E_OutOfMemory:		return ERRCODE_IO_OUTOFMEMORY;
		case store_E_OutOfSpace:		return ERRCODE_IO_OUTOFSPACE;
		case store_E_Pending:			return ERRCODE_IO_PENDING;
		case store_E_WrongFormat:		return ERRCODE_IO_WRONGFORMAT;
		case store_E_WrongVersion:		return ERRCODE_IO_WRONGVERSION;

		case store_E_Unknown:
		case store_E_NoMoreFiles:		return ERRCODE_IO_UNKNOWN;
	}

	return ERRCODE_IO_UNKNOWN;
}


OLockBytes::OLockBytes( const store::OStoreStream& rStream )
	: aStream( rStream )
{
}

ErrCode OLockBytes::ReadAt(ULONG nPos, void * pBuffer, ULONG nCount, ULONG* pRead ) const
{
	sal_uInt32 nDummy;
	storeError eError = ((OLockBytes*)this)->aStream.readAt( nPos, pBuffer, nCount, pRead ? *pRead : nDummy );
	return lcl_ConvertErrorCode( eError );
}

ErrCode OLockBytes::WriteAt(ULONG nPos, const void * pBuffer, ULONG nCount, ULONG* pWritten )
{
	sal_uInt32 nDummy;
	storeError eError = aStream.writeAt( nPos, pBuffer, nCount, pWritten ? *pWritten : nDummy );
	return lcl_ConvertErrorCode( eError );
}

ErrCode OLockBytes::Flush() const
{
	storeError eError = aStream.flush();
	return lcl_ConvertErrorCode( eError );
}

ErrCode OLockBytes::SetSize(ULONG nSize)
{
	storeError eError = aStream.setSize( nSize );
	return lcl_ConvertErrorCode( eError );
}

ErrCode OLockBytes::LockRegion(ULONG, ULONG, LockType)
{
	return ERRCODE_IO_UNKNOWN;
}

ErrCode OLockBytes::UnlockRegion(ULONG, ULONG, LockType)
{
	return ERRCODE_IO_UNKNOWN;
}

ErrCode OLockBytes::Stat(SvLockBytesStat * pStat, SvLockBytesStatFlag ) const
{
	storeError eError = aStream.getSize( pStat->nSize );
	return lcl_ConvertErrorCode( eError );
}



