/*************************************************************************
 *
 *  $RCSfile: vfshelper.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _EXTENSIONS_VFSHELPER_HXX
#define _EXTENSIONS_VFSHELPER_HXX

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#include <tools/stream.hxx>
#include <store/store.hxx>

using namespace rtl;

// =======================================================================
// Helper functions
// =======================================================================

inline void RemoveTrailingSlash( String& rName )
{
	if ( rName.Len() && ( rName.GetChar( rName.Len()-1 ) == '/' ) )
		rName.Erase( rName.Len()-1, 1 );
}

// =======================================================================
// Properties
// =======================================================================

// Einfache Properties AN/AUS wie ReadOnly, Archiv direkt in den Attribs im Store?!

#define VFSBASEPROPERTY_NOTFOUND				0

#define VFSBASEPROPERTY_TITLE					1	
#define VFSBASEPROPERTY_FILENAME				2
#define VFSBASEPROPERTY_ISFOLDER				3
#define VFSBASEPROPERTY_ISDOCUMENT				4
#define VFSBASEPROPERTY_DATEMODIFIED			5
#define VFSBASEPROPERTY_DATECREATED				6
#define VFSBASEPROPERTY_ISREADONLY				7
#define VFSBASEPROPERTY_ISHIDDEN				8

sal_Int16			GetVFSPropertyCount();
sal_Int32			GetVFSPropertyId( const OUString& rPropertyName ); 
const OUString&		GetVFSPropertyName( sal_Int32 nPropertyId );
sal_Int16			GetVFSPropertyAttributes( sal_Int32 nPropertyId );


// =======================================================================
// OLockBytes
// =======================================================================

class OLockBytes : public SvLockBytes
{
	store::OStoreStream	aStream;

public:
	OLockBytes( const store::OStoreStream& rStream );

	ErrCode ReadAt(ULONG nPos, void * pBuffer, ULONG nCount, ULONG* pRead ) const;
	ErrCode WriteAt(ULONG nPos, const void * pBuffer, ULONG nCount, ULONG* pWritten );
	ErrCode Flush() const;
	ErrCode SetSize(ULONG nSize);
	ErrCode LockRegion(ULONG, ULONG, LockType);
	ErrCode UnlockRegion(ULONG, ULONG, LockType);
	ErrCode Stat(SvLockBytesStat * pStat, SvLockBytesStatFlag) const;
};

#endif	// _EXTENSIONS_VFSHELPER_HXX



