/*************************************************************************
 *
 *  $RCSfile: asyncquit.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: as $ $Date: 2001/05/21 06:10:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef __FRAMEWORK_CLASSES_ASYNCQUIT_HXX_
#define __FRAMEWORK_CLASSES_ASYNCQUIT_HXX_

//_________________________________________________________________________________________________________________
//	my own includes
//_________________________________________________________________________________________________________________

#ifndef __FRAMEWORK_MACROS_DEBUG_HXX_
#include <macros/debug.hxx>
#endif

#ifndef __FRAMEWORK_GENERAL_H_
#include <general.h>
#endif

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

#ifndef _COM_SUN_STAR_FRAME_XDESKTOP_HPP_
#include <com/sun/star/frame/XDesktop.hpp>
#endif

#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include <com/sun/star/uno/Reference.hxx>
#endif

//_________________________________________________________________________________________________________________
//	other includes
//_________________________________________________________________________________________________________________

#ifndef _VOS_TIMER_HXX_
#include <vos/timer.hxx>
#endif

//_________________________________________________________________________________________________________________
//	const
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	namespace
//_________________________________________________________________________________________________________________

namespace framework{

//_________________________________________________________________________________________________________________
//	declarations
//_________________________________________________________________________________________________________________

/*-************************************************************************************************************//**
	@short          implement a timer to shut down the office (desktop) if last child task was destroyed
	@descr			If last task at desktop was destroyed the user has no visible controls to create a new one!
					Our office can't work so and I think we must terminate us by himself.
					But it can be that somwhere will work with us in the next time (zB. creation of global document)
					Then we must hold us alive for ... I think 5 sec! In plugin mode it can be 2 min.
					That's the reason to implement this timer. He wait 5 sec or 2 min and terminate the desktop.

	@implements		-
	@base			OTimer

	@devstatus		ready to use
*//*-*************************************************************************************************************/

class AsyncQuit	: public ::vos::OTimer
{
	//-------------------------------------------------------------------------------------------------------------
	//	public methods
	//-------------------------------------------------------------------------------------------------------------

	public:

		/*-****************************************************************************************************//**
			@short		standard ctor
			@descr		These initialize a new instance of this class with all needed informations for work.
						You must give us a reference to the desktop for terminate call.

			@seealso	-

			@param		"xDesktop", reference to desktop to call terminate() on it
			@return		-

			@onerror	-
		*//*-*****************************************************************************************************/

		AsyncQuit( const css::uno::Reference< css::frame::XDesktop >& xDesktop );

		/*-****************************************************************************************************//**
			@short		destructor
			@descr		Release all hold references of these class.

			@seealso	-

			@param		-
			@return		-

			@onerror	-
		*//*-*****************************************************************************************************/

		virtual ~AsyncQuit();

	//-------------------------------------------------------------------------------------------------------------
	//	protected methods
	//-------------------------------------------------------------------------------------------------------------

	protected:

		/*-****************************************************************************************************//**
			@short		method called after wait time
			@descr		These method is called after our wait time and try to terminate the desktop.

			@seealso	-

			@param		-
			@return		-

			@onerror	-
		*//*-*****************************************************************************************************/

    	virtual void SAL_CALL onShot();

	//-------------------------------------------------------------------------------------------------------------
	//	private methods
	//-------------------------------------------------------------------------------------------------------------

	private:

		/*-****************************************************************************************************//**
			@short		try to auto detect current office mode (normal/plug in)
			@descr		The timer has some default timeout values for supported modes!
						5 sec for normal office
						2 min for plugged office
						These method search for anything which specify one of these modes and set right
						timeout automaticly. Call method at construct time!

			@ATTENTION	We don't save the result of this operation on a member!
						We use m_TimeOut of our baseclass for these.
						Normaly the value can be set by using constructor of ouer baseclass only ...
						but as derived class we have full acces to the protected member!

			@seealso	-

			@param		-
			@return		-

			@onerror	We set the normal mode as default!
		*//*-*****************************************************************************************************/

		void impl_autoDetectMode();

	//-------------------------------------------------------------------------------------------------------------
	//	debug methods
	//-------------------------------------------------------------------------------------------------------------

		/*-****************************************************************************************************//**
			@short		debug-method to check incoming parameter of some other mehods of this class
			@descr		The following methods are used to check parameters for other methods
						of this class. The return value is used directly for an ASSERT(...).

			@seealso	ASSERTs in implementation!

			@param		references to checking variables
			@return		sal_False ,on invalid parameter
			@return		sal_True  ,otherwise

			@onerror	-
		*//*-*****************************************************************************************************/

	#ifdef ENABLE_ASSERTIONS

	private:

		sal_Bool impldbg_checkParameter_AsyncQuit( const css::uno::Reference< css::frame::XDesktop >& xDesktop );

	#endif // ENABLE_ASSERTIONS

	//-------------------------------------------------------------------------------------------------------------
	//	private member
	//-------------------------------------------------------------------------------------------------------------

	private:

		css::uno::Reference< css::frame::XDesktop >	m_xDesktop	;	/// We hold a reference to the desktop. It's neccessary to hold it alive
																	/// if all other has release his references!
		sal_Bool									m_bEnabled	;	/// Sometimes this timer must disable himself by doing nothing!

};		//	class AsyncQuit

}		//	namespace framework

#endif	//	#ifndef __FRAMEWORK_CLASSES_ASYNCQUIT_HXX_
