/*************************************************************************
 *
 *  $RCSfile: jobexecutor.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: fs $ $Date: 2001/12/20 13:49:59 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef __FRAMEWORK_SERVICES_JOBEXECUTOR_HXX_
#define __FRAMEWORK_SERVICES_JOBEXECUTOR_HXX_

//_________________________________________________________________________________________________________________
//	my own includes
//_________________________________________________________________________________________________________________

#ifndef __FRAMEWORK_THREADHELP_THREADHELPBASE_HXX_
#include <threadhelp/threadhelpbase.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_RESETABLEGUARD_HXX_
#include <threadhelp/resetableguard.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_WRITEGUARD_HXX_
#include <threadhelp/writeguard.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_READGUARD_HXX_
#include <threadhelp/readguard.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_GENERIC_HXX_
#include <macros/generic.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_DEBUG_HXX_
#include <macros/debug.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_XINTERFACE_HXX_
#include <macros/xinterface.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_XTYPEPROVIDER_HXX_
#include <macros/xtypeprovider.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_XSERVICEINFO_HXX_
#include <macros/xserviceinfo.hxx>
#endif

#ifndef __FRAMEWORK_GENERAL_H_
#include <general.h>
#endif

#ifndef __FRAMEWORK_STDTYPES_H_
#include <stdtypes.h>
#endif

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

#ifndef _COM_SUN_STAR_TASK_XJOBEXECUTOR_HPP_
#include <com/sun/star/task/XJobExecutor.hpp>
#endif

#ifndef _COM_SUN_STAR_BEANS_NAMEDVALUE_HPP_
#include <com/sun/star/beans/NamedValue.hpp>
#endif

#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif

//_________________________________________________________________________________________________________________
//	other includes
//_________________________________________________________________________________________________________________

#ifndef _UTL_CONFIGITEM_HXX_
#include <unotools/configitem.hxx>
#endif

#ifndef _CPPUHELPER_INTERFACECONTAINER_HXX_
#include <cppuhelper/interfacecontainer.hxx>
#endif

#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif

#ifndef _DATETIME_HXX
#include <tools/datetime.hxx>
#endif

#ifndef __SGI_STL_HASH_MAP
#include <hash_map>
#endif

#ifndef __SGI_STL_VECTOR
#include <vector>
#endif

#ifndef __SGI_STL_ITERATOR
#include <iterator>
#endif

//_________________________________________________________________________________________________________________
//	namespace
//_________________________________________________________________________________________________________________

namespace framework{

//_________________________________________________________________________________________________________________
//	exported const
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	exported definitions
//_________________________________________________________________________________________________________________

/*-****************************************************************************************************************
    @descr  hold information about one job configuration and support simple helper functions
****************************************************************************************************************-*/
struct Job
{
    //-------------------------------------------------------------------------------------------------------------
    public:
                                Job                    (                                );
                void            appendArgument         ( const ::rtl::OUString& sName   ,
                                                         const css::uno::Any&   aValue  );
        static  sal_Bool        mustBeActivated        ( const ::rtl::OUString& sAdmin  ,
                                                         const ::rtl::OUString& sUser   );
        static  sal_Bool        convertString2TimeStamp( const ::rtl::OUString& sString ,
                                                               DateTime&        rStamp  );
        static  ::rtl::OUString convertTimeStamp2String( const DateTime&        aStamp  );

    //-------------------------------------------------------------------------------------------------------------
    public:
        ::rtl::OUString                                 sService    ;   // uno service name of job implementation
        css::uno::Sequence< css::beans::NamedValue >    lArguments  ;   // job specific configuration items ... unknown for us!
        sal_Bool                                        bAsync      ;   // it's a async. job
        sal_Bool                                        bWork       ;   // job is currently working - don't start it again!
};

//*****************************************************************************************************************
// helper type!
typedef ::std::hash_map< ::rtl::OUString                        ,
                         Job                                    ,
                         OUStringHashCode                       ,
                         ::std::equal_to< ::rtl::OUString >     >   JobHash;

//*****************************************************************************************************************
// helper type!
typedef ::std::hash_map< ::rtl::OUString                        ,
                         ::std::vector< ::rtl::OUString >       ,
                         OUStringHashCode                       ,
                         ::std::equal_to< ::rtl::OUString >     >   EventHash;

//*****************************************************************************************************************
// wrapper!
// ConfigItem knows protected interface only :-(
// but we wish to use it as member ...
// so we must make used methods public :-)
class DynamicConfigItem : public ::utl::ConfigItem
{
    public:
                                                DynamicConfigItem   ( const ::rtl::OUString&                                sRegistry ) : ConfigItem( sRegistry ) {}
        css::uno::Sequence< ::rtl::OUString >   GetNodeNames        ( const ::rtl::OUString&                                sNode     ) { return ConfigItem::GetNodeNames ( sNode  ); }
        css::uno::Sequence< css::uno::Any >     GetProperties       ( const css::uno::Sequence< ::rtl::OUString >&          lNames    ) { return ConfigItem::GetProperties( lNames ); }
        sal_Bool                                ReplaceSetProperties( const ::rtl::OUString&                                sNode     ,
                                                                            css::uno::Sequence< css::beans::PropertyValue > lValues   ) { return ConfigItem::ReplaceSetProperties( sNode, lValues ); }
		sal_Bool								SetSetProperties	( const ::rtl::OUString&								sNode,
																			css::uno::Sequence< css::beans::PropertyValue > lValues	  ) { return ConfigItem::SetSetProperties( sNode, lValues ); }
};

/*-****************************************************************************************************************
    @descr      implements an access to job and event configuration
                We know two lists: Jobs & Events.
                First one includes pure informations about outstandnig jobs.
                Event list register these jobs to special event strings, which can be triggered by any code.
                Then you can search for this event registered jobs - toggle her working mode, let him do anything
                and deregister or suspend it after that.

    @attention  We use a static, dynamic created and ref-counted ConfigItem (as DynamicConfigItem!) as an access
                to configuration. That means - we open access to cfg in ctor on refcount==0 and close it on dtor
                on refcount==1. So nobody must think about these - we do it implicitly and transparent for user.

    @threadsafe Yes - we must guarantee atomic access on our static config access!
****************************************************************************************************************-*/
class JobCFG : private ThreadHelpBase
{
    //-------------------------------------------------------------------------------------------------------------
    public:
             JobCFG          (                                                                 );
            ~JobCFG          (                                                                 );
        void readAll         (       JobHash&                                      aJobCache   ,
                                     EventHash&                                    aEventCache );
        void setUserTimeOnJob( const ::rtl::OUString&                              sJob        );
        void saveJobArguments( const ::rtl::OUString&                              sJob        ,
                               const css::uno::Sequence< css::beans::NamedValue >& lArguments  );

    //-------------------------------------------------------------------------------------------------------------
    private:
               void impl_readJobSet(                JobHash&         aJobCache      );
               void impl_readEventSet       (       EventHash&       aEventCache    ,
                                              const JobHash&         aJobCache      );
        static void impl_seperatePathEntries( const ::rtl::OUString& sPath          ,
                                                    ::rtl::OUString* pPart1         ,
                                                    ::rtl::OUString* pPart2 = NULL  ,
                                                    ::rtl::OUString* pPart3 = NULL  ,
                                                    ::rtl::OUString* pPart4 = NULL  );

    //-------------------------------------------------------------------------------------------------------------
    private:
        static DynamicConfigItem*  m_pConfigAccess; /// dynamic cfg access
        static sal_Int32           m_nRefCount    ; /// regulate creation/deletion of these access point
};

/*-****************************************************************************************************************
    @descr      cache implement to hold informations about outstanding jobs and her event registrations
                These cache support load on demand (we use member m_bInitialized in combination with method
                implts_provideFilledCaches() to do so) and implement some easy methods for cache working.
                We guarantee right working if you use only our methods to work on job configuration.
                If you call us e.g. with any job name - we don't check that and will crash!
                If you use one of returned names of getJobsForWork() - it will work fine.

    @threadsafe Yes - we must guarantee right initialized ... but on demand loaded ... caches.
****************************************************************************************************************-*/
class JobCache : private ThreadHelpBase
{
    //-------------------------------------------------------------------------------------------------------------
    public:
                                         JobCache      (                                                                        );
        ::std::vector< ::rtl::OUString > getJobsForWork( const ::rtl::OUString& sEvent                                          );
        void                             forgetJob     ( const ::rtl::OUString& sJob                                            );
        void                             suspendJob    ( const ::rtl::OUString&                              sJob               ,
                                                         const css::uno::Sequence< css::beans::NamedValue >* pArguments = NULL  );
        void                             getJobInfo    ( const ::rtl::OUString&                              sJob               ,
                                                               Job*                                          pInfo              );

    //-------------------------------------------------------------------------------------------------------------
    private:
        void implts_provideFilledCaches();

    //-------------------------------------------------------------------------------------------------------------
    private:
        JobHash    m_lJobs          ;   /// list of all outstanding jobs
        EventHash  m_lEvents        ;   /// registration of jobs for special events
        sal_Bool   m_bInitialized   ;   /// indicates non filled cache if it's FALSE
};

/*-************************************************************************************************************//**
    @short      implements executor to start jobs on triggered events
    @descr      Jobs can register himelf in configuration for execution on special events like: "startup", "shutdown" ...
                Events will be triggered by outside code and these service regulate execution of these jobs then.
                After finishing of started jobs it change configuration to start job again or delete it from configuration.

	@implements	XInterface
				XTypeProvider
				XServiceInfo
                XJobExecutor

    @base       ThreadHelpBase
				OWeakObject

    @devstatus  draft
	@threadsafe	yes
*//*-*************************************************************************************************************/

class JobExecutor   :   // interfaces
                        public  css::lang::XTypeProvider ,
                        public  css::lang::XServiceInfo  ,
                        public  css::task::XJobExecutor  ,
                        // base classes
                        // Order is neccessary for right initialization of this class!
                        private ThreadHelpBase           ,   // helper for own threadsafe code
                        public  ::cppu::OWeakObject          // helper for refcount mechanism
{
	//-------------------------------------------------------------------------------------------------------------
	//	public methods
	//-------------------------------------------------------------------------------------------------------------
	public:

		//---------------------------------------------------------------------------------------------------------
		//	constructor / destructor
		//---------------------------------------------------------------------------------------------------------
                 JobExecutor( const css::uno::Reference< css::lang::XMultiServiceFactory >& xFactory  );
        virtual ~JobExecutor(                                                                         );

		//---------------------------------------------------------------------------------------------------------
		//	XInterface, XTypeProvider, XServiceInfo
		//---------------------------------------------------------------------------------------------------------
		DECLARE_XINTERFACE
		DECLARE_XTYPEPROVIDER
		DECLARE_XSERVICEINFO

		//---------------------------------------------------------------------------------------------------------
        //  XJobExecutor
		//---------------------------------------------------------------------------------------------------------
        virtual void SAL_CALL trigger( const ::rtl::OUString& sEvent ) throw( css::uno::RuntimeException );

	//-------------------------------------------------------------------------------------------------------------
	//	private methods
	//-------------------------------------------------------------------------------------------------------------
	private:
        void impl_reactForJobResult( const ::rtl::OUString& sJob    ,
                                     const css::uno::Any&   aResult );

	//-------------------------------------------------------------------------------------------------------------
	//	debug methods
	//	(should be private everyway!)
	//-------------------------------------------------------------------------------------------------------------

	#ifdef ENABLE_ASSERTIONS

	private:

        static sal_Bool implcp_ctor   ( const css::uno::Reference< css::lang::XMultiServiceFactory >& xFactory );
        static sal_Bool implcp_trigger( const ::rtl::OUString&                                        sEvent   );

	#endif	// #ifdef ENABLE_ASSERTIONS

	//*************************************************************************************************************
	//	variables
	//*************************************************************************************************************
	private:

        css::uno::Reference< css::lang::XMultiServiceFactory >      m_xFactory      ;   /// reference to factory, which has create this instance
        JobCache                                                    m_aJobCache     ;

};      // class JobExecutor

}		// namespace framework

#endif  // #ifndef __FRAMEWORK_SERVICES_JOBEXECUTOR_HXX_
