/*************************************************************************
 *
 *  $RCSfile: typedetection.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: as $ $Date: 2001/06/11 10:22:01 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef __FRAMEWORK_SERVICES_TYPEDETECTION_HXX_
#define __FRAMEWORK_SERVICES_TYPEDETECTION_HXX_

//_________________________________________________________________________________________________________________
//	my own includes
//_________________________________________________________________________________________________________________

#ifndef __FRAMEWORK_CLASSES_FILTERCACHE_HXX_
#include <classes/filtercache.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_THREADHELPBASE_HXX_
#include <threadhelp/threadhelpbase.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_GENERIC_HXX_
#include <macros/generic.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_DEBUG_HXX_
#include <macros/debug.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_XINTERFACE_HXX_
#include <macros/xinterface.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_XTYPEPROVIDER_HXX_
#include <macros/xtypeprovider.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_XSERVICEINFO_HXX_
#include <macros/xserviceinfo.hxx>
#endif

#ifndef __FRAMEWORK_GENERAL_H_
#include <general.h>
#endif

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif

#ifndef _COM_SUN_STAR_CONTAINER_NOSUCHELEMENTEXCEPTION_HPP_
#include <com/sun/star/container/NoSuchElementException.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_WRAPPEDTARGETEXCEPTION_HPP_
#include <com/sun/star/lang/WrappedTargetException.hpp>
#endif

#ifndef _COM_SUN_STAR_CONTAINER_XNAMEACCESS_HPP_
#include <com/sun/star/container/XNameAccess.hpp>
#endif

#ifndef _COM_SUN_STAR_DOCUMENT_XTYPEDETECTION_HPP_
#include <com/sun/star/document/XTypeDetection.hpp>
#endif

//_________________________________________________________________________________________________________________
//	other includes
//_________________________________________________________________________________________________________________

#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif

//_________________________________________________________________________________________________________________
//	namespace
//_________________________________________________________________________________________________________________

namespace framework{

//_________________________________________________________________________________________________________________
//	exported const
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	exported definitions
//_________________________________________________________________________________________________________________

/*-************************************************************************************************************//**
	@short		-
	@descr		-

	@implements	XInterface
				XTypeProvider
				XServiceInfo
				XTypeDetection
				XNameAccess
				XElementAccess
	@base		ThreadHelpBase
				OWeakObject

	@devstatus	ready to use
*//*-*************************************************************************************************************/

class TypeDetection	:	public css::lang::XTypeProvider				,
						public css::lang::XServiceInfo				,
						public css::document::XTypeDetection		,
						public css::container::XNameAccess			,		// => XElementAccess
						public ThreadHelpBase							,		// Struct for right initalization of mutex member! Mst first of baseclasses
						public ::cppu::OWeakObject
{
	//-------------------------------------------------------------------------------------------------------------
	//	public methods
	//-------------------------------------------------------------------------------------------------------------

	public:

		//---------------------------------------------------------------------------------------------------------
		//	constructor / destructor
		//---------------------------------------------------------------------------------------------------------

		/*-****************************************************************************************************//**
			@short		standard constructor
			@descr		Initialize a new instance and fill our cache with values.

			@seealso	class FilterCache
			@seealso	member m_aCache

			@param		"xFactory", factory which has created us.
			@return		-

			@onerror	An ASSERTION is thrown in debug version, if xFactory is invalid or cache can't filled.
		*//*-*****************************************************************************************************/

	 	TypeDetection( const css::uno::Reference< css::lang::XMultiServiceFactory >& xFactory );

		/*-****************************************************************************************************//**
			@short		standard destructor to delete instance
			@descr		-

			@seealso	-

			@param		-
			@return		-

			@onerror	-
		*//*-*****************************************************************************************************/

		virtual ~TypeDetection();

		//---------------------------------------------------------------------------------------------------------
		//	XInterface, XTypeProvider, XServiceInfo
		//---------------------------------------------------------------------------------------------------------

		DECLARE_XINTERFACE
		DECLARE_XTYPEPROVIDER
		DECLARE_XSERVICEINFO

		//---------------------------------------------------------------------------------------------------------
		//	XTypeDetection
		//---------------------------------------------------------------------------------------------------------

		/*-****************************************************************************************************//**
			@short		search internal name of type which present given URL
			@descr		With returned internal type name you can create filter, frame loader or detect services
						which are registered for these type.
						We make a flat type detection her everyway.

			@seealso	method queryTypeByDescriptor()

			@param		"sURL", URL of document.
			@return		An internal name of a matching type.

			@onerror	An empty string is returned.
		*//*-*****************************************************************************************************/

    	virtual ::rtl::OUString SAL_CALL queryTypeByURL( const ::rtl::OUString& sURL ) throw( css::uno::RuntimeException );

		/*-****************************************************************************************************//**
			@short		search internal name of type which present given document properties
			@descr		With returned internal type name you can create filter, frame loader or detect services
						which are registered for these type.
						With an additional parameter you can regulate deep of detection.
						If bDeep TRUE and argument "InputStream" can be found in sequence - we make a content detection too!

			@seealso	method queryTypeByURL()

			@param		"seqDescriptor", is a MediaDescriptor => see service description for further informations.
			@param		"bDeep", if it's true we make a content detection, otherwise we make a flat detection only.
			@return		An internal name of a matching type.

			@onerror	An empty string is returned.
		*//*-*****************************************************************************************************/

    	virtual ::rtl::OUString SAL_CALL queryTypeByDescriptor(	css::uno::Sequence< css::beans::PropertyValue >&	seqDescriptor	,
																sal_Bool											bDeep			) throw( css::uno::RuntimeException );

		//---------------------------------------------------------------------------------------------------------
		//	XNameAccess
		//---------------------------------------------------------------------------------------------------------

		/*-****************************************************************************************************//**
			@short		return properties of registered type specified by his internal name
			@descr		Use these method to get all informations about our internal type cache.
						We return a Sequence< PropertyValue > in an Any packed as result.

						structure of return value:
							[0].Name	=	"UIName"
							[0].Value	=	localized name of filter as [string]

							[1].Name	=	"MediaType"
							[1].Value	=	mime type as [string]

							[2].Name	=	"ClipboardFormat"
							[2].Value	=	name of clipboard format as [string]

							[3].Name	=	"URLPattern"
							[3].Value	=	list of matching URL pattern to specify type; as [integer]

							[4].Name	=	"Extensions"
							[4].Value	=	list of matching file extensions to specify type; as [integer]

							[5].Name	=	"DocumentIconID"
							[5].Value	=	ID of a suitable document icon as [integer]

			@seealso	method getElementNames()
			@seealso	method hasByName()

			@param		"sName", the name of searched type (use getElementNames() to get it!)
			@return		A Sequence< PropertyValue > packed in an Any.

			@onerror	If given name not exist a NoSuchElementException is thrown.
		*//*-*****************************************************************************************************/

    	virtual css::uno::Any SAL_CALL getByName( const ::rtl::OUString& sName ) throw(	css::container::NoSuchElementException	,
																						css::lang::WrappedTargetException		,
																						css::uno::RuntimeException				);

		/*-****************************************************************************************************//**
			@short		return list of all well known type names from configuration
			@descr		Use these method to get all names of well known types.
						You can use it to get the properties of a type by calling getByName()!

			@seealso	method getByName()
			@seealso	method hasByName()

			@param		-
			@return		A list of well known types. Is static at runtime!

			@onerror	No error should occure.
		*//*-*****************************************************************************************************/

    	virtual css::uno::Sequence< ::rtl::OUString > SAL_CALL getElementNames() throw( css::uno::RuntimeException );

		/*-****************************************************************************************************//**
			@short		check if searched type exist in configuration
			@descr		Normaly nobody need these method realy (use getElementNames() in combination with getByName()).
						We guarantee correctness of these mechanism. There is no reason to check for existing elements then ...
						but if you have an unknwon name and has no fun to search it in returned sequence ...
						you can call these ...

			@seealso	method getByName()
			@seealso	method getElementNames()

			@param		"sName", implementation name of searched type
			@return		sal_True if type exist, sal_False otherwise.

			@onerror	No error should occure.
		*//*-*****************************************************************************************************/

    	virtual sal_Bool SAL_CALL hasByName( const ::rtl::OUString& sName ) throw( css::uno::RuntimeException );

		//---------------------------------------------------------------------------------------------------------
		//	XElementAccess
		//---------------------------------------------------------------------------------------------------------

		/*-****************************************************************************************************//**
			@short		return the type of retrun value of method XNameAccess::getByName()
			@descr		In these implementation its a Sequence< PropertyValue > everytime!

			@seealso	description of interface XNameAccess

			@param		-
			@return		Type of Sequence< PropertyValue >.

			@onerror	No error should occure.
		*//*-*****************************************************************************************************/

		virtual css::uno::Type SAL_CALL getElementType() throw( css::uno::RuntimeException );

		/*-****************************************************************************************************//**
			@short		return state if informations about type available
			@descr		If these method return false - no information could'nt read from configuration ...
						I think nothing will work then. Normaly we return TRUE!

			@seealso	class FilterCache!

			@param		-
			@return		sal_True if information available, sal_False otherwise.

			@onerror	No error should occure.
		*//*-*****************************************************************************************************/

    	virtual sal_Bool SAL_CALL hasElements() throw( css::uno::RuntimeException );

	//-------------------------------------------------------------------------------------------------------------
	//	protected methods
	//-------------------------------------------------------------------------------------------------------------

	protected:

	//-------------------------------------------------------------------------------------------------------------
	//	private methods
	//-------------------------------------------------------------------------------------------------------------

	private:

	//-------------------------------------------------------------------------------------------------------------
	//	debug methods
	//	(should be private everyway!)
	//-------------------------------------------------------------------------------------------------------------

		/*-****************************************************************************************************//**
			@short		debug-method to check incoming parameter of some other mehods of this class
			@descr		The following methods are used to check parameters for other methods
						of this class. The return value is used directly for an ASSERT(...).

			@seealso	ASSERTs in implementation!

			@param		references to checking variables
			@return		sal_False ,on invalid parameter
			@return		sal_True  ,otherwise

			@onerror	-
		*//*-*****************************************************************************************************/


	#ifdef ENABLE_ASSERTIONS

	private:

	 	static sal_Bool impldbg_checkParameter_TypeDetection				(	const	css::uno::Reference< css::lang::XMultiServiceFactory >&	xFactory		);
    	static sal_Bool impldbg_checkParameter_getByName					(	const	::rtl::OUString&										sName			);
    	static sal_Bool impldbg_checkParameter_hasByName					(	const	::rtl::OUString&										sName			);
    	static sal_Bool impldbg_checkParameter_queryTypeByURL				(	const	::rtl::OUString&										sURL			);
    	static sal_Bool impldbg_checkParameter_queryTypeByDescriptor		(			css::uno::Sequence< css::beans::PropertyValue >&		seqDescriptor	,
																						sal_Bool												bDeep			);

	#endif	//	#ifdef ENABLE_ASSERTIONS

	//-------------------------------------------------------------------------------------------------------------
	//	private variables
	//	(should be private everyway!)
	//-------------------------------------------------------------------------------------------------------------

	private:

		css::uno::Reference< css::lang::XMultiServiceFactory >		m_xFactory			;
		FilterCache													m_aCache			;

};		//	class TypeDetection

}		//	namespace framework

#endif	//	#ifndef __FRAMEWORK_SERVICES_TYPEDETECTION_HXX_
