/*************************************************************************
 *
 *  $RCSfile: asyncquit.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: mba $ $Date: 2001/09/19 08:06:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

//_________________________________________________________________________________________________________________
//	my own includes
//_________________________________________________________________________________________________________________

#ifndef __FRAMEWORK_CLASSES_ASYNCQUIT_HXX_
#include <classes/asyncquit.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_GENERIC_HXX_
#include <macros/generic.hxx>
#endif

#ifndef __FRAMEWORK_COMMANDS_H_
#include <commands.h>
#endif

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

#ifndef _COM_SUN_STAR_FRAME_XTASKSSUPPLIER_HPP_
#include <com/sun/star/frame/XTasksSupplier.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XENUMERATIONACCESS_HPP_
#include <com/sun/star/container/XEnumerationAccess.hpp>
#endif

//_________________________________________________________________________________________________________________
//	other includes
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	const
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	namespace
//_________________________________________________________________________________________________________________

namespace framework{

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::frame;
using namespace ::com::sun::star::container;

//_________________________________________________________________________________________________________________
//	non exported const
//_________________________________________________________________________________________________________________

#define	TIME_FOR_NORMALMODE				5000		// 5 sec timer for normal office termination
#define	TIME_FOR_PLUGINMODE				120000		// 2 min timer for offic termination in plugin mode

//_________________________________________________________________________________________________________________
//	non exported declarations
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	definitions
//_________________________________________________________________________________________________________________

//*****************************************************************************************************************
//	constructor
//*****************************************************************************************************************
AsyncQuit::AsyncQuit( const Reference< XDesktop >& xDesktop )
		:	m_xDesktop	( xDesktop	)
		,	m_bEnabled	( sal_False	)	// Default should be false - because it's better for yet unknown usings of this timer!
{
	// Safe impossible cases.
	// We need a valid reference to work correctly.
	LOG_ASSERT( impldbg_checkParameter_AsyncQuit( xDesktop ), "AsyncQuit::AsyncQuit()\nInvalid parameter detected!\n" )

	// We must detect current office mode automaticly to set right timeout value!
	impl_autoDetectMode();
}

//*****************************************************************************************************************
//	destructor
//*****************************************************************************************************************
AsyncQuit::~AsyncQuit()
{
	// Release all used references!
	m_xDesktop = Reference< XDesktop >();
}

//*****************************************************************************************************************
//	protected method
//*****************************************************************************************************************
void SAL_CALL AsyncQuit::onShot()
{
	// Attention!
	// Sometimes this timer instance has disabled himself!
	if( m_bEnabled == sal_True )
	{
		// These timer was started automaticly if last task was removed from desktop container to shut down thes office.
		// We wait for set time and if no new task was created we will terminate the desktop ...
		// We must look for new tasks before we can do that!
		// Otherwise we go sleeping and wait for next start.
        Reference< XTasksSupplier > xTasksSupplier( m_xDesktop, UNO_QUERY );
        if( xTasksSupplier.is() )
        {
            Reference < XEnumerationAccess > xEnum = xTasksSupplier->getTasks();
            if( xEnum.is() )
            {
                Reference < XElementAccess > xElement ( xEnum, UNO_QUERY );
                if ( xElement.is() )
                {
                    if( !xElement->hasElements() )
                        m_xDesktop->terminate();
                }
            }
        }
	}
}

//*****************************************************************************************************************
//	private method
//*****************************************************************************************************************
void AsyncQuit::impl_autoDetectMode()
{
	// How can we distinguish between the different office modes?
	// a) Office is plugged if command argument "-plugin" could detected.		=> timeout = 2 min
	// b) Office is "headless" if command argument "-headless" could detected.	=> timout disabled!
	// c) Otherwise office runs in normal mode.									=> timeout = 5 sec

	// Parse command line for right parameter.
	if( c_existCommand( COMMAND_PLUGIN ) == sal_True )
	{
		// Set timeout to 2 min.
		m_TimeOut	= TIME_FOR_PLUGINMODE	;
		m_bEnabled	= sal_True				;
	}
	else
	if( c_existCommand( COMMAND_HEADLESS ) == sal_True )
	{
		// Disable timer!
		// ... but how we can do it ...
		// Desktop hold a reference to us.
		// The best way (I think) is to do nothing in "onShot()" and set timeout to "instandly"!
		m_TimeOut	= 0							;
		m_xDesktop	= Reference< XDesktop >()	;
		m_bEnabled	= sal_False					;
	}
	else
	{
		// Set timeout to 5 sec.
		m_TimeOut	= TIME_FOR_NORMALMODE	;
		m_bEnabled	= sal_True				;
	}
}

//_________________________________________________________________________________________________________________
//	debug methods
//_________________________________________________________________________________________________________________

/*-----------------------------------------------------------------------------------------------------------------
	The follow methods check parameter for other functions. If a parameter or his value is non valid,
	we return "sal_False". (else sal_True) This mechanism is used to throw an ASSERT!

	ATTENTION

		If you miss a test for one of this parameters, contact the autor or add it himself !(?)
		But ... look for right testing! See using of this methods!
-----------------------------------------------------------------------------------------------------------------*/

#ifdef ENABLE_ASSERTIONS

//*****************************************************************************************************************
// We need a valid desktop reference to work.
sal_Bool AsyncQuit::impldbg_checkParameter_AsyncQuit( const Reference< XDesktop >& xDesktop )
{
	// Set default return value.
	sal_Bool bReturn = sal_True ;
	// Check state of given parameter.
	// If one of it invalid ... set right return value.
	if	(
			( &xDesktop		==	NULL		)	||
			( xDesktop.is()	==	sal_False	)
		)
	{
		bReturn = sal_False;
	}
	// Return state of checking.
	return bReturn;
}

#endif	//	#ifdef ENABLE_ASSERTIONS

}		//	namespace framework
