/*************************************************************************
 *
 *  $RCSfile: createdispatcher.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: mba $ $Date: 2001/11/21 14:57:38 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

//_________________________________________________________________________________________________________________
//	my own includes
//_________________________________________________________________________________________________________________

#ifndef __FRAMEWORK_DISPATCH_CREATEDISPATCHER_HXX_
#include <dispatch/createdispatcher.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_TRANSACTIONGUARD_HXX_
#include <threadhelp/transactionguard.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_READGUARD_HXX_
#include <threadhelp/readguard.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_WRITEGUARD_HXX_
#include <threadhelp/writeguard.hxx>
#endif

#ifndef __FRAMEWORK_CLASSES_ARGUMENTANALYZER_HXX_
#include <classes/argumentanalyzer.hxx>
#endif

#ifndef __FRAMEWORK_CLASSES_TASKCREATOR_HXX_
#include <classes/taskcreator.hxx>
#endif

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	includes of other projects
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	namespace
//_________________________________________________________________________________________________________________

namespace framework{

//_________________________________________________________________________________________________________________
//	non exported const
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	non exported definitions
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	declarations
//_________________________________________________________________________________________________________________

/*-************************************************************************************************************//**
    @short      standard ctor
    @descr      These initialize a new instance of this class with needed informations for work.

    @seealso    using at owner

    @param      "xFactory", reference to servicemanager for creation of new services
    @param      "xParent" , reference to our owner, the parent node in frame tree, on which new created frame will be a child
    @param      "sName"   , name of new created frame
    @return     -

    @onerror    -
*//*-*************************************************************************************************************/
CreateDispatcher::CreateDispatcher( const css::uno::Reference< css::lang::XMultiServiceFactory >& xFactory ,
                                    const css::uno::Reference< css::frame::XFrame >&              xParent  ,
                                    const ::rtl::OUString&                                        sName    )
		//	Init baseclasses first
        :   BaseDispatcher( xFactory, xParent  )
        // Init member
        ,   m_sTargetName ( sName              )
{
	// Safe impossible cases
    // We need valid informations about ouer owner for work.
    LOG_ASSERT2( implcp_ctor( xFactory, xParent, sName ), "CreateDispatcher::CreateDispatcher()", "Invalid parameter detected!" )
}

/*-************************************************************************************************************//**
    @interface  XDispatch
    @short      create or recycle frame
    @descr      If frame not exist, we create and named it. Otherwise we use it to dispatch argument into these frame.

    @seealso    baseclass BaseDispatcher

    @param      "aURL"      , URL to dispatch.
    @param      "lArguments", list of optional arguments.
    @return     -

    @onerror    -
    @threadsafe yes
*//*-*************************************************************************************************************/
void SAL_CALL CreateDispatcher::dispatch( const css::util::URL&                                  aURL       ,
                                          const css::uno::Sequence< css::beans::PropertyValue >& lArguments ) throw( css::uno::RuntimeException )
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
	// Method not defined for all incoming parameter
    LOG_ASSERT2( implcp_dispatch( aURL, lArguments ), "CreateDispatcher::dispatch()", "Invalid parameter detected." )
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( m_aTransactionManager, E_HARDEXCEPTIONS );

    /* SAFE AREA ----------------------------------------------------------------------------------------------- */
    ReadGuard aReadLock( m_aLock );
    // Make snapshot of neccessary member.
    css::uno::Reference< css::lang::XMultiServiceFactory > xFactory = m_xFactory;
    // Warn programmer. If our owner is dead ... something will be wrong then.
    // We are listener for dispose() on it!
    css::uno::Reference< css::frame::XFrame > xParent( m_xOwner.get(), css::uno::UNO_QUERY );
    LOG_ASSERT2( xParent.is()==sal_False, "CreateDispatcher::dispatch()", "Couldn't get owner frame reference! Algorithm error?" )
    // Check if task was already created by another dispatch call before.
    // If yes - dispatch URL into these target.
    // If not - create new frame.
    css::uno::Reference< css::frame::XFrame > xTarget( m_xTarget.get(), css::uno::UNO_QUERY );
    ::rtl::OUString                           sName  = m_sTargetName                         ;

    aReadLock.unlock();
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */

    sal_Bool                                        bMustCreate  = ( xTarget.is() == sal_False );
    sal_Bool                                        bSuccessfull = sal_False                    ;
    css::uno::Sequence< css::beans::PropertyValue > lDescriptor  ( lArguments )                 ;

    //---------------------------------------------------------------------------------------------------------
    // I)   First we must know type of dispatch URL. It's neccessary to find registered handler or loader.
    //      But we must copy given argument descriptor. Because; detection, handling or loading of URL
    //      will change this descriptor. And it's not a good idea to do that on a const parameter!
    ::rtl::OUString sTypeName = implts_detectType( aURL, lDescriptor, sal_True ); // last parameter allow deep detection!

    //---------------------------------------------------------------------------------------------------------
    // II)  If detection was successful ... try to load it.
    //      If target doesnt exist - create new one.
    if(
        ( sTypeName.getLength() >  0         )  &&
        ( xParent.is()          == sal_True  )  &&
        ( xFactory.is()         == sal_True  )
      )
    {
        if( bMustCreate == sal_True )
        {
            sal_Bool         bHidden  = sal_True     ;
            ArgumentAnalyzer aAnalyzer( lDescriptor );

            aAnalyzer.getArgument( E_HIDDEN, bHidden );

            TaskInfo aCreateInfo( xFactory, xParent, sName, !bHidden );
            xTarget = TaskCreator::createSystemTask( aCreateInfo );
        }

        if( xTarget.is() == sal_True )
        {
            // ... dispatch URL into new created or already existing target
            // But don't forget to disable currently set Controller for second case!
            // Np panic: implts_deactivateController() returns TRUE, if no controller exist!!!
            css::uno::Reference< css::frame::XController > xController = xTarget->getController();
            if( implts_deactivateController( xController ) == sal_True )
            {
                // Safe information about new created task!
                // In callback "reactForLoadingState()" we must dispose these task, if loading failed.
                // Otherwise we must reactivate currently set controller ...
                css::uno::Sequence< sal_Bool > lInfos(2);
                lInfos[0] = bMustCreate     ;
                lInfos[1] = xController.is();

                css::uno::Any aAsyncInfo;
                aAsyncInfo <<= lInfos   ;

                bSuccessfull = implts_loadIt( aURL, lDescriptor, sTypeName, xTarget, aAsyncInfo );
            }
        }
	}

    // Normal our base class handle sending of status events to our listener ...
    // But if this method failed (e.g. task couldn't be created, neccessary services couldn't be getted ...)
    // we must send our own event! Don't forget to "react for this failed operation".
    // You can do it here ... but it's better to implement it one times only in "reactForLoadingState()".
    // So you mustn't look at different places for bugfixes!
    if( bSuccessfull == sal_False )
    {
        implts_sendResultEvent( xTarget, aURL.Complete, sal_False );
        // If target was new created ... but contains no document now ... we should dispose it!
        if(
            ( xTarget.is() == sal_True )    &&
            ( bMustCreate  == sal_True )
          )
        {
            implts_disableFrame( xTarget );
        }
    }
}

/*-************************************************************************************************************//**
    @short          react for return state of dispatch call
    @descr          If we started our dispatch call ... our baseclass call us back to give us some informations about it.
                    So we can react for it. This implmentation create new tasks and try to load something in it.
                    If dispatch was successfully we must set visible state of this task - otherwise task must be deleted.
                    But there exist another mode: Some URLs was handled by an registered content handler.
                    These dispatches works without any tasks or frames!

    @attention      Base class call us back without any set lock or mutex. So we must do it by ourself!

    @seealso        base class BaseDispatcher

    @param          "aURL"       , dispatched URL
    @param          "lDescriptor", optional arguments of original dispatch call
    @param          "xTarget"    , target of dispatch (should be our new created task)
    @param          "bState"     , state of loading proccess (ok or failed)
    @return         -

    @onerror        -
    @threadsafe     yes
*//*-*************************************************************************************************************/
void SAL_CALL CreateDispatcher::reactForLoadingState( const css::util::URL&                                   aURL        ,
                                                      const css::uno::Sequence< css::beans::PropertyValue >&  lDescriptor ,
                                                      const css::uno::Reference< css::frame::XFrame >&        xTarget     ,
                                                            sal_Bool                                          bState      ,
                                                      const css::uno::Any&                                    aAsyncInfo  )
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( m_aTransactionManager, E_HARDEXCEPTIONS );

    // Look for additional AsyncInfo, set by our own "dispatch()" call.
    // We must decide between new created targets or recycled ones which must reactivate
    // her controller ...
    css::uno::Sequence< sal_Bool > lInfos                 ;
    sal_Bool                       bCreated    = sal_True ;
    sal_Bool                       bController = sal_False;

    if( (aAsyncInfo>>=lInfos) == sal_True )
    {
        bCreated    = lInfos[0];
        bController = lInfos[1];
    }

    if( bState == sal_True )
    {
        // make target visible
        implts_enableFrame( xTarget, lDescriptor );
        // Do't forget to register this new created or recycled frame
        // as our target for further dispatches!
        // Attention: Don't reset our "m_sTargetName" ... because
        // we was initialized by our ctor and given name. We must use this name everytime!
        // These dispatcher could create or recycle THIS ONE frame only!!!
        /* SAFE AREA ------------------------------------------------------------------------------------------- */
        WriteGuard aWriteLock( m_aLock );
        m_xTarget = xTarget;
        aWriteLock.unlock();
        /* UNSAFE AREA ----------------------------------------------------------------------------------------- */
    }
    else
    if( bCreated == sal_True )
    {
        // dispose new created but unused target
        implts_disableFrame( xTarget );
    }
    else
    if( bController == sal_True )
    {
        // reactivate old controller!
        css::uno::Reference< css::frame::XController > xController = xTarget->getController();
        if( implts_reactivateController( xController ) == sal_False )
        {
            implts_disableFrame( xTarget );
        }
    }
}

/*-************************************************************************************************************//**
    @short      debug-method to check incoming parameter of some other mehods of this class
    @descr      The following methods are used to check parameters for other methods
                of this class. The return value is used directly for an ASSERT(...).

    @seealso    ASSERTs in implementation!

    @param      references to checking variables
    @return     sal_True  on invalid parameter<BR>
                sal_False otherway

    @onerror    -
    @threadsafe yes / They don't work on members - they are static!
*//*-*************************************************************************************************************/
#ifdef ENABLE_ASSERTIONS

//*****************************************************************************************************************
// We check for NULL pointer, NULL-UNO-references ... and empty strings!
// An empty target name isn't allowed ... because it is defined as "_self"!!!
// So it could be a valid frame name by using dispatch mechanism. Otherwise search
// algorithm must be wrong.
sal_Bool CreateDispatcher::implcp_ctor( const css::uno::Reference< css::lang::XMultiServiceFactory >& xFactory ,
                                        const css::uno::Reference< css::frame::XFrame >&              xParent  ,
                                        const ::rtl::OUString&                                        sName    )
{
    return(
            ( &xFactory         ==  NULL      ) ||
            ( &xParent          ==  NULL      ) ||
            ( &sName            ==  NULL      ) ||
            ( xFactory.is()     ==  sal_False ) ||
            ( xParent.is()      ==  sal_False ) ||
            ( sName.getLength() <   1         )
          );
}

#endif	//	#ifdef ENABLE_ASSERTIONS

}		//	namespace framework
