/*************************************************************************
 *
 *  $RCSfile: calendarImpl.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: bustamam $ $Date: 2001/07/01 16:55:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _I18N_CALENDARIMPL_HXX_
#define _I18N_CALENDARIMPL_HXX_

#ifndef _DATETIME_HXX
#include <tools/datetime.hxx>
#endif

#ifndef _COM_SUN_STAR_I18N_XLOCALEDATA_HPP_
#include <com/sun/star/i18n/XLocaleData.hpp>
#endif

#ifndef _COM_SUN_STAR_I18N_XCALENDAR_HPP_
#include <com/sun/star/i18n/XCalendar.hpp>
#endif

#ifndef _CPPUHELPER_IMPLBASE1_HXX_
#include <cppuhelper/implbase1.hxx> // helper for implementations
#endif


class CalendarImpl :
	public cppu::WeakImplHelper1< ::com::sun::star::i18n::XCalendar >
{
public:

	CalendarImpl();
	~CalendarImpl();

    virtual void SAL_CALL loadDefaultCalendar( const ::com::sun::star::lang::Locale& rLocale ) throw(::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL loadCalendar( const ::rtl::OUString& uniqueID, const ::com::sun::star::lang::Locale& rLocale ) throw(::com::sun::star::uno::RuntimeException);
	virtual ::com::sun::star::i18n::Calendar SAL_CALL getLoadedCalendar() throw(::com::sun::star::uno::RuntimeException);
    virtual ::com::sun::star::uno::Sequence< ::rtl::OUString > SAL_CALL getAllCalendars( const ::com::sun::star::lang::Locale& rLocale ) throw(::com::sun::star::uno::RuntimeException);
    virtual ::rtl::OUString SAL_CALL getUniqueID(  ) throw(::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL setDateTime( double nTimeInDays ) throw(::com::sun::star::uno::RuntimeException);
    virtual double SAL_CALL getDateTime(  ) throw(::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL setValue( sal_Int16 nFieldIndex, sal_Int16 nValue ) throw(::com::sun::star::uno::RuntimeException);
    virtual sal_Int16 SAL_CALL getValue( sal_Int16 nFieldIndex ) throw(::com::sun::star::uno::RuntimeException);
    virtual sal_Bool SAL_CALL isValid() throw (::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL addValue( sal_Int16 nFieldIndex, sal_Int32 nAmount ) throw(::com::sun::star::uno::RuntimeException);
    virtual sal_Int16 SAL_CALL getFirstDayOfWeek(  ) throw(::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL setFirstDayOfWeek( sal_Int16 nDay ) throw(::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL setMinimumNumberOfDaysForFirstWeek( sal_Int16 nDays ) throw(::com::sun::star::uno::RuntimeException);
    virtual sal_Int16 SAL_CALL getMinimumNumberOfDaysForFirstWeek(  ) throw(::com::sun::star::uno::RuntimeException);
    virtual sal_Int16 SAL_CALL getNumberOfMonthsInYear(  ) throw(::com::sun::star::uno::RuntimeException);
    virtual sal_Int16 SAL_CALL getNumberOfDaysInWeek(  ) throw(::com::sun::star::uno::RuntimeException);
	virtual ::com::sun::star::uno::Sequence< ::com::sun::star::i18n::CalendarItem > SAL_CALL getMonths() throw(::com::sun::star::uno::RuntimeException);
	virtual ::com::sun::star::uno::Sequence< ::com::sun::star::i18n::CalendarItem > SAL_CALL getDays() throw(::com::sun::star::uno::RuntimeException);
    virtual ::rtl::OUString SAL_CALL getDisplayName( sal_Int16 nCalendarDisplayIndex, sal_Int16 nIdx, sal_Int16 nNameType ) throw(::com::sun::star::uno::RuntimeException);


private:
	::com::sun::star::uno::Reference< ::com::sun::star::i18n::XLocaleData > xLocaleData;
	::com::sun::star::lang::Locale		aLocale;
	::com::sun::star::i18n::Calendar	aCalendar;

			const DateTime				aEpoch;
			DateTime					aDateTime;
			sal_Int16					nDstOffset;
			sal_Int16					nFirstDayOfWeek;
			sal_Int16					nMinimumNumberOfDaysForFirstWeek;

			void						invalidateData();
};
#endif
