/*************************************************************************
 *
 *  $RCSfile: collator.cxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: bustamam $ $Date: 2001/12/15 13:39:15 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <assert.h>

#include <collator.hxx>
#include <com/sun/star/uno/Sequence.hxx>
#include <com/sun/star/i18n/XTransliteration.hpp>
#include <com/sun/star/i18n/TransliterationModules.hpp>
#include <com/sun/star/i18n/CollatorOptions.hpp>
#include <stdio.h>

#include <cppuhelper/servicefactory.hxx>
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#include <unotools/processfactory.hxx>

using namespace ::rtl;
using namespace ::osl;
using namespace ::std;
using namespace ::cppu;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::i18n;

Collator::Collator( const ::com::sun::star::uno::Reference <
                                        ::com::sun::star::lang::XMultiServiceFactory >& rxMSF ):xMSF(rxMSF)
{
    if ( rxMSF.is()) {
        ::com::sun::star::uno::Reference < ::com::sun::star::uno::XInterface > xI = xMSF->createInstance( ::rtl::OUString::createFromAscii("com.sun.star.i18n.LocaleData"));
        if ( xI.is() ) {
            ::com::sun::star::uno::Any x = xI->queryInterface(::getCppuType((const ::com::sun::star::uno::Reference< ::com::sun::star::i18n::XLocaleData>*)0));
            x >>= xLD;
	}
    }
    implementationName = "com.sun.star.i18n.Collator";

}

Collator::~Collator() {
}

sal_Int32 SAL_CALL
Collator::compareSubstring(
    const ::rtl::OUString& str1, sal_Int32 off1, sal_Int32 len1,
    const ::rtl::OUString& str2, sal_Int32 off2, sal_Int32 len2)
    throw(::com::sun::star::uno::RuntimeException)
{
    if( xC.is() )
	return( xC->compareSubstring(str1, off1, len1, str2, off2, len2) );
    return(0);
}

sal_Int32 SAL_CALL
Collator::compareString(
    const ::rtl::OUString& in_str1,
    const ::rtl::OUString& in_str2)
    throw(::com::sun::star::uno::RuntimeException)
{
    if( xC.is() )
	return( xC->compareString(in_str1, in_str2) );
    return(0);
}


sal_Int32 SAL_CALL
Collator::loadCollatorAlgorithm(const ::rtl::OUString& rAlgorithm,
		   const ::com::sun::star::lang::Locale& rLocale,
		   sal_Int32 option) throw(::com::sun::star::uno::RuntimeException)
{
	::rtl::OUString rServiceName(::rtl::OUString::createFromAscii( "com.sun.star.i18n."));
	if ( rLocale.Language.getLength() ) {
	    ::rtl::OUString underScore( ::rtl::OUString::createFromAscii("_") );
	    rServiceName += rLocale.Language;
	    if ( rLocale.Country.getLength() )
		rServiceName += underScore + rLocale.Country;
	    if ( rLocale.Variant.getLength() )
		rServiceName += underScore + rLocale.Variant;
	    if ( rAlgorithm.getLength() )
		rServiceName += underScore + rAlgorithm;
	    rServiceName += underScore;
	}
	rServiceName += ::rtl::OUString::createFromAscii("Collator");

        if ( (!rServiceName.equals(aServiceName) || !xC.is()) && xMSF.is() ) {
	    aLocale = rLocale;
	    aServiceName = rServiceName;

	    if ( rServiceName.compareToAscii( implementationName ) != 0 ) {
		::com::sun::star::uno::Reference < ::com::sun::star::uno::XInterface >
			xI = xMSF->createInstance( rServiceName );
		if( xI.is() ) {
		    ::com::sun::star::uno::Any x = xI->queryInterface( 
				    ::getCppuType((const ::com::sun::star::uno::Reference<
				    ::com::sun::star::i18n::XCollator>*)0) );
			x >>= xC;
		} else
		    xC.clear();
	    } else
		xC.clear();

	    if ( ! xC.is() ) {
		::com::sun::star::uno::Reference < ::com::sun::star::uno::XInterface >
			xI = xMSF->createInstance( ::rtl::OUString::createFromAscii(
					"com.sun.star.i18n.SimpleCollator") );
		if( xI.is() ) {
		    ::com::sun::star::uno::Any x = xI->queryInterface( 
				    ::getCppuType((const ::com::sun::star::uno::Reference<
				    ::com::sun::star::i18n::XCollator>*)0) );
			x >>= xC;
		    xC->loadDefaultCollator(rLocale, option);
		} else
		    xC.clear();
	    }
        }

	tranModules = TransliterationModules_END_OF_MODULE;
	if (option & CollatorOptions::CollatorOptions_IGNORE_CASE)
	    tranModules = (TransliterationModules) (tranModules | TransliterationModules_IGNORE_CASE);
	if (option & CollatorOptions::CollatorOptions_IGNORE_KANA)
	    tranModules = (TransliterationModules) (tranModules | TransliterationModules_IGNORE_KANA);
	if (option & CollatorOptions::CollatorOptions_IGNORE_WIDTH)
	    tranModules = (TransliterationModules) (tranModules | TransliterationModules_IGNORE_WIDTH);

	return(0);
}


sal_Int32 SAL_CALL
Collator::loadDefaultCollator( const ::com::sun::star::lang::Locale& rLocale, sal_Int32 collatorOptions) throw(::com::sun::star::uno::RuntimeException)
{
    ::com::sun::star::uno::Sequence< ::com::sun::star::i18n::Implementation >
		&imp = xLD->getCollatorImplementations(rLocale);

    for (sal_Int32 i = 0; i < imp.getLength(); i++)
 	if ( imp[i].isDefault )
	    return loadCollatorAlgorithm(imp[i].unoID.copy(imp[i].unoID.indexOf('.') + 1), rLocale, collatorOptions);
    return(0);
}

void SAL_CALL
Collator::loadCollatorAlgorithmWithEndUserOption(const ::rtl::OUString& impl,
		    const ::com::sun::star::lang::Locale& rLocale,
		    const ::com::sun::star::uno::Sequence< sal_Int32 >& collatorOptions) 
		    throw(::com::sun::star::uno::RuntimeException)
{
    sal_Int32 options = 0;

    for (sal_Int32 i = 0; i < collatorOptions.getLength(); i++)
        options |= collatorOptions[i];

    loadCollatorAlgorithm(impl, rLocale, options);
}

::com::sun::star::uno::Sequence< ::rtl::OUString > SAL_CALL Collator::listCollatorAlgorithms( const ::com::sun::star::lang::Locale& rLocale ) throw(::com::sun::star::uno::RuntimeException)
{
    ::com::sun::star::uno::Sequence< ::com::sun::star::i18n::Implementation >
		&imp = xLD->getCollatorImplementations(rLocale);

    ::com::sun::star::uno::Sequence< ::rtl::OUString > list(imp.getLength());

    for (sal_Int32 i = 0; i < imp.getLength(); i++) {
        //if the current algorithm is default and the position is not on the first one, then switch
        if (imp[i].isDefault && i) {
           list[i] = list[0];
           list[0] = imp[i].unoID.copy(imp[i].unoID.indexOf('.') + 1);
        }
        else
	    //remove the language and country from the algorithm
 	  list[i] = imp[i].unoID.copy(imp[i].unoID.indexOf('.') + 1);
    }
    return list;
}

::com::sun::star::uno::Sequence< sal_Int32 > SAL_CALL
Collator::listCollatorOptions( const ::rtl::OUString& rAlgorithm )
throw(::com::sun::star::uno::RuntimeException)
{
    // Collation Options is link to locale, not collatorAlgorithm, this method get misleading.
    if (!aLocale.Language.getLength()) {
	::com::sun::star::uno::Sequence< sal_Int32 > options(1);
	options[0] = CollatorOptions::CollatorOptions_IGNORE_CASE;
	return options;
    } else if (xLD.is()) {
	::com::sun::star::uno::Sequence< ::rtl::OUString > optStr = xLD->getCollationOptions(aLocale);
	::com::sun::star::uno::Sequence< sal_Int32 > options(optStr.getLength());
	for (int i = 0; i < optStr.getLength(); i++)
	    if (!optStr[i].compareToAscii("IGNORE_CASE"))
		options[i] =  CollatorOptions::CollatorOptions_IGNORE_CASE;
	    else if (!optStr[i].compareToAscii("IGNORE_KANA"))
	    	options[i] =  CollatorOptions::CollatorOptions_IGNORE_KANA;
	    else if (!optStr[i].compareToAscii("IGNORE_WIDTH"))
	    	options[i] =  CollatorOptions::CollatorOptions_IGNORE_WIDTH;
	    else
	    	options[i] =  0;
	return options;
    }
    return(NULL);
}


::rtl::OUString SAL_CALL
Collator::getImplementationName(void)
                throw( RuntimeException )
{
    return ::rtl::OUString::createFromAscii(implementationName);
}

sal_Bool SAL_CALL
Collator::supportsService(const rtl::OUString& rServiceName)
                throw( RuntimeException )
{
    return !rServiceName.compareToAscii(implementationName);
}

Sequence< ::rtl::OUString > SAL_CALL
Collator::getSupportedServiceNames(void) throw( RuntimeException )
{
    Sequence< ::rtl::OUString > aRet(1);
    aRet[0] = ::rtl::OUString::createFromAscii(implementationName);
    return aRet;
}

