/*************************************************************************
 *
 *  $RCSfile: inetpop3.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: mhu $ $Date: 2001/03/19 11:05:07 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Matthias Huetsch <matthias.huetsch@sun.com>
 *
 *
 ************************************************************************/

#ifndef _INETPOP3_HXX
#define _INETPOP3_HXX "$Revision: 1.2 $"

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _INET_CLIENT_HXX
#include <inet/client.hxx>
#endif

class List;

/*=======================================================================
 *
 * INetCorePOP3Connection Interface.
 *
 * References:
 *   RFC 1939 - Post Office Protocol - Version 3 (STD 53).
 *   RFC 1920 - Internet Official Protocol Standards (STD 1).
 *
 *=====================================================================*/
#define INETCOREPOP3_DEF_PORT 110

enum INetCorePOP3ConnectionReply
{
	// Implementation defined Reply (-x)
	INETCOREPOP3_REPLY_TRANSFER_WAIT  = -6,
	INETCOREPOP3_REPLY_CONNECT_ERROR  = -5,
	INETCOREPOP3_REPLY_CONNECT_WAIT   = -4,
	INETCOREPOP3_REPLY_RESOLVER_ERROR = -3,
	INETCOREPOP3_REPLY_RESOLVER_WAIT  = -2,
	INETCOREPOP3_REPLY_NETWORK_ERROR  = -1,

	// Post Office Protocol Reply
	INETCOREPOP3_REPLY_ERROR          =  0,
	INETCOREPOP3_REPLY_OK             =  1
};

struct INetCorePOP3MailListEntry
{
	sal_uInt32 m_nIndex;
	sal_uInt32 m_nSize;
};

typedef rtl::OUString INetCorePOP3UniqueIdListEntry;

class INetCoreMessageOStream;

#ifdef _USE_NAMESPACE
namespace inet {
#endif

class  INetCorePOP3Connection;
struct INetCorePOP3CmdContext;
struct INetCorePOP3ConnectionContext;

typedef sal_Bool INetCorePOP3Callback (
	INetCorePOP3Connection *pConnection,
	sal_Int32               nReplyCode,
	const sal_Char         *pReplyText,
	void                   *pData);

class INetCorePOP3Connection :
	public NAMESPACE_INET(INetClientConnection_Impl)
{
public:
    INetCorePOP3Connection (void);

	sal_Bool Open (
		const rtl::OUString &rHost, sal_uInt16 nPort,
		INetCorePOP3Callback *pfnCallback, void *pData);
	sal_Bool IsOpen (void);

	sal_Bool Close (
		INetCorePOP3Callback *pfnCallback, void *pData);
	void Destroy (void);

	sal_Bool LoginUser (
		const rtl::OUString &rUsername,
		INetCorePOP3Callback *pfnCallback, void *pData);
	sal_Bool LoginPassword (
		const rtl::OUString &rPassword,
		INetCorePOP3Callback *pfnCallback, void *pData);
	sal_Bool LoginSecure (
		const rtl::OUString &rUsername,
		const rtl::OUString &rPassword,
		INetCorePOP3Callback *pfnCallback, void *pData);
	sal_Bool IsLoggedIn (void);

	sal_Bool GetMailListEntry (
		INetCorePOP3MailListEntry &rMailEntry,
		INetCorePOP3Callback *pfnCallback, void *pData);
	sal_Bool GetMailList (
		List& rMailList,
		INetCorePOP3Callback *pfnCallback, void *pData);

	sal_Bool GetUniqueIdList (
		List& rUniqueIdList,
		INetCorePOP3Callback *pfnCallback, void *pData);

	sal_Bool GetMailHeader (
		sal_uInt32 nIndex, INetCoreMessageOStream& rMessageStream,
		INetCorePOP3Callback *pfnCallback, void *pData);

	sal_Bool DeleteMail (
		sal_uInt32 nIndex,
		INetCorePOP3Callback *pfnCallback, void *pData);

	sal_Bool RetrieveMail (
		sal_uInt32 nIndex, INetCoreMessageOStream& rMessageStream,
		INetCorePOP3Callback *pfnCallback, void *pData);
	sal_uInt32 GetRetrieveCount (void);

	sal_Bool SetRetrieveCallback (
		INetCorePOP3Callback *pfnCallback, void *pData);
	sal_Bool SetTerminateCallback (
		INetCorePOP3Callback *pfnCallback, void *pData);

protected:
	virtual ~INetCorePOP3Connection (void);

private:
	INetCorePOP3ConnectionContext *m_pConCtx;

	virtual sal_Bool handleResolverEvent (
		sal_Int32 nStatus, INetCoreDNSHostEntry *pHostEntry);

	virtual sal_Bool handleSocketEvent (
		const NAMESPACE_VOS(ORef)<INetSocket> &rxSocket, sal_Int32 nEvent);

	sal_Bool StartCommand (INetCorePOP3CmdContext *pCtx);
};

#ifdef _USE_NAMESPACE
}
#endif

#endif /* !_INETPOP3_HXX */

