/*************************************************************************
 *
 *  $RCSfile: inetsmtp.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: mhu $ $Date: 2001/03/19 11:05:07 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Matthias Huetsch <matthias.huetsch@sun.com>
 *
 *
 ************************************************************************/

#ifndef _INETSMTP_HXX
#define _INETSMTP_HXX "$Revision: 1.2 $"

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _INET_CLIENT_HXX
#include <inet/client.hxx>
#endif

class INetCoreMessageIStream;

/*=======================================================================
 *
 * INetCoreSMTPConnection Interface.
 *
 * Reference: RFC  821 - Simple Mail Transfer Protocol (STD 10).
 *            RFC 1123 - Requirements for Internet Hosts.
 *            RFC 1920 - Internet Official Protocol Standards (STD 1).
 *
 *=====================================================================*/
#define INETCORESMTP_DEF_PORT 25

enum INetCoreSMTPConnectionReply
{
	// Implementation defined Reply (-x)
	INETCORESMTP_REPLY_TRANSFER_WAIT      =  -6,
	INETCORESMTP_REPLY_CONNECT_ERROR      =  -5,
	INETCORESMTP_REPLY_CONNECT_WAIT       =  -4,
	INETCORESMTP_REPLY_RESOLVER_ERROR     =  -3,
	INETCORESMTP_REPLY_RESOLVER_WAIT      =  -2,
	INETCORESMTP_REPLY_NETWORK_ERROR      =  -1,

	// Positive Preliminary Reply (1xx)
	   // unused.

	// Positive Completion Reply (2xx)
	INETCORESMTP_REPLY_SYSTEM_STATUS      = 211,
	INETCORESMTP_REPLY_HELP_MESSAGE       = 214,
	INETCORESMTP_REPLY_SERVICE_READY      = 220,
	INETCORESMTP_REPLY_SERVICE_CLOSING    = 221,
	INETCORESMTP_REPLY_ACTION_OK          = 250,
	INETCORESMTP_REPLY_FORWARDING         = 251,

	// Positive Intermediate Reply (3xx)
	INETCORESMTP_REPLY_START_MAILING      = 354,

	// Transient Negative Completion Reply (4xx)
	INETCORESMTP_REPLY_SERVICE_UNAVAIL    = 421,
	INETCORESMTP_REPLY_MAILBOX_UNAVAIL    = 450,
	INETCORESMTP_REPLY_ACTION_ABORTED     = 451,
	INETCORESMTP_REPLY_STORAGE_UNAVAIL    = 452,

	// Permanent Negative Completion Reply (5xx)
	INETCORESMTP_REPLY_COMMAND_SYNTAX     = 500,
	INETCORESMTP_REPLY_PARAM_SYNTAX       = 501,
	INETCORESMTP_REPLY_COMMAND_UNAVAIL    = 502,
	INETCORESMTP_REPLY_COMMAND_SEQUENCE   = 503,
	INETCORESMTP_REPLY_PARAM_UNAVAIL      = 504,
	INETCORESMTP_REPLY_MAILBOX_INVALID    = 550,
	INETCORESMTP_REPLY_REMOTE_USER        = 551,
	INETCORESMTP_REPLY_STORAGE_EXCEEDED   = 552,
	INETCORESMTP_REPLY_MAILBOX_NAME       = 553,
	INETCORESMTP_REPLY_TRANSACTION_FAILED = 554
};

#ifdef _USE_NAMESPACE
namespace inet {
#endif

class  INetCoreSMTPConnection;
struct INetCoreSMTPConnectionContext;
struct INetCoreSMTPCommandContext;

typedef sal_Bool INetCoreSMTPCallback (
	INetCoreSMTPConnection *pConnection,
	sal_Int32               nReplyCode,
	const sal_Char         *pReplyText,
	void                   *pData);

class INetCoreSMTPConnection :
	public NAMESPACE_INET(INetClientConnection_Impl)
{
public:
    INetCoreSMTPConnection (void);

	sal_Bool Open (
		const rtl::OUString  &rHost, sal_uInt16 nPort,
		INetCoreSMTPCallback *pfnCallback, void *pData);
	sal_Bool IsOpen (void);

	sal_Bool Close (
		INetCoreSMTPCallback *pfnCallback, void *pData);
	void Destroy (void);

	sal_Bool MailFrom (
		const rtl::OUString  &rSender,
		INetCoreSMTPCallback *pfnCallback, void *pData);
	sal_Bool MailTo (
		const rtl::OUString  &rRecipient,
		INetCoreSMTPCallback *pfnCallback, void *pData);

	sal_Bool TransferData (
		INetCoreMessageIStream &rMessageStream,
		INetCoreSMTPCallback *pfnCallback, void *pData);
	sal_uInt32 GetTransferCount (void);

	sal_Bool SetTransferCallback (
		INetCoreSMTPCallback *pfnCallback, void *pData);
	sal_Bool SetTerminateCallback (
		INetCoreSMTPCallback *pfnCallback, void *pData);

protected:
	virtual ~INetCoreSMTPConnection (void);

private:
	INetCoreSMTPConnectionContext *m_pConCtx;

	virtual sal_Bool handleResolverEvent (
		sal_Int32 nStatus, INetCoreDNSHostEntry *pHostEntry);

	virtual sal_Bool handleSocketEvent (
		const NAMESPACE_VOS(ORef)<INetSocket> &rxSocket, sal_Int32 nEvent);

	sal_Bool StartCommand (INetCoreSMTPCommandContext *pCtx);
};

#ifdef _USE_NAMESPACE
}
#endif

#endif /* !_INETSMTP_HXX */

