/*************************************************************************
 *
 *  $RCSfile: inethbci.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: mhu $ $Date: 2001/03/19 11:27:12 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define _INETHBCI_CXX "$Revision: 1.2 $"

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif
#ifndef _DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif
#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif
#ifndef _CACHESTR_HXX
#include <tools/cachestr.hxx>
#endif

#ifndef _INETHBCI_HXX
#include <inethbci.hxx>
#endif
#ifndef _INETTCP_HXX
#include <inettcp.hxx>
#endif

INetHbci::INetHbci()
	: nWritten (0),
	  nStatus  (INET_HBCI_NOTCONNECTED)
{
}

INetHbci::~INetHbci()
{
	Disconnect();
}

const BOOL INetHbci::Connect(const String& sHost, const USHORT nPort )
{
	if (xCon.isValid())
		Disconnect();

	xCon = new INetCoreTCPConnection;
	xCon->SetTerminateCallback (
		(INetCoreTCPCallback*)TerminateCallback, this);

	if (!xCon->Open (
		rtl::OUString::createFromAscii ("hbci://"),
		sHost, nPort,
		(INetCoreTCPCallback*)ConnectCallback, this))
	{
		xCon = 0;
		aConnectLinkHdl.Call(
			(void*)((UINT32)INET_HBCI_NAMERESOLVE_ERROR));
		return FALSE;
	}
	return TRUE;
}

void INetHbci::Disconnect()
{
	if (nStatus == INET_HBCI_CONNECTED)
	{
		nStatus = INET_HBCI_NOTCONNECTED;
		aDisconnectLinkHdl.Call(this);
	}
	if (xCon.isValid())
	{
		xCon->Abort();
		xCon = 0;
	}
}

const BOOL INetHbci::WriteRequest(SvLockBytes* pLB)
{
	if (xCon.isValid())
	{
		xSendLB = pLB;
		return xCon->Send (*pLB, (INetCoreTCPCallback*)SendCallback, this);
	}
	return FALSE;
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// Callbacks for the INetCoreTCPConnection
//

int INetHbci::ConnectCallback( INetCoreTCPConnection *pCon,
							   int nStatus,
							   INetHbci *pThis)
{
	switch (nStatus)
	{
		case INETCORETCP_STATUS_NAMERES_WAIT:
			break;

		case INETCORETCP_STATUS_NAMERES_DONE:
			// callback wird in connect_wait gerufen
			break;

		case INETCORETCP_STATUS_NAMERES_ERROR:
			pThis->xCon->Abort();
			pThis->xCon = 0;
			pThis->aConnectLinkHdl.Call(
				(void*)((UINT32)INET_HBCI_NAMERESOLVE_ERROR));
			break;

		case INETCORETCP_STATUS_CONNECT_WAIT:
			pThis->aStatusLinkHdl.Call(
				(void*)((UINT32)INET_HBCI_NAMERESOLVED));
			break;

		case INETCORETCP_STATUS_CONNECT_DONE:
			pThis->nStatus = INET_HBCI_CONNECTED;
			pThis->aConnectLinkHdl.Call(
				(void*)((UINT32)INET_HBCI_CONNECT_SUCCESS));
			break;

		case INETCORETCP_STATUS_NETWORK_ERROR:
		case INETCORETCP_STATUS_CONNECT_ERROR:
			pThis->xCon->Abort();
			pThis->xCon = 0;
			pThis->aConnectLinkHdl.Call(
				(void*)((UINT32)INET_HBCI_CONNECT_ERROR));
			break;

		default:
			DBG_WARNINGFILE("Unknown Callbackstatus");
			break;
	}
	return 0;
}

int INetHbci::SendCallback( INetCoreTCPConnection *pCon,
							int nStatus,
							INetHbci *pThis)
{
	switch (nStatus)
	{
		case INETCORETCP_STATUS_NETWORK_ERROR:
			pThis->Disconnect();
			break;

		case INETCORETCP_STATUS_SEND_WAIT:
			pThis->nWritten = pThis->xCon->GetSendCount();
			if (pThis->nWritten > 0)
				pThis->aStatusLinkHdl.Call(
					(void*)((UINT32)INET_HBCI_DATAWRITTEN));
			break;

		case INETCORETCP_STATUS_SEND_DONE:
		{
			
			pThis->nWritten = pThis->xCon->GetSendCount();
			pThis->aStatusLinkHdl.Call(
				(void*)((UINT32)INET_HBCI_DATAWRITTEN));

			pThis->xRecvLB =
				new SvLockBytes (new SvCacheStream, TRUE);
			pThis->xCon->Recv (
				*(pThis->xRecvLB),
				(INetCoreTCPCallback*)ReceiveCallback,
				pThis);
		}
		break;

		default:
			DBG_WARNINGFILE("Unknown Callbackstatus");
			break;
	}
	return 0;
}

int INetHbci::ReceiveCallback( INetCoreTCPConnection *pCon,
							   int nStatus,
							   INetHbci *pThis)
{
	switch (nStatus)
	{
		case INETCORETCP_STATUS_NETWORK_ERROR:
		case INETCORETCP_STATUS_RECV_ERROR:
			pThis->Disconnect();
			break;

		case INETCORETCP_STATUS_RECV_WAIT:
			pThis->aResponseLinkHdl.Call(&(*(pThis->xRecvLB)));
			break;

		default:
			DBG_WARNINGFILE("Unknown Callbackstatus");
			break;
	}
	return 0;
}

int INetHbci::TerminateCallback( INetCoreTCPConnection *pCon,
								 int nStatus,
								 INetHbci *pThis)
{
	pThis->xCon = 0;
	if(nStatus == INET_HBCI_CONNECTED)
	{
		nStatus = INET_HBCI_NOTCONNECTED;
		pThis->aDisconnectLinkHdl.Call(pThis);
	}
	return 0;
}

//----------------------
void INetHbci::dummy1(){};
void INetHbci::dummy2(){};
void INetHbci::dummy3(){};
//----------------------

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// C-Wrapper Functions
//

INetHbci* __LOADONCALLAPI NewINetHbci()
{
	return new INetHbci();
};

