/*************************************************************************
 *
 *  $RCSfile: ftpcntl.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: th $ $Date: 2001/05/11 12:18:33 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Matthias Huetsch <matthias.huetsch@sun.com>
 *
 *
 ************************************************************************/

#define _INET_FTPCNTL_CXX "$Revision: 1.3 $"

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifndef _RTL_ALLOC_H_
#include <rtl/alloc.h>
#endif
#ifndef _RTL_MEMORY_H_
#include <rtl/memory.h>
#endif
#ifndef _RTL_STRING_H_
#include <rtl/string.h>
#endif

#ifndef _VOS_MACROS_HXX_
#include <vos/macros.hxx>
#endif
#ifndef _VOS_OBJECT_HXX_
#include <vos/object.hxx>
#endif

#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

#ifndef _INET_SOCKET_HXX
#include <inet/socket.hxx>
#endif

#ifndef _INET_FTPCNTL_HXX
#include <ftpcntl.hxx>
#endif

#include <stdlib.h>

#ifdef _USE_NAMESPACE
using namespace inet;
#endif

using rtl::OString;
using rtl::OUString;

//=======================================================================

inline sal_Bool ascii_isDigit( sal_Unicode ch )
{
    return ((ch >= 0x0030) && (ch <= 0x0039));
}

/*========================================================================
 *
 * INetFTPCntlContext implementation.
 *
 *======================================================================*/
/*
 * INetFTPCntlContext.
 */
INetFTPCntlContext::INetFTPCntlContext (sal_uInt32 nBufSiz)
    : m_xSocket (NULL),
      m_nBufSiz (nBufSiz),
      m_pfnCB   (NULL),
      m_pDataCB (NULL)
{
    m_pBuffer = (sal_Char*)(rtl_allocateMemory (m_nBufSiz));
    m_pRead = m_pWrite = m_pBuffer;
}

/*
 * ~INetFTPCntlContext.
 */
INetFTPCntlContext::~INetFTPCntlContext (void)
{
    if (m_xSocket.isValid())
    {
        m_xSocket->close();
        m_xSocket.unbind();
    }
    rtl_freeMemory (m_pBuffer);
}

/*
 * copy.
 */
void INetFTPCntlContext::copy (const sal_Char *pBuffer, sal_uInt32 nLength)
{
    NAMESPACE_VOS(OGuard) aGuard (*this);
    if (m_nBufSiz < nLength)
    {
        m_nBufSiz = nLength;
        m_pBuffer = (sal_Char*)(rtl_reallocateMemory (m_pBuffer, m_nBufSiz));
    }
    m_pRead = m_pWrite = m_pBuffer;

    rtl_copyMemory (m_pBuffer, pBuffer, nLength);
    m_pRead += nLength;
}

/*
 * send.
 */
sal_Int32 INetFTPCntlContext::send (INetFTPCommandStream *pStrm)
{
    NAMESPACE_VOS(OGuard) aGuard (*this);

    m_aStateBlk.setStateCode(0);
    while (!m_aStateBlk.getStateCode())
    {
        // Send command.
        sal_Int32 nBytes = m_pRead - m_pWrite;
        if (nBytes > 0)
        {
            // Command buffer not yet empty.
            sal_Int32 nWrite = INETFTP_SOCKET_INVALID;
            if (m_xSocket.isValid())
                nWrite = m_xSocket->send (m_pWrite, nBytes);
            if (nWrite > 0)
            {
                // Have written some bytes.
                m_pWrite += nWrite;
            }
            else if (nWrite == INETFTP_SOCKET_WOULDBLOCK)
            {
                // Wait for next event.
                m_aStateBlk.setStateCode (
                    INetFTPConnection::REPLY_REQUEST_WAIT);
            }
            else
            {
                // Network error.
                m_aStateBlk.setStateCode (
                    INetFTPConnection::REPLY_NETWORK_ERROR);
                m_aStateBlk.setState (STATE_ERROR);
            }
        }
        else
        {
            // Command buffer empty.
            m_pRead = m_pWrite = m_pBuffer;

            // Check command stream.
            if (pStrm)
            {
                // Read command.
                int nRead = pStrm->read (m_pBuffer, m_nBufSiz, this);
                if (nRead > 0)
                {
                    // Have read some bytes.
                    m_pRead += nRead;
                }
                else
                {
                    // Command stream exhausted.
                    m_aStateBlk.setStateCode (
                        INetFTPConnection::REPLY_REQUEST_DONE);
                }
            }
            else
            {
                // Done.
                m_aStateBlk.setStateCode (
                    INetFTPConnection::REPLY_REQUEST_DONE);
            }
        }
    }
    return m_aStateBlk.getStateCode();
}

/*
 * recv.
 */
sal_Int32 INetFTPCntlContext::recv (INetFTPCommandStream *pStrm)
{
    NAMESPACE_VOS(OGuard) aGuard (*this);

    m_aStateBlk.setStateCode(0);
    while (!m_aStateBlk.getStateCode())
    {
        // Read reply.
        sal_Int32 nRead = INETFTP_SOCKET_INVALID;
        if (m_xSocket.isValid())
            nRead = m_xSocket->recv (m_pBuffer, m_nBufSiz);
        if (nRead > 0)
        {
            // Check command stream.
            typedef INetFTPCommandStream command_type;
            if (pStrm)
            {
                // Analyze reply.
                sal_Int32 result = pStrm->write (m_pBuffer, nRead, this);
                if (!(result == command_type::REPLY_OK))
                {
                    if (result == command_type::REPLY_LOADED)
                    {
                        // Obtain reply code.
                        m_aStateBlk.setStateCode (pStrm->getReplyCode());
                    }
                    else
                    {
                        // Syntax error.
                        m_aStateBlk.setStateCode (
                            INetFTPConnection::REPLY_SYNTAX_ERROR);
                        m_aStateBlk.setState (STATE_ERROR);
                    }
                }
            }
        }
        else if (nRead == INETFTP_SOCKET_WOULDBLOCK)
        {
            // Wait for next event.
            m_aStateBlk.setStateCode (
                INetFTPConnection::REPLY_RESPONSE_WAIT);
        }
        else
        {
            // Network error.
            m_aStateBlk.setStateCode (
                INetFTPConnection::REPLY_NETWORK_ERROR);
            m_aStateBlk.setState (STATE_ERROR);
        }
    }
    return m_aStateBlk.getStateCode();
}

/*========================================================================
 *
 * INetFTPCommandStream implementation.
 *
 *======================================================================*/
VOS_IMPLEMENT_CLASSINFO(
    VOS_CLASSNAME (INetFTPCommandStream, inet),
    VOS_NAMESPACE (INetFTPCommandStream, inet),
    VOS_NAMESPACE (OObject, vos),
    0);

/*
 * INetFTPCommandStream.
 */
INetFTPCommandStream::INetFTPCommandStream (
    const OString &rCommand, Command eCommand)
    : m_eCommand   (eCommand),
      m_pCommand   (NULL),
      m_pRead      (NULL),
      m_pWrite     (NULL),
      m_nReplyCode (0),
      m_bFirstLine (sal_True)
{
    sal_Int32 n = rCommand.pData->length;
    if (n > 0)
    {
        m_pCommand = (sal_Char*)(rtl_allocateMemory(n));
        m_pRead = m_pWrite = m_pCommand;

        rtl_copyMemory (m_pRead, rCommand.pData->buffer, n);
        m_pRead += n;
    }
}

/*
 * ~INetFTPCommandStream.
 */
INetFTPCommandStream::~INetFTPCommandStream (void)
{
    rtl_freeMemory (m_pCommand);
}

/*
 * read.
 */
sal_Int32 INetFTPCommandStream::read (
    sal_Char *pData, sal_uInt32 nSize, void *pCtx)
{
    // Fill callers buffer.
    sal_Char *p = pData, *q = pData + nSize;
    while (p < q)
    {
        // Callers buffer not yet filled.
        sal_Int32 n = m_pRead - m_pWrite;
        if (n > 0)
        {
            // Bytes still in buffer.
            sal_Int32 k = VOS_MIN((q - p), n);
            rtl_copyMemory (p, m_pWrite, k);
            m_pWrite += k;
            p += k;
        }
        else
        {
            // Buffer empty. Reset to begin.
            m_pRead = m_pWrite = m_pCommand;
            break;
        }
    }
    return (p - pData);
}

/*
 * write.
 */
sal_Int32 INetFTPCommandStream::write (
    const sal_Char *pData, sal_uInt32 nSize, void *pCtx)
{
    sal_Int32 result = REPLY_OK;

    // Process data.
    const sal_Char *pStop = pData + nSize;
    while (pData < pStop)
    {
        if (*pData == '\012')
        {
            // Skip <LF> character.
            pData++;

            // Check line buffer size.
            sal_uInt32 nData = m_aBuffer.Tell();
            if (nData)
            {
                // Parse zero-terminated line buffer.
                m_aBuffer << '\0';

                result = parseLine (
                    (const sal_Char*)(m_aBuffer.GetData()), nData, pCtx);
                if (result == REPLY_ERROR)
                    pData = pStop;

                // Reset line buffer.
                m_aBuffer.Seek (STREAM_SEEK_TO_BEGIN);
            }
        }
        else if (*pData == '\015')
        {
            // Skip <CR> character.
            pData++;
        }
        else
        {
            // Insert character into line buffer.
            m_aBuffer << *pData++;
        }
    }

    // Leave.
    return (result);
}

/*
 * parseLine.
 */
sal_Int32 INetFTPCommandStream::parseLine (
    const sal_Char *pBuffer, sal_uInt32 nLength, void *pCtx)
{
    sal_Int32 reply = 0;
    sal_Char  cont  = '\0';

    if (ascii_isDigit (*pBuffer))
    {
        if (nLength > 2)
            reply = atoi (pBuffer);
        if (nLength > 3)
            cont = pBuffer[3];
        if (nLength > 3)
            pBuffer += 4; // Skip over reply code.
    }

    m_aReplyBuffer.append (pBuffer);
    m_aReplyBuffer.append (sal_Char ('\012'));

    if (m_bFirstLine)
    {
        if (reply)
            m_nReplyCode = reply;
        else
            return REPLY_ERROR;
        m_bFirstLine = sal_False;
    }

    if (reply && (reply == m_nReplyCode) && (cont == ' '))
    {
        m_bFirstLine = sal_True;
        return REPLY_LOADED;
    }
    return REPLY_OK;
}

/*========================================================================
 *
 * INetFTPOpenCommandStream implementation.
 *
 *======================================================================*/
VOS_IMPLEMENT_CLASSINFO(
    VOS_CLASSNAME (INetFTPOpenCommandStream, inet),
    VOS_NAMESPACE (INetFTPOpenCommandStream, inet),
    VOS_NAMESPACE (INetFTPCommandStream, inet),
    0);

/*
 * INetFTPOpenCommandStream.
 */
INetFTPOpenCommandStream::INetFTPOpenCommandStream (const OString &rCommand)
    : INetFTPCommandStream (rCommand, CMD_OPEN)
{
}

/*
 * ~INetFTPOpenCommandStream.
 */
INetFTPOpenCommandStream::~INetFTPOpenCommandStream (void)
{
}

/*
 * parseLine.
 */
sal_Int32 INetFTPOpenCommandStream::parseLine (
    const sal_Char *pBuffer, sal_uInt32 nLength, void *pCtx)
{
    typedef INetFTPCommandStream base;

    sal_Int32 result = base::parseLine (pBuffer, nLength, pCtx);
    if (result == REPLY_LOADED)
    {
    }
    return result;
}

/*========================================================================
 *
 * INetFTPLoginCommandStream implementation.
 *
 *======================================================================*/
VOS_IMPLEMENT_CLASSINFO(
    VOS_CLASSNAME (INetFTPLoginCommandStream, inet),
    VOS_NAMESPACE (INetFTPLoginCommandStream, inet),
    VOS_NAMESPACE (INetFTPCommandStream, inet),
    0);

/*
 * INetFTPLoginCommandStream.
 */
INetFTPLoginCommandStream::INetFTPLoginCommandStream (const OString &rCommand)
    : INetFTPCommandStream (rCommand, CMD_LOGIN)
{
}

/*
 * ~INetFTPLoginCommandStream.
 */
INetFTPLoginCommandStream::~INetFTPLoginCommandStream (void)
{
}

/*
 * parseLine.
 */
sal_Int32 INetFTPLoginCommandStream::parseLine (
    const sal_Char *pBuffer, sal_uInt32 nLength, void *pCtx)
{
    typedef INetFTPCommandStream base;

    sal_Int32 result = base::parseLine (pBuffer, nLength, pCtx);
    if (result == REPLY_LOADED)
    {
    }
    return result;
}

/*========================================================================
 *
 * INetFTPPasvCommandStream implementation.
 *
 *======================================================================*/
VOS_IMPLEMENT_CLASSINFO(
    VOS_CLASSNAME (INetFTPPasvCommandStream, inet),
    VOS_NAMESPACE (INetFTPPasvCommandStream, inet),
    VOS_NAMESPACE (INetFTPCommandStream, inet),
    0);

/*
 * INetFTPPasvCommandStream.
 */
INetFTPPasvCommandStream::INetFTPPasvCommandStream (const OString &rCommand)
    : INetFTPCommandStream (rCommand, CMD_PASV)
{
}

/*
 * ~INetFTPPasvCommandStream.
 */
INetFTPPasvCommandStream::~INetFTPPasvCommandStream (void)
{
}

/*
 * parseLine.
 */
sal_Int32 INetFTPPasvCommandStream::parseLine (
    const sal_Char *pBuffer, sal_uInt32 nLength, void *pCtx)
{
    typedef INetFTPCommandStream base;

    sal_Int32 result = base::parseLine (pBuffer, nLength, pCtx);
    if (result == REPLY_LOADED)
    {
    }
    return result;
}

/*========================================================================
 *
 * INetFTPPwdCommandStream implementation.
 *
 *======================================================================*/
VOS_IMPLEMENT_CLASSINFO(
    VOS_CLASSNAME (INetFTPPwdCommandStream, inet),
    VOS_NAMESPACE (INetFTPPwdCommandStream, inet),
    VOS_NAMESPACE (INetFTPCommandStream, inet),
    0);

/*
 * INetFTPPwdCommandStream.
 */
INetFTPPwdCommandStream::INetFTPPwdCommandStream (const OString &rCommand)
    : INetFTPCommandStream (rCommand, CMD_PWD)
{
}

/*
 * ~INetFTPPwdCommandStream.
 */
INetFTPPwdCommandStream::~INetFTPPwdCommandStream (void)
{
}

/*
 * parseLine.
 */
sal_Int32 INetFTPPwdCommandStream::parseLine (
    const sal_Char *pBuffer, sal_uInt32 nLength, void *pCtx)
{
    typedef INetFTPCommandStream base;

    sal_Int32 result = base::parseLine (pBuffer, nLength, pCtx);
    if (result == REPLY_LOADED)
    {
        if (getReplyCode() == INetFTPConnection::REPLY_PATHNAME_CREATED)
        {
            // Extract quoted pathname.
            const sal_Char *p = pBuffer;
            sal_Int32       n = nLength;

            sal_Int32 k = rtl_str_indexOfChar_WithLength (p, n, '"') + 1;

            p = &p[k];
            n = rtl_str_indexOfChar_WithLength (p, n - k, '"');

            m_aCWD = OUString (p, n, RTL_TEXTENCODING_UTF8);
        }
    }
    return result;
}

/*========================================================================
 *
 * INetFTPTypeCommandStream implementation.
 *
 *======================================================================*/
VOS_IMPLEMENT_CLASSINFO(
    VOS_CLASSNAME (INetFTPTypeCommandStream, inet),
    VOS_NAMESPACE (INetFTPTypeCommandStream, inet),
    VOS_NAMESPACE (INetFTPCommandStream, inet),
    0);

/*
 * INetFTPTypeCommandStream.
 */
INetFTPTypeCommandStream::INetFTPTypeCommandStream (
    const OString &rCommand, Command eCommand)
    : INetFTPCommandStream (rCommand, eCommand)
{
}

/*
 * ~INetFTPTypeCommandStream.
 */
INetFTPTypeCommandStream::~INetFTPTypeCommandStream (void)
{
}

/*
 * parseLine.
 */
sal_Int32 INetFTPTypeCommandStream::parseLine (
    const sal_Char *pBuffer, sal_uInt32 nLength, void *pCtx)
{
    typedef INetFTPCommandStream base;

    sal_Int32 result = base::parseLine (pBuffer, nLength, pCtx);
    if (result == REPLY_LOADED)
    {
    }
    return result;
}

/*======================================================================
 *
 * INetCoreFTPReplyStream (obsolete) implementation.
 *
 *====================================================================*/
#define __FTP_NEW_TYPES 1
#ifndef __FTP_NEW_TYPES

/*
 * INetCoreFTPPasvReplyStream.
 */
int INetCoreFTPPasvReplyStream::ParseLine (void *pCtx)
{
    int status = INetCoreFTPReplyStream::ParseLine (pCtx);
    if (status == INETCORE_STREAM_LOADED)
    {
        if (GetReplyCode() == INETCOREFTP_REPLY_PASSIVE_MODE)
        {
            // Check data context.
            INetCoreFTPDataContext *dctx =
                ((INetCoreFTPConnectionImp *)pCtx)->GetDataContext();
            if (dctx == NULL)
                return INETCORE_STREAM_ERROR;
            if (dctx->bAborting)
                return INETCORE_STREAM_ERROR;

            /*
             * Extract host and port from buffered line.
             * Scan for first digit after the reply code (RFC 1123).
             */
            char *p = buffer + 4;
            while (*p && !ascii_isDigit(*p)) p++;

            if (!*p) return INETCORE_STREAM_ERROR;

            char *q = p;
            for (int i = 0; i < 4; i++, q++)
            {
                if (!*q) break;

                while (*q && ascii_isDigit(*q)) q++;
                *q = '.';
            }
            if (i < 4) return INETCORE_STREAM_ERROR;
            *(--q) = '\0';

            rtl_copyMemory (dctx->pHost, p, rtl_str_getLength(p) + 1);

            p = ++q;
            if (!*p) return INETCORE_STREAM_ERROR;

            int port[2];
            q = p;
            for (i = 0; i < 2; i++, q++)
            {
                if (!*q) break;

                while (*q && ascii_isDigit(*q)) q++;
                *q = '\0';

                port[i] = atoi (p);
                p = q + 1;
            }
            if (i < 2) return INETCORE_STREAM_ERROR;

            dctx->nPort = (USHORT)((port[0] << 8) + port[1]);
        }
    }
    return status;
}

#endif /* !__FTP_NEW_TYPES */

