/*************************************************************************
 *
 *  $RCSfile: imapresp.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:31:16 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef TOOLS_INETMIME_HXX
#include <tools/inetmime.hxx>
#endif

#ifndef INET_IMAPCLNT_HXX
#include <imapclnt.hxx>
#endif
#ifndef _INETCOREMSG_HXX
#include <inetmsg.hxx>
#endif

//============================================================================
//
//  INetIMAPResponse
//
//============================================================================

// virtual
INetIMAPResponse::~INetIMAPResponse()
{}

//============================================================================
//
//  INetIMAPClosedResponse
//
//============================================================================

// virtual
INetIMAPResponse::Type INetIMAPClosedResponse::getType() const
{
	return TYPE_CLOSED;
}

//============================================================================
//
//  INetIMAPErrorResponse
//
//============================================================================

// virtual
INetIMAPResponse::Type INetIMAPErrorResponse::getType() const
{
	return TYPE_ERROR;
}

//============================================================================
//
//  INetIMAPOpeningResponse
//
//============================================================================

// virtual
INetIMAPResponse::Type INetIMAPOpeningResponse::getType() const
{
	return TYPE_OPENING;
}

//============================================================================
//
//  INetIMAPInvalidResponse
//
//============================================================================

// virtual
INetIMAPResponse::Type INetIMAPInvalidResponse::getType() const
{
	return TYPE_INVALID;
}

//============================================================================
// virtual
UniString INetIMAPInvalidResponse::getText() const
{
	return m_aLine;
}

//============================================================================
//
//  INetIMAPCodeResponse
//
//============================================================================

INetIMAPCodeResponse::INetIMAPCodeResponse(Code eTheCode,
										   INetIMAPFlags eThePermanentFlags,
										   INetIMAPFlagKeywordList const &
										       rThePermanentFlagKeywords,
										   bool bThePermanentNewFlagKeywords,
										   sal_uInt32 nTheNumber,
										   UniString const & rTheText):
	m_eCode(eTheCode),
	m_aText(rTheText)
{
	switch (m_eCode)
	{
		case CODE_PERMANENTFLAGS:
			m_ePermanentFlags = eThePermanentFlags;
			m_pPermanentFlagKeywords = &rThePermanentFlagKeywords;
			m_bPermanentNewFlagKeywords = bThePermanentNewFlagKeywords;
			break;

		case CODE_UIDVALIDITY:
		case CODE_UNSEEN:
			m_nNumber = nTheNumber;
			break;
	}
}

//============================================================================
// virtual
UniString INetIMAPCodeResponse::getText() const
{
	UniString aTheText;
	switch (m_eCode)
	{
		case CODE_PARSE:
			aTheText.AssignAscii(RTL_CONSTASCII_STRINGPARAM("[PARSE]"));
			break;

		case CODE_PERMANENTFLAGS:
		{
			aTheText.
				AssignAscii(RTL_CONSTASCII_STRINGPARAM("[PERMANENTFLAGS ("));
			bool bFlags = false;
			if (m_ePermanentFlags & INET_IMAP_FLAG_ANSWERED)
			{
				aTheText.
					AppendAscii(RTL_CONSTASCII_STRINGPARAM("\\Answered"));
				bFlags = true;
			}
			if (m_ePermanentFlags & INET_IMAP_FLAG_FLAGGED)
			{
				if (bFlags)
					aTheText += ' ';
				aTheText.AppendAscii(RTL_CONSTASCII_STRINGPARAM("\\Flagged"));
				bFlags = true;
			}
			if (m_ePermanentFlags & INET_IMAP_FLAG_DELETED)
			{
				if (bFlags)
					aTheText += ' ';
				aTheText.AppendAscii(RTL_CONSTASCII_STRINGPARAM("\\Deleted"));
				bFlags = true;
			}
			if (m_ePermanentFlags & INET_IMAP_FLAG_SEEN)
			{
				if (bFlags)
					aTheText += ' ';
				aTheText.AppendAscii(RTL_CONSTASCII_STRINGPARAM("\\Seen"));
				bFlags = true;
			}
			if (m_ePermanentFlags & INET_IMAP_FLAG_DRAFT)
			{
				if (bFlags)
					aTheText += ' ';
				aTheText.AppendAscii(RTL_CONSTASCII_STRINGPARAM("\\Draft"));
				bFlags = true;
			}
			if (m_pPermanentFlagKeywords)
				for (sal_uInt32 i = 0;
					 i < m_pPermanentFlagKeywords->getCount(); ++i)
				{
					if (bFlags)
						aTheText += ' ';
					aTheText += UniString(m_pPermanentFlagKeywords->get(i),
										  RTL_TEXTENCODING_ASCII_US);
					bFlags = true;
				}
			if (m_bPermanentNewFlagKeywords)
			{
				if (bFlags)
					aTheText += ' ';
				aTheText.AppendAscii(RTL_CONSTASCII_STRINGPARAM("\\*"));
			}
			aTheText.AppendAscii(RTL_CONSTASCII_STRINGPARAM(")]"));
			break;
		}

		case CODE_READ_ONLY:
			aTheText.AssignAscii(RTL_CONSTASCII_STRINGPARAM("[READ-ONLY]"));
			break;

		case CODE_READ_WRITE:
			aTheText.AssignAscii(RTL_CONSTASCII_STRINGPARAM("[READ-WRITE]"));
			break;

		case CODE_TRYCREATE:
			aTheText.AssignAscii(RTL_CONSTASCII_STRINGPARAM("[TRYCREATE]"));
			break;

		case CODE_UIDVALIDITY:
		{
			INetMIMEUnicodeOutputSink
				aSink(0, INetMIMEOutputSink::NO_LINE_LENGTH_LIMIT);
			aSink.write(RTL_CONSTASCII_STRINGPARAM("[UIDVALIDITY "));
			INetMIME::writeUnsigned(aSink, m_nNumber);
			aSink << ']';
			aTheText = aSink.takeBuffer();
			break;
		}

		case CODE_UNSEEN:
		{
			INetMIMEUnicodeOutputSink
				aSink(0, INetMIMEOutputSink::NO_LINE_LENGTH_LIMIT);
			aSink.write(RTL_CONSTASCII_STRINGPARAM("[UNSEEN "));
			INetMIME::writeUnsigned(aSink, m_nNumber);
			aSink << ']';
			aTheText = aSink.takeBuffer();
			break;
		}
	}
	if (m_aText.Len() != 0)
	{
		if (aTheText.Len() != 0)
			aTheText += ' ';
		aTheText += m_aText;
	}
	return aTheText;
}

//============================================================================
//
//  INetIMAPContinueCodeResponse
//
//============================================================================

// virtual
INetIMAPResponse::Type INetIMAPContinueCodeResponse::getType() const
{
	return TYPE_CONTINUE_CODE;
}

//============================================================================
//
//  INetIMAPStateResponse
//
//============================================================================

// virtual
INetIMAPResponse::Type INetIMAPStateResponse::getType() const
{
	return TYPE_STATE;
}

//============================================================================
//
//  INetIMAPFlagsResponse
//
//============================================================================

// virtual
INetIMAPResponse::Type INetIMAPFlagsResponse::getType() const
{
	return TYPE_FLAGS;
}

//============================================================================
//
//  INetIMAPListResponse
//
//============================================================================

// virtual
INetIMAPListResponse::~INetIMAPListResponse()
{
	while (m_aMailboxes.Count() != 0)
		delete m_aMailboxes.Remove(m_aMailboxes.Count() - 1);
}

//============================================================================
// virtual
INetIMAPResponse::Type INetIMAPListResponse::getType() const
{
	return TYPE_LIST;
}

//============================================================================
//
//  INetIMAPMailboxResponse
//
//============================================================================

// virtual
INetIMAPResponse::Type INetIMAPMailboxResponse::getType() const
{
	return TYPE_MAILBOX;
}

//============================================================================
//
//  INetIMAPSearchResponse
//
//============================================================================

// virtual
INetIMAPResponse::Type INetIMAPSearchResponse::getType() const
{
	return TYPE_SEARCH;
}

//============================================================================
//
//  INetIMAPStatusResponse
//
//============================================================================

// virtual
INetIMAPResponse::Type INetIMAPStatusResponse::getType() const
{
	return TYPE_STATUS;
}

//============================================================================
//
//  INetIMAPExistsResponse
//
//============================================================================

// virtual
INetIMAPResponse::Type INetIMAPExistsResponse::getType() const
{
	return TYPE_EXISTS;
}

//============================================================================
//
//  INetIMAPRecentResponse
//
//============================================================================

// virtual
INetIMAPResponse::Type INetIMAPRecentResponse::getType() const
{
	return TYPE_RECENT;
}

//============================================================================
//
//  INetIMAPExpungeResponse
//
//============================================================================

// virtual
INetIMAPResponse::Type INetIMAPExpungeResponse::getType() const
{
	return TYPE_EXPUNGE;
}

//============================================================================
//
//  INetIMAPFetchResponseBodySection
//
//============================================================================

// virtual
INetIMAPFetchResponseBodySection::~INetIMAPFetchResponseBodySection()
{
	delete m_pData;
}

//============================================================================
//
//  INetIMAPFetchResponseBodySectionList
//
//============================================================================

// virtual
INetIMAPFetchResponseBodySectionList::~INetIMAPFetchResponseBodySectionList()
{
	while (Count() != 0)
		delete static_cast< INetIMAPFetchResponseBodySection * >(
			       Remove(Count() - 1));
}

//============================================================================
//
//  INetIMAPFetchResponse
//
//============================================================================

// virtual
INetIMAPResponse::Type INetIMAPFetchResponse::getType() const
{
	return TYPE_FETCH;
}

//============================================================================
//
//  INetIMAPCapabilityResponse
//
//============================================================================

// virtual
INetIMAPResponse::Type INetIMAPCapabilityResponse::getType() const
{
	return TYPE_CAPABILITY;
}

//============================================================================
//
//  INetIMAPNamespaceList
//
//============================================================================

// virtual
INetIMAPNamespaceList::~INetIMAPNamespaceList()
{
	while (Count() != 0)
		delete static_cast< INetIMAPNamespace * >(Remove(Count() - 1));
}

//============================================================================
//
//  INetIMAPNamespaceResponse
//
//============================================================================

// virtual
INetIMAPNamespaceResponse::~INetIMAPNamespaceResponse()
{
	delete m_pNamespaces[NAMESPACE_PERSONAL];
	delete m_pNamespaces[NAMESPACE_OTHER_USERS];
	delete m_pNamespaces[NAMESPACE_SHARED];
}

//============================================================================
// virtual
INetIMAPResponse::Type INetIMAPNamespaceResponse::getType() const
{
	return TYPE_NAMESPACE;
}

//============================================================================
void INetIMAPNamespaceResponse::addNamespace(NamespaceKind eKind,
											 INetIMAPNamespace * pNamespace)
{
	if (!m_pNamespaces[eKind])
		m_pNamespaces[eKind] = new INetIMAPNamespaceList;
	m_pNamespaces[eKind]->add(pNamespace);
}

