/*************************************************************************
 *
 *  $RCSfile: mailclnt.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: mhu $ $Date: 2001/07/11 18:49:13 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Matthias Huetsch <matthias.huetsch@sun.com>
 *
 *
 ************************************************************************/

#define _INET_MAILCLNT_CXX "$Revision: 1.3 $"

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifndef _RTL_RANDOM_H_
#include <rtl/random.h>
#endif
#ifndef _RTL_USTRBUF_HXX
#include <rtl/ustrbuf.hxx>
#endif

#ifndef _VOS_REF_HXX_
#include <vos/ref.hxx>
#endif
#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif

#ifndef _DATETIME_HXX
#include <tools/datetime.hxx>
#endif
#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif
#ifndef _TOOLS_INETDEF_HXX
#include <tools/inetdef.hxx>
#endif

#ifndef _INET_CONFIG_HXX
#include <inetcfg.hxx>
#endif
#ifndef _INETDNS_HXX
#include <inetdns.hxx>
#endif

#ifndef _INETCOREMAIL_HXX
#include <inetmail.hxx>
#endif
#ifndef _INET_MAILCLNT_HXX
#include <mailclnt.hxx>
#endif

using namespace rtl;

using namespace inet;
using namespace inet::mail;

/*========================================================================
 *
 * INetCoreMailer implementation.
 *
 *======================================================================*/
extern "C" INetCoreMailer* SAL_CALL NewINetCoreMailer (void)
{
	return new INetCoreMailer_Impl();
}

/*
 * INetCoreMailer.
 */
INetCoreMailer::INetCoreMailer (void)
{
}

/*
 * ~INetCoreMailer.
 */
INetCoreMailer::~INetCoreMailer (void)
{
}

/*
 * CreateINetCoreMIMEMessage.
 */
INetCoreMIMEMessage*
INetCoreMailer_Impl::CreateINetCoreMIMEMessage (void) const
{
	return new INetCoreMIMEMessage();
}

/*
 * CreateINetCoreNewsMessage.
 */
INetCoreNewsMessage*
INetCoreMailer_Impl::CreateINetCoreNewsMessage (void) const
{
	return new INetCoreNewsMessage();
}

/*
 * Reserved.
 */
void INetCoreMailer_Impl::Dummy1 (void)
{
}

void INetCoreMailer_Impl::Dummy2 (void)
{
}

void INetCoreMailer_Impl::Dummy3 (void)
{
}

/*========================================================================
 *
 * INetCoreMailer_Impl implementation.
 *
 *======================================================================*/
/*
 * INetCoreMailer_Impl.
 */
INetCoreMailer_Impl::INetCoreMailer_Impl (void)
	: m_pResolver (NULL),
	  m_hPool     (NULL)
{
}

/*
 * ~INetCoreMailer_Impl.
 */
INetCoreMailer_Impl::~INetCoreMailer_Impl (void)
{
	if (m_hPool)
		rtl_random_destroyPool (m_hPool);
	delete m_pResolver;
}

/*
 * operator INetCoreMailer*().
 */
INetCoreMailer_Impl::operator INetCoreMailer* (void)
{
	return this;
}

/*
 * getMutex_Impl.
 */
inline NAMESPACE_VOS(IMutex)& INetCoreMailer_Impl::getMutex_Impl (void) const
{
	return ((SAL_CONST_CAST(INetCoreMailer_Impl*, this))->m_aMutex);
}

/*
 * prepareMessage.
 */
sal_Bool INetCoreMailer_Impl::prepareMessage (INetCoreMIMEMessage &rMessage)
{
	NAMESPACE_VOS(OGuard) aGuard (getMutex_Impl());
	if (rMessage.GetFrom().Len())
	{
		// Obtain current time.
		DateTime aNow;
		aNow.ConvertToUTC();

		// Check Date.
		UniString aDate (rMessage.GetDate());
		if (!aDate.Len())
		{
			// Generate DATE header field.
			rMessage.GenerateDateField (aNow, aNow, aDate);
			rMessage.SetDate (aDate);
		}

		// Check Message-ID.
		UniString aMessageID (rMessage.GetMessageID());
		if (!aMessageID.Len())
		{
			// Check resolver and random pool.
			if (m_pResolver == NULL)
				m_pResolver = new INetCoreDNSResolver();
			if (m_hPool == NULL)
				m_hPool = rtl_random_createPool();

			// Obtain local hostname.
			INetCoreDNSHostEntry aHostent (
				OUString::createFromAscii ("localhost"));
			m_pResolver->GetHostName (&aHostent);

			OUString aDomain (aHostent.GetCanonicalName());
			if (aDomain.indexOf('.') < 0)
				aDomain = aHostent.GetDomainName();
			if (aDomain.indexOf('.') < 0)
				aDomain = OUString::createFromAscii ("mis.configured.host");

			// Generate MESSAGE-ID header field.
			OUStringBuffer aBuffer;

			aBuffer.append (sal_Unicode ('<'));
			aBuffer.append (sal_Int32 (aNow.GetDate()));
			aBuffer.append (sal_Unicode ('.'));
			aBuffer.append (sal_Int32 (aNow.GetTime()));

			if (m_hPool)
			{
				// Append some random part for uniqueness.
				sal_uInt32 nRandom = sal_uInt32 (aNow.GetTime());

				rtl_random_addBytes (m_hPool, &nRandom, sizeof(nRandom));
				rtl_random_getBytes (m_hPool, &nRandom, sizeof(nRandom));

				aBuffer.append (sal_Unicode ('.'));
				aBuffer.append (sal_Int32 (nRandom & 0x7fffffff));
			}

			aBuffer.append (sal_Unicode ('@'));
			aBuffer.append (aDomain);
			aBuffer.append (sal_Unicode ('>'));

			rMessage.SetMessageID (aBuffer.makeStringAndClear());
		}

		// Check UserAgent (X-Mailer).
		UniString aUserAgent (rMessage.GetXMailer());
		if (!aUserAgent.Len())
		{
			// Generate X-MAILER header field.
			NAMESPACE_VOS(ORef)<INetConfig> xConfig;
			if (INetConfig::getOrCreate (xConfig))
				aUserAgent = UniString (xConfig->getUserAgent());
			if (!aUserAgent.Len())
				aUserAgent = UniString::CreateFromAscii (INET_DEF_CALLERNAME);
			rMessage.SetXMailer (aUserAgent);
		}

		// Done.
		return sal_True;
	}
	return sal_False;
}

/*========================================================================
 *
 * NewsClient implementation.
 *
 *======================================================================*/
/*
 * createClient_Impl.
 */
inline sal_Bool INetCoreMailer_Impl::createClient_Impl (
	NAMESPACE_VOS(ORef)<NewsClient_Impl> &rxClient)
{
	NAMESPACE_VOS(OGuard) aGuard (getMutex_Impl());
	if (!m_xNewsClient.isValid())
	{
		// Check resolver.
		if (m_pResolver == NULL)
			m_pResolver = new INetCoreDNSResolver();

		// Create NewsClient.
		m_xNewsClient = new NewsClient_Impl (*this);
	}
	rxClient = m_xNewsClient;
	return (rxClient.isValid());
}

/*
 * getClient_Impl.
 */
inline sal_Bool INetCoreMailer_Impl::getClient_Impl (
	NAMESPACE_VOS(ORef)<NewsClient_Impl> &rxClient) const
{
	NAMESPACE_VOS(OGuard) aGuard (getMutex_Impl());
	rxClient = m_xNewsClient;
	return (rxClient.isValid());
}

/*
 * terminated.
 */
void INetCoreMailer_Impl::terminated (
	const NAMESPACE_VOS(ORef)<NewsClient_Impl> &rxClient)
{
	NAMESPACE_VOS(OGuard) aGuard (getMutex_Impl());
	m_xNewsClient.unbind();
}

/*
 * NewsOpenConnection.
 */
sal_Bool INetCoreMailer_Impl::NewsOpenConnection (
	const OUString &rHost, sal_uInt16 nPort,
	INetCoreMailerCallback *pfnCallback, void *pData)
{
	NAMESPACE_VOS(ORef)<NewsClient_Impl> xClient;
	if (createClient_Impl (xClient))
		return xClient->openConnection (rHost, nPort, pfnCallback, pData);
	else
		return sal_False;
}

/*
 * NewsIsOpen.
 */
sal_Bool INetCoreMailer_Impl::NewsIsOpen (void) const
{
	NAMESPACE_VOS(ORef)<NewsClient_Impl> xClient;
	if (getClient_Impl (xClient))
		return xClient->isOpen();
	else
		return sal_False;
}

/*
 * NewsCloseConnection.
 */
sal_Bool INetCoreMailer_Impl::NewsCloseConnection (
	INetCoreMailerCallback *pfnCallback, void *pData)
{
	NAMESPACE_VOS(ORef)<NewsClient_Impl> xClient;
	if (getClient_Impl (xClient))
		return xClient->closeConnection (pfnCallback, pData);
	else
		return sal_False;
}

/*
 * NewsAbortConnection.
 */
void INetCoreMailer_Impl::NewsAbortConnection (void)
{
	NAMESPACE_VOS(ORef)<NewsClient_Impl> xClient;
	if (getClient_Impl (xClient))
	{
		xClient->abortConnection();
		terminated (xClient);
	}
}

/*
 * NewsModeReader.
 */
sal_Bool INetCoreMailer_Impl::NewsModeReader (
	INetCoreMailerCallback *pfnCallback, void *pData)
{
	NAMESPACE_VOS(ORef)<NewsClient_Impl> xClient;
	if (getClient_Impl (xClient))
		return xClient->setModeReader (pfnCallback, pData);
	else
		return sal_False;
}

/*
 * NewsAuthenticate.
 */
sal_Bool INetCoreMailer_Impl::NewsAuthenticate (
	const OUString &rUsername, const OUString &rPassword,
	INetCoreMailerCallback *pfnCallback, void *pData)
{
	NAMESPACE_VOS(ORef)<NewsClient_Impl> xClient;
	if (getClient_Impl (xClient))
		return xClient->authenticate(rUsername, rPassword, pfnCallback, pData);
	else
		return sal_False;
}

/*
 * NewsAuthenticatePassword.
 */
sal_Bool INetCoreMailer_Impl::NewsAuthenticatePassword (
	const OUString &rPassword,
	INetCoreMailerCallback *pfnCallback, void *pData)
{
	NAMESPACE_VOS(ORef)<NewsClient_Impl> xClient;
	if (getClient_Impl (xClient))
		return xClient->authenticatePassword (rPassword, pfnCallback, pData);
	else
		return sal_False;
}

/*
 * NewsGroupList.
 */
sal_Bool INetCoreMailer_Impl::NewsGroupList (
	List &rList,
	INetCoreMailerCallback *pfnCallback, void *pData)
{
	NAMESPACE_VOS(ORef)<NewsClient_Impl> xClient;
	if (getClient_Impl (xClient))
		return xClient->getGroups (rList, pfnCallback, pData);
	else
		return sal_False;
}

/*
 * NewsNewGroupsList.
 */
sal_Bool INetCoreMailer_Impl::NewsNewGroupsList (
	const DateTime &rSince, List &rList,
	INetCoreMailerCallback *pfnCallback, void *pData)
{
	NAMESPACE_VOS(ORef)<NewsClient_Impl> xClient;
	if (getClient_Impl (xClient))
		return xClient->getNewGroups (rSince, rList, pfnCallback, pData);
	else
		return sal_False;
}

/*
 * NewsNewNewsList.
 */
sal_Bool INetCoreMailer_Impl::NewsNewNewsList (
	const OUString &rGroups, const DateTime &rSince, List &rList,
	INetCoreMailerCallback *pfnCallback, void *pData)
{
	NAMESPACE_VOS(ORef)<NewsClient_Impl> xClient;
	if (getClient_Impl (xClient))
		return xClient->getNewNews(rGroups, rSince, rList, pfnCallback, pData);
	else
		return sal_False;
}

/*
 * NewsSelectGroup.
 */
sal_Bool INetCoreMailer_Impl::NewsSelectGroup (
	INetCoreNNTPGroupListEntry &rEntry,
	INetCoreMailerCallback *pfnCallback, void *pData)
{
	NAMESPACE_VOS(ORef)<NewsClient_Impl> xClient;
	if (getClient_Impl (xClient))
		return xClient->selectGroup (rEntry, pfnCallback, pData);
	else
		return sal_False;
}

/*
 * NewsHasOverview.
 */
sal_Bool INetCoreMailer_Impl::NewsHasOverview (void) const
{
	// (OBSOLETE).
	return sal_True;
}

/*
 * NewsArticleHeadOverview.
 */
sal_Bool INetCoreMailer_Impl::NewsArticleHeadOverview (
	sal_uInt32              nFirst,
	sal_uInt32              nLast,
	INetCoreNewsMessage    &rMessage,
	INetCoreMailerCallback *pfnCallback, void *pData)
{
	NAMESPACE_VOS(ORef)<NewsClient_Impl> xClient;
	if (!getClient_Impl (xClient))
		return sal_False;

	return xClient->getArticleOverview (
		nFirst, nLast, rMessage, pfnCallback, pData);
}

/*
 * NewsArticleHead (by ArticleNumber).
 */
sal_Bool INetCoreMailer_Impl::NewsArticleHead (
	sal_uInt32              nArticle,
	INetCoreNewsMessage    &rMessage,
	INetCoreMailerCallback *pfnCallback, void *pData)
{
	NAMESPACE_VOS(ORef)<NewsClient_Impl> xClient;
	if (!getClient_Impl (xClient))
		return sal_False;

	return xClient->getArticleHead (
		nArticle, OUString(), rMessage, pfnCallback, pData);
}

/*
 * NewsArticleHead (by MessageID).
 */
sal_Bool INetCoreMailer_Impl::NewsArticleHead (
	const OUString         &rMessageID,
	INetCoreNewsMessage    &rMessage,
	INetCoreMailerCallback *pfnCallback, void *pData)
{
	NAMESPACE_VOS(ORef)<NewsClient_Impl> xClient;
	if (!getClient_Impl (xClient))
		return sal_False;

	return xClient->getArticleHead (
		0, rMessageID, rMessage, pfnCallback, pData);
}

/*
 * NewsArticle (by ArticleNumber).
 */
sal_Bool INetCoreMailer_Impl::NewsArticle (
	sal_uInt32              nArticle,
	INetCoreNewsMessage    &rMessage,
	INetCoreMailerCallback *pfnCallback, void *pData)
{
	NAMESPACE_VOS(ORef)<NewsClient_Impl> xClient;
	if (!getClient_Impl (xClient))
		return sal_False;

	return xClient->getArticle (
		nArticle, OUString(), rMessage, pfnCallback, pData);
}

/*
 * NewsArticle (by MessageID).
 */
sal_Bool INetCoreMailer_Impl::NewsArticle (
	const OUString         &rMessageID,
	INetCoreNewsMessage    &rMessage,
	INetCoreMailerCallback *pfnCallback, void *pData)
{
	NAMESPACE_VOS(ORef)<NewsClient_Impl> xClient;
	if (!getClient_Impl (xClient))
		return sal_False;

	return xClient->getArticle (
		0, rMessageID, rMessage, pfnCallback, pData);
}

/*
 * NewsPostArticle.
 */
sal_Bool INetCoreMailer_Impl::NewsPostArticle (
	INetCoreNewsMessage    &rMessage,
	INetCoreMailerCallback *pfnCallback, void *pData)
{
	NAMESPACE_VOS(ORef)<NewsClient_Impl> xClient;
	if (getClient_Impl (xClient))
		return xClient->postArticle (rMessage, pfnCallback, pData);
	else
		return sal_False;
}

/*
 * NewsIsPostingAllowed.
 */
sal_Bool INetCoreMailer_Impl::NewsIsPostingAllowed (void) const
{
	NAMESPACE_VOS(ORef)<NewsClient_Impl> xClient;
	if (getClient_Impl (xClient))
		return xClient->isPostingAllowed();
	else
		return sal_False;
}

/*
 * NewsGetTransferCount.
 */
sal_uInt32 INetCoreMailer_Impl::NewsGetTransferCount (void) const
{
	NAMESPACE_VOS(ORef)<NewsClient_Impl> xClient;
	if (getClient_Impl (xClient))
		return xClient->getTransferCount();
	else
		return 0;
}

/*
 * NewsSetTransferCallback.
 */
sal_Bool INetCoreMailer_Impl::NewsSetTransferCallback (
	INetCoreMailerCallback *pfnCallback, void *pData)
{
	// (OBSOLETE).
	return sal_True;
}

/*========================================================================
 *
 * RecvClient implementation.
 *
 *======================================================================*/
/*
 * createClient_Impl.
 */
inline sal_Bool INetCoreMailer_Impl::createClient_Impl (
	NAMESPACE_VOS(ORef)<RecvClient_Impl> &rxClient)
{
	NAMESPACE_VOS(OGuard) aGuard (getMutex_Impl());
	if (!m_xRecvClient.isValid())
	{
		// Check resolver.
		if (m_pResolver == NULL)
			m_pResolver = new INetCoreDNSResolver();

		// Create RecvClient.
		m_xRecvClient = new RecvClient_Impl (*this);
	}
	rxClient = m_xRecvClient;
	return (rxClient.isValid());
}

/*
 * getClient_Impl.
 */
inline sal_Bool INetCoreMailer_Impl::getClient_Impl (
	NAMESPACE_VOS(ORef)<RecvClient_Impl> &rxClient) const
{
	NAMESPACE_VOS(OGuard) aGuard (getMutex_Impl());
	rxClient = m_xRecvClient;
	return (rxClient.isValid());
}

/*
 * terminated.
 */
void INetCoreMailer_Impl::terminated (
	const NAMESPACE_VOS(ORef)<RecvClient_Impl> &rxClient)
{
	NAMESPACE_VOS(OGuard) aGuard (getMutex_Impl());
	m_xRecvClient.unbind();
}

/*
 * RecvOpenConnection.
 */
sal_Bool INetCoreMailer_Impl::RecvOpenConnection (
	const OUString &rHost, sal_uInt16 nPort,
	INetCoreMailerCallback *pfnCallback, void *pData)
{
	NAMESPACE_VOS(ORef)<RecvClient_Impl> xClient;
	if (createClient_Impl (xClient))
		return xClient->openConnection (rHost, nPort, pfnCallback, pData);
	else
		return sal_False;
}

/*
 * RecvIsOpen.
 */
sal_Bool INetCoreMailer_Impl::RecvIsOpen (void) const
{
	NAMESPACE_VOS(ORef)<RecvClient_Impl> xClient;
	if (getClient_Impl (xClient))
		return xClient->isOpen();
	else
		return sal_False;
}

/*
 * RecvCloseConnection.
 */
sal_Bool INetCoreMailer_Impl::RecvCloseConnection (
	INetCoreMailerCallback *pfnCallback, void *pData)
{
	NAMESPACE_VOS(ORef)<RecvClient_Impl> xClient;
	if (getClient_Impl (xClient))
		return xClient->closeConnection (pfnCallback, pData);
	else
		return sal_False;
}

/*
 * RecvAbortConnection.
 */
void INetCoreMailer_Impl::RecvAbortConnection (void)
{
	NAMESPACE_VOS(ORef)<RecvClient_Impl> xClient;
	if (getClient_Impl (xClient))
	{
		xClient->abortConnection();
		terminated (xClient);
	}
}

/*
 * RecvLogin.
 */
sal_Bool INetCoreMailer_Impl::RecvLogin (
	const OUString &rUsername, const OUString &rPassword,
	INetCoreMailerCallback *pfnCallback, void *pData)
{
	NAMESPACE_VOS(ORef)<RecvClient_Impl> xClient;
	if (getClient_Impl (xClient))
		return xClient->login (rUsername, rPassword, pfnCallback, pData);
	else
		return sal_False;
}

/*
 * RecvLoginSecure.
 */
sal_Bool INetCoreMailer_Impl::RecvLoginSecure (
	const OUString &rUsername, const OUString &rPassword,
	INetCoreMailerCallback *pfnCallback, void *pData)
{
	// (NYI).
	return RecvLogin (rUsername, rPassword, pfnCallback, pData);
}

/*
 * RecvIsLoggedIn.
 */
sal_Bool INetCoreMailer_Impl::RecvIsLoggedIn (void) const
{
	NAMESPACE_VOS(ORef)<RecvClient_Impl> xClient;
	if (getClient_Impl (xClient))
		return xClient->isLoggedIn();
	else
		return sal_False;
}

/*
 * RecvMailListEntry.
 */
sal_Bool INetCoreMailer_Impl::RecvMailListEntry (
	INetCoreMailInfoListEntry &rEntry,
	INetCoreMailerCallback *pfnCallback, void *pData)
{
	NAMESPACE_VOS(ORef)<RecvClient_Impl> xClient;
	if (getClient_Impl (xClient))
		return xClient->getMailListEntry (rEntry, pfnCallback, pData);
	else
		return sal_False;
}

/*
 * RecvMailList.
 */
sal_Bool INetCoreMailer_Impl::RecvMailList (
	List &rMailList,
	INetCoreMailerCallback *pfnCallback, void *pData)
{
	NAMESPACE_VOS(ORef)<RecvClient_Impl> xClient;
	if (getClient_Impl (xClient))
		return xClient->getMailList (rMailList, pfnCallback, pData);
	else
		return sal_False;
}

/*
 * RecvUniqueIdList.
 */
sal_Bool INetCoreMailer_Impl::RecvUniqueIdList (
	List &rUniqueIdList,
	INetCoreMailerCallback *pfnCallback, void *pData)
{
	NAMESPACE_VOS(ORef)<RecvClient_Impl> xClient;
	if (getClient_Impl (xClient))
		return xClient->getUniqueIdList (rUniqueIdList, pfnCallback, pData);
	else
		return sal_False;
}

/*
 * RecvMailHead.
 */
sal_Bool INetCoreMailer_Impl::RecvMailHead (
	sal_uInt32 nIndex, INetCoreMIMEMessage &rMessage,
	INetCoreMailerCallback *pfnCallback, void *pData)
{
	NAMESPACE_VOS(ORef)<RecvClient_Impl> xClient;
	if (getClient_Impl (xClient))
		return xClient->getMailHead (nIndex, rMessage, pfnCallback, pData);
	else
		return sal_False;
}

/*
 * RecvMail.
 */
sal_Bool INetCoreMailer_Impl::RecvMail (
	sal_uInt32 nIndex, INetCoreMIMEMessage &rMessage,
	INetCoreMailerCallback *pfnCallback, void *pData)
{
	NAMESPACE_VOS(ORef)<RecvClient_Impl> xClient;
	if (getClient_Impl (xClient))
		return xClient->getMail (nIndex, rMessage, pfnCallback, pData);
	else
		return sal_False;
}

/*
 * RecvDeleteMail.
 */
sal_Bool INetCoreMailer_Impl::RecvDeleteMail (
	sal_uInt32 nIndex,
	INetCoreMailerCallback *pfnCallback, void *pData)
{
	NAMESPACE_VOS(ORef)<RecvClient_Impl> xClient;
	if (getClient_Impl (xClient))
		return xClient->deleteMail (nIndex, pfnCallback, pData);
	else
		return sal_False;
}

/*
 * RecvGetTransferCount.
 */
sal_uInt32 INetCoreMailer_Impl::RecvGetTransferCount (void) const
{
	NAMESPACE_VOS(ORef)<RecvClient_Impl> xClient;
	if (getClient_Impl (xClient))
		return xClient->getTransferCount();
	else
		return 0;
}

/*
 * RecvSetTransferCallback.
 */
sal_Bool INetCoreMailer_Impl::RecvSetTransferCallback (
	INetCoreMailerCallback *pfnCallback, void *pData)
{
	// (OBSOLETE).
	return sal_True;
}

/*========================================================================
 *
 * SendClient implementation.
 *
 *======================================================================*/
/*
 * createClient_Impl.
 */
inline sal_Bool INetCoreMailer_Impl::createClient_Impl (
	NAMESPACE_VOS(ORef)<SendClient_Impl> &rxClient)
{
	NAMESPACE_VOS(OGuard) aGuard (getMutex_Impl());
	if (!m_xSendClient.isValid())
	{
		// Check resolver.
		if (m_pResolver == NULL)
			m_pResolver = new INetCoreDNSResolver();

		// Create SendClient.
		m_xSendClient = new SendClient_Impl (*this);
	}
	rxClient = m_xSendClient;
	return (rxClient.isValid());
}

/*
 * getClient_Impl.
 */
inline sal_Bool INetCoreMailer_Impl::getClient_Impl (
	NAMESPACE_VOS(ORef)<SendClient_Impl> &rxClient) const
{
	NAMESPACE_VOS(OGuard) aGuard (getMutex_Impl());
	rxClient = m_xSendClient;
	return (rxClient.isValid());
}

/*
 * terminated.
 */
void INetCoreMailer_Impl::terminated (
	const NAMESPACE_VOS(ORef)<SendClient_Impl> &rxClient)
{
	NAMESPACE_VOS(OGuard) aGuard (getMutex_Impl());
	m_xSendClient.unbind();
}

/*
 * SendOpenConnection.
 */
sal_Bool INetCoreMailer_Impl::SendOpenConnection (
	const OUString &rHost, sal_uInt16 nPort,
	INetCoreMailerCallback *pfnCallback, void *pData)
{
	NAMESPACE_VOS(ORef)<SendClient_Impl> xClient;
	if (createClient_Impl (xClient))
		return xClient->openConnection (rHost, nPort, pfnCallback, pData);
	else
		return sal_False;
}

/*
 * SendIsOpen.
 */
sal_Bool INetCoreMailer_Impl::SendIsOpen (void) const
{
	NAMESPACE_VOS(ORef)<SendClient_Impl> xClient;
	if (getClient_Impl (xClient))
		return xClient->isOpen();
	else
		return sal_False;
}

/*
 * SendCloseConnection.
 */
sal_Bool INetCoreMailer_Impl::SendCloseConnection (
	INetCoreMailerCallback *pfnCallback, void *pData)
{
	NAMESPACE_VOS(ORef)<SendClient_Impl> xClient;
	if (getClient_Impl (xClient))
		return xClient->closeConnection (pfnCallback, pData);
	else
		return sal_False;
}

/*
 * SendAbortConnection.
 */
void INetCoreMailer_Impl::SendAbortConnection (void)
{
	NAMESPACE_VOS(ORef)<SendClient_Impl> xClient;
	if (getClient_Impl (xClient))
	{
		xClient->abortConnection();
		terminated (xClient);
	}
}

/*
 * SendMail.
 */
sal_Bool INetCoreMailer_Impl::SendMail (
	INetCoreMIMEMessage    &rMessage,
	INetCoreMailerCallback *pfnCallback, void *pData)
{
	NAMESPACE_VOS(ORef)<SendClient_Impl> xClient;
	if (getClient_Impl (xClient))
		return xClient->sendMail (rMessage, pfnCallback, pData);
	else
		return sal_False;
}

/*
 * SendGetTransferCount.
 */
sal_uInt32 INetCoreMailer_Impl::SendGetTransferCount (void) const
{
	NAMESPACE_VOS(ORef)<SendClient_Impl> xClient;
	if (getClient_Impl (xClient))
		return xClient->getTransferCount();
	else
		return 0;
}

/*
 * SendSetTransferCallback.
 */
sal_Bool INetCoreMailer_Impl::SendSetTransferCallback (
	INetCoreMailerCallback *pfnCallback, void *pData)
{
	// (OBSOLETE).
	return sal_True;
}

