/*************************************************************************
 *
 *  $RCSfile: sendclnt.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: mhu $ $Date: 2001/03/19 11:06:59 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Matthias Huetsch <matthias.huetsch@sun.com>
 *
 *
 ************************************************************************/

#ifndef _INET_SENDCLNT_HXX
#define _INET_SENDCLNT_HXX "$Revision: 1.2 $"

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _VOS_REF_HXX_
#include <vos/ref.hxx>
#endif
#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif

#ifndef _INETCOREMAIL_HXX
#include <inetmail.hxx>
#endif
#ifndef _INETSMTP_HXX
#include <inetsmtp.hxx>
#endif

namespace inet
{

/*========================================================================
 *
 * SendClient_Impl internals.
 *
 *======================================================================*/
namespace smtp
{
	class SendContext_Impl;
}

namespace mail
{

/*========================================================================
 *
 * SendClient_Impl interface.
 *
 *======================================================================*/
class SendClient_Impl : public NAMESPACE_VOS(OReference)
{
public:
	class ClientManager
	{
	public:
		virtual operator INetCoreMailer* (void) = 0;

		virtual sal_Bool prepareMessage (
			INetCoreMIMEMessage &rMessage) = 0;

		virtual void terminated (
			const NAMESPACE_VOS(ORef)<SendClient_Impl> &rxClient) = 0;
	};

	SendClient_Impl (ClientManager &rManager);

	sal_Bool openConnection (
		const rtl::OUString    &rHost, sal_uInt16 nPort,
		INetCoreMailerCallback *pfnCallback, void *pData);
	sal_Bool isOpen (void) const;

	sal_Bool closeConnection (
		INetCoreMailerCallback *pfnCallback, void *pData);
	void abortConnection (void);

	sal_Bool sendMail (
		INetCoreMIMEMessage &rMessage,
		INetCoreMailerCallback *pfnCallback, void *pData);

	sal_uInt32 getTransferCount (void) const;

protected:
	/** Destruction.
	 */
	virtual ~SendClient_Impl (void);

private:
	/** Representation.
	 */
	enum State
	{
		STATE_NONE = 0,
		STATE_EVENT,

		STATE_OPEN,
		STATE_CLOSE,
		STATE_FROM,
		STATE_TO,
		STATE_DATA
	};

	ClientManager         & m_rManager;
	NAMESPACE_VOS(OMutex)   m_aMutex;
	NAMESPACE_VOS(IMutex) & getMutex_Impl (void) const;

	/** Connection.
	 */
	typedef INetCoreSMTPConnection connection_type;
	NAMESPACE_VOS(ORef)<connection_type> m_xConnection;

	sal_Bool createConnection_Impl (
		NAMESPACE_VOS(ORef)<connection_type> &rxConnection);
	sal_Bool getConnection_Impl (
		NAMESPACE_VOS(ORef)<connection_type> &rxConnection) const;

	static sal_Bool onConnectionEvent (
		connection_type *pConnection,
		sal_Int32 nReplyCode, const sal_Char *pReplyText, void *pData);
	void handleConnectionEvent (
		connection_type *pConnection,
		sal_Int32 nReplyCode, const sal_Char *pReplyText);

	/** Context.
	 */
	NAMESPACE_VOS(ORef)<inet::smtp::SendContext_Impl> m_xContext;

	/** State.
	 */
	State    m_eState;

	sal_Bool changeState_Impl (State ePrev, State eNext);
	void     setState_Impl    (State eState);

	/** Implementation.
	 */
	sal_Bool mailFrom_Impl (const rtl::OUString &rFrom);
	sal_Bool mailTo_Impl (const rtl::OUString &rRcpt);
	sal_Bool transferData_Impl (INetCoreMessageIStream &rStrm);

	/** Not implemented.
	 */
	SendClient_Impl (const SendClient_Impl&);
	SendClient_Impl& operator= (const SendClient_Impl&);
};

/*========================================================================
 *
 * The End.
 *
 *======================================================================*/
} // mail
} // inet

#endif /* !_INET_SENDCLNT_HXX */


