/*************************************************************************
 *
 *  $RCSfile: patchspy.c,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:31:17 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <stdio.h>
#include <io.h>
#include <process.h>
#include <fcntl.h>
#include <stdlib.h>

#define BUFLEN 1024*16

void main( int argc, char *argv[], char **envp )
{
	int fh;
	char buffer[BUFLEN];
	int	 bufcount = 0;
	int  bufpos = 0;
	int sp = 0, len = 11;
	const char *pattern = "wsock32.dll";
	const char *replace = "wntch32.dll";

    if( argc != 2 )
	{
		printf( "\nError: Argument must be the filename to patch for use with sockspy.\n");
		return;
		exit(-1);
	};
	fh = _open(argv[1],_O_BINARY | _O_RDWR );
	if(fh == -1)
	{
		printf( "\nError: Couldn't open %s.\n",argv[1]);
		exit(-2);
	};
	while(1)
	{
		if(bufcount == bufpos)
		{
			if(((bufcount = _read(fh,buffer,BUFLEN)) == -1) || (!bufcount))
			{
				_close(fh);
				if(!bufcount)
					break;
				printf("\nError: read Error!\n");
				exit(-5);
			}
			bufpos = 0;
		}
		if(tolower(buffer[bufpos++]) == pattern[sp])
		{
			sp++;
			if(sp == len)
			{
				long test2;
				long test;
				test = _tell(fh);

				if(_lseek(fh, -11-bufcount+bufpos, SEEK_CUR) == -1)
				{
					_close(fh);
					printf("\nError: couldn't seek back\n");
					exit(-4);
				}
				test2 = _tell(fh);
				
				if(_write(fh,replace,len) != 11)
				{
					_close(fh);
					printf("\nError: couldn't write patch\n");
					exit(-5);
				}
				close(fh);
				printf("\nYeah! File patched for use with sockspy.\n");
				exit(0);
			}
		}
		else
			sp = 0;
	}
	_close(fh);
	printf("\nError: Pattern '%s' not found!\n",pattern);
    exit(-3);
}
