/*************************************************************************
 *
 *  $RCSfile: ftptest.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:31:17 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define _FTPTEST_CXX "$Revision: 1.1.1.1 $"

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _VOS_MACROS_HXX_
#include <vos/macros.hxx>
#endif
#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif
#ifndef _GEN_HXX
#include <tools/gen.hxx>
#endif
#ifndef _LINK_HXX
#include <tools/link.hxx>
#endif
#ifndef _LIST_HXX
#include <tools/list.hxx>
#endif
#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif
#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#ifndef _SV_EDIT_HXX
#include <vcl/edit.hxx>
#endif
#ifndef _SV_HELP_HXX
#include <vcl/help.hxx>
#endif
#ifndef _SV_LSTBOX_HXX
#include <vcl/lstbox.hxx>
#endif
#ifndef _SV_TOOLBOX_HXX
#include <vcl/toolbox.hxx>
#endif
#ifndef _SV_WRKWIN_HXX
#include <vcl/wrkwin.hxx>
#endif

#ifndef _INET_MACROS_HXX
#include <inet/macros.hxx>
#endif
#ifndef _INET_MODULE_HXX
#include <inet/module.hxx>
#endif
#ifndef _INET_CONFIG_HXX
#include <inetcfg.hxx>
#endif

#ifndef _INETDNS_HXX
#include <inetdns.hxx>
#endif
#ifndef _INETFTP_HXX
#include <inetftp.hxx>
#endif

#include <stdlib.h>

#if (defined(WIN) || defined(WNT) || defined(OS2))
#define FTPTEST_DATAFILE "c:\\ftptest.dat"
#elif (defined(UNX))
#define FTPTEST_DATAFILE "/tmp/ftptest.dat"
#else
#define FTPTEST_DATAFILE "ftptest.dat"
#endif

#ifdef _USE_NAMESPACE
using namespace inet;
using namespace rtl;
#endif

inline UniString S2U (const sal_Char *pszAscii)
{
	return UniString::CreateFromAscii (pszAscii);
}

/*========================================================================
 *
 * MyModule.
 *
 *======================================================================*/
class MyModule
{
public:
	MyModule (void);
	~MyModule (void);

	sal_Bool isValid (void) const;

private:
	INetModuleApi *m_pApi;
};

MyModule::MyModule (void)
	: m_pApi (INetModule_Impl::getOrCreate())
{
	if (m_pApi)
		m_pApi->acquire();
}

MyModule::~MyModule (void)
{
	if (m_pApi)
		m_pApi->release();
}

sal_Bool MyModule::isValid (void) const
{
	return (!!m_pApi);
}

/*========================================================================
 *
 * MyOutWindow.
 *
 *======================================================================*/
#define MYOUTWINDOW_MAXLINES 500

class MyOutWindow : public ListBox
{
public:
	MyOutWindow (Window *pParent, WinBits nWinStyle);
	~MyOutWindow (void);

	void Append (const String &rLine);
};

MyOutWindow::MyOutWindow (Window *pParent, WinBits nWinStyle)
	: ListBox (pParent, nWinStyle | WB_AUTOHSCROLL)
{
}

MyOutWindow::~MyOutWindow (void)
{
}

void MyOutWindow::Append (const String &rLine)
{
	String aLine (rLine);

	xub_StrLen nPos = aLine.Search ('\n');
	while (nPos != STRING_NOTFOUND)
	{
		if (GetEntryCount() >= MYOUTWINDOW_MAXLINES)
			RemoveEntry(0);
		InsertEntry (aLine.Copy (0, nPos));

		aLine.Erase (0, nPos + 1);
		nPos = aLine.Search ('\n');
	}

	if (GetEntryCount() >= MYOUTWINDOW_MAXLINES)
		RemoveEntry(0);
	InsertEntry (aLine);

	SetTopEntry (MYOUTWINDOW_MAXLINES - 1);
}

/*========================================================================
 *
 * MyWin.
 *
 *======================================================================*/
#define MYWIN_ITEMID_CLEAR   1
#define MYWIN_ITEMID_OPEN    2
#define MYWIN_ITEMID_USER    3
#define MYWIN_ITEMID_PASS    4
#define MYWIN_ITEMID_NOOP    5
#define MYWIN_ITEMID_PWD     6
#define MYWIN_ITEMID_CWD     7
#define MYWIN_ITEMID_LST     8
#define MYWIN_ITEMID_MKD     9
#define MYWIN_ITEMID_RMD    10
#define MYWIN_ITEMID_DEL    11
#define MYWIN_ITEMID_ASCII  12
#define MYWIN_ITEMID_IMAGE  13
#define MYWIN_ITEMID_RETR   14
#define MYWIN_ITEMID_STOR   15
#define MYWIN_ITEMID_ABORT  16
#define MYWIN_ITEMID_BYE    17
#define MYWIN_ITEMID_KILL   18

class MyWin : public WorkWindow
{
public:
	MyWin (Window *pParent, WinBits nWinStyle);
	virtual ~MyWin (void);

	void Resize (void);
	DECL_LINK   (ToolBarHnd, ToolBox*);

private:
	/** Representation.
	 */
	ToolBox              *pTool;
	Edit                 *pCmdEdit;
	MyOutWindow          *m_pOutWin;

	INetCoreDNSResolver                    *m_pResolver;
	NAMESPACE_VOS(ORef)<INetFTPConnection>  m_xConnection;

	SvOpenLockBytesRef    m_xRecvLB;
	SvLockBytesRef        m_xSendLB;
	List                  m_aNameList;

	/** Implementation.
	 */
	void Print (const String &rOutText, BOOL bUpdate = TRUE);

	static sal_Bool CommandCallback (
		INetFTPConnection *pCon,
		sal_Int32 nReply, const sal_Char *pText, void *pData);

	static sal_Bool GetPathCallback (
		INetFTPConnection *pCon,
		sal_Int32 nReply, const sal_Char *pText, void *pData);

	static sal_Bool GetNameListCallback (
		INetFTPConnection *pCon,
		sal_Int32 nReply, const sal_Char *pText, void *pData);

	static sal_Bool RetrieveCallback (
		INetFTPConnection *pCon,
		sal_Int32 nReply, const sal_Char *pText, void *pData);

	static sal_Bool StoreCallback (
		INetFTPConnection *pCon,
		sal_Int32 nReply, const sal_Char *pText, void *pData);

	static sal_Bool TermCallback (
		INetFTPConnection *pCon,
		sal_Int32 nReply, const sal_Char *pText, void *pData);
};

/*
 * MyWin.
 */
MyWin::MyWin (Window *pParent, WinBits nWinStyle)
	: WorkWindow (pParent, nWinStyle)
{
	// ToolBar.
	pTool = new ToolBox (this, WB_SVLOOK | WB_BORDER);

	pTool->InsertItem  (MYWIN_ITEMID_CLEAR, S2U("Clear"));
	pTool->SetHelpText (MYWIN_ITEMID_CLEAR, S2U("Clear Output Window"));
	pTool->InsertSeparator();

	pTool->InsertItem  (MYWIN_ITEMID_OPEN, S2U("Open"));
	pTool->SetHelpText (MYWIN_ITEMID_OPEN, S2U("Open Connection to Server"));
	pTool->InsertItem  (MYWIN_ITEMID_USER, S2U("User"));
	pTool->SetHelpText (MYWIN_ITEMID_USER, S2U("Login Username"));
	pTool->InsertItem  (MYWIN_ITEMID_PASS, S2U("Pass"));
	pTool->SetHelpText (MYWIN_ITEMID_PASS, S2U("Login Password"));
	pTool->InsertSeparator();

	pTool->InsertItem  (MYWIN_ITEMID_NOOP, S2U("Check"));
	pTool->SetHelpText (MYWIN_ITEMID_NOOP, S2U("Check Connection to Server"));
	pTool->InsertSeparator();

	pTool->InsertItem  (MYWIN_ITEMID_PWD, S2U("Pwd"));
	pTool->SetHelpText (MYWIN_ITEMID_PWD, S2U("Print Working Directory"));
	pTool->InsertItem  (MYWIN_ITEMID_CWD, S2U("Cwd"));
	pTool->SetHelpText (MYWIN_ITEMID_CWD, S2U("Change Working Directory"));
	pTool->InsertItem  (MYWIN_ITEMID_LST, S2U("Lst"));
	pTool->SetHelpText (MYWIN_ITEMID_LST, S2U("List Directory contents"));
	pTool->InsertItem  (MYWIN_ITEMID_MKD, S2U("Mkd"));
	pTool->SetHelpText (MYWIN_ITEMID_MKD, S2U("Make Directory"));
	pTool->InsertItem  (MYWIN_ITEMID_RMD, S2U("Rmd"));
	pTool->SetHelpText (MYWIN_ITEMID_RMD, S2U("Remove Directory"));
	pTool->InsertItem  (MYWIN_ITEMID_DEL, S2U("Del"));
	pTool->SetHelpText (MYWIN_ITEMID_DEL, S2U("Delete File"));
	pTool->InsertSeparator();

	pTool->InsertItem  (MYWIN_ITEMID_ASCII, S2U("Asc"));
	pTool->SetHelpText (MYWIN_ITEMID_ASCII, S2U("Set Type to ASCII"));
	pTool->InsertItem  (MYWIN_ITEMID_IMAGE, S2U("Bin"));
	pTool->SetHelpText (MYWIN_ITEMID_IMAGE, S2U("Set Type to binary Image"));
	pTool->InsertItem  (MYWIN_ITEMID_RETR,  S2U("Retr"));
	pTool->SetHelpText (MYWIN_ITEMID_RETR,  S2U("Retrieve File from Server"));
	pTool->InsertItem  (MYWIN_ITEMID_STOR,  S2U("Stor"));
	pTool->SetHelpText (MYWIN_ITEMID_STOR,  S2U("Store File on Server"));
	pTool->InsertItem  (MYWIN_ITEMID_ABORT, S2U("Abort"));
	pTool->SetHelpText (MYWIN_ITEMID_ABORT, S2U("Abort File Transfer"));
	pTool->InsertSeparator();

	pTool->InsertItem  (MYWIN_ITEMID_BYE, S2U("Close"));
	pTool->SetHelpText (MYWIN_ITEMID_BYE, S2U("Logout and Disconnect"));
	pTool->InsertSeparator();

	pTool->InsertItem  (MYWIN_ITEMID_KILL, S2U("Kill"));
	pTool->SetHelpText (MYWIN_ITEMID_KILL, S2U("Kill Connection to Server"));

	pTool->SetClickHdl (LINK(this, MyWin, ToolBarHnd));
	pTool->Show();

	// HostEdit.
	pCmdEdit = new Edit (this);
	pCmdEdit->SetReadOnly (FALSE);
	pCmdEdit->Show();

	// Output window.
	m_pOutWin = new MyOutWindow (this, WB_HSCROLL | WB_VSCROLL | WB_BORDER);
	m_pOutWin->SetReadOnly (TRUE);
	m_pOutWin->Show();

	// DNS Resolver.
	m_pResolver = new INetCoreDNSResolver;
}

/*
 * ~MyWin.
 */
MyWin::~MyWin (void)
{
	delete m_pResolver;
	delete m_pOutWin;
	delete pCmdEdit;
	delete pTool;
}

/*
 * Print.
 */
void MyWin::Print (const String &rOutText, BOOL bUpdate)
{
	if (rOutText.Len())
		m_pOutWin->Append (rOutText);
	if (bUpdate)
		m_pOutWin->Update();
}

/*
 * Resize.
 */
void MyWin::Resize (void)
{
	Size aWinSize = GetOutputSizePixel();
	int nWinW = aWinSize.Width();
	int nWinH = aWinSize.Height();

	int nBoxH = pTool->CalcWindowSizePixel().Height();
	pTool->SetPosSizePixel (Point (0, 0), Size (nWinW, nBoxH));

	pCmdEdit->SetPosSizePixel (
		Point (    0, nBoxH),
		Size  (nWinW, nBoxH) );

	m_pOutWin->SetPosSizePixel (
		Point (0, nBoxH + nBoxH),
		Size (nWinW, nWinH - (nBoxH + nBoxH)));
}

/*
 * ToolBarHnd.
 */
IMPL_LINK (MyWin, ToolBarHnd, ToolBox*, pTool)
{
	String aCmdLine (pCmdEdit->GetText());
	switch (pTool->GetCurItemId())
	{
		case MYWIN_ITEMID_CLEAR:
			m_pOutWin->Clear();
			break;

		case MYWIN_ITEMID_OPEN:
			if (aCmdLine.Len())
			{
				String aHost (aCmdLine.GetToken ((USHORT)0, ':'));
				USHORT nPort = 21;

				USHORT nToken = aCmdLine.GetTokenCount (':');
				if (nToken > 1)
				{
					String aPort (aCmdLine.GetToken ((USHORT)1, ':'));
					nPort = (USHORT)(aPort.ToInt32());
				}
				if (INetFTPConnection::createInstance (m_xConnection))
				{
					m_xConnection->setTerminateCallback (TermCallback, this);

					// SOCKS gateway on MHU.STARDIV.DE || FTPPROXY.STARDIV.DE
					// m_xConnection->setSocksGateway ("172.17.1.254", 1080);

					// m_xConnection->setSocksGateway ("192.109.83.29", 1080);
					// m_xConnection->setSocksGateway ("192.109.83.74", 1080);
					// m_xConnection->setSocksGateway ("172.17.12.4", 1080);

					if (m_xConnection->open (
						aHost, nPort, CommandCallback, this))
					{
						String aText (S2U("Connecting to \" "));
						aText.Append (aCmdLine);
						aText.AppendAscii ("\" ...");
						Print (aText);
					}
					else
					{
						m_xConnection.unbind();
						Print (S2U("Connect Failure."));
					}
				}
			}
			break;
		  
		case MYWIN_ITEMID_USER:
			if (m_xConnection.isValid() && aCmdLine.Len())
			{
				if (!m_xConnection->loginUsername (
					aCmdLine, CommandCallback, this))
				{
					Print (S2U("LoginUsername Failure."));
				}
			}
			break;
		  
		case MYWIN_ITEMID_PASS:
			if (m_xConnection.isValid() && aCmdLine.Len())
			{
				if (!m_xConnection->loginPassword (
					aCmdLine, CommandCallback, this))
				{
					Print (S2U("LoginPassword Failure."));
				}
			}
			break;

		case MYWIN_ITEMID_NOOP:
			if (m_xConnection.isValid())
			{
				if (!m_xConnection->noop (CommandCallback, this))
				{
					Print (S2U("Noop Failure."));
				}
			}
			break;

		case MYWIN_ITEMID_PWD:
			if (m_xConnection.isValid())
			{
				if (!m_xConnection->getCurDir (GetPathCallback, this))
				{
					Print (S2U("GetCurDir Failure."));
				}
			}
			break;

		case MYWIN_ITEMID_CWD:
			if (m_xConnection.isValid() && aCmdLine.Len())
			{
				if (!m_xConnection->setCurDir (
					aCmdLine, CommandCallback, this))
				{
					Print (S2U("SetCurDir Failure."));
				}
			}
			break;

		case MYWIN_ITEMID_LST: // NLST | LIST.
			if (m_xConnection.isValid())
			{
				if (!m_xConnection->getNameList (
					aCmdLine, m_aNameList, GetNameListCallback, this))
				{
					Print (S2U("GetNameList Failure."));
				}
			}
			break;

		case MYWIN_ITEMID_MKD:
			if (m_xConnection.isValid() && aCmdLine.Len())
			{
				if (!m_xConnection->makeDir (
					aCmdLine, CommandCallback, this))
				{
					Print (S2U("MakeDir Failure."));
				}
			}
			break;

		case MYWIN_ITEMID_RMD:
			if (m_xConnection.isValid() && aCmdLine.Len())
			{
				if (!m_xConnection->removeDir (
					aCmdLine, CommandCallback, this))
				{
					Print (S2U("RemoveDir Failure."));
				}
			}
			break;

		case MYWIN_ITEMID_DEL:
			if (m_xConnection.isValid() && aCmdLine.Len())
			{
				if (!m_xConnection->remove (
					aCmdLine, CommandCallback, this))
				{
					Print (S2U("Delete Failure."));
				}
			}
			break;

		case MYWIN_ITEMID_ASCII: // Type A
			if (m_xConnection.isValid())
			{
				if (!m_xConnection->setTypeAscii (CommandCallback, this))
				{
					Print (S2U("SetTypeAscii Failure."));
				}
			}
			break;

		case MYWIN_ITEMID_IMAGE: // Type I
			if (m_xConnection.isValid())
			{
				if (!m_xConnection->setTypeImage (CommandCallback, this))
				{
					Print (S2U("SetTypeImage Failure."));
				}
			}
			break;

		case MYWIN_ITEMID_RETR:
			if (m_xConnection.isValid() && aCmdLine.Len())
			{
				m_xRecvLB.Clear();

				SvFileStream *pStrm = new SvFileStream (
					S2U(FTPTEST_DATAFILE), STREAM_READWRITE | STREAM_TRUNC);
				pStrm->Seek (STREAM_SEEK_TO_BEGIN);

				m_xRecvLB = new SvAsyncLockBytes (pStrm, TRUE);

				m_xConnection->setTransferCallback (RetrieveCallback, this);
				if (!m_xConnection->retrieve (
					aCmdLine, m_xRecvLB, 0, RetrieveCallback, this))
				{
					Print (S2U("Retrieve Failure."));
				}
			}
			break;

		case MYWIN_ITEMID_STOR:
			if (m_xConnection.isValid() && aCmdLine.Len())
			{
				m_xSendLB.Clear();

				SvFileStream *pStrm = new SvFileStream (
					S2U(FTPTEST_DATAFILE), STREAM_READ | STREAM_NOCREATE);
				pStrm->Seek (STREAM_SEEK_TO_BEGIN);

				m_xSendLB = new SvLockBytes (pStrm, TRUE);
				
				m_xConnection->setTransferCallback (StoreCallback, this);
				if (!m_xConnection->store (
					m_xSendLB, aCmdLine, 0, StoreCallback, this))
				{
					Print (S2U("Store Failure."));
				}
			}
			break;

		case MYWIN_ITEMID_ABORT:
			if (m_xConnection.isValid())
			{
				if (!m_xConnection->abortTransfer())
				{
					Print (S2U("AbortTransfer Failure."));
				}
			}
			break;

		case MYWIN_ITEMID_BYE:
			if (m_xConnection.isValid())
			{
				if (!m_xConnection->close (CommandCallback, this))
				{
					Print (S2U("Close Failure."));
				}
			}
			break;

		case MYWIN_ITEMID_KILL:
			if (m_xConnection.isValid())
			{
				m_xConnection->abort();
				m_xConnection.unbind();
			}
			break;

		default: // Ignore.
			break;
	}
	return 0;
}

/*
 * CommandCallback.
 */
sal_Bool MyWin::CommandCallback (
	INetFTPConnection *pCon,
	sal_Int32 nReply, const sal_Char *pText, void *pData)
{
	MyWin *pThis = SAL_REINTERPRET_CAST(MyWin*, pData);
	if (pThis)
	{
		NAMESPACE_VOS(OGuard) aGuard (Application::GetSolarMutex());

		String aText (S2U("CommandCallback: Reply Code: "));
		aText += UniString::CreateFromInt32 (nReply);
		if (pText)
		{
			aText.Append (sal_Unicode('\n'));
			aText.AppendAscii (pText);
		}
		pThis->Print (aText);

		if (nReply == INetFTPConnection::REPLY_NETWORK_ERROR)
			pThis->m_xConnection.unbind();
	}
	return sal_True;
}

/*
 * GetPathCallback.
 */
sal_Bool MyWin::GetPathCallback (
	INetFTPConnection *pCon,
	sal_Int32 nReply, const sal_Char *pText, void *pData)
{
	MyWin *pThis = SAL_REINTERPRET_CAST(MyWin*, pData);
	if (pThis)
	{
		NAMESPACE_VOS(OGuard) aGuard (Application::GetSolarMutex());

		String aText (S2U("GetPathCallback: Reply Code: "));
		aText += UniString::CreateFromInt32 (nReply);
		if (pText)
		{
			aText.Append (sal_Unicode('\n'));
			aText.AppendAscii (pText);
		}
		if (nReply/100 == 2)
		{
			aText.AppendAscii ("\nGetPathCallback: Current Path: ");
			aText.Append (UniString (pCon->getCurDir()));
		}
		pThis->Print (aText);

		if (nReply == INetFTPConnection::REPLY_NETWORK_ERROR)
			pThis->m_xConnection.unbind();
	}
	return sal_True;
}

/*
 * GetNameListCallback.
 */
sal_Bool MyWin::GetNameListCallback (
	INetFTPConnection *pCon,
	sal_Int32 nReply, const sal_Char *pText, void *pData)
{
	MyWin *pThis = SAL_REINTERPRET_CAST(MyWin*, pData);
	if (pThis)
	{
		NAMESPACE_VOS(OGuard) aGuard (Application::GetSolarMutex());

		String aText (S2U("GetNameListCallback: Reply Code: "));
		aText += UniString::CreateFromInt32 (nReply);
		if (pText)
		{
			aText.Append (sal_Unicode('\n'));
			aText.AppendAscii (pText);
			pThis->Print (aText);
		}
		if (nReply/100 == 2)
		{
			aText.AssignAscii ("GetNameListCallback: RetrCount: ");
			aText += UniString::CreateFromInt32 (pCon->getRetrieveCount());
			pThis->Print (aText);
		}

		List &rList = pThis->m_aNameList;
		ULONG  i, n = rList.Count();
		for (i = 0; i < n; i++)
		{
			INetFTPDirentry *entry = (INetFTPDirentry*)(rList.GetObject(i));
			if (entry->m_aName.getLength() > 0)
			{
				aText.Assign (entry->m_aName);
				if (entry->m_nMode & INETCOREFTP_FILEMODE_ISDIR)
					aText += sal_Unicode('/');
				aText += sal_Unicode('\t');
				aText += UniString::CreateFromInt32 (entry->m_nSize);
				pThis->Print (aText, (i % 10 == 0));
			}
			delete entry;
		}
		rList.Clear();
		pThis->Print (String());

		if (nReply == INetFTPConnection::REPLY_NETWORK_ERROR)
			pThis->m_xConnection.unbind();
	}
	return sal_True;
}

/*
 * RetrieveCallback.
 */
sal_Bool MyWin::RetrieveCallback (
	INetFTPConnection *pCon,
	sal_Int32 nReply, const sal_Char *pText, void *pData)
{
	MyWin *pThis = SAL_REINTERPRET_CAST(MyWin*, pData);
	if (pThis)
	{
		NAMESPACE_VOS(OGuard) aGuard (Application::GetSolarMutex());
		if (nReply == INetFTPConnection::REPLY_TRANSFER_WAIT)
		{
			sal_uInt32 nRead = pCon->getRetrieveCount();

			String aText (S2U("RetrieveCallback: RetrCount: "));
			aText += UniString::CreateFromInt32 (nRead);
			pThis->Print (aText);

			if (nRead > 100000)
			{
#if 0   /* @@@ ABORT @@@ */
				pCon->abortTransfer();
#endif  /* @@@ ABORT @@@ */
			}
		}
		else
		{
			String aText (S2U("RetrieveCallback: Reply Code: "));
			aText += UniString::CreateFromInt32 (nReply);
			if (pText)
			{
				aText.Append (sal_Unicode('\n'));
				aText.AppendAscii (pText);
			}

			aText.AppendAscii ("\nRetrieveCallback: RetrCount: ");
			aText += UniString::CreateFromInt32 (pCon->getRetrieveCount());
			pThis->Print (aText);

			pCon->setTransferCallback (NULL, NULL);
			pThis->m_xRecvLB.Clear();
		}

		if (nReply == INetFTPConnection::REPLY_NETWORK_ERROR)
			pThis->m_xConnection.unbind();
	}
	return sal_True;
}

/*
 * StoreCallback.
 */
sal_Bool MyWin::StoreCallback (
	INetFTPConnection *pCon,
	sal_Int32 nReply, const sal_Char *pText, void *pData)
{
	MyWin *pThis = SAL_REINTERPRET_CAST(MyWin*, pData);
	if (pThis)
	{
		NAMESPACE_VOS(OGuard) aGuard (Application::GetSolarMutex());
		if (nReply == INetFTPConnection::REPLY_TRANSFER_WAIT)
		{
			String aText (S2U("StoreCallback: StorCount: "));
			aText += UniString::CreateFromInt32 (pCon->getStoreCount());
			pThis->Print (aText);
		}
		else
		{
			String aText (S2U("StoreCallback: Reply Code: "));
			aText += UniString::CreateFromInt32 (nReply);
			if (pText)
			{
				aText.Append (sal_Unicode('\n'));
				aText.AppendAscii (pText);
			}

			aText.AppendAscii ("\nStoreCallback: StorCount: ");
			aText += UniString::CreateFromInt32 (pCon->getStoreCount());
			pThis->Print (aText);

			pCon->setTransferCallback (NULL, NULL);
			pThis->m_xSendLB.Clear();
		}

		if (nReply == INetFTPConnection::REPLY_NETWORK_ERROR)
			pThis->m_xConnection.unbind();
	}
	return sal_True;
}

/*
 * TermCallback.
 */
sal_Bool MyWin::TermCallback (
	INetFTPConnection *pCon,
	sal_Int32 nReply, const sal_Char *pText, void *pData)
{
	MyWin *pThis = SAL_REINTERPRET_CAST(MyWin*, pData);
	if (pThis)
	{
		NAMESPACE_VOS(OGuard) aGuard (Application::GetSolarMutex());

		String aText (S2U("TermCallback: Reply Code: "));
		aText += UniString::CreateFromInt32 (nReply);
		if (pText)
		{
			aText.Append (sal_Unicode('\n'));
			aText.AppendAscii (pText);
		}
		pThis->Print (aText);

		if (nReply == INetFTPConnection::REPLY_NETWORK_ERROR)
			pThis->m_xConnection.unbind();
	}
	return sal_True;
}

/*========================================================================
 *
 * MyApp.
 *
 *======================================================================*/
class MyApp : public Application
{
public:
	virtual void Main (void)
	{
		MyModule aModule;
		if (aModule.isValid())
		{
			Help::EnableBalloonHelp();

			MyWin aMyWin (NULL, WB_APP | WB_STDWORK);
			aMyWin.SetText (S2U ("FtpTest/1.26"));
			aMyWin.Show();

			Execute();
		}
	}
};

MyApp aMyApp;

