/*************************************************************************
 *
 *  $RCSfile: ldaptest.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:31:17 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif
#ifndef _GEN_HXX
#include <tools/gen.hxx>
#endif
#ifndef _LINK_HXX
#include <tools/link.hxx>
#endif
#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#ifndef _SV_EDIT_HXX
#include <vcl/edit.hxx>
#endif
#ifndef _SV_HELP_HXX
#include <vcl/help.hxx>
#endif
#ifndef _SV_LSTBOX_HXX
#include <vcl/lstbox.hxx>
#endif
#ifndef _SV_TOOLBOX_HXX
#include <vcl/toolbox.hxx>
#endif
#ifndef _SV_WRKWIN_HXX
#include <vcl/wrkwin.hxx>
#endif

#ifndef _INET_MACROS_HXX
#include <inet/macros.hxx>
#endif
#ifndef _INET_MODULE_HXX
#include <inet/module.hxx>
#endif
#ifndef _INET_CONFIG_HXX
#include <inetcfg.hxx>
#endif

#ifndef _INETCORELDAP_HXX
#include <inetldap.hxx>
#endif
#ifndef _LDAPMSG_HXX
#include <ldapmsg.hxx>
#endif

#ifdef _USE_NAMESPACE
using namespace inet;
using namespace rtl;
#endif

#include <stdlib.h>

inline UniString S2U (const sal_Char *pszAscii)
{
	return UniString::CreateFromAscii (pszAscii);
}
inline rtl::OUString S2OU (const sal_Char *pszAscii)
{
	return rtl::OUString::createFromAscii (pszAscii);
}

/*========================================================================
 *
 * MyModule.
 *
 *======================================================================*/
class MyModule
{
public:
	MyModule (void);
	~MyModule (void);

	sal_Bool isValid (void) const;

private:
	INetModuleApi *m_pApi;
};

MyModule::MyModule (void)
	: m_pApi (INetModule_Impl::getOrCreate())
{
	if (m_pApi)
		m_pApi->acquire();
}

MyModule::~MyModule (void)
{
	if (m_pApi)
		m_pApi->release();
}

sal_Bool MyModule::isValid (void) const
{
	return (!!m_pApi);
}

/*========================================================================
 *
 * MyOutWindow.
 *
 *======================================================================*/
#define MYOUTWINDOW_MAXLINES 500

class MyOutWindow : public ListBox
{
public:
	MyOutWindow (Window *pParent, WinBits nWinStyle);
	~MyOutWindow (void);

	void Append (const String &rLine);
};

MyOutWindow::MyOutWindow (Window *pParent, WinBits nWinStyle)
	: ListBox (pParent, nWinStyle | WB_AUTOHSCROLL)
{
}

MyOutWindow::~MyOutWindow (void)
{
}

void MyOutWindow::Append (const String &rLine)
{
	String aLine (rLine);

	xub_StrLen nPos = aLine.Search ('\n');
	while (nPos != STRING_NOTFOUND)
	{
		if (GetEntryCount() >= MYOUTWINDOW_MAXLINES)
			RemoveEntry(0);
		InsertEntry (aLine.Copy (0, nPos));

		aLine.Erase (0, nPos + 1);
		nPos = aLine.Search ('\n');
	}

	if (GetEntryCount() >= MYOUTWINDOW_MAXLINES)
		RemoveEntry(0);
	InsertEntry (aLine);

	SetTopEntry (MYOUTWINDOW_MAXLINES - 1);
}

/*========================================================================
 *
 * MyWin interface.
 *
 *======================================================================*/
class MyWin : public WorkWindow
{
public:
	MyWin (Window *pParent, WinBits nWinStyle);
	virtual ~MyWin (void);

	void Resize (void);
	DECL_LINK (ToolBarHnd, ToolBox *);

private:
	enum MyItemID
	{
		ITEMID_LDAP_CLEAR   =  1,
		ITEMID_LDAP_OPEN    =  2,
		ITEMID_LDAP_BIND    =  3,
		ITEMID_LDAP_LIST    =  4,
		ITEMID_LDAP_READ    =  5,
		ITEMID_LDAP_SEARCH  =  6,
		ITEMID_LDAP_PERSON  =  7,
		ITEMID_LDAP_DELETE  =  8,
		ITEMID_LDAP_ABANDON =  9,
		ITEMID_LDAP_UNBIND  = 10,
		ITEMID_LDAP_ABORT   = 11,
		ITEMID_LDAP_TEST    = 12
	};

	ToolBox       *pTool;
	Edit          *pCmdEdit;
	MyOutWindow   *m_pOutWin;

	NAMESPACE_VOS(ORef)<INetCoreLDAPConnection> m_xConnection;

	void Print (const String &rOutText, BOOL bUpdate = TRUE);

	static int RequestCallback (
		INetCoreLDAPConnection *pConnection,
		int nReplyCode, const void *pReplyData,
		sal_uInt16 nMsgID, void *pData);
};

/*========================================================================
 *
 * MyWin implementation.
 *
 *======================================================================*/
/*
 * MyWin.
 */
MyWin::MyWin (Window *pParent, WinBits nWinStyle)
	: WorkWindow (pParent, nWinStyle)
{
	// ToolBar.
	pTool = new ToolBox (this, WB_SVLOOK | WB_BORDER);

	pTool->InsertItem  (ITEMID_LDAP_CLEAR, S2U("Clear"));
	pTool->SetHelpText (ITEMID_LDAP_CLEAR, S2U("Clear the Output Window"));
	pTool->InsertSeparator();

	pTool->InsertItem  (ITEMID_LDAP_OPEN, S2U("Open"));
	pTool->SetHelpText (ITEMID_LDAP_OPEN, S2U("Open Connection"));
	pTool->InsertItem  (ITEMID_LDAP_BIND, S2U("Bind"));
	pTool->SetHelpText (ITEMID_LDAP_BIND, S2U("Establish Session"));
	pTool->InsertSeparator();

	pTool->InsertItem  (ITEMID_LDAP_LIST, S2U("List"));
	pTool->SetHelpText (ITEMID_LDAP_LIST,
						S2U("Search Request (X.500 List Operation)"));
	pTool->InsertItem  (ITEMID_LDAP_READ, S2U("Read"));
	pTool->SetHelpText (ITEMID_LDAP_READ,
						S2U("Search Request (X.500 Read Operation)"));
	pTool->InsertItem  (ITEMID_LDAP_SEARCH, S2U("Search"));
	pTool->SetHelpText (ITEMID_LDAP_SEARCH,
						S2U("Search Request (deep, unlimited)"));
	pTool->InsertItem  (ITEMID_LDAP_PERSON, S2U("Person"));
	pTool->SetHelpText (ITEMID_LDAP_PERSON,
						S2U("Search Request (commonName)"));
	pTool->InsertItem  (ITEMID_LDAP_DELETE, S2U("Delete"));
	pTool->SetHelpText (ITEMID_LDAP_DELETE,
						S2U("Delete a Directory Entry"));
	pTool->InsertSeparator();

	pTool->InsertItem  (ITEMID_LDAP_ABANDON, S2U("Abandon"));
	pTool->SetHelpText (ITEMID_LDAP_ABANDON,
						S2U("Abandon a Request in Progress"));
	pTool->InsertItem  (ITEMID_LDAP_UNBIND, S2U("Unbind"));
	pTool->SetHelpText (ITEMID_LDAP_UNBIND, S2U("Disconnect Session"));
	pTool->InsertItem  (ITEMID_LDAP_ABORT, S2U("Abort"));
	pTool->SetHelpText (ITEMID_LDAP_ABORT, S2U("Abort Connection"));
	pTool->InsertSeparator();

	pTool->InsertItem  (ITEMID_LDAP_TEST, S2U("Test"));
	pTool->SetHelpText (ITEMID_LDAP_TEST, S2U("Perform programmed Test."));

	pTool->SetClickHdl (LINK (this, MyWin, ToolBarHnd));
	pTool->Show();

	// Edit.
	pCmdEdit = new Edit (this);
	pCmdEdit->SetReadOnly (FALSE);
	pCmdEdit->Show();

	// Output window.
	m_pOutWin = new MyOutWindow (this, WB_HSCROLL | WB_VSCROLL | WB_BORDER);
	m_pOutWin->SetReadOnly (TRUE);
	m_pOutWin->Show();

	// LDAP.
	m_xConnection = NULL;
}

/*
 * ~MyWin.
 */
MyWin::~MyWin (void)
{
	if (m_xConnection.isValid())
	{
		m_xConnection->Abort();
		m_xConnection = NULL;
	}

	delete m_pOutWin;
	delete pCmdEdit;
	delete pTool;
}

/*
 * Print.
 */
void MyWin::Print (const String &rOutText, BOOL bUpdate)
{
	if (rOutText.Len())
		m_pOutWin->Append (rOutText);
	if (bUpdate)
		m_pOutWin->Update();
}

/*
 * Resize.
 */
void MyWin::Resize (void)
{
	Size aWinSize = GetOutputSizePixel();
	int nWinW = aWinSize.Width();
	int nWinH = aWinSize.Height();

	int nBoxH = pTool->CalcWindowSizePixel().Height();

	pTool->SetPosSizePixel (
		Point (0, 0),
		Size  (nWinW, nBoxH));

	pCmdEdit->SetPosSizePixel (
		Point (0, nBoxH),
		Size  (nWinW, nBoxH));

	m_pOutWin->SetPosSizePixel (
		Point (0, nBoxH + nBoxH),
		Size  (nWinW, nWinH - (nBoxH + nBoxH)));
}

/*
 * ToolBarHnd.
 */
IMPL_LINK (MyWin, ToolBarHnd, ToolBox*, pTool)
{
	String aCmdLine (pCmdEdit->GetText());
	switch (pTool->GetCurItemId())
	{
		case ITEMID_LDAP_CLEAR: // Clear.
			m_pOutWin->Clear();
			break;

		case ITEMID_LDAP_OPEN: // Open.
			if (aCmdLine.Len() > 0)
			{
				if (m_xConnection.isEmpty())
					m_xConnection = new INetCoreLDAPConnection();

				if (!m_xConnection->Open (
					aCmdLine, 0, RequestCallback, this))
				{
					Print (S2U("Open Failure."));
					m_xConnection = NULL;
				}
			}
			break;

		case ITEMID_LDAP_BIND: // Bind: aCmdLine -> ObjectDN.
			if (m_xConnection.isValid())
			{
				String aPwd;
#if 0 /* _EXPERIMENTAL_ */
				aCmdLine =
					"cn=Matthew Tyler,ou=Human Resources,o=Ace Industry,c=us";
				if (aCmdLine.Len ()) aPwd = "instantiate";
#endif /* _EXPERIMENTAL_ */
				USHORT nMsgID = m_xConnection->Bind (aCmdLine, aPwd);

				String aText (S2U("Bind: MessageID: "));
				aText += UniString::CreateFromInt32 (nMsgID);
				Print (aText);
			}
			break;

		case ITEMID_LDAP_LIST: // List: aCmdLine -> baseObject.
			if (m_xConnection.isValid() && (aCmdLine.Len () > 0))
			{
				USHORT nMsgID = m_xConnection->List (aCmdLine, FALSE);
				String aText (S2U("List: MessageID: "));
				aText += UniString::CreateFromInt32 (nMsgID);
				Print (aText);
			}
			break;

		case ITEMID_LDAP_READ: // Read: aCmdLine -> baseObject.
			if (m_xConnection.isValid() && (aCmdLine.Len () > 0))
			{
				USHORT nMsgID = m_xConnection->Read (aCmdLine, FALSE);
				String aText (S2U("Read: MessageID: "));
				aText += UniString::CreateFromInt32 (nMsgID);
				Print (aText);
			}
			break;

		case ITEMID_LDAP_SEARCH: // Search (deep, unlimited).
			if (m_xConnection.isValid() && (aCmdLine.Len() > 0))
			{
				// aCmdLine -> baseObject.
				INetCoreLDAPPresentFilter aPresent;
				aPresent.SetAttributeType (S2OU("objectClass"));

				INetCoreLDAPSearchRequestMessage aSearch;
				aSearch.SetMessageID (0);
				aSearch.SetBaseObject (aCmdLine);
				aSearch.SetScope (
					INETCORELDAP_SEARCH_SCOPE_WHOLESUBTREE);
				aSearch.SetDerefAlias (
					INETCORELDAP_SEARCH_DEREF_FINDING_BASEOBJECT);
				aSearch.SetSizeLimit (0);
				aSearch.SetTimeLimit (0);
				aSearch.SetAttributesOnly (FALSE);
				aSearch.SetFilter (aPresent);

				USHORT nMsgID = m_xConnection->Search (aSearch);
				String aText (S2U("Search: MessageID: "));
				aText += UniString::CreateFromInt32 (nMsgID);
				Print (aText);
			}
			break;

		case ITEMID_LDAP_PERSON: // Search (Person).
			if (m_xConnection.isValid() && (aCmdLine.Len() > 0))
			{
				// aCmdLine -> commonName.
#if 0
				INetCoreLDAPAttributeValuePair aPerson;
				aPerson.SetType  (S2OU("cn"));
				aPerson.SetValue (aCmdLine);

				INetCoreLDAPEqualityMatchFilter aFilter;
				aFilter.SetAssertion (aPerson);
				INetCoreLDAPApproxMatchFilter aFilter;
				aFilter.SetAssertion (aPerson);
#endif
				INetCoreLDAPSubstringFilter aFilter;
				aFilter.SetAttributeType (S2OU("cn"));
#if 1
				aFilter.SetSubstring (aCmdLine); // contains...
#else
				aFilter.SetSubstring ( // begins with...
					"stephan", INETCORELDAP_SUBSTRING_INITIAL);
				aFilter.SetSubstring ( // ends with...
					"taxhet", INETCORELDAP_SUBSTRING_FINAL);
#endif

				INetCoreLDAPSearchRequestMessage aSearch;
				aSearch.SetMessageID (0);
				aSearch.SetBaseObject (OUString());
				aSearch.SetScope (
					INETCORELDAP_SEARCH_SCOPE_WHOLESUBTREE);
				aSearch.SetDerefAlias (
					INETCORELDAP_SEARCH_DEREF_FINDING_BASEOBJECT);
				aSearch.SetSizeLimit (100);
				aSearch.SetTimeLimit (0);
				aSearch.SetAttributesOnly (FALSE);
				aSearch.SetFilter (aFilter);

				aSearch.SetAttributeType (S2OU("cn"));
				aSearch.SetAttributeType (S2OU("sn"));
				aSearch.SetAttributeType (S2OU("givenName"));
				aSearch.SetAttributeType (S2OU("c"));
				aSearch.SetAttributeType (S2OU("l"));
				aSearch.SetAttributeType (S2OU("o"));
				aSearch.SetAttributeType (S2OU("mail"));
				aSearch.SetAttributeType (S2OU("telephoneNumber"));

				USHORT nMsgID = m_xConnection->Search (aSearch);
				String aText (S2U("Search: MessageID: "));
				aText += UniString::CreateFromInt32 (nMsgID);
				Print (aText);
			}
			break;

		case ITEMID_LDAP_DELETE: // Delete.
			if (m_xConnection.isValid() && (aCmdLine.Len () > 0))
			{
				USHORT nMsgID = m_xConnection->Delete (aCmdLine);
				String aText (S2U("Read: MessageID: "));
				aText += UniString::CreateFromInt32 (nMsgID);
				Print (aText);
			}
			break;

		case ITEMID_LDAP_ABANDON: // Abandon.
			if (m_xConnection.isValid() && (aCmdLine.Len () > 0))
			{
				USHORT nMsgID = m_xConnection->Abandon (aCmdLine.ToInt32());
				String aText (S2U("Abandon: MessageID: "));
				aText += UniString::CreateFromInt32 (nMsgID);
				Print (aText);
			}
			break;

		case ITEMID_LDAP_UNBIND: // Unbind.
			if (m_xConnection.isValid())
			{
				USHORT nMsgID = m_xConnection->Unbind();
				String aText (S2U("Unbind: MessageID: "));
				aText += UniString::CreateFromInt32 (nMsgID);
				Print (aText);
			}
			break;

		case ITEMID_LDAP_ABORT: // Abort.
			if (m_xConnection.isValid())
			{
				m_xConnection->Abort();
				m_xConnection = NULL;
			}
			break;

		case ITEMID_LDAP_TEST: // LDAPMSG Test.
			if (m_xConnection.isValid())
			{
#if 0 /* _EXPERIMENTAL_ */
				INetCoreLDAPEntry *pEntry = new INetCoreLDAPEntry;
#if 0
				pEntry->SetObjectName (
					"ou=StarDivision GmbH, o=Ace Industry, c=us");

				INetCoreLDAPAttribute *pAttrs = new INetCoreLDAPAttribute;
				pAttrs->SetType ("objectClass");
				pAttrs->SetValue ("top");
				pAttrs->SetValue ("organizationalUnit");
				pEntry->SetAttribute (*pAttrs);
				delete pAttrs;

#endif
#if 0
				pEntry->SetObjectName (
					"ou=Development,ou=StarDivision GmbH,o=Ace Industry,c=us");

				INetCoreLDAPAttribute *pAttrs = new INetCoreLDAPAttribute;
				pAttrs->SetType ("objectClass");
				pAttrs->SetValue ("top");
				pAttrs->SetValue ("organizationalUnit");
				pEntry->SetAttribute (*pAttrs);
				delete pAttrs;

#endif
#if 0
				String aTest;
				pEntry->GetObjectName (aTest);
				aStr += "\nObjectName: "; aStr += aTest;

				USHORT n = pEntry->GetAttributeCount();
				aStr += "\nAttributesCount: "; aStr += n;

				for (USHORT i = 0; i < n; i++)
				{
					pAttrs = pEntry->GetAttribute (i);

					pAttrs->GetType (aTest);
					aStr += "\n\tAttributeType: "; aStr += aTest;

					USHORT m = pAttrs->GetValueCount();
					aStr += "\n\tAttributeValueCount: "; aStr += m;

					for (USHORT j = 0; j < m; j++)
					{
						pAttrs->GetValue (aTest, j);
						aStr += "\n\t\tAttributeValue: "; aStr += aTest;
					}
					delete pAttrs;
				}

				USHORT nMsgID = m_xConnection->Add (*pEntry);
				aStr += "\nAdd: MessageID: ";
				aText += UniString::CreateFromInt32 (nMsgID);
				
				delete pEntry;
#endif
#if 0
				USHORT nMsgID = m_xConnection->ModifyRDN (
					"ou=Development,ou=StarDivision GmbH,o=Ace Industry,c=us",
					"ou=Entwicklung");
				aStr += "\nModifyRDN: MessageID: ";
				aText += UniString::CreateFromInt32 (nMsgID);
#endif
#if 1
				INetCoreLDAPPresentFilter aPresent1;
				aPresent1.SetAttributeType ("objectClass");
				INetCoreLDAPPresentFilter aPresent2;
				aPresent2.SetAttributeType ("ou");
				INetCoreLDAPPresentFilter aPresent3;
				aPresent3.SetAttributeType ("modifyTimeStamp");

				INetCoreLDAPAndFilter aAnd;
				aAnd.SetFilter (aPresent1);
				aAnd.SetFilter (aPresent2);
				aAnd.SetFilter (aPresent3);

				INetCoreLDAPSearchRequestMessage aSearch;
				aSearch.SetMessageID (0);
				aSearch.SetBaseObject ("o=Ace Industry, c=us");
				aSearch.SetScope (
					INETCORELDAP_SEARCH_SCOPE_WHOLESUBTREE);
				aSearch.SetDerefAlias (
					INETCORELDAP_SEARCH_DEREF_FINDING_BASEOBJECT);

				aSearch.SetSizeLimit (50);
				aSearch.SetTimeLimit (0);
				aSearch.SetAttributesOnly (FALSE);

				aSearch.SetFilter (aAnd);

				USHORT nMsgID = m_xConnection->Search (aSearch);
				String aText ("Search: MessageID: ");
				aText += UniString::CreateFromInt32 (nMsgID);
				Print (aText);
#endif
#endif /* _EXPERIMENTAL_ */
			}
			break;

		default: // Ignored.
			break;
	}
	return 0;
}

/*
 * RequestCallback.
 */
int MyWin::RequestCallback (
	INetCoreLDAPConnection *pConnection,
	int nReplyCode, const void *pReplyData, sal_uInt16 nMsgID, void *pData)
{
	MyWin *pThis = SAL_REINTERPRET_CAST(MyWin*, pData);
	if (pThis)
	{
		NAMESPACE_VOS(OGuard) aGuard (Application::GetSolarMutex());

		String aText (S2U("RequestCallback: nReplyCode: "));
		aText += UniString::CreateFromInt32 (nReplyCode);
		aText.AppendAscii (" (MessageID: ");
		aText += UniString::CreateFromInt32 (nMsgID);
		aText += sal_Unicode(')');
		pThis->Print (aText);

		switch (nReplyCode)
		{
			case INETCORELDAP_REPLY_RESPONSE_DONE:
				if (pReplyData)
				{
					const INetCoreLDAPResult *pResult =
						(const INetCoreLDAPResult *)pReplyData;

					aText.AssignAscii ("ResultCode: ");
					aText += UniString::CreateFromInt32 (
						pResult->GetResultCode());

					OUString aResult;
					if (pResult->GetMatchedDN (aResult))
					{
						if (aResult.getLength())
						{
							aText.AppendAscii ("\n\tMatchedDN: ");
							aText.Append (UniString (aResult));
						}
					}
					if (pResult->GetErrorMessage (aResult))
					{
						if (aResult.getLength())
						{
							aText.AppendAscii ("\n\tErrorMessage: ");
							aText.Append (UniString (aResult));
						}
					}
					pThis->Print (aText);
				}
				break;

			case INETCORELDAP_REPLY_SEARCHENTRY:
				if (pReplyData)
				{
					const INetCoreLDAPEntry *pEntry =
						(const INetCoreLDAPEntry *)pReplyData;

					OUString aTest;
					pEntry->GetObjectName (aTest);
					aText.AssignAscii ("ObjName: ");
					aText.Append (UniString (aTest));

					USHORT n = pEntry->GetAttributeCount();
					aText.AppendAscii ("\nAttrCount: ");
					aText += UniString::CreateFromInt32 (n);

					INetCoreLDAPAttribute *pAttrs = NULL;
					for (USHORT i = 0; i < n; i++)
					{
						pAttrs = pEntry->GetAttribute (i);

						pAttrs->GetType (aTest);
						aText.AppendAscii ("\n\tAttrType: ");
						aText.Append (UniString (aTest));

						USHORT m = pAttrs->GetValueCount();
						aText.AppendAscii ("\n\tAttrValCount: ");
						aText += UniString::CreateFromInt32 (m);

						for (USHORT j = 0; j < m; j++)
						{
							pAttrs->GetValue (aTest, j);
							aText.AppendAscii ("\n\t\tAttrVal: ");
							aText.Append (UniString (aTest));
						}
						delete pAttrs;
					}
					pThis->Print (aText);
				}
				break;

			case INETCORELDAP_REPLY_CONNECTION_TERMINATED:
				pThis->m_xConnection = NULL;
				break;

			default:
				break;
		}
	}
	return 1;
}

/*========================================================================
 *
 * MyApp.
 *
 *======================================================================*/
class MyApp : public Application
{
public:
	virtual void Main (void)
	{
		MyModule aModule;
		if (aModule.isValid())
		{
			Help::EnableBalloonHelp();
			String aUserAgent (S2U("DirectoryUserAgent/1.13"));

			NAMESPACE_VOS(ORef)<INetConfig> xConfig;
			if (INetConfig::getOrCreate (xConfig))
			{
				// Setup ProxyConfig.
				INetProxyConfig aProxyCfg (xConfig->getProxyConfig());

				// aProxyCfg.setSocksProxy (S2OU("172.17.1.254"), 1080);
				aProxyCfg.setNoProxyList (S2OU("*.stardiv.de"));

				xConfig->setProxyConfig (aProxyCfg);

				// Setup additional configuration.
				// xConfig->setDomainNameServer (S2OU("192.109.83.75"));
				xConfig->setUserAgent (aUserAgent);
			}


			MyWin aMyWin (NULL, WB_APP | WB_STDWORK);
			aMyWin.SetText (aUserAgent);
			aMyWin.Show();

			Execute();
		}
	}
};

MyApp aMyApp;

