#*************************************************************************
#
#   $RCSfile: makefile.mk,v $
#
#   $Revision: 1.2 $
#
#   last change: $Author: hr $ $Date: 2001/02/20 17:39:10 $
#
#   The Contents of this file are made available subject to the terms of
#   either of the following licenses
#
#          - GNU Lesser General Public License Version 2.1
#          - Sun Industry Standards Source License Version 1.1
#
#   Sun Microsystems Inc., October, 2000
#
#   GNU Lesser General Public License Version 2.1
#   =============================================
#   Copyright 2000 by Sun Microsystems, Inc.
#   901 San Antonio Road, Palo Alto, CA 94303, USA
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License version 2.1, as published by the Free Software Foundation.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#   MA  02111-1307  USA
#
#
#   Sun Industry Standards Source License Version 1.1
#   =================================================
#   The contents of this file are subject to the Sun Industry Standards
#   Source License Version 1.1 (the "License"); You may not use this file
#   except in compliance with the License. You may obtain a copy of the
#   License at http://www.openoffice.org/license.html.
#
#   Software provided under this License is provided on an "AS IS" basis,
#   WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
#   WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
#   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
#   See the License for the specific provisions governing your rights and
#   obligations concerning the Software.
#
#   The Initial Developer of the Original Code is: Sun Microsystems, Inc.
#
#   Copyright: 2000 by Sun Microsystems, Inc.
#
#   All Rights Reserved.
#
#   Contributor(s): _______________________________________
#
#
#
#*************************************************************************
PRJ=..$/..

PRJNAME=INET
TARGET=socktest
LIBTARGET=NO

# --- Settings -----------------------------------------------------

.INCLUDE :  svpre.mk
.INCLUDE :  settings.mk
.INCLUDE :  sv.mk

# --- Files --------------------------------------------------------

CXXFILES=	\
	socktest.cxx	\
	ftptest.cxx		\
	mailtest.cxx	\
	ldaptest.cxx

.IF "$(SOLAR_SSL)" != ""
CXXFILES+=	\
	ssldemo.cxx
.ENDIF # SOLAR_SSL

OBJFILES=	\
	$(OBJ)$/socktest.obj	\
	$(OBJ)$/ftptest.obj		\
	$(OBJ)$/mailtest.obj	\
	$(OBJ)$/ldaptest.obj

.IF "$(SOLAR_SSL)" != ""
OBJFILES+=	\
	$(OBJ)$/ssldemo.obj
.ENDIF # SOLAR_SSL

# ------------------------------------------------------------------
# LIBRARIES
# ------------------------------------------------------------------
.IF "$(LDAPBERLIB)" == ""

.IF "$(GUI)" == "UNX"
LDAPBERLIB=	-lldapber
.ENDIF # unx

.IF "$(GUI)" == "WNT"
LDAPBERLIB=	ldapber.lib
.ENDIF # wnt

.ENDIF # ldapberlib

.IF "$(GUI)" != "UNX"
TESTAPPLIBS=	$(LB)$/nidebug.lib
.ELSE
TESTAPPLIBS=	$(LB)$/nidebug.a
.ENDIF # unx

TESTAPPLIBS+=$(SVLIB) $(TOOLSLIB) $(VOSLIB) $(SALLIB) $(LDAPBERLIB)

# ------------------------------------------------------------------
# SOCKTEST
# ------------------------------------------------------------------
APP1TARGET= socktest
APP1OBJS=	$(OBJ)$/socktest.obj

APP1STDLIBS=$(TESTAPPLIBS)

APP1DEF=    $(MISC)$/$(APP1TARGET).def
APP1DEPN=   $(L)$/itools.lib	\
			$(L)$/ivos.lib		\
			$(LB)$/nidebug.lib

# ------------------------------------------------------------------
# FTPTEST
# ------------------------------------------------------------------
APP2TARGET= ftptest
APP2OBJS=   $(OBJ)$/ftptest.obj

APP2STDLIBS=$(TESTAPPLIBS)

APP2DEF=    $(MISC)$/$(APP2TARGET).def
APP2DEPN=   $(L)$/itools.lib	\
			$(L)$/ivos.lib		\
			$(LB)$/nidebug.lib

# ------------------------------------------------------------------
# MAILTEST
# ------------------------------------------------------------------
APP3TARGET= mailtest
APP3OBJS=   $(OBJ)$/mailtest.obj

APP3STDLIBS=$(TESTAPPLIBS)

APP3DEF=    $(MISC)$/$(APP3TARGET).def
APP3DEPN=   $(L)$/itools.lib	\
			$(L)$/ivos.lib		\
			$(LB)$/nidebug.lib

# ------------------------------------------------------------------
# LDAPTEST
# ------------------------------------------------------------------
APP4TARGET= ldaptest
APP4OBJS=   $(OBJ)$/ldaptest.obj

APP4STDLIBS=$(TESTAPPLIBS)

APP4DEF=    $(MISC)$/$(APP4TARGET).def
APP4DEPN=   $(L)$/itools.lib	\
			$(L)$/ivos.lib		\
			$(LB)$/nidebug.lib

# ------------------------------------------------------------------
# SSLDEMO
# ------------------------------------------------------------------
.IF "$(SOLAR_SSL)" != ""

APP5TARGET= ssldemo
APP5OBJS=	$(OBJ)$/ssldemo.obj
#APP5RES=	$(RES)$/socktest.res

APP5STDLIBS=$(TESTAPPLIBS)

APP5DEF=    $(MISC)$/$(APP5TARGET).def
APP5DEPN=   $(L)$/itools.lib	\
			$(L)$/ivos.lib		\
			$(LB)$/nidebug.lib	\
			$(SRS)$/inetres.srs

.ENDIF # SOLAR_SSL

# --- Targets ------------------------------------------------------

.INCLUDE : target.mk

# ------------------------------------------------------------------
# Windows
# ------------------------------------------------------------------

.IF "$(GUI)" == "WIN"

$(MISC)$/$(APP1TARGET).def:
    echo  NAME          $(APP1TARGET)                       >$@
    echo  DESCRIPTION   'Testprogramm'                     >>$@
    echo  EXETYPE       WINDOWS                            >>$@
    echo  STUB          'winSTUB.EXE'                      >>$@
    echo  PROTMODE                                         >>$@
    echo  CODE          PRELOAD MOVEABLE DISCARDABLE       >>$@
    echo  DATA          PRELOAD MOVEABLE MULTIPLE          >>$@
    echo  HEAPSIZE      8192                               >>$@
    echo  STACKSIZE     32768                              >>$@

$(MISC)$/$(APP2TARGET).def:
    echo  NAME          $(APP2TARGET)                       >$@
    echo  DESCRIPTION   'Testprogramm'                     >>$@
    echo  EXETYPE       WINDOWS                            >>$@
    echo  STUB          'winSTUB.EXE'                      >>$@
    echo  PROTMODE                                         >>$@
    echo  CODE          PRELOAD MOVEABLE DISCARDABLE       >>$@
    echo  DATA          PRELOAD MOVEABLE MULTIPLE          >>$@
    echo  HEAPSIZE      8192                               >>$@
    echo  STACKSIZE     32768                              >>$@

$(MISC)$/$(APP3TARGET).def:
    echo  NAME          $(APP3TARGET)                       >$@
    echo  DESCRIPTION   'Testprogramm'                     >>$@
    echo  EXETYPE       WINDOWS                            >>$@
    echo  STUB          'winSTUB.EXE'                      >>$@
    echo  PROTMODE                                         >>$@
    echo  CODE          PRELOAD MOVEABLE DISCARDABLE       >>$@
    echo  DATA          PRELOAD MOVEABLE MULTIPLE          >>$@
    echo  HEAPSIZE      8192                               >>$@
    echo  STACKSIZE     32768                              >>$@

$(MISC)$/$(APP4TARGET).def:
    echo  NAME          $(APP4TARGET)                       >$@
    echo  DESCRIPTION   'Testprogramm'                     >>$@
    echo  EXETYPE       WINDOWS                            >>$@
    echo  STUB          'winSTUB.EXE'                      >>$@
    echo  PROTMODE                                         >>$@
    echo  CODE          PRELOAD MOVEABLE DISCARDABLE       >>$@
    echo  DATA          PRELOAD MOVEABLE MULTIPLE          >>$@
    echo  HEAPSIZE      8192                               >>$@
    echo  STACKSIZE     32768                              >>$@

.IF "$(SOLAR_SSL)" != ""

$(MISC)$/$(APP5TARGET).def:
    echo  NAME          $(APP5TARGET)                       >$@
    echo  DESCRIPTION   'Testprogramm'                     >>$@
    echo  EXETYPE       WINDOWS                            >>$@
    echo  STUB          'winSTUB.EXE'                      >>$@
    echo  PROTMODE                                         >>$@
    echo  CODE          PRELOAD MOVEABLE DISCARDABLE       >>$@
    echo  DATA          PRELOAD MOVEABLE MULTIPLE          >>$@
    echo  HEAPSIZE      8192                               >>$@
    echo  STACKSIZE     32768                              >>$@

.ENDIF # SOLAR_SSL
.ENDIF # WIN

# ------------------------------------------------------------------
# OS2
# ------------------------------------------------------------------

.IF "$(GUI)" == "OS2"

$(MISC)$/$(APP1TARGET).def:
    echo  NAME          $(APP1TARGET) WINDOWAPI             >$@
    echo  DESCRIPTION   'Testprogramm'                     >>$@
.IF "$(COM)"=="MTW"
    echo  PROTMODE                                         >>$@
    echo  CODE          LOADONCALL                         >>$@
    echo  DATA          PRELOAD MULTIPLE                   >>$@
    echo  HEAPSIZE      32768                              >>$@
    echo  STACKSIZE     32768                              >>$@
.ELSE
.IF "$(COM)" != "BLC"
    echo  STUB          'os2STUB.EXE'                      >>$@
.ENDIF
    echo  EXETYPE       OS2                                >>$@
    echo  PROTMODE                                         >>$@
    echo  CODE          LOADONCALL                         >>$@
    echo  DATA          PRELOAD MULTIPLE                   >>$@
    echo  HEAPSIZE      8192                               >>$@
    echo  STACKSIZE     32768                              >>$@
.ENDIF

$(MISC)$/$(APP2TARGET).def:
    echo  NAME          $(APP2TARGET) WINDOWAPI            >$@
    echo  DESCRIPTION   'Testprogramm'                     >>$@
.IF "$(COM)"=="MTW"
    echo  PROTMODE                                         >>$@
    echo  CODE          LOADONCALL                         >>$@
    echo  DATA          PRELOAD MULTIPLE                   >>$@
    echo  HEAPSIZE      32768                              >>$@
    echo  STACKSIZE     32768                              >>$@
.ELSE
.IF "$(COM)" != "BLC"
    echo  STUB          'os2STUB.EXE'                      >>$@
.ENDIF
    echo  EXETYPE       OS2                                >>$@
    echo  PROTMODE                                         >>$@
    echo  CODE          LOADONCALL                         >>$@
    echo  DATA          PRELOAD MULTIPLE                   >>$@
    echo  HEAPSIZE      8192                               >>$@
    echo  STACKSIZE     32768                              >>$@
.ENDIF

$(MISC)$/$(APP3TARGET).def:
    echo  NAME          $(APP3TARGET) WINDOWAPI             >$@
    echo  DESCRIPTION   'Testprogramm'                     >>$@
.IF "$(COM)"=="MTW"
    echo  PROTMODE                                         >>$@
    echo  CODE          LOADONCALL                         >>$@
    echo  DATA          PRELOAD MULTIPLE                   >>$@
    echo  HEAPSIZE      32768                              >>$@
    echo  STACKSIZE     32768                              >>$@
.ELSE
.IF "$(COM)" != "BLC"
    echo  STUB          'os2STUB.EXE'                      >>$@
.ENDIF
    echo  EXETYPE       OS2                                >>$@
    echo  PROTMODE                                         >>$@
    echo  CODE          LOADONCALL                         >>$@
    echo  DATA          PRELOAD MULTIPLE                   >>$@
    echo  HEAPSIZE      8192                               >>$@
    echo  STACKSIZE     32768                              >>$@
.ENDIF

$(MISC)$/$(APP4TARGET).def:
    echo  NAME          $(APP4TARGET) WINDOWAPI             >$@
    echo  DESCRIPTION   'Testprogramm'                     >>$@
.IF "$(COM)"=="MTW"
    echo  PROTMODE                                         >>$@
    echo  CODE          LOADONCALL                         >>$@
    echo  DATA          PRELOAD MULTIPLE                   >>$@
    echo  HEAPSIZE      32768                              >>$@
    echo  STACKSIZE     32768                              >>$@
.ELSE
.IF "$(COM)" != "BLC"
    echo  STUB          'os2STUB.EXE'                      >>$@
.ENDIF
    echo  EXETYPE       OS2                                >>$@
    echo  PROTMODE                                         >>$@
    echo  CODE          LOADONCALL                         >>$@
    echo  DATA          PRELOAD MULTIPLE                   >>$@
    echo  HEAPSIZE      8192                               >>$@
    echo  STACKSIZE     32768                              >>$@
.ENDIF

.IF "$(SOLAR_SSL)" != ""

$(MISC)$/$(APP5TARGET).def:
    echo  NAME          $(APP5TARGET) WINDOWAPI             >$@
    echo  DESCRIPTION   'Testprogramm'                     >>$@
.IF "$(COM)"=="MTW"
    echo  PROTMODE                                         >>$@
    echo  CODE          LOADONCALL                         >>$@
    echo  DATA          PRELOAD MULTIPLE                   >>$@
    echo  HEAPSIZE      32768                              >>$@
    echo  STACKSIZE     32768                              >>$@
.ELSE
.IF "$(COM)" != "BLC"
    echo  STUB          'os2STUB.EXE'                      >>$@
.ENDIF
    echo  EXETYPE       OS2                                >>$@
    echo  PROTMODE                                         >>$@
    echo  CODE          LOADONCALL                         >>$@
    echo  DATA          PRELOAD MULTIPLE                   >>$@
    echo  HEAPSIZE      8192                               >>$@
    echo  STACKSIZE     32768                              >>$@
.ENDIF

.ENDIF # SOLAR_SSL
.ENDIF # OS2
