/*************************************************************************
 *
 *  $RCSfile: ssldemo.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: mhu $ $Date: 2001/08/22 10:02:14 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif

#ifndef _GEN_HXX
#include <tools/gen.hxx>
#endif

#ifndef _LINK_HXX
#include <tools/link.hxx>
#endif

#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

#ifndef _SV_HELP_HXX
#include <vcl/help.hxx>
#endif

#ifndef _SV_TOOLBOX_HXX
#include <vcl/toolbox.hxx>
#endif

#ifndef _SV_WRKWIN_HXX
#include <vcl/wrkwin.hxx>
#endif

#ifndef _SVEDIT_HXX
#include <svtools/svmedit.hxx>
#endif

#ifndef _INET_CONFIG_HXX
#include "inetcfg.hxx"
#endif

#ifndef _INETDNS_HXX
#include "inetdns.hxx"
#endif

#ifndef _INETSSL_HXX
#include "inetssl.hxx"
#endif

/*
 * MyWin.
 */
class MyWin : public WorkWindow
{
	ToolBox       *pTool;
	MultiLineEdit *pOutEdit;

	INetCoreDNSResolver           *pNameResolver;
	INetCoreActiveTCPSecureSocket *pSocket;

	static int ResolverCallback (
		int status, INetCoreDNSHostEntry *pHostEntry, void *pData);

	static int SocketCallback (
		INetCoreActiveTCPSecureSocket *pSocket,
		int nEvent, BOOL bError, void *pData);

public:
	MyWin (Window *pParent, WinBits nWinStyle);
	~MyWin (void);

	void Resize (void);
	DECL_LINK   (ToolBarHnd, ToolBox*);
};

MyWin::MyWin (Window *pParent, WinBits nWinStyle)
	: WorkWindow (pParent, nWinStyle)
{
	// ToolBar.
	pTool = new ToolBox (this, WB_SVLOOK | WB_BORDER);

	pTool->InsertItem  (1, "Clear");
	pTool->SetHelpText (1, "Clears the Output Window");
	pTool->InsertSeparator ();

	pTool->InsertItem  (2, "Test");
	pTool->SetHelpText (2, "Performs programmed Test");

	pTool->SetClickHdl (LINK (this, MyWin, ToolBarHnd));
	pTool->Show ();

	// MultiLineEdit.
	pOutEdit = new MultiLineEdit (this, WB_HSCROLL | WB_VSCROLL | WB_BORDER);
	pOutEdit->SetReadOnly (TRUE);
	pOutEdit->Show ();

	// Config.
	INetConfigRef xConfig (GetINetConfig());
	if (xConfig.Is())
	{
		xConfig->setDomainNameServer ("192.109.83.75");
		// xConfig->setSecureSocketCertificatePath (".");
	}

	// NameResolver (jaguar.stardiv.de).
	pNameResolver = new INetCoreDNSResolver();

	// SOCKS gateway.
	// INetCoreTCPSocket::SetSOCKSGateway ("192.109.83.191", 1080); // mhu
	// INetCoreTCPSocket::SetSOCKSGateway ("192.109.83.118", 1080); // ftpproxy

	// Socket.
	pSocket = NULL;
}

MyWin::~MyWin (void)
{
	delete pSocket;
	delete pNameResolver;
	delete pOutEdit;
	delete pTool;
}

void MyWin::Resize (void)
{
	Size aWinSize = GetOutputSizePixel ();
	int nWinW = aWinSize.Width ();
	int nWinH = aWinSize.Height ();

	int nBoxH = pTool->CalcWindowSizePixel().Height();

	pTool->SetPosSizePixel (
		Point (0, 0),
		Size  (nWinW, nBoxH));

	pOutEdit->SetPosSizePixel (
		Point (0, nBoxH),
		Size  (nWinW, nWinH - nBoxH));
}

IMPL_LINK (MyWin, ToolBarHnd, ToolBox*, pTool)
{
	USHORT nItemId = pTool->GetCurItemId ();
	String aStr = pOutEdit->GetText ();

	switch (nItemId)
	{
		case 1: // Clear.
			aStr.Erase ();
			break;

		case 2: // Test.
		    {
				// "mhu.stardiv.de", 443);
				// "www.verwaltung.uni-mainz.de", 443);
				INetCoreDNSHostEntry *he = new INetCoreDNSHostEntry (
					"jane.prakinf.tu-ilmenau.de", 443);
				if (!pNameResolver->GetHostByName (
					he, ResolverCallback, this))
				{
					aStr += "\nGetHostByName Failure.";
					delete he;
				}
			}
			break;

		default: // Ignored.
			break;
	}

	pOutEdit->SetText (aStr.ConvertLineEnd ());
	pOutEdit->Show ();

	return 0;
}

int MyWin::ResolverCallback (
	int status, INetCoreDNSHostEntry *pHostEntry, void *pData)
{
	if (status == INETCOREDNS_RESOLVER_START) return 1;

	MyWin *pWin = (MyWin *)pData;
	String aStr = pWin->pOutEdit->GetText ();

	aStr += "\nResolverCallback: Status: ";
	aStr += status;

	aStr += "\nDomainName: ";
	if (pHostEntry->GetCanonicalName())
	{
		aStr += pHostEntry->GetCanonicalName ();
		aStr += " Alias: ";
	}
	aStr += pHostEntry->GetDomainName ();
	aStr += " [";
	aStr += pHostEntry->GetDottedDecimalName ();
	aStr += ']';

	if ((status == INETCOREDNS_RESOLVER_SUCCESS) ||
		(status == INETCOREDNS_RESOLVER_EXPIRED)    )
	{
		// "https"
		pWin->pSocket = new INetCoreActiveTCPSecureSocket;

#if 0
		INetCoreActiveTCPSocket *pBase = pWin->pSocket;

		if (!pBase->Connect (
			pHostEntry->GetDottedDecimalName (), 443,
			(INetCoreIPSocketCallback *)SocketCallback, pWin))
#else
		if (!pWin->pSocket->Connect (
			pHostEntry->GetDottedDecimalName (), 443,
			(INetCoreSSLConnectCallback *)SocketCallback, pWin))
#endif
		{
			aStr += "\nConnect Failure.";
			delete (pWin->pSocket);
			pWin->pSocket = NULL;
		}
	}
	delete pHostEntry;

	pWin->pOutEdit->SetText (aStr.ConvertLineEnd ());
	pWin->pOutEdit->Show ();

	return 1;
}

int MyWin::SocketCallback (
	INetCoreActiveTCPSecureSocket *pSocket,
	int nEvent, BOOL bError, void *pData)
{
	MyWin *pWin = (MyWin *)pData;
	String aStr = pWin->pOutEdit->GetText ();

	aStr += "\nSocketCallback: Event: ";
	aStr += nEvent;
	aStr += " Error: ";
	aStr += (int)bError;

	if (nEvent == INETCORESOCK_EVENT_CONNECT)
	{
		aStr += "\nSocket: Connected: ";
		aStr += (int)(pSocket->IsConnected ());

		if (pSocket->IsConnected ())
		{
			aStr += " [";
			aStr += pSocket->GetPeerName ();
			aStr += ':';
			aStr += pSocket->GetPeerPort ();
			aStr += ']';

			int nEventMask =
				(INETCORESOCK_EVENT_READ | INETCORESOCK_EVENT_WRITE |
				 INETCORESOCK_EVENT_CLOSE);
			if (pWin->pSocket->EnableCallback (
				nEventMask, (INetCoreIPSocketCallback *)SocketCallback, pWin))
			{
				String aReqStr = "GET / HTTP/1.0\r\n";
				aReqStr += "From: mhu@stardivision.de\r\n";
				aReqStr += "User-Agent: SockDemoClient/1.2\r\n";
				aReqStr += "\r\n";

				int nWrite = pSocket->Write (aReqStr, aReqStr.Len ());
				aStr += "\nSocket: Write: ";
				aStr += nWrite;

				nEvent = INETCORESOCK_EVENT_READ;
			}
		}
		else if (!bError)
		{
			pSocket->Connect (
				pSocket->GetPeerName (), pSocket->GetPeerPort (),
				(INetCoreSSLConnectCallback *)SocketCallback, pWin);
		}
		else
		{
			pSocket->Shutdown ();
		}
	}
	if (nEvent == INETCORESOCK_EVENT_READ)
	{
		char buffer[1024];
		int nRead;

		while ((nRead = pSocket->Read (buffer, sizeof (buffer) - 1)) > 0)
		{
			buffer[nRead] = '\0';

			aStr += "\nSocket: Read: ";
			aStr += nRead;
			aStr += '\n';
			aStr += buffer;
		}

		/* @@@ SESSION-ID hit test on SSLeay "s_server" */
		/* pSocket->Shutdown (); */
		/* @@@ */
	}

	pWin->pOutEdit->SetText (aStr.ConvertLineEnd ());
	pWin->pOutEdit->Show ();

	if (nEvent & INETCORESOCK_EVENT_CLOSE) pWin->pSocket = NULL;
	return 1;
}

/*
 * MyApp.
 */
class MyApp : public Application
{
public:
	void Main (void)
	{
		Help::EnableBalloonHelp ();

		MyWin aMyWin (NULL, WB_APP | WB_STDWORK);
		aMyWin.SetText ("SockDemoClient/1.2");
		aMyWin.Show();

		Execute();
	}
};

MyApp aMyApp;

