/*************************************************************************
 *
 *  $RCSfile: BASE64Encoder.java,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:31:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.star.tool.starjar;

import java.io.OutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.IOException;

public class BASE64Encoder extends CharacterEncoder {
	
    protected int bytesPerAtom() {
	    return (3);
    }

    protected int bytesPerLine() {
	    return (57);
    }

    private final static char pem_array[] = {
	//       0   1   2   3   4   5   6   7
		'A','B','C','D','E','F','G','H', // 0
		'I','J','K','L','M','N','O','P', // 1
		'Q','R','S','T','U','V','W','X', // 2
		'Y','Z','a','b','c','d','e','f', // 3
		'g','h','i','j','k','l','m','n', // 4
		'o','p','q','r','s','t','u','v', // 5
		'w','x','y','z','0','1','2','3', // 6
		'4','5','6','7','8','9','+','/'  // 7
	};

    protected void encodeAtom(OutputStream outStream, 
                              byte data[], int offset, int len)
                              throws IOException 
	{
    	byte a, b, c;
    
    	if (len == 1) {
    	    a = data[offset];
    	    b = 0;
    	    c = 0;
    	    outStream.write(pem_array[(a >>> 2) & 0x3F]);
    	    outStream.write(pem_array[((a << 4) & 0x30) + ((b >>> 4) & 0xf)]);
    	    outStream.write('=');
    	    outStream.write('=');
    	} else if (len == 2) {
    	    a = data[offset];
    	    b = data[offset+1];
    	    c = 0;
    	    outStream.write(pem_array[(a >>> 2) & 0x3F]);
    	    outStream.write(pem_array[((a << 4) & 0x30) + ((b >>> 4) & 0xf)]);
    	    outStream.write(pem_array[((b << 2) & 0x3c) + ((c >>> 6) & 0x3)]);
    	    outStream.write('=');
    	} else {
    	    a = data[offset];
    	    b = data[offset+1];
    	    c = data[offset+2];
    	    outStream.write(pem_array[(a >>> 2) & 0x3F]);
    	    outStream.write(pem_array[((a << 4) & 0x30) + ((b >>> 4) & 0xf)]);
    	    outStream.write(pem_array[((b << 2) & 0x3c) + ((c >>> 6) & 0x3)]);
    	    outStream.write(pem_array[c & 0x3F]);
    	}
    }
}

