/*************************************************************************
 *
 *  $RCSfile: Perl5Compiler.java,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:31:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.star.tool.starjar.regex;


// Referenced classes of package com.sun.star.tool.starjar.regex:
//            MalformedPatternException, Perl5Pattern, _cls1, PatternCompiler, 
//            _cls2, Pattern

public final class Perl5Compiler implements PatternCompiler {

    private static final int _fld015E = 0;
    private static final int _fld015D = 1;
    private static final int _fld015C = 2;
    private static final int _fld015B = 4;
    private static final int _fld015A = 8;
    private static final char _fld0159 = 1;
    private static final char _fld0158 = 2;
    private static final char _fld0157 = 4;
    private static final char _fld0156 = 8;
    private static final char _fld0155 = 16;
    private static final char _fld0154 = 32;
    private static final char _fld0153 = 32768;
    private static final String _fld0152 = "^$.[()|?+*\\";
    private static final String _fld0151 = "0123456789abcdef0123456789ABCDEFx";
    private _cls1 _fld0150;
    private boolean _fld014F;
    private char _fld014E[];
    private int _fld014D;
    private int _fld014C;
    private int _fld014B;
    private char _fld014A[];
    public static final int DEFAULT_MASK = 0;
    public static final int CASE_INSENSITIVE_MASK = 1;
    public static final int MULTILINE_MASK = 8;
    public static final int SINGLELINE_MASK = 16;
    public static final int EXTENDED_MASK = 32;
    public static final int READ_ONLY_MASK = 32768;


    public static final String quotemeta(char ac[]) {
        StringBuffer stringbuffer = new StringBuffer(2 * ac.length);
        for (int i = 0; i < ac.length; i++) {
            if (!_cls2._mth0138(ac[i]))
                stringbuffer.append('\\');
            stringbuffer.append(ac[i]);
        }

        return stringbuffer.toString();
    }

    public static final String quotemeta(String s) {
        return quotemeta(s.toCharArray());
    }

    static boolean _mth0171(char c) {
        return c == '*' || c == '+' || c == '?';
    }

    static boolean _mth0170(char ac[], int i) {
        if (i < ac.length && i >= 0)
            return ac[i] == '*' || ac[i] == '+' || ac[i] == '?' || ac[i] == '{' && _mth016F(ac, i);
        else
            return false;
    }

    static boolean _mth016F(char ac[], int i) {
        if (ac[i] != '{')
            return false;
        if (++i >= ac.length || !Character.isDigit(ac[i]))
            return false;
        for (; i < ac.length && Character.isDigit(ac[i]); i++);
        
        if (i < ac.length && ac[i] == ',')
            i++;
        for (; i < ac.length && Character.isDigit(ac[i]); i++);
        
        return i < ac.length && ac[i] == '}';
    }

    static int _mth016E(char ac[], int i, int j, int ai[]) {
        int k = 0;
        int l;
        
        for (ai[0] = 0; i < ac.length && 
             j-- > 0 && 
             (l = "0123456789abcdef0123456789ABCDEFx".indexOf(ac[i])) != -1; ai[0]++) 
        {
            k <<= 4;
            k |= l & 0xf;
            i++;
        }

        return k;
    }

    static int _mth016D(char ac[], int i, int j, int ai[]) {
        int k = 0;
        
        for (ai[0] = 0; i < ac.length && 
             j > 0 && ac[i] >= '0' && 
             ac[i] <= '7'; ai[0]++) {
            k <<= 3;
            k |= ac[i] - 48;
            j--;
            i++;
        }

        return k;
    }

    static void _mth016C(char ac[], char c) {
        switch(c) {
            case 105: /* 'i' */
                ac[0] |= '\001';
                return;
    
            case 103: /* 'g' */
                ac[0] |= '\002';
                return;
    
            case 111: /* 'o' */
                ac[0] |= '\004';
                return;
    
            case 109: /* 'm' */
                ac[0] |= '\b';
                return;
    
            case 115: /* 's' */
                ac[0] |= '\020';
                return;
    
            case 120: /* 'x' */
                ac[0] |= ' ';
                return;
        }
    }

    void _mth016B(char c) {
        
        if (_fld014A != null)
            _fld014A[_fld014C] = c;
        _fld014C++;
    }

    int _mth016A(char c) {
        int i = _fld014C;
        
        if (_fld014A == null) {
            _fld014C += 2;
        } else {
            _fld014A[_fld014C++] = c;
            _fld014A[_fld014C++] = 0;
        }
        return i;
    }

    int _mth0169(char c, char c1) {
        int i = _fld014C;
        
        if (_fld014A == null) {
            _fld014C += 3;
        } else {
            _fld014A[_fld014C++] = c;
            _fld014A[_fld014C++] = 0;
            _fld014A[_fld014C++] = c1;
        }
        return i;
    }

    void _mth0168(char c, int i) {
        int l = _cls2._fld0113[c] != '\n' ? 0 : 2;
        
        if (_fld014A == null) {
            _fld014C += 2 + l;
            return;
        }
        int j = _fld014C;
        _fld014C += 2 + l;
        int k = _fld014C;
        
        while (j > i) {
            j--;
            k--;
            _fld014A[k] = _fld014A[j];
        }

        _fld014A[i++] = c;
        
        for (_fld014A[i++] = 0; l-- > 0; _fld014A[i++] = 0);
    }

    void _mth0167(int i, int j) {
        if (_fld014A == null || i == -1)
            return;
        int k = i;
        do {
            int l = _cls2._mth0139(_fld014A, k);
            if (l == -1)
                break;
            k = l;
        } while (true);
        
        int i1;
        if (_fld014A[k] == '\r')
            i1 = k - j;
        else
            i1 = j - k;
        _fld014A[k + 1] = (char)i1;
    }

    void _mth0166(int i, int j) {
        if (_fld014A == null || i == -1 || _cls2._fld0113[_fld014A[i]] != '\f') {
            return;
        } else {
            _mth0167(_cls2._mth013B(i), j);
            return;
        }
    }

    char _mth0165() {
        char c = _fld0150._mth0106();
        
        do {
            char c1 = _fld0150._mth010E();
            if (c1 == '(' && _fld0150._mth010D(1) == '?' && _fld0150._mth010D(2) == '#') {
                for (; c1 != '\uFFFF' && c1 != ')'; c1 = _fld0150._mth0108());
                _fld0150._mth0108();
                continue;
            }
            if ((_fld014E[0] & 0x20) == 0)
                break;
                
            if (Character.isWhitespace(c1)) {
                _fld0150._mth0108();
                continue;
            }
            
            if (c1 != '#')
                break;
            
            for (; c1 != '\uFFFF' && c1 != '\n'; c1 = _fld0150._mth0108());
            _fld0150._mth0108();
        } while (true);
        
        return c;
    }

    int _mth0164(int ai[]) throws MalformedPatternException {
        int l = 0;
        ai[0] = 0;
        int j = _mth016A('\f');
        int i = -1;
        
        if (_fld0150._mth010B() == 0)
        {
            _fld0150._mth010A(-1);
            _mth0165();
        }
        else
        {
            _fld0150._mth0107();
            _mth0165();
        }
        for (char c = _fld0150._mth010E(); c != '\uFFFF' && c != '|' && c != ')';)
        {
            l &= 0xfffffff7;
            int k = _mth0160(ai);
            if (k == -1)
            {
                if ((l & 0x8) != 0)
                    c = _fld0150._mth010E();
                else
                    return -1;
            }
            else
            {
                ai[0] |= l & 0x1;
                if (i == -1)
                {
                    ai[0] |= l & 0x4;
                }
                else
                {
                    _fld014B++;
                    _mth0167(i, k);
                }
                i = k;
                c = _fld0150._mth010E();
            }
        }

        if (i == -1)
            _mth016A('\017');
        return j;
    }

    int _mth0163(int ai[])
        throws MalformedPatternException
    {
        int ai1[] = new int[1];
        ai[0] = 0;
        boolean flag = false;
        int i = -1;
label0:
        do
        {
            char c = _fld0150._mth010E();
            switch(c)
            {
            default:
                break;

            case 94: /* '^' */
                _mth0165();
                if ((_fld014E[0] & 0x8) != 0)
                    i = _mth016A('\002');
                else
                if ((_fld014E[0] & 0x10) != 0)
                    i = _mth016A('\003');
                else
                    i = _mth016A('\001');
                break label0;

            case 36: /* '$' */
                _mth0165();
                if ((_fld014E[0] & 0x8) != 0)
                    i = _mth016A('\005');
                else
                if ((_fld014E[0] & 0x10) != 0)
                    i = _mth016A('\006');
                else
                    i = _mth016A('\004');
                break label0;

            case 46: /* '.' */
                _mth0165();
                if ((_fld014E[0] & 0x10) != 0)
                    i = _mth016A('\b');
                else
                    i = _mth016A('\007');
                _fld014B++;
                ai[0] |= 0x3;
                break label0;

            case 91: /* '[' */
                _fld0150._mth0108();
                i = _mth0161();
                ai[0] |= 0x3;
                break label0;

            case 40: /* '(' */
                _mth0165();
                i = _mth015F(true, ai1);
                if (i == -1)
                {
                    if ((ai1[0] & 0x8) == 0)
                        return -1;
                    continue;
                }
                ai[0] |= ai1[0] & 0x5;
                break label0;

            case 41: /* ')' */
            case 124: /* '|' */
                if ((ai1[0] & 0x8) != 0)
                {
                    ai[0] |= 0x8;
                    return -1;
                }
                else
                {
                    throw new MalformedPatternException("Error in expression at " + _fld0150._mth0104(_fld0150._mth010B()));
                }

            case 42: /* '*' */
            case 43: /* '+' */
            case 63: /* '?' */
                throw new MalformedPatternException("?+* follows nothing in expression");

            case 92: /* '\\' */
                char c1 = _fld0150._mth0108();
                switch(c1)
                {
                case 65: /* 'A' */
                    i = _mth016A('\003');
                    ai[0] |= 0x2;
                    _mth0165();
                    break;

                case 71: /* 'G' */
                    i = _mth016A('\036');
                    ai[0] |= 0x2;
                    _mth0165();
                    break;

                case 90: /* 'Z' */
                    i = _mth016A('\006');
                    ai[0] |= 0x2;
                    _mth0165();
                    break;

                case 119: /* 'w' */
                    i = _mth016A('\022');
                    ai[0] |= 0x3;
                    _mth0165();
                    break;

                case 87: /* 'W' */
                    i = _mth016A('\023');
                    ai[0] |= 0x3;
                    _mth0165();
                    break;

                case 98: /* 'b' */
                    i = _mth016A('\024');
                    ai[0] |= 0x2;
                    _mth0165();
                    break;

                case 66: /* 'B' */
                    i = _mth016A('\025');
                    ai[0] |= 0x2;
                    _mth0165();
                    break;

                case 115: /* 's' */
                    i = _mth016A('\026');
                    ai[0] |= 0x3;
                    _mth0165();
                    break;

                case 83: /* 'S' */
                    i = _mth016A('\027');
                    ai[0] |= 0x3;
                    _mth0165();
                    break;

                case 100: /* 'd' */
                    i = _mth016A('\030');
                    ai[0] |= 0x3;
                    _mth0165();
                    break;

                case 68: /* 'D' */
                    i = _mth016A('\031');
                    ai[0] |= 0x3;
                    _mth0165();
                    break;

                case 48: /* '0' */
                case 97: /* 'a' */
                case 99: /* 'c' */
                case 101: /* 'e' */
                case 102: /* 'f' */
                case 110: /* 'n' */
                case 114: /* 'r' */
                case 116: /* 't' */
                case 120: /* 'x' */
                    flag = true;
                    break;

                case 49: /* '1' */
                case 50: /* '2' */
                case 51: /* '3' */
                case 52: /* '4' */
                case 53: /* '5' */
                case 54: /* '6' */
                case 55: /* '7' */
                case 56: /* '8' */
                case 57: /* '9' */
                    StringBuffer stringbuffer = new StringBuffer(10);
                    int j = 0;
                    for (char c2 = _fld0150._mth010D(j); Character.isDigit(c2); c2 = _fld0150._mth010D(j))
                    {
                        stringbuffer.append(c2);
                        j++;
                    }

                    try
                    {
                        j = Integer.parseInt(stringbuffer.toString());
                    }
                    catch(NumberFormatException numberformatexception)
                    {
                        throw new MalformedPatternException("Unexpected number format exception.  Please report this bug.NumberFormatException message: " + numberformatexception.getMessage());
                    }
                    if (j > 9 && j >= _fld014D)
                    {
                        flag = true;
                    }
                    else
                    {
                        if (j >= _fld014D)
                            throw new MalformedPatternException("Invalid backreference: \\" + j);
                        _fld014F = true;
                        i = _mth0169('\032', (char)j);
                        ai[0] |= 0x1;
                        for (char c3 = _fld0150._mth010E(); Character.isDigit(c3); c3 = _fld0150._mth0108());
                        _fld0150._mth0107();
                        _mth0165();
                    }
                    break;

                case 0: /* '\0' */
                case 65535: 
                    if (_fld0150._mth0109())
                        throw new MalformedPatternException("Trailing \\ in expression.");
                    // fall through

                default:
                    flag = true;
                    break;

                }
                break label0;

            case 35: /* '#' */
                if ((_fld014E[0] & 0x20) == 0)
                    break;
                for (; !_fld0150._mth0109() && _fld0150._mth010E() != '\n'; _fld0150._mth0108());
                if (!_fld0150._mth0109())
                    continue;
                break;

            }
            _fld0150._mth0108();
            flag = true;
            break;
        }
        while (true);
        if (flag)
        {
            i = _mth016A('\016');
            if (_fld014A != null)
                _fld014A[_fld014C] = '\uFFFF';
            _fld014C++;
            int k = 0;
            int l = _fld0150._mth010B() - 1;
label1:
            for (int i1 = _fld0150._mth010C(); k < 127 && l < i1; k++)
            {
                int j1 = l;
                char c4 = _fld0150._mth010E(l);
                char c8;
                switch(c4)
                {
                case 36: /* '$' */
                case 40: /* '(' */
                case 41: /* ')' */
                case 46: /* '.' */
                case 91: /* '[' */
                case 94: /* '^' */
                case 124: /* '|' */
                    break label1;

                case 92: /* '\\' */
                    char c5 = _fld0150._mth010E(++l);
                    switch(c5)
                    {
                    case 65: /* 'A' */
                    case 66: /* 'B' */
                    case 68: /* 'D' */
                    case 71: /* 'G' */
                    case 83: /* 'S' */
                    case 87: /* 'W' */
                    case 90: /* 'Z' */
                    case 98: /* 'b' */
                    case 100: /* 'd' */
                    case 115: /* 's' */
                    case 119: /* 'w' */
                        l--;
                        break label1;

                    case 110: /* 'n' */
                        c8 = '\n';
                        l++;
                        break;

                    case 114: /* 'r' */
                        c8 = '\r';
                        l++;
                        break;

                    case 116: /* 't' */
                        c8 = '\t';
                        l++;
                        break;

                    case 102: /* 'f' */
                        c8 = '\f';
                        l++;
                        break;

                    case 101: /* 'e' */
                        c8 = '\033';
                        l++;
                        break;

                    case 97: /* 'a' */
                        c8 = '\007';
                        l++;
                        break;

                    case 120: /* 'x' */
                        int ai2[] = new int[1];
                        c8 = (char)_mth016E(_fld0150._fld0101, ++l, 2, ai2);
                        l += ai2[0];
                        break;

                    case 99: /* 'c' */
                        l++;
                        c8 = _fld0150._mth010E(l++);
                        if (Character.isLowerCase(c8))
                            c8 = Character.toUpperCase(c8);
                        c8 ^= '@';
                        break;

                    case 48: /* '0' */
                    case 49: /* '1' */
                    case 50: /* '2' */
                    case 51: /* '3' */
                    case 52: /* '4' */
                    case 53: /* '5' */
                    case 54: /* '6' */
                    case 55: /* '7' */
                    case 56: /* '8' */
                    case 57: /* '9' */
                        boolean flag1 = false;
                        char c6 = _fld0150._mth010E(l);
                        if (c6 == '0')
                            flag1 = true;
                        c6 = _fld0150._mth010E(l + 1);
                        if (Character.isDigit(c6))
                        {
                            StringBuffer stringbuffer1 = new StringBuffer(10);
                            int k1 = l;
                            for (char c7 = _fld0150._mth010E(k1); Character.isDigit(c7); c7 = _fld0150._mth010E(k1))
                            {
                                stringbuffer1.append(c7);
                                k1++;
                            }

                            try
                            {
                                k1 = Integer.parseInt(stringbuffer1.toString());
                            }
                            catch(NumberFormatException numberformatexception1)
                            {
                                throw new MalformedPatternException("Unexpected number format exception.  Please report this bug.NumberFormatException message: " + numberformatexception1.getMessage());
                            }
                            if (!flag1)
                                flag1 = k1 >= _fld014D;
                        }
                        if (flag1)
                        {
                            int ai3[] = new int[1];
                            c8 = (char)_mth016D(_fld0150._fld0101, l, 3, ai3);
                            l += ai3[0];
                        }
                        else
                        {
                            l--;
                            break label1;
                        }
                        break;

                    case 0: /* '\0' */
                    case 65535: 
                        if (l >= i1)
                            throw new MalformedPatternException("Trailing \\ in expression.");
                        // fall through

                    default:
                        c8 = _fld0150._mth010E(l++);
                        break;

                    }
                    break;

                case 35: /* '#' */
                    if ((_fld014E[0] & 0x20) != 0)
                        for (; l < i1 && _fld0150._mth010E(l) != '\n'; l++);
                    // fall through

                case 9: /* '\t' */
                case 10: /* '\n' */
                case 11: /* '\013' */
                case 12: /* '\f' */
                case 13: /* '\r' */
                case 32: /* ' ' */
                    if ((_fld014E[0] & 0x20) != 0) {
                        l++;
                        k--;
                        continue;
                    }
                    // fall through

                default:
                    c8 = _fld0150._mth010E(l++);
                    break;

                }
                if ((_fld014E[0] & '\001') != 0 && Character.isUpperCase(c8))
                    c8 = Character.toLowerCase(c8);
                if (l < i1 && _mth0170(_fld0150._fld0101, l))
                {
                    if (k > 0)
                    {
                        l = j1;
                    }
                    else
                    {
                        k++;
                        if (_fld014A != null)
                            _fld014A[_fld014C] = c8;
                        _fld014C++;
                    }
                    break;
                }
                if (_fld014A != null)
                    _fld014A[_fld014C] = c8;
                _fld014C++;
            }

            _fld0150._mth010A(l - 1);
            _mth0165();
            if (k < 0)
                throw new MalformedPatternException("Unexpected compilation failure.  Please report this bug!");
            if (k > 0)
                ai[0] |= 0x1;
            if (k == 1)
                ai[0] |= 0x2;
            if (_fld014A != null)
                _fld014A[_cls2._mth013D(i)] = (char)k;
            if (_fld014A != null)
                _fld014A[_fld014C] = '\uFFFF';
            _fld014C++;
        }
        return i;
    }

    void _mth0162(char ac[], int i, char c, char c1)
    {
        if (_fld014A == null || c1 >= '\u0100')
            return;
        c1 &= '\uFFFF';
        if (c == 0)
        {
            ac[i + (c1 >> 4)] |= 1 << (c1 & 0xf);
            return;
        }
        else
        {
            ac[i + (c1 >> 4)] &= ~(1 << (c1 & 0xf));
            return;
        }
    }

    int _mth0161()
        throws MalformedPatternException
    {
        boolean flag = false;
        char c2 = '\uFFFF';
        int ai[] = new int[1];
        int j = _mth016A('\t');
        char i;
        if (_fld0150._mth010E() == '^') {
            _fld014B++;
            _fld0150._mth0108();
            i = 0;
        } else {
            i = 0xFFFF;
        }
        int k = _fld014C;
        
        for (char c = 0; c < 16; c++) {
            if (_fld014A != null)
                _fld014A[_fld014C] = i;
            _fld014C++;
        }

        char c1 = _fld0150._mth010E();
        boolean flag1;
        if (c1 == ']' || c1 == '-')
            flag1 = true;
        else
            flag1 = false;
        while (!_fld0150._mth0109() && (c1 = _fld0150._mth010E()) != ']' || flag1) {
            flag1 = false;
            _fld0150._mth0108();
            
            if (c1 == '\\') {
                c1 = _fld0150._mth0106();
                switch(c1) {
                default:
                    break;

                case 119: /* 'w' */
                    for (c1 = 0; c1 < '\u0100'; c1++)
                        if (_cls2._mth0138(c1))
                            _mth0162(_fld014A, k, i, c1);

                    c2 = '\uFFFF';
                    continue;

                case 87: /* 'W' */
                    for (c1 = 0; c1 < '\u0100'; c1++)
                        if (!_cls2._mth0138(c1))
                            _mth0162(_fld014A, k, i, c1);

                    c2 = '\uFFFF';
                    continue;

                case 115: /* 's' */
                    for (c1 = 0; c1 < '\u0100'; c1++)
                        if (Character.isWhitespace(c1))
                            _mth0162(_fld014A, k, i, c1);

                    c2 = '\uFFFF';
                    continue;

                case 83: /* 'S' */
                    for (c1 = 0; c1 < '\u0100'; c1++)
                        if (!Character.isWhitespace(c1))
                            _mth0162(_fld014A, k, i, c1);

                    c2 = '\uFFFF';
                    continue;

                case 100: /* 'd' */
                    for (c1 = '0'; c1 <= '9'; c1++)
                        _mth0162(_fld014A, k, i, c1);

                    c2 = '\uFFFF';
                    continue;

                case 68: /* 'D' */
                    for (c1 = 0; c1 < '0'; c1++)
                        _mth0162(_fld014A, k, i, c1);

                    for (c1 = ':'; c1 < '\u0100'; c1++)
                        _mth0162(_fld014A, k, i, c1);

                    c2 = '\uFFFF';
                    continue;

                case 110: /* 'n' */
                    c1 = '\n';
                    break;

                case 114: /* 'r' */
                    c1 = '\r';
                    break;

                case 116: /* 't' */
                    c1 = '\t';
                    break;

                case 98: /* 'b' */
                    c1 = '\b';
                    break;

                case 101: /* 'e' */
                    c1 = '\033';
                    break;

                case 97: /* 'a' */
                    c1 = '\007';
                    break;

                case 120: /* 'x' */
                    c1 = (char)_mth016E(_fld0150._fld0101, _fld0150._mth010B(), 2, ai);
                    _fld0150._mth0108(ai[0]);
                    break;

                case 99: /* 'c' */
                    c1 = _fld0150._mth0106();
                    if (Character.isLowerCase(c1))
                        c1 = Character.toUpperCase(c1);
                    c1 ^= '@';
                    break;

                case 48: /* '0' */
                case 49: /* '1' */
                case 50: /* '2' */
                case 51: /* '3' */
                case 52: /* '4' */
                case 53: /* '5' */
                case 54: /* '6' */
                case 55: /* '7' */
                case 56: /* '8' */
                case 57: /* '9' */
                    c1 = (char)_mth016D(_fld0150._fld0101, _fld0150._mth010B() - 1, 3, ai);
                    _fld0150._mth0108(ai[0] - 1);
                    break;

                }
            }
            if (flag)
            {
                if (c2 > c1)
                    throw new MalformedPatternException("Invalid [] range in expression.");
                flag = false;
            }
            else
            {
                c2 = c1;
                if (_fld0150._mth010E() == '-' && _fld0150._mth010B() + 1 < _fld0150._mth010C() && _fld0150._mth010D(1) != ']')
                {
                    _fld0150._mth0108();
                    flag = true;
                    continue;
                }
            }
            for (; c2 <= c1; c2++)
            {
                _mth0162(_fld014A, k, i, c2);
                if ((_fld014E[0] & '\001') != 0 && Character.isUpperCase(c2))
                    _mth0162(_fld014A, k, i, Character.toLowerCase(c2));
            }

            c2 = c1;
        }

        if (_fld0150._mth010E() != ']')
        {
            throw new MalformedPatternException("Unmatched [] in expression.");
        }
        else
        {
            _mth0165();
            return j;
        }
    }

    int _mth0160(int ai[])
        throws MalformedPatternException
    {
        boolean flag = false;
        boolean flag1 = false;
        int ai1[] = new int[1];
        int k = 0;
        int l = 65535;
        int i = _mth0163(ai1);
        if (i == -1)
        {
            if ((ai1[0] & 0x8) != 0)
                ai[0] |= 0x8;
            return -1;
        }
        char c = _fld0150._mth010E();
        if (c == '(' && _fld0150._mth010D(1) == '?' && _fld0150._mth010D(2) == '#')
        {
            for (; c != '\uFFFF' && c != ')'; c = _fld0150._mth0108());
            if (c != '\uFFFF')
            {
                _mth0165();
                c = _fld0150._mth010E();
            }
        }
        if (c == '{' && _mth016F(_fld0150._fld0101, _fld0150._mth010B()))
        {
            int j = _fld0150._mth010B() + 1;
            int i1;
            int j1 = i1 = _fld0150._mth010C();
            char c1;
            for (c1 = _fld0150._mth010E(j); Character.isDigit(c1) || c1 == ','; c1 = _fld0150._mth010E(j))
            {
                if (c1 == ',')
                {
                    if (j1 != i1)
                        break;
                    j1 = j;
                }
                j++;
            }

            if (c1 == '}')
            {
                StringBuffer stringbuffer = new StringBuffer(10);
                if (j1 == i1)
                    j1 = j;
                _fld0150._mth0108();
                int k1 = _fld0150._mth010B();
                for (char c2 = _fld0150._mth010E(k1); Character.isDigit(c2); c2 = _fld0150._mth010E(k1))
                {
                    stringbuffer.append(c2);
                    k1++;
                }

                try
                {
                    k = Integer.parseInt(stringbuffer.toString());
                }
                catch(NumberFormatException numberformatexception)
                {
                    throw new MalformedPatternException("Unexpected number format exception.  Please report this bug.NumberFormatException message: " + numberformatexception.getMessage());
                }
                char c3 = _fld0150._mth010E(j1);
                if (c3 == ',')
                    j1++;
                else
                    j1 = _fld0150._mth010B();
                k1 = j1;
                stringbuffer = new StringBuffer(10);
                for (char c4 = _fld0150._mth010E(k1); Character.isDigit(c4); c4 = _fld0150._mth010E(k1))
                {
                    stringbuffer.append(c4);
                    k1++;
                }

                try
                {
                    if (k1 != j1)
                        l = Integer.parseInt(stringbuffer.toString());
                }
                catch(NumberFormatException numberformatexception1)
                {
                    throw new MalformedPatternException("Unexpected number format exception.  Please report this bug.NumberFormatException message: " + numberformatexception1.getMessage());
                }
                if (l == 0 && _fld0150._mth010E(j1) != '0')
                    l = 65535;
                _fld0150._mth010A(j);
                _mth0165();
                flag = true;
                flag1 = true;
            }
        }
        if (!flag) {
            flag1 = false;
            if (c != '*' && c != '+' && c != '?') {
                ai[0] = ai1[0];
                return i;
            }
            _mth0165();
            ai[0] = c == '+' ? 1 : 4;
            if (c == '*' && (ai1[0] & 0x2) != 0) {
                _mth0168('\020', i);
                _fld014B += 4;
            } else
            if (c == '*') {
                k = 0;
                flag1 = true;
            } else
            if (c == '+' && (ai1[0] & 0x2) != 0) {
                _mth0168('\021', i);
                _fld014B += 3;
            } else
            if (c == '+') {
                k = 1;
                flag1 = true;
            } else
            if (c == '?') {
                k = 0;
                l = 1;
                flag1 = true;
            }
        }
        if (flag1)
        {
            if ((ai1[0] & 0x2) != 0)
            {
                _fld014B += (2 + _fld014B) / 2;
                _mth0168('\n', i);
            }
            else
            {
                _fld014B += 4 + _fld014B;
                _mth0167(i, _mth016A('"'));
                _mth0168('\013', i);
                _mth0167(i, _mth016A('\017'));
            }
            if (k > 0)
                ai[0] = 1;
            if (l != 0 && l < k)
                throw new MalformedPatternException("Invalid interval {" + k + "," + l + "}");
            if (_fld014A != null)
            {
                _fld014A[i + 2] = (char)k;
                _fld014A[i + 3] = (char)l;
            }
        }
        if (_fld0150._mth010E() == '?')
        {
            _mth0165();
            _mth0168('\035', i);
            _mth0167(i, i + 2);
        }
        if (_mth0170(_fld0150._fld0101, _fld0150._mth010B()))
            throw new MalformedPatternException("Nested repetitions *?+ in expression");
        else
            return i;
    }

    int _mth015F(boolean flag, int ai[]) throws MalformedPatternException {
        int i = -1;
        int j = 0;
        int ai1[] = new int[1];
        ai[0] = 1;
        char c3;
        
        if (flag) {
            c3 = '\001';
            
            if (_fld0150._mth010E() == '?')
            {
                _fld0150._mth0108();
                char c;
                c3 = c = _fld0150._mth0106();
                switch(c)
                {
                case 35: /* '#' */
                    char c1;
                    for (c1 = _fld0150._mth010E(); c1 != '\uFFFF' && c1 != ')'; c1 = _fld0150._mth0108());
                    if (c1 != ')')
                    {
                        throw new MalformedPatternException("Sequence (?#... not terminated");
                    }
                    else
                    {
                        _mth0165();
                        ai[0] = 8;
                        return -1;
                    }

                default:
                    _fld0150._mth0107();
                    char c2;
                    for (c2 = _fld0150._mth010E(); c2 != '\uFFFF' && "iogmsx".indexOf(c2) != -1; c2 = _fld0150._mth0108())
                        _mth016C(_fld014E, c2);

                    if (c2 != ')')
                    {
                        throw new MalformedPatternException("Sequence (?" + c2 + "...) not recognized");
                    }
                    else
                    {
                        _mth0165();
                        ai[0] = 8;
                        return -1;
                    }

                case 33: /* '!' */
                case 58: /* ':' */
                case 61: /* '=' */
                    break;

                }
            } else {
                j = _fld014D;
                _fld014D++;
                i = _mth0169('\033', (char)j);
            }
        } else {
            c3 = 0;
        }
        int k = _mth0164(ai1);
        
        if (k == -1)
            return -1;
        
        if (i != -1)
            _mth0167(i, k);
        else
            i = k;
        
        if ((ai1[0] & 0x1) == 0)
            ai[0] &= 0xfffffffe;
        
        for (ai[0] |= ai1[0] & 0x4; _fld0150._mth010E() == '|'; ai[0] |= ai1[0] & 0x4) {
            _mth0165();
            int l = _mth0164(ai1);
            
            if (l == -1)
                return -1;
            _mth0167(i, l);
            
            if ((ai1[0] & 0x1) == 0)
                ai[0] &= 0xfffffffe;
        }

        int j1;
        switch(c3) {
            case 58: /* ':' */
                j1 = _mth016A('\017');
                break;
    
            case 1: /* '\001' */
                j1 = _mth0169('\034', (char)j);
                break;
    
            case 33: /* '!' */
            case 61: /* '=' */
                j1 = _mth016A('!');
                ai[0] &= 0xfffffffe;
                break;
    
            case 0: /* '\0' */
            default:
                j1 = _mth016A((char) 0);
                break;

        }
        _mth0167(i, j1);
        
        for (int i1 = i; i1 != -1; i1 = _cls2._mth0139(_fld014A, i1))
            _mth0166(i1, j1);

        if (c3 == '=') {
            _mth0168('\037', i);
            _mth0167(i, _mth016A('\017'));
        } else
        if (c3 == '!') {
            _mth0168(' ', i);
            _mth0167(i, _mth016A('\017'));
        }
        
        if (c3 != 0 && (_fld0150._mth0109() || _mth0165() != ')'))
            throw new MalformedPatternException("Unmatched parentheses.");
        
        if (c3 == 0 && !_fld0150._mth0109()) {
            
            if (_fld0150._mth010E() == ')')
                throw new MalformedPatternException("Unmatched parentheses.");
            else
                throw new MalformedPatternException("Unreached characters at end of expression.  Please report this bug!");
        } else {
            return i;
        }
    }

    public Pattern compile(char ac[], int i) throws MalformedPatternException {
        int ai[] = new int[1];
        boolean flag = false;
        boolean flag1 = false;
        int j1 = 0;
        _fld0150 = new _cls1(ac);
        int j = i & 0x1;
        _fld014E[0] = (char)i;
        _fld014F = false;
        _fld014D = 1;
        _fld014C = 0;
        _fld014B = 0;
        _fld014A = null;
        if (_fld014A != null)
            _fld014A[_fld014C] = 0;
        _fld014C++;
        
        if (_mth015F(false, ai) == -1)
            throw new MalformedPatternException("Unknown compilation error.");
        
        if (_fld014C >= 65534)
            throw new MalformedPatternException("Expression is too large.");
        
        _fld014A = new char[_fld014C];
        Perl5Pattern perl5pattern = new Perl5Pattern();
        perl5pattern._program = _fld014A;
        perl5pattern._expression = new String(ac);
        _fld0150._mth010A(0);
        _fld014D = 1;
        _fld014C = 0;
        _fld014B = 0;
        
        if (_fld014A != null)
            _fld014A[_fld014C] = 0;
        _fld014C++;
        
        if (_mth015F(false, ai) == -1)
            throw new MalformedPatternException("Unknown compilation error.");
        
        j = _fld014E[0] & '\001';
        perl5pattern._isExpensive = _fld014B >= 10;
        perl5pattern._startClassOffset = -1;
        perl5pattern._anchor = 0;
        perl5pattern._back = -1;
        perl5pattern._options = i;
        perl5pattern._startString = null;
        perl5pattern._mustString = null;
        String s = null;
        String s1 = null;
        int k = 1;
        
        if (_fld014A[_cls2._mth0139(_fld014A, k)] == 0) {
            int l = k = _cls2._mth013B(k);
            for (char c = _fld014A[l]; c == '\033' && (flag = true) || c == '\f' && _fld014A[_cls2._mth0139(_fld014A, l)] != '\f' || c == '\021' || c == '\035' || _cls2._fld0113[c] == '\n' && _cls2._mth013F(_fld014A, l) > 0; c = _fld014A[l]) {
                if (c == '\021')
                    flag1 = true;
                else
                    l += _cls2._fld0114[c];
                l = _cls2._mth013B(l);
            }

            boolean flag2 = true;
            
            while (flag2) {
                flag2 = false;
                char c1 = _fld014A[l];
                if (c1 == '\016')
                    s1 = new String(_fld014A, _cls2._mth013D(l + 1), _fld014A[_cls2._mth013D(l)]);
                else
                if (_cls2._mth013C(c1, _cls2._fld0111, 2))
                    perl5pattern._startClassOffset = l;
                else
                if (c1 == '\024' || c1 == '\025')
                    perl5pattern._startClassOffset = l;
                else
                if (_cls2._fld0113[c1] == '\001') {
                    perl5pattern._anchor = 1;
                    l = _cls2._mth013B(l);
                    flag2 = true;
                }
                else
                if (c1 == '\020' && _cls2._fld0113[_fld014A[_cls2._mth013B(l)]] == '\007' && (perl5pattern._anchor & 0x1) != 0) {
                    perl5pattern._anchor = 5;
                    l = _cls2._mth013B(l);
                    flag2 = true;
                }
            }

            if (flag1 && (!flag || !_fld014F))
                perl5pattern._anchor |= 0x2;
            StringBuffer stringbuffer = new StringBuffer();
            StringBuffer stringbuffer1 = new StringBuffer();
            int i1 = 0;
            j1 = 0;
            int k1 = 0;
            int l1 = 0;
            int i2 = 0;
            char c2;
            
            while (k > 0 && (c2 = _fld014A[k]) != 0) 
                if (c2 == '\f') {
                    if (_fld014A[_cls2._mth0139(_fld014A, k)] == '\f')
                    {
                        k1 = -30000;
                        for (; _fld014A[k] == '\f'; k = _cls2._mth0139(_fld014A, k));
                    } else {
                        k = _cls2._mth013B(k);
                    }
                } else
                if (c2 == ' ')
                {
                    k1 = -30000;
                    k = _cls2._mth0139(_fld014A, k);
                } else {
                    if (c2 == '\016')
                    {
                        l = k;
                        int j2;
                        while (_fld014A[j2 = _cls2._mth0139(_fld014A, k)] == '\034') 
                            k = j2;

                        j1 += _fld014A[_cls2._mth013D(l)];
                        j2 = _fld014A[_cls2._mth013D(l)];
                        if (k1 - l1 == i1)
                        {
                            stringbuffer.append(new String(_fld014A, _cls2._mth013D(l) + 1, j2));
                            i1 += j2;
                            k1 += j2;
                            l = _cls2._mth0139(_fld014A, k);
                        } else
                        if (j2 >= i1 + (k1 < 0 ? 0 : 1)) {
                            i1 = j2;
                            stringbuffer = new StringBuffer(new String(_fld014A, _cls2._mth013D(l) + 1, j2));
                            l1 = k1;
                            k1 += i1;
                            l = _cls2._mth0139(_fld014A, k);
                        } else
                            k1 += j2;
                    } else
                    if (_cls2._mth013C(c2, _cls2._fld0112, 0)) {
                        k1 = -30000;
                        i1 = 0;
                        if (stringbuffer.length() > stringbuffer1.length()) {
                            stringbuffer1 = stringbuffer;
                            i2 = l1;
                        }
                        stringbuffer = new StringBuffer();
                        if (c2 == '\021' && _cls2._mth013C(_fld014A[_cls2._mth013B(k)], _cls2._fld0111, 0))
                            j1++;
                        else
                        if (_cls2._fld0113[c2] == '\n' && _cls2._mth013C(_fld014A[_cls2._mth013B(k) + 2], _cls2._fld0111, 0))
                            j1 += _cls2._mth013F(_fld014A, k);
                    } else
                    if (_cls2._mth013C(c2, _cls2._fld0111, 0)) {
                        k1++;
                        j1++;
                        i1 = 0;
                        if (stringbuffer.length() > stringbuffer1.length()) {
                            stringbuffer1 = stringbuffer;
                            i2 = l1;
                        }
                        stringbuffer = new StringBuffer();
                    }
                    k = _cls2._mth0139(_fld014A, k);
                }

            if (stringbuffer.length() + (_cls2._fld0113[_fld014A[l]] != '\004' ? 0 : 1) > stringbuffer1.length()) {
                stringbuffer1 = stringbuffer;
                i2 = l1;
            } else {
                stringbuffer = new StringBuffer();
            }
            if (stringbuffer1.length() > 0 && s1 == null) {
                s = stringbuffer1.toString();
                if (i2 < 0)
                    i2 = -1;
                perl5pattern._back = i2;
            } else {
                stringbuffer1 = null;
            }
        }
        perl5pattern._isCaseInsensitive = (j & 0x1) != 0;
        perl5pattern._numParentheses = _fld014D - 1;
        perl5pattern._minLength = j1;
        
        if (s != null) {
            perl5pattern._mustString = s.toCharArray();
            perl5pattern._mustUtility = 100;
        }
        if (s1 != null)
            perl5pattern._startString = s1.toCharArray();
        return perl5pattern;
    }

    public Pattern compile(char ac[]) throws MalformedPatternException {
        return compile(ac, 0);
    }

    public Pattern compile(String s) throws MalformedPatternException {
        return compile(s.toCharArray(), 0);
    }

    public Pattern compile(String s, int i) throws MalformedPatternException {
        return compile(s.toCharArray(), i);
    }

    public Perl5Compiler() {
        _fld014E = new char[1];
    }

}

