/*************************************************************************
 *
 *  $RCSfile: Perl5Substitution.java,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:31:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.star.tool.starjar.regex;

import java.util.Vector;

// Referenced classes of package com.sun.star.tool.starjar.regex:
//            StringSubstitution, MatchResult, PatternMatcher, Pattern

public class Perl5Substitution extends StringSubstitution {
    public static final int INTERPOLATE_ALL = 0;
    public static final int INTERPOLATE_NONE = -1;
    int _fld01B4;
    Vector _fld01B3;
    transient String _fld01B2;

    static Vector _mth01B7(String s) {
        Vector vector = new Vector(5);
        StringBuffer stringbuffer = new StringBuffer(5);
        StringBuffer stringbuffer1 = new StringBuffer(10);
        char ac[] = s.toCharArray();
        int i = 0;
        boolean flag = false;
        boolean flag1 = false;
        
        for (; i < ac.length; i++)
            if (flag && Character.isDigit(ac[i])) {
                stringbuffer.append(ac[i]);
                
                if (stringbuffer1.length() > 0) {
                    vector.addElement(stringbuffer1.toString());
                    stringbuffer1.setLength(0);
                }
            } else {
                if (flag) {
                    try {
                        vector.addElement(new Integer(stringbuffer.toString()));
                        flag1 = true;
                    } catch(NumberFormatException ex) {
                        vector.addElement(stringbuffer.toString());
                    }
                    stringbuffer.setLength(0);
                    flag = false;
                }
                if (ac[i] == '$' && i + 1 < ac.length && ac[i + 1] != '0' && Character.isDigit(ac[i + 1]))
                    flag = true;
                else
                    stringbuffer1.append(ac[i]);
            }

        if (flag)
            try {
                vector.addElement(new Integer(stringbuffer.toString()));
                flag1 = true;
            } catch(NumberFormatException ex) {
                vector.addElement(stringbuffer.toString());
            }
        else
        if (stringbuffer1.length() > 0)
            vector.addElement(stringbuffer1.toString());
        if (flag1)
            return vector;
        else
            return null;
    }

    String _mth01B6(MatchResult matchresult) {
        StringBuffer stringbuffer = new StringBuffer(10);
        _mth01B5(stringbuffer, matchresult);
        return stringbuffer.toString();
    }

    void _mth01B5(StringBuffer stringbuffer, MatchResult matchresult) {
        int i = _fld01B3.size();
        
        for (int j = 0; j < i; j++) {
            Object obj = _fld01B3.elementAt(j);
            
            if (obj instanceof String) {
                stringbuffer.append(obj);
            } else {
                Integer integer = (Integer)obj;
                int k = integer.intValue();
                
                if (k > 0 && k < matchresult.groups()) {
                    String s = matchresult.group(k);
                    if (s != null)
                        stringbuffer.append(s);
                } else {
                    stringbuffer.append('$');
                    stringbuffer.append(k);
                }
            }
        }
    }

    public Perl5Substitution() {
        this("", 0);
    }

    public Perl5Substitution(String s) {
        this(s, 0);
    }

    public Perl5Substitution(String s, int i) {
        setSubstitution(s, i);
    }

    public void setSubstitution(String s) {
        setSubstitution(s, 0);
    }

    public void setSubstitution(String s, int i) {
        super.setSubstitution(s);
        _fld01B4 = i;
        
        if (i != -1 && s.indexOf(36) != -1)
            _fld01B3 = _mth01B7(s);
        else
            _fld01B3 = null;
        _fld01B2 = null;
    }

    public void appendSubstitution(StringBuffer stringbuffer, 
                                   MatchResult matchresult, 
                                   int i, String s, 
                                   PatternMatcher patternmatcher, 
                                   Pattern pattern) 
    {
        if (_fld01B3 == null) {
            super.appendSubstitution(stringbuffer, 
                                     matchresult, 
                                     i, s, 
                                     patternmatcher, 
                                     pattern);
            return;
        }
        if (_fld01B4 < 1 || i < _fld01B4) {
            _mth01B5(stringbuffer, matchresult);
            return;
        }
        if (i == _fld01B4)
            _fld01B2 = _mth01B6(matchresult);
        stringbuffer.append(_fld01B2);
    }
}

