/*************************************************************************
 *
 *  $RCSfile: NativeThreadPoolWrapper.java,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: kr $ $Date: 2001/05/17 12:55:05 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package com.sun.star.lib.uno.environments.remote;


import java.util.Hashtable;


import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.IBridge;


/**
 * This class wrapps the native uno thread pool.
 * <p>
 * @version 	$Revision: 1.7 $ $ $Date: 2001/05/17 12:55:05 $
 * @author 	    Joeg Budischewski
 * @see         com.sun.star.uno.UnoRuntime
 * @see         com.sun.star.lib.uno.environments.remote.ThreadPool
 * @see         com.sun.star.lib.uno.environments.remote.IThreadPool
 * @see         com.sun.star.lib.uno.environments.remote.Job
 * @since       UDK1.0
 */
public class NativeThreadPoolWrapper implements IThreadPool {
	/**
	 * When set to true, enables various debugging output.
	 */
	public final boolean DEBUG = false;

	protected INativeCallback _callback = new NativeCallback();
	protected Hashtable       _mapTicket = new Hashtable();
	
	
	/**
	 * Gets the <code>ThreadID</code> of this thread.
	 * Implements the method of <code>IThreadPool</code>
	 * <p>
	 * @return the thread id
	 * @see com.sun.star.lib.uno.environments.remote.IThreadPool#getThreadId
	 */
	public ThreadID getThreadId() {
		if(DEBUG) System.err.println("##### " + getClass().getName() + ".getThreadId()");

		byte a[] = NativeThreadPool.getThreadId();
		ThreadID id = new ThreadID( a );
		return id;
	}
	
	/**
	 * Adds a jobQueue for the current thread to the threadpool.
	 * Requests are now put into this queue.
	 * Implements the method of <code>IThreadPool</code>
	 * <p>
	 * @param  disposeId    the dipose id with which the thread can be interrupted while staying in the queue
	 * @see                 #enter
	 * @see com.sun.star.lib.uno.environments.remote.IThreadPool#addThread
	 */
	public void addThread(Object disposeId) {
		if(DEBUG) System.err.println("##### " + getClass().getName() + ".addThread(" + disposeId + ")");

		
		Long l = new Long( NativeThreadPool.createTicket( disposeId ) );
		_mapTicket.put( java.lang.Thread.currentThread().getName() , l );
	}
	
	/**
	 * Removes the jobQueue for the current thread.
	 * Implements the method of <code>IThreadPool</code>
	 * <p>
	 * @see com.sun.star.lib.uno.environments.remote.IThreadPool#removeThread
	 */
	public void removeThread() {
		if(DEBUG) System.err.println("##### " + getClass().getName() + ".removeThread()");
		// Nothing to do for the C-threadpool
		// Tiding up has already been done by enter
	}

	/**
	 * Queues a job into the jobQueue of the thread belonging to the jobs threadId.
	 * Implements the method of <code>IThreadPool</code>
	 * <p>
	 * @param job       the job
	 * @param disposeId the dispose id
	 * @see com.sun.star.lib.uno.environments.remote.IThreadPool#putJob
	 */
	public void putJob(Job job, Object bridgeId) {
		if(DEBUG) System.err.println("##### " + getClass().getName() + ".putJob(" + job + " "+ bridgeId + ")");

		if( job.getOperation() == null) {
			// a reply ...
			try {
				NativeThreadPool.reply(job.getThreadId().getBytes() ,
									   job.execute());
			}
			catch(Throwable throwable) {
//  			catch(com.sun.star.uno.RuntimeException exception) {
				NativeThreadPool.reply(job.getThreadId().getBytes() ,
									   new ExceptionHolder( throwable ) );
			}
		}
		else
		{
			// a request ...
			NativeThreadPool.request(job.getThreadId().getBytes(),
									 job,
									 _callback,
									 !job.isSynchron());
		}
	}
	
	/**
	 * Lets the current thread enter the ThreadPool.
	 * The thread then dispatches all jobs and leaves
	 * the ThreadPool when it gets a reply job.
	 * Implements the method of <code>IThreadPool</code>
	 * <p>
	 * @see com.sun.star.lib.uno.environments.remote.IThreadPool#enter
	 */
	public Object enter() throws Throwable {
		if(DEBUG) System.err.println("##### " + getClass().getName() + ".enter()");

		Object o2 = _mapTicket.remove( java.lang.Thread.currentThread().getName() );
		Long l = ( Long ) o2;
		Object o = NativeThreadPool.waitOnTicket( l.longValue() );
		if( o instanceof ExceptionHolder )
		{
			throw ((ExceptionHolder) o)._e;
		}
		return o;
	}

	/**
	 * Interrupts all threads which have associated the dispose id.
	 * Implements the method of <code>IThreadPool</code>
	 * <p>
	 * @param disposeId    the dispose id
	 * @see com.sun.star.lib.uno.environments.remote.IThreadPool#dispose
	 */
	public void dispose(Object bridgeId) {
		if(DEBUG) System.err.println("##### " + getClass().getName() + ".dispose()");

		NativeThreadPool.dispose( bridgeId );
	}
	
	public void stopDispose(Object bridgeId) {
		if(DEBUG) System.err.println("##### " + getClass().getName() + ".stopDispose()");

		NativeThreadPool.stopDispose( bridgeId );
	}

	private class ExceptionHolder
	{
		public Throwable _e;

		public ExceptionHolder(Throwable e)
		{
			_e = e;
		}
	}
	
	public class NativeCallback implements INativeCallback	{
		public void doRequest(Object o) {
			if(DEBUG) System.err.println("##### " + getClass().getName() + ".doRequest(" + o + ")");

  			if(o instanceof Job) {
				Job job = (Job)o;
				try {
					job.execute();
				}
				catch (Throwable e) {
//  				catch (java.lang.Exception e) {
					System.out.println( "doRequest : " + e );
					e.printStackTrace();
				}
  			}
  			else {
  				System.out.println( "NativeCallback: object is not a Job" + o );
  			}
		}
	}
}


//  class NativeThreadPool {
//  	static {
//  		try {
//  			System.loadLibrary("java_uno");
//  		}
//  		catch(java.lang.UnsatisfiedLinkError e1) {
//  			try {
//  				System.loadLibrary("javaloader");
//  			}
//  			catch(java.lang.UnsatisfiedLinkError e2) {
//  				System.out.println("Couldn't load library " + e1 + " neither " + e2);
//  				throw e1;
//  			}
//  		}
//  	}

//  	static native boolean add(byte[] id);
//  	static native byte[] retrieve();
//  	static native void revoke();

//  	static native long createTicket(Object disposeId);
//    	static native Object waitOnTicket(long ticket);
//  	static native void request(byte[] id,
//  							   Object threadSpecificData,
//  							   INativeCallback c,
//  							   boolean bIsOneway );

//  	static native void reply(byte[] id, Object o);

//  	static native void dispose(Object disposeId);
//  	static native void stopDispose(Object disposeId);
//  }

class NativeThreadPool {
	static {
		try {
			System.loadLibrary("java_uno");
		}
		catch(java.lang.UnsatisfiedLinkError e1) {
			try {
				System.loadLibrary("javaloader");
			}
			catch(java.lang.UnsatisfiedLinkError e2) {
				System.out.println("Couldn't load library " + e1 + " neither " + e2);
				throw e1;
			}
		}
	}

	static native byte []getThreadId();

	static native jlong create();
	static native void attach(long handle);
	static native void detach(long handle);

	static native Object enter(long handle);
  	static native Object putJob(long handle, byte threadId[], Job job, boolean oneWay);

	static native void dispose(long handle);
	static native void destroy(long handle);
}
