/*************************************************************************
 *
 *  $RCSfile: XConnection_Test.java,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: kr $ $Date: 2000/11/03 08:57:59 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.star.comp.connections;


import java.util.Vector;


import com.sun.star.comp.loader.FactoryHelper;

import com.sun.star.connection.XAcceptor;
import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnectionBroadcaster;
import com.sun.star.connection.XConnector;

import com.sun.star.io.XStreamListener;

import com.sun.star.lang.EventObject;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;

import com.sun.star.registry.XRegistryKey;

import com.sun.star.uno.UnoRuntime;


public class XConnection_Test implements XInitialization {
	/**
	 * When set to true, enables various debugging output.
	 */
	static public final boolean DEBUG = true;

	/**
	 * The name of the service, the <code>JavaLoader</code> acceses this through reflection.
	 */
	static private final String __serviceName = "com.sun.star.connection.XConnection_Test";

	/**
	 * Gives a factory for creating the service.
	 * This method is called by the <code>JavaLoader</code>
	 * <p>
	 * @return  returns a <code>XSingleServiceFactory</code> for creating the component
	 * @param   implName     the name of the implementation for which a service is desired
	 * @param   multiFactory the service manager to be uses if needed
	 * @param   regKey       the registryKey
	 * @see                  com.sun.star.comp.loader.JavaLoader
	 */
	public static XSingleServiceFactory __getServiceFactory(String implName, 
															XMultiServiceFactory multiFactory, 
															XRegistryKey regKey)
	{
		XSingleServiceFactory xSingleServiceFactory = null;

//  		String services[] = multiFactory.getAvailableServiceNames();
		
//  		for(int j = 0; j < services.length; ++ j)
//  			System.err.println("------------------ " + services[j]);

	    if (implName.equals(XConnection_Test.class.getName()) )
	        xSingleServiceFactory = FactoryHelper.getServiceFactory(XConnection_Test.class,
																	__serviceName,
																	multiFactory, 
																	regKey);
	    
	    return xSingleServiceFactory;
	}
	
	/**
	 * Writes the service information into the given registry key.
	 * This method is called by the <code>JavaLoader</code>
	 * <p>
	 * @return  returns true if the operation succeeded
	 * @param   regKey       the registryKey
	 * @see                  com.sun.star.comp.loader.JavaLoader
	 */
	public static boolean __writeRegistryServiceInfo(XRegistryKey regKey) {
		return FactoryHelper.writeRegistryServiceInfo(XConnection_Test.class.getName(), __serviceName, regKey);
    }

	static class Worker extends Thread implements XStreamListener {
		XAcceptor   _xAcceptor;
		XConnector  _xConnector;
		XConnection _xConnection;
		String      _connectionDcp;
		boolean     _passed = false;
		boolean     _started;
		boolean     _closed;
		boolean     _error;
		boolean     _terminated;
		boolean     _withError;
		byte        _defBlock[];

		{
			// standard block
			_defBlock = new byte[255];
			for(int i = 0; i < _defBlock.length; ++ i)
				_defBlock[i] = (byte)i;
		}

		Worker(XAcceptor xAcceptor, String connectionDcp, boolean withError) {
			_xAcceptor     = xAcceptor;
			_connectionDcp = connectionDcp;
			_withError     = withError;
		}

		Worker(XConnector xConnector, String connectionDcp) {
			_xConnector    = xConnector;
			_connectionDcp = connectionDcp;
		}

		byte[] readBlock() throws com.sun.star.uno.Exception {
			// get the number of data bytes
			byte size[][] = new byte[1][];
			int read = _xConnection.read(size, 1);
			if(read != 1)
				throw new com.sun.star.uno.Exception("communication error 1:" + read);
						
			// get the data bytes
			byte block[][] = new byte[1][size[0][0] & 0xff];
			read = _xConnection.read(block, size[0][0] & 0xff);
			if(read != (size[0][0] & 0xff))
				throw new com.sun.star.uno.Exception("communication error 2");

			if(DEBUG) System.err.println("read block of size:" + block[0].length);

			return block[0];
		}

		void writeBlock(byte block[]) throws com.sun.star.uno.Exception {
			if(DEBUG) System.err.println("writing block of size:" + block.length);

			// write size byte
			byte size[] = new byte[]{(byte)block.length};
			_xConnection.write(size);

			// write data
			_xConnection.write(block);
		}
			
		public void run() {
			try {
				if(_xAcceptor != null) { // write what we read
					_xConnection = _xAcceptor.accept(_connectionDcp);
					
					XConnectionBroadcaster xConnectionBroadcaster = (XConnectionBroadcaster)UnoRuntime.queryInterface(XConnectionBroadcaster.class,
																													  _xConnection);

					xConnectionBroadcaster.addStreamListener(this);

					byte block[] = readBlock();
					while(block.length > 0 && !_withError) {
						writeBlock(block);
						_xConnection.flush();

						block = readBlock();
					}

					_xAcceptor.stopAccepting();
				}
				else if(_xConnector != null) { // write random data and check
					_xConnection = _xConnector.connect(_connectionDcp);

					XConnectionBroadcaster xConnectionBroadcaster = (XConnectionBroadcaster)UnoRuntime.queryInterface(XConnectionBroadcaster.class,
																													  _xConnection);

					xConnectionBroadcaster.addStreamListener(this);

					for(int i = 0; i < 10; ++ i) { // send 10 blocks
						writeBlock(_defBlock);
						_xConnection.flush();

						byte block[] = readBlock();
						
						// check that we read what we have written
						boolean passed = true;
						for(int j = 0; j < block.length; ++ j)
							passed = passed && (block[j] == _defBlock[j]);

						if(!passed)
							throw new com.sun.star.uno.Exception("communication error 3");						
					}

					writeBlock(new byte[0]); // write empty block -> end of transmission
					_xConnection.flush();
				}
				else
					throw  new com.sun.star.uno.Exception("communication error 4");
				
				_xConnection.close();
				_passed = true;
			}
			catch(com.sun.star.io.IOException ioException) {
				if(DEBUG) System.err.println("#### Worker - expected exception occurred:" + ioException);
			}
			catch(com.sun.star.uno.Exception exception) {
				System.out.println("#### Reader - unexpected:" + exception);
			}
		}

		boolean getState() {
			return ((_passed && !_error && _closed) || (!_passed && _error && !_closed)) && _started;
		}

		// XEventListener
		public void disposing(/*IN*/EventObject source) throws com.sun.star.uno.RuntimeException {
			if(DEBUG) System.err.println("##### " + getClass().getName() + ".disposing:" + source);
		}

		// XStreamListener
		public void started() throws com.sun.star.uno.RuntimeException {
			if(DEBUG) System.err.println("##### " + getClass().getName() + ".started");

			_started = true;
		}

		public void closed() throws com.sun.star.uno.RuntimeException {
			if(DEBUG) System.err.println("##### " + getClass().getName() + ".closed");

			_closed = true;
		}

		public void terminated(  ) throws com.sun.star.uno.RuntimeException {
			if(DEBUG) System.err.println("##### " + getClass().getName() + ".terminated");

			_terminated = true;
		}

		public void error( /*IN*/java.lang.Object aException ) throws com.sun.star.uno.RuntimeException {
			if(DEBUG) System.err.println("##### " + getClass().getName() + ".error");

			_error = true;
		}
	}

	protected XMultiServiceFactory _xMultiServiceFactory;

	public XConnection_Test(XMultiServiceFactory xMultiServiceFactory) {
		_xMultiServiceFactory = xMultiServiceFactory;
	}

	public boolean test(Vector notpassed, String clientDcp, String serverDcp, boolean withError) throws com.sun.star.uno.Exception {
		XAcceptor xAcceptor = (XAcceptor)UnoRuntime.queryInterface(XAcceptor.class, _xMultiServiceFactory.createInstance("com.sun.star.connection.Acceptor"));
		XConnector xConnector = (XConnector)UnoRuntime.queryInterface(XConnector.class, _xMultiServiceFactory.createInstance("com.sun.star.connection.Connector"));

		
		Worker writer = new Worker(xAcceptor, serverDcp, withError);
		Worker reader = new Worker(xConnector, clientDcp);
		
		try {
			writer.start();
			Thread.sleep(1000);
			reader.start();

			writer.join();
			reader.join();
		}
		catch(java.lang.InterruptedException interruptedException) {
			throw new com.sun.star.uno.Exception(interruptedException.getMessage());
		}

		boolean passed = writer.getState() && reader.getState();

		return passed;
	}

	public void initialize(Object args[]) throws com.sun.star.uno.Exception {
		System.err.println("\tTesting XConnection (" + args[0] + " - " + args[1] + ") ...");

		boolean passed = true;

		System.err.println("\t\tchecking without error...");
  		passed = test(null, (String)args[0], (String)args[1], false) && passed;
		System.err.println("\t\tchecking with error...");
		passed = test(null, (String)args[0], (String)args[1], true) && passed;

		System.err.println("XConnection_Test - passed (" + args[0] + " - " + args[1] + ")? " + passed);
//  		if(!passed && notpassed != null)
//  			notpassed.addElement("XConnection_Test - passed? " + passed);
	}



//  	static public void main(String argv[]) throws Exception {
//  		test(null, argv[0], argv[1]);
//  	}
}


