/*************************************************************************
 *
 *  $RCSfile: LoaderTest.java,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:27:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.star.comp.loader;

import com.sun.star.comp.servicemanager.ServiceManager;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.container.XSet;

import com.sun.star.container.XSet;
import com.sun.star.container.XContentEnumerationAccess;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XEnumerationAccess;
import com.sun.star.container.XElementAccess;

import com.sun.star.lang.XComponent;

import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XEventListener;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.lang.XInitialization;

import com.sun.star.loader.XImplementationLoader;

public class LoaderTest {
    private static final boolean DEBUG = false;
    
    private static final void DEBUG( String dbg ) {
        System.err.println(">>>LoaderTest - " + dbg );
    } 
    
    
    JavaLoader        loader = null;
    ServiceManager    manager = null;
    
    public LoaderTest(String[] args) {
        try {
            System.err.println("create ServiceManager");
            System.err.println();
            manager = new ServiceManager();
            
            String[] factories = new String[args.length + 3];
            
            factories[0] = "com.sun.star.comp.servicemanager.ServiceManager";
            factories[1] = "com.sun.star.comp.loader.JavaLoader";
            factories[2] = "java.awt.Button";
            
            System.arraycopy(args, 0, factories, 2, args.length);
                        
            manager.addFactories( factories );
            
            System.err.println("now try to instanciate the components");
            
            for (int j=0; j<args.length; j++) {
                try {
                    System.err.println( "try to create instance of " + args[j] );
                    Object obj = manager.createInstance(args[j]);
                    System.err.println( "create instance done ... " );
                } catch (Exception e) {
                    System.err.println("an "+e.toString() + " occured while create instance of " +args[j] );
                }
            }
            
            System.err.println("---------------------------------------------------------------");
            System.err.println("test the  XMultiServiceFactory interface  of the ServiceManager");
            
            System.err.println("-- createInstance");
            
            Object test1 = manager.createInstance( "java.awt.Button" );
            java.awt.Button btn1 = (java.awt.Button) UnoRuntime.queryInterface(java.awt.Button.class, test1);
            System.err.println("button 1 created without args" );
            System.err.println("-- done ...");
            
            System.err.println("-- createInstanceWithArguments");
            
            String[] params = { "TestButton" };
            Object test2 = manager.createInstanceWithArguments( "java.awt.Button", params );
            
            java.awt.Button btn2 = (java.awt.Button) UnoRuntime.queryInterface(java.awt.Button.class, test2);
            
            System.err.println("button 2 created with label " + btn2.getLabel() );
            
            System.err.println("-- done ...");
            
            System.err.println("-- getAvailableServiceNames");
            
            String[] availableServiceNames = manager.getAvailableServiceNames();
            
            for (int n=0; n<availableServiceNames.length; n++)
                System.err.println("service #"+n+" : " +availableServiceNames[n] );
            
            System.err.println("-- done ...");
            System.err.println();
            System.err.println("---------------------------------------------------------------");
            System.err.println("test the  XSet interface  of the ServiceManager");
            
            Object[] param = { manager };
            Object loaderObj = manager.createInstanceWithArguments("com.sun.star.loader.Java", param);
            XImplementationLoader xLoader = (XImplementationLoader) UnoRuntime.queryInterface(XImplementationLoader.class, loaderObj);
            
            Object dummyFactory = xLoader.activate( "com.sun.star.comp.loader.DummyService", null, null, null );
            
            System.err.println("-- insert");
            manager.insert(dummyFactory);
            System.err.println("-- done ...");
            
            System.err.println("-- has");
            
            System.err.println("-- done ...");
           
            String[] sParam = { " test the DummyService " };
            Object dummyObj = manager.createInstanceWithArguments("com.sun.star.service.Dummy", sParam);
            
            DummyService dummyService = (DummyService) UnoRuntime.queryInterface(DummyService.class, dummyObj);
            
            System.err.println("-- remove");
            
            System.err.println("-- done ...");
            
            System.err.println();
            
            System.err.println("---------------------------------------------------------------");
            System.err.println();
            System.err.println("test XEnumerationAccess interface");
            System.err.println("test createEnumeration");
            XEnumeration xEnum = manager.createEnumeration();
            
            System.err.println("registered factories:");
            while (xEnum.hasMoreElements())
                System.err.println( xEnum.nextElement().toString() );
            
            System.err.println("test XEnumerationAccess interface - done....");
            System.err.println();
            System.err.println("---------------------------------------------------------------");
            System.err.println();
            System.err.println(" remove DummyService ");
            manager.remove( dummyFactory );
            System.err.println(" DummyService removed");
            System.err.println();
            System.err.println("registered factories:");
            xEnum = manager.createEnumeration();
            while (xEnum.hasMoreElements())
                System.err.println( xEnum.nextElement().toString() );
            
            System.err.println();
            System.err.println("---------------------------------------------------------------");
            
            
            
            
            
        }     
        catch (Exception ex) {
            ex.printStackTrace();
        }        
    }

    public static void main( String[] args ) {
        LoaderTest test = new LoaderTest(args);
    }
}

