/*************************************************************************
 *
 *  $RCSfile: TestClient.java,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:27:55 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.star.comp.rmclient;


import java.lang.reflect.InvocationTargetException;

import test.TestBridgeException;
import test.XCallMe;
import test.XInterfaceTest;
import test.XTestFactory;

import com.sun.star.bridge.XConnectionClientSide;

import com.sun.star.comp.rmserver.CallMe_Impl;

import com.sun.star.uno.UnoRuntime;

public class TestClient {
	static private double getCallsPerSec(XCallMe rCall , int nLoops, int nToDo) throws TestBridgeException {
		long startTime, endTime;
		
		startTime = System.currentTimeMillis();
		for(int i = 0; i < nLoops; ++i)
			rCall.call("Performance test string", nToDo);

		endTime = System.currentTimeMillis();

		return (endTime - startTime) / 1000.0;
	}

	static private double getCallsPerSecOneway(XCallMe rCall, int nLoops, int nToDo) throws TestBridgeException {
		long startTime, endTime;

		startTime = System.currentTimeMillis();
		for(int i = 0; i < nLoops; ++ i)
			rCall.callOneway("Performance test string" , nToDo);

		endTime = System.currentTimeMillis();

		return (endTime - startTime) / 1000.0;
	}

	static private void testPerformance(XCallMe rRemote, XCallMe rLocal) throws TestBridgeException {
		String aTestString;

		int nDoSomething = 1;
		int nCalls = 2000;
		double dRemote, dLocal;

		System.err.println("Doing performance test oneway " + nCalls + " ...");
		dLocal  = getCallsPerSecOneway( rLocal  , nCalls , nDoSomething );
		dRemote = getCallsPerSecOneway( rRemote , nCalls , nDoSomething );
		System.err.println("Local: " + dLocal + "\n Remote: " + dRemote);
		if( dLocal > 0. )
			System.err.println("Remote/Local: " + dRemote/dLocal);

		System.err.println("Overhead per Call[s]:" + (dRemote - dLocal)/((double)nCalls));

		nCalls = 400;
		System.err.println("Waiting for onewayrequests to be completed ....");
		rRemote.call("Performance test string" , 1);
	
		System.err.println("Doing performance test ...");
		dRemote = getCallsPerSec(rRemote, nCalls, nDoSomething);
		dLocal  = getCallsPerSec(rLocal, nCalls, nDoSomething);
		System.err.println("Local: " + dLocal + "\nRemote: "  + dRemote);
		if( dLocal > 0. )
			System.err.println("Remote/Local: " + dRemote/dLocal);

		System.err.println("Overhead per Call[s]:" + (dRemote - dLocal)/((double)nCalls ));
	}

	private static void testException(XCallMe xCallMe) {
		try {
		    xCallMe.call("dummy" , -1);
			System.err.println("testException - no exeception thrown");
		}
		catch(TestBridgeException testBridgeException)	{
			// Exception flew successfully !
			System.err.println("Exception flew successfully!");
		}
		catch(Exception exception) {
			System.err.println("only base class of exception could be catched:" + exception);
			exception.printStackTrace();

			if(exception instanceof InvocationTargetException) {
				InvocationTargetException invocationTargetException = (InvocationTargetException)exception;
				System.err.println("--- only base class of exception could be catched:" + invocationTargetException.getTargetException());
				invocationTargetException.getTargetException().printStackTrace();
			}
		}
		catch(Throwable throwable) {
			System.err.println("wrong unknown exception !");
		}
	}

	private static void testSequenceOfCalls(XCallMe rRCallMe) {
		System.err.println("Testing sequence of calls");
		for(int i = 0; i < 800; ++i)
			rRCallMe.callOneway("hifuj", i);
	}

	private static void doTest(Object object) throws TestBridgeException {
		XTestFactory xTestFactory = (XTestFactory)UnoRuntime.queryInterface(XTestFactory.class, object);

  		XCallMe local_xCallMe = new CallMe_Impl();
		XCallMe remote_xCallMe = xTestFactory.createCallMe();

		System.err.println( "Testing exception local ...");
		testException(local_xCallMe);
		System.err.println("Testing exception remote ...");
		testException(remote_xCallMe);
	
		//--------------------
		// Test attributes
		//----------------------
  		String string = "dum didel dum dideldei";
		local_xCallMe.setsAttribute(string);
		System.err.print("local callme get/set attribute: ");
		if(local_xCallMe.getsAttribute().equals(string))
			System.err.println("passed");
		else
			System.err.println("failure");

  		remote_xCallMe.setsAttribute(string);
  		System.err.print("remote callme get/set attribute: ");
  		if(remote_xCallMe.getsAttribute().equals(string))
			System.err.println("passed");
		else
			System.err.println("failure");
		
		//-------------------
		// Performance test
		//-------------------
  		testPerformance(remote_xCallMe , local_xCallMe);
	
		//----------------
		// Test sequence
		//----------------
  		testSequenceOfCalls(remote_xCallMe);

	
		// test triple to check if transporting the same interface multiple
		// times causes any problems
		XInterfaceTest rRTest = xTestFactory.createInterfaceTest();
		XInterfaceTest rRTest2 = xTestFactory.createInterfaceTest();
  		XInterfaceTest rRTest3 = xTestFactory.createInterfaceTest();

		rRTest.setIn(remote_xCallMe);
		rRTest2.setIn(remote_xCallMe);
  		rRTest3.setIn(remote_xCallMe);
		if(!UnoRuntime.areSame(rRTest2.get(), remote_xCallMe))
			System.err.println("remote set/get interface failure");
	
		rRTest.setIn(local_xCallMe);
		rRTest2.setIn(local_xCallMe);
		rRTest3.setIn(local_xCallMe);
		if(!UnoRuntime.areSame(rRTest2.get(), local_xCallMe))
			System.err.println("local set/get interface failure");

		XCallMe r[] = new XCallMe[] {remote_xCallMe};
		rRTest.setIn(remote_xCallMe);
		rRTest.setInOut(r);
		if(UnoRuntime.areSame(local_xCallMe, r[0]))
			System.err.println("local setInOut local == remote callme failure");


		//--------------------------------
		// test thread deadlocking
		//--------------------------------
		local_xCallMe.callAgain(remote_xCallMe, 10);

  		rRTest3 = null;
  		rRTest2 = null;
  		rRTest = null;
		remote_xCallMe = null;
  		xTestFactory = null;

		System.err.println("Test finished.");
	}

	static String neededServices[] = new String[] {
		"com.sun.star.comp.servicemanager.ServiceManager",
		"com.sun.star.comp.loader.JavaLoader",
		"com.sun.star.comp.connections.Connector",
  		"com.sun.star.comp.connections.Acceptor",
		"com.sun.star.comp.rmclient.ConnectionClientSide"
	};

	static public void main(String args[]) throws com.sun.star.uno.Exception {
		com.sun.star.comp.servicemanager.ServiceManager smgr = new com.sun.star.comp.servicemanager.ServiceManager();
		smgr.addFactories(neededServices, null);

		XConnectionClientSide xConnectionClientSide = (XConnectionClientSide)smgr.createInstance("com.sun.star.bridge.Connection");

		try {
  			if(xConnectionClientSide.connect("socket:localhost:5001", "bad guy", "secret")) {
				Object object = xConnectionClientSide.getRemoteObject();

  				doTest(object);

				object = null;

//  				Thread.sleep(1000);
//  				xConnectionClientSide.close();
			}
		}
		catch(Exception exception) {
			System.err.println("####### TestClient.main - exception occurred:" + exception);
			exception.printStackTrace();
		}

		xConnectionClientSide = null;
//  		Thread.currentThread().suspend();

		System.gc();
		System.gc();
		System.gc();
		System.gc();
		System.gc();
		System.gc();
		System.gc();
		System.gc();

//  		UnoRuntime.reset();
	}
}

