/*************************************************************************
 *
 *  $RCSfile: Proxy_Test.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kr $ $Date: 2001/04/19 16:09:27 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.star.lib.uno.environments.java;


import java.lang.reflect.Method;
import java.lang.reflect.InvocationTargetException;

import java.util.Vector;


import com.sun.star.bridge.XBridge;

import com.sun.star.uno.MappingException;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;


public class Proxy_Test {
	static class Requester implements IRequester {
		int _modus;
		boolean _virtual;
		boolean _forceSynchronous;
		boolean _passed = true;

		Requester(boolean virtual, boolean forceSynchronous) {
			_virtual = virtual;
			_forceSynchronous = forceSynchronous;
		}

		public Object sendRequest(Object object, 
								  Type type, 
								  String operation, 
								  Object params[], 
								  Boolean synchron[],
								  Boolean mustReply[]) throws Throwable 
		{
			if(_virtual && (operation.equals("release") || operation.equals("acquire"))) {
				String message = getClass().getName() + " received " + operation + " despite object is virtual!!!";
				System.err.println(message);

				_passed = false;

				throw new java.lang.RuntimeException(message);
			}

			if(_forceSynchronous && (synchron == null || synchron[0].booleanValue() == false)) {
				String message = getClass().getName() + " received " + operation + " to be async despite object is forceSynchronous!!!";
				System.err.println(message);

				_passed = false;

				throw new java.lang.RuntimeException(message);
			}

			if(_forceSynchronous && (mustReply == null || mustReply[0].booleanValue() == false)) {
				String message = getClass().getName() + " received " + operation + " and do need to reply despite object is forceSynchronous!!!";
				System.err.println(message);

				_passed = false;

				throw new java.lang.RuntimeException(message);
			}

			Object result = null;
			switch(_modus) {
			case 0: 
				if(operation.equals("getInstance"))
					result = new String("abc");
			break; // return null

			case 1: throw new com.sun.star.uno.MappingException("a mapping exception");
			case 2: throw new com.sun.star.uno.RuntimeException("a mapping exception");
			case 3: throw new com.sun.star.uno.Exception("a mapping exception");
			case 4: 
				// force NullPointerException
				String bla = null;
				bla.length();

			case 5:
				throw new Throwable("a Throwable");
			}

			return result;
		}
	}

	static boolean test_exception_type(XBridge xBridge, Method method, Object params[], Class zClass) {
		boolean passed = true;

		try {
			method.invoke(xBridge, params);
			if(zClass != null) {// should an exception fly?
				System.err.println("expected exception:" + zClass);
				passed = false;
			}
		}
		catch(Throwable throwable) {
			if(zClass == null 
			|| !(throwable instanceof InvocationTargetException) 
			|| !zClass.isInstance(((InvocationTargetException)throwable).getTargetException())) {
				System.err.println("unexpected:" + ((InvocationTargetException)throwable).getTargetException());
				passed = false;
			}

			// missing: we have to check the stack trace here
		}

		return passed;
	}

	static public boolean test_exceptions(Requester requester, XBridge xBridge, Method method, Object params[], Class classes[]) {
		boolean passed = true;

		for(int i = 0; i < classes.length; ++ i) {
			requester._modus = i;
			passed = passed && test_exception_type(xBridge, method, params, classes[i]);
		}

		return passed;
	}

	static public boolean test_standard_methods(boolean virtual, boolean forceSynchronous, Vector notpassed) throws Exception {
		boolean passed = true;

		Requester requester = new Requester(virtual, forceSynchronous);
		XBridge xBridge = (XBridge)Proxy.create(requester, "oidoid", new Type(com.sun.star.bridge.XBridge.class), virtual, forceSynchronous);
		Class proxyClass = xBridge.getClass();
		
		passed = test_exceptions(requester, xBridge, 
								 proxyClass.getMethod("queryInterface", new Class[]{Type.class}), new Object[]{new Type("com.sun.star.connection.XConnector")},
								 new Class[] {null, 
											  MappingException.class,
											  com.sun.star.uno.RuntimeException.class,
											  MappingException.class,
											  NullPointerException.class,
											  MappingException.class});

		passed = test_exceptions(requester, xBridge, 
								 proxyClass.getMethod("getInstance", new Class[]{String.class}), new Object[]{"blabla"},
								 new Class[] {null, 
											  MappingException.class,
											  com.sun.star.uno.RuntimeException.class,
											  com.sun.star.uno.Exception.class,
											  NullPointerException.class,
											  java.lang.Exception.class});

		passed = test_exceptions(requester, xBridge, 
								 proxyClass.getMethod("acquire", new Class[0]), new Object[0],
								 new Class[] {null, 
											  virtual ? null : MappingException.class,
											  virtual ? null : com.sun.star.uno.RuntimeException.class,
											  virtual ? null : com.sun.star.uno.Exception.class,
											  virtual ? null : NullPointerException.class,
											  virtual ? null : java.lang.Exception.class});

		passed = test_exceptions(requester, xBridge, 
								 proxyClass.getMethod("release", new Class[0]), new Object[0],
								 new Class[] {null, 
											  virtual ? null : MappingException.class,
											  virtual ? null : com.sun.star.uno.RuntimeException.class,
											  virtual ? null : com.sun.star.uno.Exception.class,
											  virtual ? null : NullPointerException.class,
											  virtual ? null : java.lang.Exception.class});

		passed = passed && requester._passed;

		if(!passed && notpassed != null)
			notpassed.addElement("Proxy_Test - test_standard_methods virtual:" + virtual + " forceSynchronous:" + forceSynchronous + " passed? " + passed);

		return passed;
	}

	static public boolean test(Vector notpassed) throws Exception  {
		boolean passed = true;
		System.err.println("Proxy - doing tests...");

		// test standard proxy
		passed = passed && test_standard_methods(false, false, notpassed);

		// test forceSynchronous proxy
  		passed = passed && test_standard_methods(false, true, notpassed);

		// test virtual proxy
		passed = passed && test_standard_methods(true, false, notpassed);


		System.err.println("Proxy - tests passed? " + passed);

		return passed;
	}

	static public void main(String args[]) throws Exception {
		test(null);
	}
}
