/*************************************************************************
 *
 *  $RCSfile: Type_Test.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kr $ $Date: 2001/01/17 10:13:08 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package com.sun.star.uno;


import java.util.Vector;


import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;


import com.sun.star.connection.XConnection;

import com.sun.star.comp.connections.PipedConnection;


public class Type_Test {
	static private void dumpType(Type type) throws java.lang.Exception {
		System.err.println("TypeClass:" + type.getTypeClass().getValue());
		System.err.println("TypeName:" + type.getTypeName());
		System.err.println("ArrayClassName:" + type.getArrayTypeName());
		System.err.println("Class:" + type.getDescription());
	}

	static public boolean test_type(String typeName) throws java.lang.Exception {
		dumpType(TypeDescription.getType(typeName));

		return true;
	}

	static public boolean test_class(String className) throws java.lang.Exception {
		dumpType(TypeDescription.getType(Class.forName(className)));

		return true;
	}

	static public boolean test(Vector notpassed) throws java.lang.Exception {
		boolean passed = true;

		Type type = TypeDescription.getType(Class.forName("java.lang.String"));

		System.err.println("Type test passed? " + passed);
		if(!passed)
			notpassed.addElement("Type test passed? " + passed);

		return passed;
	}

	static public void main(String args[]) throws java.lang.Exception {
		if(args[0].equals("class"))
			test_class(args[1]);
		else
			test_type(args[1]);
	}
}


