/*************************************************************************
 *
 *  $RCSfile: UnoRuntime_Test.java,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: dbo $ $Date: 2001/06/12 08:38:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package com.sun.star.uno;


import java.util.Vector;


import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;


import com.sun.star.connection.XConnection;

import com.sun.star.comp.connections.PipedConnection;

class CurrentContext_Impl implements com.sun.star.uno.XCurrentContext
{
    private Integer m_value = new Integer( Thread.currentThread().hashCode() );
    
    public Object getValueByName( String Name )
    {
        if (Name.equals( "value" ))
        {
            return m_value;
        }
        return null;
    }
}
class Thread_Impl extends Thread
{
    public boolean m_passed = false;
    public com.sun.star.uno.XCurrentContext m_context = null;
    
    public void run()
    {
        Object o = UnoRuntime.getCurrentContext();
        if (o != null)
        {
            System.err.println( "### current context test failed: 1!" );
        }
        else
        {
            com.sun.star.uno.XCurrentContext context = new CurrentContext_Impl();
            UnoRuntime.setCurrentContext( context );
            m_context = UnoRuntime.getCurrentContext();
            if (context != m_context || ((Integer)m_context.getValueByName( "value" )).intValue() != this.hashCode())
            {
                System.err.println( "### current context test failed: 2!" );
            }
            else
            {
                UnoRuntime.setCurrentContext( null );
                o = UnoRuntime.getCurrentContext();
                if (o != null)
                {
                    System.err.println( "### current context test failed: 3!" );
                }
                else
                {
                    m_passed = true;
                }
            }
        }
    }
}

public class UnoRuntime_Test {
	interface I1 {
	}

	private static Type I1_type = null;
	static {
		I1_type = new Type(I1.class);
	}

	static class Test1 {
	}

	static class Test2 implements IQueryInterface {
		class T2 implements I1 {
		}

		T2 t2 = new T2();

		public Object queryInterface(Type type) {
			Object object = type.equals(I1_type) ? t2 : null;

			return object;
		}
			
		public boolean isSame(Object object) {
			return object == t2;
		}
			
		public String getOid() {
			return null;
		}
	}

	static class Test3 implements I1 {
	}


	static class Test4 implements IQueryInterface {
		class T4 implements I1, IQueryInterface {
			public Object queryInterface(Type type) {
				return Test4.this.queryInterface(type);
			}
			
			public boolean isSame(Object object) {
				return UnoRuntime.areSame(Test4.this,object);
			}
			
			public String getOid() {
				return UnoRuntime.generateOid(Test4.this);
			}
		}

		T4 t4 = new T4();

		public Object queryInterface(Type type) {
			Object object = type.equals(I1_type) ? t4 : null;

			return object;
		}
			
		public boolean isSame(Object object) {
			return object == t4;
		}
			
		public String getOid() {
			return null;
		}
	}

	static boolean test_queryInterface() {
		boolean passed = true;

		// test if a query for an interface which is not supported gives zero
		Test1 test1 = new Test1();
		I1 i1 = (I1)UnoRuntime.queryInterface(I1.class, test1);
		passed = passed && (i1 == null);


		// test if a query for an interface which is supported through IQueryInterface works
		Test2 test2 = new Test2();
		I1 i2 = (I1)UnoRuntime.queryInterface(I1.class, test2);
		passed = passed && (i2 != null);

		// test if a query for an interface which is directly supported (through inheritance) works
		Test3 test3 = new Test3();
		I1 i3 = (I1)UnoRuntime.queryInterface(I1.class, test3);
		passed = passed && (i3 != null);

		System.err.println("\ttest_queryInterface passed? " + passed);

		return passed;
	}

	static boolean test_areSame() {
		boolean passed = true;

		Test1 test1_1 = new Test1();
		Test1 test1_2 = new Test1();

		// test if two independent instances are not the same
		passed = passed && !UnoRuntime.areSame(test1_1, test1_2);

		// test if a delegator object is same as the delegator creator
		Test2 test2 = new Test2();
		I1 i1 = (I1)UnoRuntime.queryInterface(I1.class, test2);
		passed = passed && UnoRuntime.areSame(i1, test2);

		// test if delegator creator is not same with test1_1
		passed = passed && !UnoRuntime.areSame(test2, test1_1);

		System.err.println("\ttest_areSame passed? " + passed);

		return passed;
	}

	static boolean test_generateOid() {
		boolean passed = true;
		
		// test if UnoRuntime generates a Oid for a simple class
		Test1 test1 = new Test1();
		String oId=UnoRuntime.generateOid(test1);
//  		System.err.println("#### UnoRuntime.generateOid(test1):" + oId);
		passed = passed && (oId!=null);

		// test if UnoRuntime generates a Oid for a class
		// implementing IQueryInterface and returning null in getOid()
		Test2 test2 = new Test2();
		oId=UnoRuntime.generateOid(test2);
//  		System.err.println("#### UnoRuntime.generateOid(test2):" + oId);
		passed = passed && (oId!=null);

		// test if a delegator object has the same Oid as the delegator creator
		Test4 test4 = new Test4();
		oId=UnoRuntime.generateOid(test4);
//  		System.err.println("#### UnoRuntime.generateOid(test4.i1):" + oId);
		I1 i1 = (I1)UnoRuntime.queryInterface(I1.class, test4);
		String oId2=UnoRuntime.generateOid(i1);
//  		System.err.println("#### UnoRuntime.generateOid(test4.i1):" + oId2);
		passed = passed && oId2.equals(oId);

		System.err.println("\ttest_generateOid passed? " + passed);

		return passed;
	}

	static boolean test_getEnvironment() throws java.lang.Exception {
		boolean passed = true;

		Object o1 = new Object();
		Object o2 = new Object();
		
		// get two environments with different contexts
		IEnvironment java_environment1 = UnoRuntime.getEnvironment("java", o1);
		IEnvironment java_environment2 = UnoRuntime.getEnvironment("java", o2);

		// ensure that the environments are different
		passed = passed && (java_environment1 != java_environment2);
		
		// test if we get the same environment when we reget it
		passed = passed && (UnoRuntime.areSame(java_environment1, UnoRuntime.getEnvironment("java", o1)));
  		passed = passed && (UnoRuntime.areSame(java_environment2, UnoRuntime.getEnvironment("java", o2)));

		// drop the environments and wait until they are gc
		java_environment1 = null;
		java_environment2 = null;
		System.err.println("\twaiting for gc to remove environments...");
		while(UnoRuntime.getEnvironmentCount() > 0) {
			System.gc();
			System.runFinalization();

			byte dummy[] = new byte[] {1, 1, 3};
		}
		
		System.err.println("\ttest_getEnvironment passed? " + passed);

		return passed;
	}

	static boolean test_getBridge() throws java.lang.Exception {
		boolean passed = true;

		PipedConnection oneSide = new PipedConnection(new Object[0]);
		PipedConnection otherSide = new PipedConnection(new Object[]{oneSide});

		// get a bridge
		IBridge iBridge = UnoRuntime.getBridgeByName("java", null, "remote", "testname", new Object[]{"urp", oneSide, null});

		// reget the bridge, it must be the same as above
		IBridge iBridge_tmp = UnoRuntime.getBridgeByName("java", null, "remote", "testname", new Object[]{"urp", oneSide, null});
		passed = passed && (UnoRuntime.areSame(iBridge_tmp, iBridge));

		// dispose the bridge, this removes the entry from the runtime
		iBridge.dispose();

		System.err.println("\twaiting for gc to remove bridges...");
		while(UnoRuntime.getBridgeCount() > 0 || UnoRuntime.getEnvironmentCount() > 0) {
			new Object();

			System.gc();
			System.runFinalization();
		}
		
		System.err.println("\ttest_getBridge passed? " + passed);

		return passed;
	}

	static boolean test_getMapping() {
		boolean passed = true;

		System.err.println("\ttest_getMapping - not tested");

		return passed;
	}

	static boolean test_reset() throws java.lang.Exception {
		boolean passed = true;


		PipedConnection oneSide = new PipedConnection(new Object[0]);
		PipedConnection otherSide = new PipedConnection(new Object[]{oneSide});

		IEnvironment java_environment = UnoRuntime.getEnvironment("java", null);

		IBridge iBridge = UnoRuntime.getBridgeByName("java", null, "remote", null, new Object[]{"urp", oneSide, null});
		iBridge.dispose();

		java_environment = null;
		iBridge = null;



		System.err.println("\twaiting for gc to remove objects...");
		while(UnoRuntime.getEnvironmentCount() > 0 || UnoRuntime.getBridgeCount() > 0) {
			System.err.println("\twaiting for gc to remove objects..." + UnoRuntime.getEnvironmentCount() + " " + UnoRuntime.getBridgeCount());

			System.gc();
			System.runFinalization();

			byte dummy[] = new byte[]{1,2,3};
		}
		

		System.err.println("\ttest_reset passed? " + passed);
		return passed;
	}
    
	static boolean test_CurrentContext() throws java.lang.Exception
    {    
        Thread_Impl t1 = new Thread_Impl();
        Thread_Impl t2 = new Thread_Impl();
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        
        int h1 = ((Integer)t1.m_context.getValueByName( "value" )).intValue();
        int h2 = ((Integer)t2.m_context.getValueByName( "value" )).intValue();
        
		boolean passed = (t1.m_passed && t2.m_passed && t1.m_context != t2.m_context &&
                          h1 == t1.hashCode() && h2 == t2.hashCode() && h1 != h2);
		System.err.println("\ttest_CurrentContext passed? " + passed);
        
        return passed;
    }
    
	static public boolean test(Vector notpassed) throws java.lang.Exception {
		boolean passed = true;

		System.err.println("UnoRuntime - doing tests...");

		passed = passed && test_CurrentContext();
		passed = passed && test_queryInterface();
		passed = passed && test_areSame();
		passed = passed && test_generateOid();
		passed = passed && test_getEnvironment();
		passed = passed && test_getBridge();
		passed = passed && test_getMapping();
		passed = passed && test_reset();

		System.err.println("UnoRuntime test passed? " + passed);
		if(!passed && notpassed != null)
			notpassed.addElement("UnoRuntime test passed? " + passed);

		return passed;
	}

	static public void main(String args[]) throws java.lang.Exception {
		if(args.length == 1) {
			if(args[0].equals("test_CurrentContext"))
				test_CurrentContext();

			else if(args[0].equals("test_queryInterface"))
				test_queryInterface();

			else if(args[0].equals("test_areSame"))
				test_areSame();

			else if(args[0].equals("test_generateOid"))
				test_generateOid();

			else if(args[0].equals("test_getEnvironment"))
				test_getEnvironment();

			else if(args[0].equals("test_getBridge"))
				test_getBridge();

			else if(args[0].equals("test_getMapping"))
				test_getMapping();

			else if(args[0].equals("test_reset"))
				test_reset();
		}
		else
			test(null);
	}
}


