/*************************************************************************
 *
 *  $RCSfile: ldapasn.h,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:31:47 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _LDAPBER_LDAPASN_H
#define _LDAPBER_LDAPASN_H "$Revision: 1.1.1.1 $"

#ifdef __cplusplus
extern "C" {
#endif

/*========================================================================
 *
 * ASN.1 object constants.
 *
 *======================================================================*/
#define V_ASN1_UNIVERSAL        0x00
#define V_ASN1_APPLICATION      0x40
#define V_ASN1_CONTEXT_SPECIFIC 0x80
#define V_ASN1_PRIVATE          0xc0

#define V_ASN1_CONSTRUCTED      0x20
#define V_ASN1_PRIMITIVE_TAG    0x1f

#define V_ASN1_EOC               0
#define V_ASN1_BOOLEAN           1
#define V_ASN1_INTEGER           2
#define V_ASN1_NEG_INTEGER      (2+0x100)
#define V_ASN1_BIT_STRING        3
#define V_ASN1_OCTET_STRING      4
#define V_ASN1_NULL              5
#define V_ASN1_OBJECT            6
#define V_ASN1_ENUMERATED       10
#define V_ASN1_NEG_ENUMERATED  (10+0x100)
#define V_ASN1_SEQUENCE         16
#define V_ASN1_SET              17

/*========================================================================
 *
 * ASN.1 data structures.
 *
 *======================================================================*/
typedef unsigned char BYTE;

typedef int   ASN1_i2d_t (void  *a, BYTE **pp);
typedef void* ASN1_d2i_t (void **a, BYTE **pp, long length);

void* ASN1_dup (ASN1_i2d_t *i2d, ASN1_d2i_t *d2i, void *a);


/*
 * ASN1_NULL.
 */
typedef char ASN1_NULL;

ASN1_NULL* ASN1_NULL_new();
#define ASN1_NULL_free(a)

int i2d_ASN1_NULL (ASN1_NULL *a, BYTE **pp);
ASN1_NULL* d2i_ASN1_NULL (ASN1_NULL **a, BYTE **pp, long length);

#define tag_ASN1_NULL (V_ASN1_UNIVERSAL | V_ASN1_NULL)


/*
 * ASN1_BOOLEAN.
 */
typedef struct asn1_boolean_st {
	int value;
} ASN1_BOOLEAN;

ASN1_BOOLEAN* ASN1_BOOLEAN_new (void);
void ASN1_BOOLEAN_free (ASN1_BOOLEAN *a);

int i2d_ASN1_BOOLEAN (ASN1_BOOLEAN *a, BYTE **pp);
ASN1_BOOLEAN* d2i_ASN1_BOOLEAN (ASN1_BOOLEAN **a, BYTE **pp, long length);

#define tag_ASN1_BOOLEAN (V_ASN1_UNIVERSAL | V_ASN1_BOOLEAN)


/*
 * ASN1_BIT_STRING.
 */
typedef struct asn1_bit_string_st {
	int   length;
	int   type;
	BYTE *data;
} ASN1_BIT_STRING;

ASN1_BIT_STRING* ASN1_BIT_STRING_type_new (int type);
#define ASN1_BIT_STRING_new() ASN1_BIT_STRING_type_new(V_ASN1_BIT_STRING)

void ASN1_BIT_STRING_free (ASN1_BIT_STRING *a);

int i2d_ASN1_BIT_STRING (
	ASN1_BIT_STRING *a, BYTE **pp);
ASN1_BIT_STRING* d2i_ASN1_BIT_STRING (
	ASN1_BIT_STRING **a, BYTE **pp, long length);

#define tag_ASN1_BIT_STRING (V_ASN1_UNIVERSAL | V_ASN1_BIT_STRING)


/*
 * ASN1_OCTET_STRING.
 */
#define ASN1_OCTET_STRING         ASN1_BIT_STRING

#define ASN1_OCTET_STRING_new()   ASN1_BIT_STRING_type_new(V_ASN1_OCTET_STRING)
#define ASN1_OCTET_STRING_free(a) ASN1_BIT_STRING_free((a))

int i2d_ASN1_OCTET_STRING (
	ASN1_OCTET_STRING *a, BYTE **pp);
ASN1_OCTET_STRING* d2i_ASN1_OCTET_STRING (
	ASN1_OCTET_STRING **a, BYTE **pp, long length);

#define tag_ASN1_OCTET_STRING (V_ASN1_UNIVERSAL | V_ASN1_OCTET_STRING)


/*
 * ASN1_OBJECT.
 */
#define ASN1_OBJECT         ASN1_BIT_STRING

#define ASN1_OBJECT_new()   ASN1_BIT_STRING_type_new(V_ASN1_OBJECT)
#define ASN1_OBJECT_free(a) ASN1_BIT_STRING_free((a))

int i2d_ASN1_OBJECT (
	ASN1_OBJECT *a, BYTE **pp);
ASN1_OBJECT* d2i_ASN1_OBJECT (
	ASN1_OCTET_STRING **a, BYTE **pp, long length);

#define tag_ASN1_OBJECT (V_ASN1_UNIVERSAL | V_ASN1_OBJECT)


/*
 * ASN1_SIGNED_NUMBER (INTEGER || ENUMERATED).
 */
#define ASN1_SIGNED_NUMBER             ASN1_BIT_STRING

#define ASN1_SIGNED_NUMBER_type_new(t) ASN1_BIT_STRING_type_new((t))
#define ASN1_SIGNED_NUMBER_free(a)     ASN1_BIT_STRING_free((a))

int i2d_ASN1_SIGNED_NUMBER (
	ASN1_SIGNED_NUMBER *a, BYTE **pp);
ASN1_SIGNED_NUMBER* d2i_ASN1_SIGNED_NUMBER (
	ASN1_SIGNED_NUMBER **a, BYTE **pp, long length);

int ASN1_SIGNED_NUMBER_get (ASN1_SIGNED_NUMBER *a, long *v);
int ASN1_SIGNED_NUMBER_set (ASN1_SIGNED_NUMBER *a, long  v);


/*
 * ASN1_INTEGER.
 */
#define ASN1_INTEGER         ASN1_SIGNED_NUMBER

#define ASN1_INTEGER_new()   ASN1_SIGNED_NUMBER_type_new(V_ASN1_INTEGER)
#define ASN1_INTEGER_free(a) ASN1_SIGNED_NUMBER_free((a))

#define i2d_ASN1_INTEGER(a, pp)    i2d_ASN1_SIGNED_NUMBER((a), (pp))
#define d2i_ASN1_INTEGER(a, pp, l) d2i_ASN1_SIGNED_NUMBER((a), (pp), (l))

#define tag_ASN1_INTEGER (V_ASN1_UNIVERSAL | V_ASN1_INTEGER)

#define ASN1_INTEGER_get(a, v) ASN1_SIGNED_NUMBER_get((a), (v))
#define ASN1_INTEGER_set(a, v) ASN1_SIGNED_NUMBER_set((a), (v))


/*
 * ASN1_ENUMERATED.
 */
#define ASN1_ENUMERATED         ASN1_SIGNED_NUMBER

#define ASN1_ENUMERATED_new()   ASN1_SIGNED_NUMBER_type_new(V_ASN1_ENUMERATED)
#define ASN1_ENUMERATED_free(a) ASN1_SIGNED_NUMBER_free((a))

#define i2d_ASN1_ENUMERATED(a, pp)    i2d_ASN1_SIGNED_NUMBER((a), (pp))
#define d2i_ASN1_ENUMERATED(a, pp, l) d2i_ASN1_SIGNED_NUMBER((a), (pp), (l))

#define tag_ASN1_ENUMERATED (V_ASN1_UNIVERSAL | V_ASN1_ENUMERATED)

#define ASN1_ENUMERATED_get(a, v) ASN1_SIGNED_NUMBER_get((a), (v))
#define ASN1_ENUMERATED_set(a, v) ASN1_SIGNED_NUMBER_set((a), (v))


/*
 * ASN1_COLLECTION (SEQUENCE || SET).
 */
typedef struct asn1_collection_st {
	unsigned int count;
	unsigned int limit;
	char**       values;
} ASN1_COLLECTION;

ASN1_COLLECTION* ASN1_COLLECTION_new (void);
void ASN1_COLLECTION_free (ASN1_COLLECTION *a, void (*destroy)());

int i2d_ASN1_COLLECTION (
	ASN1_COLLECTION *a, BYTE **pp,
	ASN1_i2d_t *i2d, int xtag, int xclass);
ASN1_COLLECTION* d2i_ASN1_COLLECTION (
	ASN1_COLLECTION **a, BYTE **pp, long length,
	ASN1_d2i_t *d2i, int xtag, int xclass);

int ASN1_COLLECTION_insert (
	ASN1_COLLECTION *a, char *value, unsigned int pos);
char* ASN1_COLLECTION_remove (
	ASN1_COLLECTION *a, unsigned int pos);

#define ASN1_COLLECTION_count(a)    ((a)->count)
#define ASN1_COLLECTION_value(a, i) ((a)->values[i])


/*
 * ASN1_SEQUENCE.
 */
#define ASN1_SEQUENCE            ASN1_COLLECTION

#define ASN1_SEQUENCE_new()      ASN1_COLLECTION_new()
#define ASN1_SEQUENCE_free(a, f) ASN1_COLLECTION_free((a), (f))

#define i2d_ASN1_SEQUENCE(a, pp)    i2d_ASN1_COLLECTION((a), (pp))
#define d2i_ASN1_SEQUENCE(a, pp, l) d2i_ASN1_COLLECTION((a), (pp), (l))

#define tag_ASN1_SEQUENCE \
	(V_ASN1_UNIVERSAL | V_ASN1_CONSTRUCTED | V_ASN1_SEQUENCE)

#define ASN1_SEQUENCE_insert(a, v, i) ASN1_COLLECTION_insert((a), (v), (i))
#define ASN1_SEQUENCE_remove(a, i)    ASN1_COLLECTION_remove((a), (i))

#define ASN1_SEQUENCE_count(a)        ASN1_COLLECTION_count((a))
#define ASN1_SEQUENCE_value(a, i)     ASN1_COLLECTION_value((a), (i))


/*
 * ASN1_SET.
 */
#define ASN1_SET         ASN1_COLLECTION

#define ASN1_SET_new()      ASN1_COLLECTION_new()
#define ASN1_SET_free(a, f) ASN1_COLLECTION_free((a), (f))

#define i2d_ASN1_SET(a, pp)    i2d_ASN1_COLLECTION((a), (pp))
#define d2i_ASN1_SET(a, pp, l) d2i_ASN1_COLLECTION((a), (pp), (l))

#define tag_ASN1_SET \
	(V_ASN1_UNIVERSAL | V_ASN1_CONSTRUCTED | V_ASN1_SET)

#define ASN1_SET_insert(a, v, i) ASN1_COLLECTION_insert((a), (v), (i))
#define ASN1_SET_remove(a, i)    ASN1_COLLECTION_remove((a), (i))

#define ASN1_SET_count(a)        ASN1_COLLECTION_count((a))
#define ASN1_SET_value(a, i)     ASN1_COLLECTION_value((a), (i))


/*========================================================================
 *
 * The End.
 *
 *======================================================================*/
#ifdef __cplusplus
}
#endif

#endif /* !_LDAPBER_LDAPASN_H */

