
#include <sal/types.h>
#include <osl/file.h>
#include <string.h>
#include <osl/file.hxx>
#include <rtl/alloc.h>
#include <rtl/string.hxx>
#include <rtl/strbuf.hxx>
#include <rtl/ustring.hxx>

#ifndef INCLUDED_SVTOOLS_PATHOPTIONS_HXX
#include <svtools/pathoptions.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_USEROPTIONS_HXX
#include <svtools/useroptions.hxx>
#endif

#if defined(WIN) || defined(WNT)
#undef __LITTLEENDIAN 
#define __LITTLEENDIAN 1
#else
#include <tools/svconf.h>
#endif

#include <stdio.h>

using namespace rtl;
using namespace osl;

#include "thlookup.hxx"


ThesLookup::ThesLookup(const ::rtl::OUString & idxpath, const ::rtl::OUString& datpath)
{
    nw = 0;
    if (thInitialize(idxpath, datpath) != 1) {
        fprintf(stderr,"Error - can't open %s or %s\n",OU2A(idxpath), OU2A(datpath));
        fflush(stderr);
        /* did not initialize properly - throw exception? */
    }
}


ThesLookup::~ThesLookup()
{
    if (thCleanup() != 1) {
        /* did not cleanup properly - throw exception? */
    }
}


sal_Int32 ThesLookup::thInitialize(const ::rtl::OUString & idxpath, const ::rtl::OUString & datpath)
{
    ::osl::FileBase::RC rc;

    /* first open the index file and load the index */
    ::osl::File * pifile = new File(idxpath);
    rc = pifile->open(OpenFlag_Read);
    if (rc != FileBase::E_None) {
        delete (pifile);
        pifile = NULL;
        return 0;
    } 
        
    sal_Char * wrd;
    wrd = (sal_Char *)rtl_allocateZeroMemory(MAX_WD_LEN);

    sal_Int32 len = readLine(pifile,wrd,MAX_WD_LEN);
    while (len > 0)
    { 
        sal_Int32 np = rtl_str_indexOfChar(wrd,',');          
        *(wrd+np) = '\0';
        list[nw] = (sal_Char *)rtl_allocateZeroMemory(np+1);
        rtl_copyMemory((list[nw]),wrd,np);
        offst[nw] = rtl_ustr_toInt32(A2OU((wrd+np+1)),10);
        nw++;
        len = readLine(pifile,wrd,MAX_WD_LEN);
    }

    rtl_freeMemory((void *)wrd);
    pifile->close();
    delete (pifile);

    /* next open the data file */
    pdfile = new File(datpath);
    rc = pdfile->open(OpenFlag_Read);
    if (rc != FileBase::E_None) {
        delete (pdfile);
        pdfile = NULL;
        return 0;
    } 
        
    return 1;        
}


sal_Int32 ThesLookup::thCleanup()
{
    /* first close the data file */
    if (pdfile) {
        pdfile->close();
        delete (pdfile);
    }

    /* now free up all the allocated strings on the list */
    for (sal_Int32 i=0; i < nw; i++) 
    {
        if (list[i]) {
            rtl_freeMemory(list[i]);
            list[i] = 0;
        }
    }

    nw = 0;
    return 1;
}


/* 
lookup text in index and return synonym count and pointer to an 
array of sal_Char * (i.e the synonyms)

note: calling routine should call rtl_freeMemory(*lsyns) 
if non-zero. do *not* free any of the individual synonym sal_Char *
*/

sal_Int32 ThesLookup::Lookup(const sal_Char * pText, sal_Int32 len, sal_Char*** lsyn)
{ 

    // handle the case of missing file or file related errors
    if (! pdfile) return 0;

    sal_uInt64 offset = 0;
    sal_uInt16 ns = 0;
 
    *lsyn = 0;

    /* copy search word and make sure null terminated */
    sal_Char * wrd = (sal_Char *) rtl_allocateZeroMemory(len+1);
    rtl_copyMemory(wrd,pText,len);
  
    /* find it in the list */
    sal_Int32 idx = binsearch(wrd,list,nw);
    rtl_freeMemory(wrd);  
    if (idx < 0) return 0;

    /* now grab the offset and load up the number of synonyms */
    /* and the indexes to the synonyms */
    offset = (sal_uInt64) offst[idx];

    if (pdfile->setPos(Pos_Absolut,offset) != FileBase::E_None) return 0;

    sal_uInt64 bq;
    sal_uInt64 br;
    sal_Char * buf;
      
    bq = sizeof(sal_uInt16);
    buf  = (sal_Char *) rtl_allocateMemory( (sal_uInt32) bq);
    if (pdfile->read(buf,bq,br) != FileBase::E_None) {
        rtl_freeMemory(buf);
        return 0;
    }
    if (bq != br)  {
        rtl_freeMemory(buf);
        return 0;
    }
    end_cpy((sal_Char *)&ns,buf,1);
    rtl_freeMemory(buf);

    offset = offset + sizeof(sal_uInt16);
    if (pdfile->setPos(Pos_Absolut,offset) != FileBase::E_None) return 0;

    if (ns > MAX_WDS) ns = MAX_WDS - 1;
    bq = ns * sizeof(sal_uInt16);
    buf = (sal_Char *) rtl_allocateMemory( (sal_uInt32) bq);
    if (pdfile->read(buf,bq,br) != FileBase::E_None) {
        rtl_freeMemory(buf);
        return 0;
    }
    if (bq != br) {
        rtl_freeMemory(buf);
        return 0;
    }

    end_cpy((sal_Char *)ilst,buf,ns);
    rtl_freeMemory(buf);

    sal_Char ** syns = (sal_Char **) rtl_allocateZeroMemory(
                                            ns * sizeof(sal_Char *) );
    for (sal_Int32 i=0; i< ns; i++)
    {
        syns[i] = list[ilst[i]];
    }   
    *lsyn = syns;

    return ns;
}


/* 
  read a line of text from a text file stripping
  off the line terminator and replacing it with
  a null string terminator.

  returns:  -1 on error or the number of characters in
             in the returning string

  A maximum of nc characters will be returned
*/
sal_Int32 ThesLookup::readLine(File * pf, sal_Char * buf, sal_Int32 nc)
{
    sal_uInt64 nb = 0;
    sal_uInt64 nr;
    FileBase::RC rc;
  
    *buf = 0;
    do {
        rc = pf->read(buf+nb,1,nr);
        if ( rc != FileBase::E_None ) return -1; 
        if ( nr  == 0 ) {
            *(buf+nb)= '\0';
            return (sal_Int32) nb;
        }
        nb = nb + nr;
        if (nb == (sal_uInt64)(nc - 1)) {
            *(buf+nb) = '\0';
            return (sal_Int32) nb;
        }
    } while ( *(buf+(nb-1)) != '\n' );
    *(buf+(nb-1)) = '\0';
    return (sal_Int32) nb;
}

/* 
  performs a binary search on null terminated character
  strings

  returns: -1 on not found
           index of wrd in the list[]
*/
sal_Int32 ThesLookup::binsearch(sal_Char * sw, sal_Char* list[], int nlst) 
{
    sal_Int32 lp, up, mp, j, indx;
    lp = 0;
    up = nlst-1;
    indx = -1;
    if (rtl_str_compare(sw,list[lp]) < 0) return -1;
    if (rtl_str_compare(sw,list[up]) > 0) return -1;
    while (indx < 0 ) {
        mp = (sal_Int32)((lp+up) >> 1);
        j = rtl_str_compare(sw,list[mp]);
        if ( j > 0) {
            lp = mp + 1;
        } else if (j < 0 ) {
            up = mp - 1;
        } else {
            indx = mp;
        }
        if (lp > up) return -1;      
    }
    return indx;
}


/*
   performs a special memcpy of a string of unsigned shorts
   which does endian swapping on little endian systems to
   create big endian versions of the unsigned short data
*/
void ThesLookup::end_cpy(sal_Char * q, sal_Char * p, sal_Int32 num_u16)
{
#if defined(__LITTLEENDIAN)
    sal_Char * s;
    sal_Char * t;
    sal_Int32 i;
    s = p + 1;
    t = q + 1;
    for (i=0;i<num_u16;i++) {
        *q = *s; *t = *p;
        p+=2; q+=2; s+=2; t+=2;
    }
#else 
    rtl_copyMemory(q,p,(num_u16 * sizeof(sal_uInt16)));
#endif
}





