#!/usr/bin/awk -f

##
## Package: lingucomponent-tools
##
## Copyright (C) 2002, 2003 Pavel Jank (Pavel@Janik.cz)
##
## This file is licensed under GNU LGPL and SISSL license.
##

#
# This file converts TeX hyphenation file into .dic file for OpenOffice.org.
#

# This function prints the header line of the dic file.
# Be sure to change the line to match your language.

function Hyphenation_header () {
  print "ISO8859-2"
}

# This function replaces TeX's transcription of characters with diacritical
# marks to their 8bit variants. Current version support Czech and Slovak
# characters.

function TeX_replace_transcription () {
  gsub("\\\\'a", "");
  gsub("\\\\'e", "");
  gsub("\\\\'i", "");
  gsub("\\\\'y", "");
  gsub("\\\\'o", "");
  gsub("\\\\'u", "");

  gsub("\\\\'r", "");

  gsub("\\\\v e", "");
  gsub("\\\\v s", "");
  gsub("\\\\v c", "");
  gsub("\\\\v r", "");
  gsub("\\\\v z", "");
  gsub("\\\\v d", "");
  gsub("\\\\v t", "");
  gsub("\\\\v n", "");
  gsub("\\\\v l", "");

  gsub("\\\\r u", "");

  gsub("\\\\\"a", "");

  gsub("\\\\\\^o", "");
}

BEGIN {
  Hyphenation_header();
}

{
  if ($0 ~ "^}")
    PRINTING=0;

  if (PRINTING == 1 && $0 !~ "^ *%.*$") {
    TeX_replace_transcription();
    print;
  }

  if ($0 ~ "^\\\\patterns")
    PRINTING=1;
}

END {
}
