#!/usr/bin/awk -f

##
## Package: lingucomponent-tools
##
## Copyright (C) 2002, 2003 Pavel Jank (Pavel@Janik.cz)
##
## This file is licensed under GNU LGPL and SISSL license.
##

#
# This file converts ispell .DIC file into .dic file for myspell so it
# can be used as dictionary file for OpenOffice.org.
#

BEGIN {
   FS = "/";
}

# This function sorts letters in the STRING alphabetically.

function SortString(STRING) {
  TMP="";
  for (i=1; i<=length(STRING); i++)
    ARRAY[i]=substr(STRING,i,1);
  n=asort(ARRAY);
  for (i=1; i<=n; i++)
    if (index(TMP,ARRAY[i])==0 && ARRAY[i] != " ")
      TMP=TMP ARRAY[i];
  delete ARRAY;
  return TMP;
}

{
  if ($2 != "") {
    for(i=1; i<=length($2); i++) {
      FLAG=substr($2,i,1);
      if (index (WORDS[$1], FLAG) == 0)
	WORDS[$1]=WORDS[$1] FLAG;
    }
  }
  else
    WORDS[$1]=" ";
}

END {
  # Print how many words we have in our dictionary.
  for (TEMP in WORDS) COUNT++;
  print COUNT;

  for (TEMP in WORDS) {
    if (WORDS[TEMP] != "" && WORDS[TEMP] != " ")
      # We print flags alphabetically sorted here.
      print TEMP "/" SortString(WORDS[TEMP]);
    else
      print TEMP;
  }
}
