import com.sun.star.bridge.XUnoUrlResolver;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.uno.XComponentContext;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.container.XSet;
import org.openoffice.XToDo;


public class Test {
    public static void main(String args[]) {
        try {
            if ( args.length < 2 ) {
                System.out.println(
                "usage: java -classpath .;" +
                "<Office path>/program/classes/jurt.jar;" +
                "<Office path>/program/classes/ridl.jar;" +
                "<Office path>/program/classes/sandbox.jar;" +
                "<Office path>/program/classes/unoil.jar;" +
                "<Office path>/program/classes/juh.jar " +
                "DocumentLoader \"<connection>\" \"<ToDo URL>\"" );
                System.out.println( "\ne.g.:" );
                System.out.println(
                "java -classpath .;d:/office60/program/classes/jurt.jar;" +
                "d:/office60/program/classes/ridl.jar;" +
                "d:/office60/program/classes/sandbox.jar;" +
                "d:/office60/program/classes/unoil.jar; " +
                "d:/office60/program/classes/juh.jar " +
                "DocumentLoader \"uno:socket,host=localhost,port=8100;urp;" +
                "StarOffice.ServiceManager\" " +
                "\"file:///d:/cvs/api/odk/examples/java/" +
                "ToDo/ToDo.sxc\"" );
                System.exit(1);
            }
            
      /* Bootstraps a component context with the jurt base components
         registered. Component context to be granted to a component for running.
         Arbitrary values can be retrieved from the context. */
            XComponentContext xcomponentcontext =
            com.sun.star.comp.helper.Bootstrap.createInitialComponentContext(
            null );
            
      /* Gets the service manager instance to be used (or null). This method has
         been added for convenience, because the service manager is a often used
         object. */
            XMultiComponentFactory xmulticomponentfactory =
            xcomponentcontext.getServiceManager();
            
            // NOTE: This is special code, that is only necessary, when connecting to
            //       a Sun ONE Webtop !
            // Connection: "uno:portal,host=<portalhost>,port=<port>,service=soffice,user=<username>,password=<passwd>;urp;StarOffice.ServiceManager"
            if ( args[ 0 ].regionMatches( 4, "portal", 0, 6 ) ) {
                com.sun.star.loader.XImplementationLoader
                ximplementationloader =
                ( com.sun.star.loader.XImplementationLoader )
                UnoRuntime.queryInterface(
                com.sun.star.loader.XImplementationLoader.class,
                xmulticomponentfactory.createInstanceWithContext(
                "com.sun.star.loader.Java", xcomponentcontext ) );
                com.sun.star.container.XSet xset = (com.sun.star.container.XSet)
                UnoRuntime.queryInterface( com.sun.star.container.XSet.class,
                xmulticomponentfactory );
                
                com.sun.star.lang.XSingleServiceFactory xsingleservicefactory =
                ( com.sun.star.lang.XSingleServiceFactory )
                UnoRuntime.queryInterface(
                com.sun.star.lang.XSingleServiceFactory.class,
                ximplementationloader.activate(
                "com.sun.star.comp.portal_connect.Connector", null, null,
                null ) );
                xset.insert( xsingleservicefactory );
            }
            
      /* Creates an instance of the component UnoUrlResolver which
         supports the services specified by the factory. */
            Object objectUrlResolver =
            xmulticomponentfactory.createInstanceWithContext(
            "com.sun.star.bridge.UnoUrlResolver", xcomponentcontext );
            
            // Create a new url resolver
            XUnoUrlResolver xurlresolver = ( XUnoUrlResolver )
            UnoRuntime.queryInterface( XUnoUrlResolver.class,
            objectUrlResolver );
            
            // Resolves an object that is specified as follow:
            // uno:<connection description>;<protocol description>;<initial object name>
            Object objectInitial = xurlresolver.resolve( args[ 0 ] );
            
            // Create a service manager from the initial object
            xmulticomponentfactory = ( XMultiComponentFactory )
            UnoRuntime.queryInterface( XMultiComponentFactory.class,
            objectInitial );
            
            // Query for the XPropertySet interface.
            XPropertySet xpropertysetMultiComponentFactory = ( XPropertySet )
            UnoRuntime.queryInterface( XPropertySet.class,
            xmulticomponentfactory );
            
            // Get the default context from the office server.
            Object objectDefaultContext =
            xpropertysetMultiComponentFactory.getPropertyValue(
            "DefaultContext" );
            
            // Query for the interface XComponentContext.
            xcomponentcontext = ( XComponentContext ) UnoRuntime.queryInterface(
            XComponentContext.class, objectDefaultContext );
            
            /* A desktop environment contains tasks with one or more
               frames in which components can be loaded. Desktop is the
               environment for components which can instanciate within
               frames. */
            XComponentLoader xcomponentloader = ( XComponentLoader )
            UnoRuntime.queryInterface( XComponentLoader.class,
            xmulticomponentfactory.createInstanceWithContext(
            "com.sun.star.frame.Desktop", xcomponentcontext ) );
            
            // Load the Calc document, which will be automaticly displayed
            XComponent xcomponent = xcomponentloader.loadComponentFromURL(
            args[ 1 ], "_blank", 0,
            new PropertyValue[0] );
            
            // Querying for the interface XSpreadsheetDocument on XComponent
            XSpreadsheetDocument xspreadsheetdocument = ( XSpreadsheetDocument )
            UnoRuntime.queryInterface( XSpreadsheetDocument.class, xcomponent );
            
            // Querying for the interface XSet on the XMultiComponentFactory
            XSet xsetMultiComponentFactory = ( XSet ) UnoRuntime.queryInterface(
            XSet.class, xmulticomponentfactory );
            
            // Getting the XSingleServiceFactory for the ToDo component
            XSingleServiceFactory xsingleservicefactoryToDo =
            ToDo.__getServiceFactory( "ToDo$_ToDo", ( XMultiServiceFactory )
            UnoRuntime.queryInterface( XMultiServiceFactory.class,
            xmulticomponentfactory ), null );
            
            // Inserting the XSingleServiceFactory into the container
            xsetMultiComponentFactory.insert( xsingleservicefactoryToDo );
            
            // Creating an instance of the ToDo component
            Object objectToDo =
            xmulticomponentfactory.createInstanceWithContext(
            "org.openoffice.ToDo", xcomponentcontext );
            
            if ( objectToDo != null ) {
                // Querying for the interface XToDo
                XToDo xToDo = ( XToDo )
                UnoRuntime.queryInterface( XToDo.class, objectToDo );
                
                // Recalculate the spreadsheet
                xToDo.recalc( xspreadsheetdocument );
            }
            
            // Removing the XSingleServiceFactory of ToDo from the container
            xsetMultiComponentFactory.remove( xsingleservicefactoryToDo );
            
            System.exit(0);
        }
        catch( Exception exception ) {
            System.err.println( exception );
        }
    }
}
