/*************************************************************************
 *
 *  $RCSfile: SCalcDemo.java,v $
 *
 *  $Revision: 1.2.18.1 $
 *
 *  last change: $Author: jsc $ $Date: 2003/02/17 10:18:51 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


package com.sun.star.comp.demo;


import com.sun.star.bridge.XUnoUrlResolver;


import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XTypeProvider;

import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XNamingService;
import com.sun.star.lib.uno.helper.WeakBase;

// staroffice interfaces to provide desktop and componentloader
// and components i.e. spreadsheets, writerdocs etc.
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XComponentLoader;

import com.sun.star.frame.XDesktop;

import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.container.XIndexAccess;
import com.sun.star.table.XCellRange;
import com.sun.star.sheet.XCellRangeAddressable;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.table.XTableChartsSupplier;
import com.sun.star.table.XTableCharts;
import com.sun.star.container.XNameAccess;
import com.sun.star.document.XEmbeddedObjectSupplier;
import com.sun.star.chart.XChartDocument;
import com.sun.star.chart.XDiagram;
import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.XComponent;
import com.sun.star.beans.PropertyValue;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.table.XCell;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;

import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.table.XTableChart;

import com.sun.star.bridge.XBridgeFactory;
import com.sun.star.bridge.XBridge;

import com.sun.star.awt.Rectangle;

public class SCalcDemo extends WeakBase implements XTypeProvider, XServiceInfo, XInitialization {
	static private final boolean DEBUG = true;

	static final String __serviceName = "com.sun.star.demo.SCalcDemo";

	static final String data[][] = {
		new String[] {null, null, "JAN", null, "FEB", null, "MAR", null, "APR", null, "MAI", null, "JUN", null, 
					  "JUL", null, "AUG", null, "SEP", null, "OCT", null, "NOV", null, "DEC", null, "SUM", null},

		new String[] {"Smith", null, "42","V", "58.9","V", "-66.5","V", 
					  "43.4","V", "44.5","V",  "45.3","V", "-67.3","V", 
					  "30.5","V", "23.2","V",  "-97.3","V",  "22.4","V", 
					  "23.5","V",  "=SUM(B2:M2)", ""},
	
		new String[] {"Smith2", null, "42","V", "58.9","V", "-66.5","V", 
					  "43.4","V","44.5","V","45.3","V","-67.3","V",
					  "30.5","V","23.2","V","-97.3","V","22.4","V",
					  "23.5","V","=SUM(B2:M2)",""},
    
		new String[] {"Jones", null, "21","V", "40.9","V","-57.5","V",
					  "-23.4","V","34.5","V","59.3","V","27.3","V",
					  "-38.5","V","43.2","V","57.3","V","25.4","V",
					  "28.5","V","=SUM(B3:M3)",""},
	
		new String[]{"Brown",null,"31.45","V","-20.9","V","-117.5","V",
					 "23.4","V","-114.5","V","115.3","V","-171.3","V",
					 "89.5","V","41.2","V","71.3","V","25.4","V",
					 "38.5","V", "=SUM(A4:L4)",""}
	}; 


	static public void blabla(XMultiServiceFactory xMSF) throws com.sun.star.uno.Exception {
		XSpreadsheetDocument myDoc = null;
		XCell oCell = null;
		

		//Calc
		Object  oInterface = xMSF.createInstance("com.sun.star.frame.Desktop");
		XDesktop oDesktop = ( XDesktop ) UnoRuntime.queryInterface( XDesktop.class, oInterface );
		XComponentLoader oCLoader = ( XComponentLoader ) UnoRuntime.queryInterface(
            XComponentLoader.class, oDesktop );
		PropertyValue [] szEmptyArgs = new PropertyValue [0];
		String doc = "private:factory/scalc";
		XComponent aDoc = oCLoader.loadComponentFromURL(doc, "_blank", 0, szEmptyArgs );
		XSpreadsheetDocument oDoc = (XSpreadsheetDocument) UnoRuntime.queryInterface(
            XSpreadsheetDocument.class, aDoc);

    
		XSpreadsheets oSheets = oDoc.getSheets() ;
		XIndexAccess oIndexSheets = (XIndexAccess) UnoRuntime.queryInterface(XIndexAccess.class, oSheets);
		XSpreadsheet oSheet = (XSpreadsheet) UnoRuntime.queryInterface(
            XSpreadsheet.class, oIndexSheets.getByIndex(0));
	
	
		// fill in data
		for(int i = 0; i < data.length; ++ i)
			createRow(oSheet, i, data[i]);


		// insert a chart
    
		Rectangle oRect = new Rectangle();
		oRect.X = 500;
		oRect.Y = 3000;
		oRect.Width = 25000;
		oRect.Height = 11000;
    
		XCellRange oRange = (XCellRange)UnoRuntime.queryInterface(XCellRange.class, oSheet);
		XCellRange myRange = oRange.getCellRangeByName("A1:n4");
		XCellRangeAddressable oRangeAddr = (XCellRangeAddressable)UnoRuntime.queryInterface(
            XCellRangeAddressable.class, myRange);
		CellRangeAddress myAddr = oRangeAddr.getRangeAddress();

		CellRangeAddress[] oAddr = new CellRangeAddress[1];
		oAddr[0] = myAddr;
		XTableChartsSupplier oSupp = (XTableChartsSupplier)UnoRuntime.queryInterface(
            XTableChartsSupplier.class, oSheet);
    
		XTableChart oChart = null;
    
		System.out.println("Insert Chart");

		XTableCharts oCharts = oSupp.getCharts();
		oCharts.addNewByName("Example", oRect, oAddr, true, true);
	
		// Change some of the diagramm properties
		oChart = (XTableChart) UnoRuntime.queryInterface(
            XTableChart.class, ((XNameAccess) UnoRuntime.queryInterface(
                                    XNameAccess.class, oCharts)).getByName("Example"));
		XEmbeddedObjectSupplier oEOS = (XEmbeddedObjectSupplier) UnoRuntime.queryInterface(
            XEmbeddedObjectSupplier.class, oChart);
		Object oInt = oEOS.getEmbeddedObject();
		XChartDocument xChart = (XChartDocument) UnoRuntime.queryInterface(XChartDocument.class,oInt);
		XDiagram oDiag = (XDiagram) xChart.getDiagram();
		System.out.println("Change Diagramm to 3D");
		XPropertySet oCPS = (XPropertySet)UnoRuntime.queryInterface( XPropertySet.class, oDiag );
		oCPS.setPropertyValue("Dim3D", new Boolean(true));
		System.out.println("Change the title");
		XPropertySet oTPS = (XPropertySet)UnoRuntime.queryInterface(
            XPropertySet.class, xChart.getTitle() );
		oTPS.setPropertyValue("String","The new title");
	}

	private static void createRow(XSpreadsheet oSheet, int row, String args[])
            throws com.sun.star.lang.IndexOutOfBoundsException {
		for(int i = 0; i < args.length / 2; ++ i) {
			if(args[2 * i] != null) {
				if(args[2 * i + 1] == null)
					insertIntoCell(i, row, args[2 * i], oSheet);
				else
					insertIntoCell2(i, row, args[2 * i], oSheet, args[2 * i + 1]);
			}
		}
	}

  
	public static void insertIntoCell(int CellX, int CellY, String theText, XSpreadsheet TT1)
        throws com.sun.star.lang.IndexOutOfBoundsException {
 
		XCell oCell = TT1.getCellByPosition(CellX, CellY);
		XText oTableText = (XText) UnoRuntime.queryInterface(
            XText.class, TT1.getCellByPosition(CellX, CellY));
    
		//create a cursor object
		XTextCursor oC = oTableText.createTextCursor();
    
		XPropertySet oTPS = (XPropertySet)UnoRuntime.queryInterface( XPropertySet.class, oC );
		XPropertySet oCPS = (XPropertySet)UnoRuntime.queryInterface( XPropertySet.class, oCell );

		try {    
			oCPS.setPropertyValue("IsCellBackgroundTransparent", new Boolean(false));
			oCPS.setPropertyValue("CellBackColor",new Integer(6710932));
			oTPS.setPropertyValue("CharColor",new Integer(16777215));
      
		} catch (Exception e) {
     
			System.out.println("Can't change colors (insertIntoCell) " + e);     
     
		}

    
		//inserting some Text
		oTableText.insertString( oC, theText, true );
  
	} // end of insertIntoCell
 
	public static void insertIntoCell2(int CellX, int CellY, String theValue, XSpreadsheet TT1, String flag)
        throws com.sun.star.lang.IndexOutOfBoundsException {
 
		XCell oCell = TT1.getCellByPosition(CellX, CellY);
    
		//create a cursor object
    
		XPropertySet oCPS = (XPropertySet)UnoRuntime.queryInterface( XPropertySet.class, oCell );

		try {    
			oCPS.setPropertyValue("IsCellBackgroundTransparent", new Boolean(false));
			oCPS.setPropertyValue("CellBackColor",new Integer(13421823));
		} catch (Exception e) {
     
			System.out.println("Can't change colors (insertIntoCell2) " + e);
     
		}

    
		//inserting some Text
		if (flag.equals("V")) {oCell.setValue((new Float(theValue)).floatValue());}
		else {oCell.setFormula(theValue);}
  
	} // end of insertIntoCell  

	private XMultiServiceFactory _xMultiServiceFactory;
		
	public SCalcDemo(XMultiServiceFactory xMultiServiceFactory)
        throws com.sun.star.uno.Exception {
		if(DEBUG) System.err.println("##### " + getClass().getName() + ".<init>:" + xMultiServiceFactory);
		
		_xMultiServiceFactory = xMultiServiceFactory;

		blabla(_xMultiServiceFactory);
	}
	
	// XInitialization
	public void initialize(Object[] aArguments)
        throws com.sun.star.uno.Exception, com.sun.star.uno.RuntimeException {
		if(DEBUG) {
			System.err.println("##### " + getClass().getName() + ".initialize;");
			
			for(int i = 0; i < aArguments.length; ++ i)
				System.err.println("##### " + aArguments[i]);
		}
		
		_xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(
            XMultiServiceFactory.class, aArguments[0]);
		
		if(_xMultiServiceFactory == null) {
			XNamingService xNamingService = (XNamingService)UnoRuntime.queryInterface(
                XNamingService.class, aArguments[0]);
			Object smgr = xNamingService.getRegisteredObject("StarOffice.ServiceManager");
			_xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(
                XMultiServiceFactory.class, smgr);
		}
	}
	
	// XServiceInfo
	public String getImplementationName() throws com.sun.star.uno.RuntimeException {
		return getClass().getName();
	}
	
	public boolean supportsService(String serviceName) throws com.sun.star.uno.RuntimeException {
		return __serviceName.equals(serviceName);
	}
	
	public String[] getSupportedServiceNames() throws com.sun.star.uno.RuntimeException {
		return new String[] {__serviceName};
	}
}
