/*************************************************************************
 *
 *  $RCSfile: treeopt.cxx,v $
 *
 *  $Revision: 1.21 $
 *
 *  last change: $Author: os $ $Date: 2002/06/25 07:57:48 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef PRECOMPILED
#include "ofapch.hxx"
#endif

#pragma hdrstop

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_LINGUISTIC2_XDICTIONARYLIST_HPP_
#include <com/sun/star/linguistic2/XDictionaryList.hpp>
#endif

#ifndef _SFX_HRC //autogen
#include <sfx2/sfx.hrc>
#endif
#ifndef _TOOLS_RCID_H
#include <tools/rcid.h>
#endif
#include "fontsubs.hxx"
#include "app.hxx"
#include "app.hrc"
#include <resid.hxx>

#include <comphelper/processfactory.hxx>

#ifndef _UNO_LINGU_HXX
#include <svx/unolingu.hxx>
#endif
#ifndef _SVX_DIALOGS_HRC //autogen
#include <svx/dialogs.hrc>
#endif
#ifndef _SFXMODULE_HXX //autogen
#include <sfx2/module.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _XDEF_HXX //autogen
#include <svx/xdef.hxx>
#endif
#ifndef _SVX_XFLCLIT_HXX //autogen
#include <svx/xflclit.hxx>
#endif
#ifndef _XPOOL_HXX //autogen
#include <svx/xpool.hxx>
#endif
#ifndef _SVX_TAB_AREA_HXX //autogen
#include <svx/tabarea.hxx>
#endif
#ifndef _OFF_OFAITEM_HXX //autogen
#include <ofaitem.hxx>
#endif
#ifndef _SFXDISPATCH_HXX
#include <sfx2/dispatch.hxx>
#endif
#ifndef _SV_WAITOBJ_HXX //autogen
#include <vcl/waitobj.hxx>
#endif
#ifndef _SFXSLSTITM_HXX //autogen
#include <svtools/slstitm.hxx>
#endif
#include <sfx2/viewfrm.hxx>
#ifndef INCLUDED_SVTOOLS_VIEWOPTIONS_HXX
#include <svtools/viewoptions.hxx>
#endif

#include <treeopt.hxx>
#include <treeopt.hrc>

using namespace ::rtl;
using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::linguistic2;

#define C2U(cChar) OUString::createFromAscii(cChar)

#define HINT_TIMEOUT			200
#define COLORPAGE_UNKNOWN		((sal_uInt16)0xFFFF)

sal_uInt16 	OfaTreeOptionsDialog::nLastDialogPageId = USHRT_MAX;

// some stuff for easier changes for SvtViewOptions
static const sal_Char*		pViewOptDataName = "page data";
#define VIEWOPT_DATANAME	OUString::createFromAscii( pViewOptDataName )

static inline void SetViewOptUserItem( SvtViewOptions& rOpt, const String& rData )
{
	rOpt.SetUserItem( VIEWOPT_DATANAME, makeAny( OUString( rData ) ) );
}

static inline String GetViewOptUserItem( const SvtViewOptions& rOpt )
{
	Any aAny( rOpt.GetUserItem( VIEWOPT_DATANAME ) );
	OUString aUserData;
	aAny >>= aUserData;

	return String( aUserData );
}

/* -----------------11.02.99 09:56-------------------
 *
 * --------------------------------------------------*/
struct OptionsPageInfo
{
	SfxTabPage* 	pPage;
	sal_uInt16			nPageId;
};

struct OptionsGroupInfo
{
	SfxItemSet* pInItemSet;
	SfxItemSet* pOutItemSet;

	SfxShell*	pShell; 	//hier werden die Pages erzeugt
	SfxModule*	pModule;	//hier wird der ItemSet erzeugt
	sal_uInt16		nDialogId;  //Id des ehemaligen Dialogs
	sal_Bool		bLoadError;	//gab es hier schon einen Ladefehler?

	OptionsGroupInfo( SfxShell* pSh, SfxModule* pMod, sal_uInt16 nId ) :
		pInItemSet( NULL ), pOutItemSet( NULL ), pShell( pSh ),
		pModule( pMod ), nDialogId( nId ), bLoadError( sal_False ) {}
	~OptionsGroupInfo() { delete pInItemSet; delete pOutItemSet; }
};

// class ExternBrowserHintBox_Impl ---------------------------------------

class ExternBrowserHintBox_Impl : public ModalDialog
{
private:
	FixedImage	aImage;
	FixedText	aHintFT;
	CheckBox	aDisableCB;
	OKButton	aOKBtn;

public:
	ExternBrowserHintBox_Impl( Window* pParent );

	sal_Bool		IsHintDisabled() const { return aDisableCB.IsChecked(); }
};

// -----------------------------------------------------------------------

ExternBrowserHintBox_Impl::ExternBrowserHintBox_Impl( Window* pParent ) :

	ModalDialog( pParent, OffResId( RID_OFADLG_OPTIONS_TREE_HINT ) ),

	aImage		( this, ResId( IMG_HINT ) ),
	aHintFT		( this, ResId( FT_HINT ) ),
	aDisableCB	( this, ResId( CB_DISABLE ) ),
	aOKBtn		( this, ResId( BTN_HINT ) )

{
	FreeResource();

	aImage.SetImage( WarningBox::GetStandardImage() );
}
/* -----------------04.05.99 15:51-------------------
 *
 * --------------------------------------------------*/
sal_Bool    OfaOptionsTreeListBox::Collapse( SvLBoxEntry* pParent )
{
	bInCollapse = sal_True;
	sal_Bool bRet = SvTreeListBox::Collapse(pParent);
	bInCollapse = sal_False;
	return bRet;
}


/* -----------------11.02.99 07:54-------------------
 *
 * --------------------------------------------------*/

OfaTreeOptionsDialog::OfaTreeOptionsDialog( Window* pParent ) :

	SfxModalDialog( pParent, OffResId( RID_OFADLG_OPTIONS_TREE ) ),

	aOkPB			( this, ResId( PB_OK ) ),
	aCancelPB		( this, ResId( PB_CANCEL ) ),
	aHelpPB			( this, ResId( PB_HELP ) ),
	aBackPB			( this, ResId( PB_BACK ) ),
	aTreeLB			( this, ResId( TLB_PAGES ) ),
	aHiddenGB		( this, ResId( FB_BORDER ) ),
	aPageTitleFT	( this, ResId( FT_PAGE_TITLE ) ),
	aLine1FL		( this, ResId( FL_LINE_1 ) ),
	aHelpFT			( this, ResId( FT_HELPTEXT ) ),
	aHelpImg		( this, ResId( IMG_HELP ) ),
	aHelpTextsArr	(		ResId( STR_HELPTEXTS ) ),
	sNotLoadedError	(		ResId( ST_LOAD_ERROR ) ),

	sTitle				( GetText() ),
	pCurrentPageEntry	( NULL ),
	pColorPageItemSet	( NULL ),
	pColorTab			( NULL ),
	nChangeType			( CT_NONE ),
	nUnknownType		( COLORPAGE_UNKNOWN ),
	nUnknownPos			( COLORPAGE_UNKNOWN ),
	bIsAreaTP			( sal_False ),
	bForgetSelection	( sal_False ),
	bExternBrowserActive( sal_False ),
	bImageResized		( sal_False )

{
	Bitmap aRootClosed( ResId( BMP_ROOT_CLOSED ) );
	Bitmap aRootOpened( ResId( BMP_ROOT_OPENED ) );
	aTreeLB.SetNodeBitmaps( aRootClosed, aRootOpened );

	FreeResource();

    ResMgr* pIsoRes = SFX_APP()->GetLabelResManager();
    ResId aImgLstRes(RID_IMGLIST_TREEOPT);
	aImgLstRes.SetRT(RSC_IMAGELIST);
    if(pIsoRes->IsAvailable( aImgLstRes))
        aPageImages = ImageList(ResId( RID_IMGLIST_TREEOPT, pIsoRes));
    aTreeLB.SetHelpId( HID_OFADLG_TREELISTBOX );
	aTreeLB.SetWindowBits( WB_HASBUTTONS | WB_HASBUTTONSATROOT |
						   WB_HASLINES | WB_HASLINESATROOT |
						   WB_CLIPCHILDREN | WB_HSCROLL | WB_FORCE_MAKEVISIBLE );
	aTreeLB.SetSpaceBetweenEntries( 0 );
	aTreeLB.SetSelectionMode( SINGLE_SELECTION );
	aTreeLB.SetExpandedHdl( LINK( this, OfaTreeOptionsDialog, ExpandedHdl_Impl ) );
	aTreeLB.SetSelectHdl( LINK( this, OfaTreeOptionsDialog, ShowPageHdl_Impl ) );
	aBackPB.SetClickHdl( LINK( this, OfaTreeOptionsDialog, BackHdl_Impl ) );
	aOkPB.SetClickHdl( LINK( this, OfaTreeOptionsDialog, OKHdl_Impl ) );

	aHiddenGB.Show();
	aHintTimer.SetTimeout( HINT_TIMEOUT );
	aHintTimer.SetTimeoutHdl( LINK( this, OfaTreeOptionsDialog, HintHdl_Impl ) );
	bExternBrowserActive = FALSE;
}

/* -----------------11.02.99 07:58-------------------
 *
 * --------------------------------------------------*/

OfaTreeOptionsDialog::~OfaTreeOptionsDialog()
{
	SvLBoxEntry* pEntry = aTreeLB.First();
	//erst children
	while(pEntry)
	{
		//wenn Child, dann OptionsPageInfo
		if(aTreeLB.GetParent(pEntry))
		{
			OptionsPageInfo *pPageInfo = (OptionsPageInfo *)pEntry->GetUserData();
			if(pPageInfo->pPage)
			{
				pPageInfo->pPage->FillUserData();
				String aPageData(pPageInfo->pPage->GetUserData());
				if ( aPageData.Len() )
				{
					SvtViewOptions aTabPageOpt( E_TABPAGE, String::CreateFromInt32( pPageInfo->nPageId ) );
					SetViewOptUserItem( aTabPageOpt, aPageData );
				}
				delete pPageInfo->pPage;
			}

			if (pPageInfo->nPageId == RID_SFXPAGE_LINGU)
			{
				// write personal dictionaries
				Reference< XDictionaryList >  xDicList( SvxGetDictionaryList() );
				if (xDicList.is())
				{
					SvxSaveDictionaries( xDicList );
				}
			}

			delete pPageInfo;
		}
		pEntry = aTreeLB.Next(pEntry);
	}
	pEntry = aTreeLB.First();
	//dann parents
	while(pEntry)
	{
		if(!aTreeLB.GetParent(pEntry))
		{
			OptionsGroupInfo *pGroupInfo = (OptionsGroupInfo *)pEntry->GetUserData();
			delete pGroupInfo;
		}
		pEntry = aTreeLB.Next(pEntry);
	}
	delete pColorPageItemSet;

}

/* -----------------11.02.99 08:21-------------------
 *
 * --------------------------------------------------*/
void	OfaTreeOptionsDialog::AddTabPage( sal_uInt16 nId, const String& rPageName,
											sal_uInt16 nGroup )
{
	OptionsPageInfo *pPageInfo = new OptionsPageInfo;
	pPageInfo->pPage = 0;
	pPageInfo->nPageId = nId;

	SvLBoxEntry* pParent = aTreeLB.GetEntry( 0, nGroup );
	DBG_ASSERT(pParent, "Gruppe nicht vorhanden");
	SvLBoxEntry* pEntry = aTreeLB.InsertEntry(rPageName, pParent);
	pEntry->SetUserData(pPageInfo);

}
/* -----------------11.02.99 10:02-------------------
 *	der ItemSet* geht in den Besitz des Dialogs
 * --------------------------------------------------*/
sal_uInt16	OfaTreeOptionsDialog::AddGroup(const String& rGroupName,
										SfxShell* pCreateShell,
										SfxModule* pCreateModule,
										sal_uInt16 nDialogId )
{
	SvLBoxEntry* pEntry = aTreeLB.InsertEntry(rGroupName);
	OptionsGroupInfo* pInfo =
		new OptionsGroupInfo( pCreateShell, pCreateModule, nDialogId );
	pEntry->SetUserData(pInfo);
	sal_uInt16 nRet = 0;
	pEntry = aTreeLB.First();
	while(pEntry)
	{
		if(!aTreeLB.GetParent(pEntry))
			nRet++;
		pEntry = aTreeLB.Next(pEntry);
	}
	return nRet - 1;
}

/* -----------------11.02.99 10:31-------------------
 *
 * --------------------------------------------------*/
IMPL_LINK(OfaTreeOptionsDialog, ShowPageHdl_Impl, SvTreeListBox*, pBox)
{
	SvLBoxEntry* pEntry = pBox->GetCurEntry();
	SvLBoxEntry* pParent = pBox->GetParent(pEntry);
	pBox->EndSelection();
	if(pCurrentPageEntry == pEntry)
		return 0;
	if(pCurrentPageEntry && ((OptionsPageInfo *)pCurrentPageEntry->GetUserData())->pPage->IsVisible())
	{
		OptionsPageInfo *pPageInfo = (OptionsPageInfo *)pCurrentPageEntry->GetUserData();
		OptionsGroupInfo* pGroupInfo = (OptionsGroupInfo *)aTreeLB.GetParent(pCurrentPageEntry)->GetUserData();
		int nLeave = SfxTabPage::LEAVE_PAGE;
		if(RID_SVXPAGE_COLOR != pPageInfo->nPageId &&
				pPageInfo->pPage->HasExchangeSupport())
		{
		   nLeave = pPageInfo->pPage->DeactivatePage(pGroupInfo->pOutItemSet);

		   if ( RID_SVXPAGE_OPT_EXTERN_BROWSER == pPageInfo->nPageId )
		   {
				// Benutzung des externen Browsers an/aus?
				sal_Bool bTemp = sal_False;
				FASTBOOL bOutSet = sal_False;
				const SfxPoolItem* pItem;

				// Im OutSet nach bestimmte Items suchen
				if ( SFX_ITEM_SET == pGroupInfo->pOutItemSet->
					 GetItemState( SID_OPT_EXTBRW_ON, sal_False, &pItem ) )
				{
					DBG_ASSERT( pItem->ISA(SfxBoolItem), "BoolItem erwartet" );
					bTemp = ( (SfxBoolItem*)pItem )->GetValue();
					bOutSet = sal_True;
				}

				if ( !bTemp &&
					 SFX_ITEM_SET == pGroupInfo->pOutItemSet->
					 GetItemState( SID_OPT_EXTBRW_OFF_EXCEPTION, sal_False, &pItem ) )
				{
					DBG_ASSERT( pItem->ISA(SfxStringListItem), "StringListItem erwartet" );
					List* pList = ( (SfxStringListItem*)pItem )->GetList();
					bTemp = ( pList->Count() > 0 );
					bOutSet = sal_True;
				}

				// Im OutSet nichts gefunden? -> dann im InSet suchen
				if ( !bOutSet &&
					 SFX_ITEM_SET == pGroupInfo->pInItemSet->
					 GetItemState( SID_OPT_EXTBRW_ON, sal_False, &pItem ) )
				{
					DBG_ASSERT( pItem->ISA(SfxBoolItem), "BoolItem erwartet" );
					bTemp = ( (SfxBoolItem*)pItem )->GetValue();
				}

				if ( !bTemp && !bOutSet &&
					 SFX_ITEM_SET == pGroupInfo->pInItemSet->
					 GetItemState( SID_OPT_EXTBRW_OFF_EXCEPTION, sal_False, &pItem ) )
				{
					DBG_ASSERT( pItem->ISA(SfxStringListItem), "StringListItem erwartet" );
					List* pList = ( (SfxStringListItem*)pItem )->GetList();
					bTemp = ( pList->Count() > 0 );
				}
				bExternBrowserActive = bTemp;
		   }
		}

		if(nLeave == SfxTabPage::KEEP_PAGE)
		{
			//die Seite darf nicht verlassen werden!
			pBox->Select(pCurrentPageEntry);
			return 0;
		}
		else
			pPageInfo->pPage->Hide();
	}
	if(pParent)
	{
		aPageTitleFT.Hide();
		aLine1FL.Hide();
		aHelpFT.Hide();
		aHelpImg.Hide();
		OptionsPageInfo *pPageInfo = (OptionsPageInfo *)pEntry->GetUserData();
		OptionsGroupInfo* pGroupInfo = (OptionsGroupInfo *)pParent->GetUserData();
		if(!pPageInfo->pPage)
		{
			if(pGroupInfo->bLoadError)
				return 0;
			if ( RID_SVXPAGE_COLOR == pPageInfo->nPageId )
			{
				if(!pColorPageItemSet)
				{
					pColorPageItemSet = new SfxItemSet( *OFF_APP()->GetXOutdevItemPool(),
											XATTR_FILLSTYLE, XATTR_FILLCOLOR );
					pColorPageItemSet->Put( XFillColorItem() );
				}
			}
			else
			{
				if(pGroupInfo->pModule && !pGroupInfo->pModule->IsLoaded())
				{
					SfxModule* pOldModule = pGroupInfo->pModule;
					sal_Bool bIdentical = pGroupInfo->pModule == pGroupInfo->pShell;

					WaitObject aWait(this);
					pGroupInfo->pModule = pGroupInfo->pModule->Load();
					if(!pGroupInfo->pModule)
					{
						pGroupInfo->bLoadError = sal_True;
						InfoBox(pBox, sNotLoadedError).Execute();
						return 0;
					}
					if(bIdentical)
						 pGroupInfo->pShell = pGroupInfo->pModule;
					//jetzt noch testen, ob es auch in anderen Gruppen das gleiche Module gab (z.B. Text+HTML)
					SvLBoxEntry* pTemp = aTreeLB.First();
					while(pTemp)
					{
						if(!aTreeLB.GetParent(pTemp) && pTemp != pEntry)
						{
							OptionsGroupInfo* pTGInfo = (OptionsGroupInfo *)pTemp->GetUserData();
							if(pTGInfo->pModule == pOldModule)
							{
								pTGInfo->pModule = pGroupInfo->pModule;
								if(bIdentical)
									pTGInfo->pShell = pGroupInfo->pModule;
							}
						}
						pTemp = aTreeLB.Next(pTemp);
					}
				}
				if(!pGroupInfo->pInItemSet)
					pGroupInfo->pInItemSet = pGroupInfo->pShell->CreateItemSet( pGroupInfo->nDialogId );
				if(!pGroupInfo->pOutItemSet)
					pGroupInfo->pOutItemSet = new SfxItemSet(*pGroupInfo->pInItemSet->GetPool(),
																	pGroupInfo->pInItemSet->GetRanges());

			}
			if(pGroupInfo->pModule)
			{
				pPageInfo->pPage = pGroupInfo->pModule->CreateTabPage(
								pPageInfo->nPageId, this, *pGroupInfo->pInItemSet );
			}
			else if(RID_SVXPAGE_COLOR != pPageInfo->nPageId)
				pPageInfo->pPage = OFF_APP()->CreateTabPage(
								pPageInfo->nPageId, this, *pGroupInfo->pInItemSet );
			else
			{
				pPageInfo->pPage = OFF_APP()->
					CreateTabPage( pPageInfo->nPageId, this, *pColorPageItemSet );
				SvxColorTabPage& rColPage = *(SvxColorTabPage*)pPageInfo->pPage;
				const OfaPtrItem* pPtr = NULL;
				if ( SfxViewFrame::Current() && SfxViewFrame::Current()->GetDispatcher() )
					pPtr = (const OfaPtrItem*)SfxViewFrame::Current()->
						GetDispatcher()->Execute( SID_GET_COLORTABLE, SFX_CALLMODE_SYNCHRON );
				pColorTab = pPtr ? (XColorTable*)pPtr->GetValue()
								 : OFF_APP()->GetStdColorTable();

				rColPage.SetColorTable( pColorTab );
				rColPage.SetPageType( &nUnknownType );
				rColPage.SetDlgType( &nUnknownType );
				rColPage.SetPos( &nUnknownPos );
				rColPage.SetAreaTP( &bIsAreaTP );
				rColPage.SetColorChgd( (ChangeType*)&nChangeType );
				rColPage.Construct();
			}
			SvtViewOptions aTabPageOpt( E_TABPAGE, String::CreateFromInt32( pPageInfo->nPageId ) );
			pPageInfo->pPage->SetUserData( GetViewOptUserItem( aTabPageOpt ) );

			Point aTreePos(aTreeLB.GetPosPixel());
			Size aTreeSize(aTreeLB.GetSizePixel());
			Point aGBPos(aHiddenGB.GetPosPixel());
			long nDiff = aGBPos.Y();
			DBG_ASSERT(pPageInfo->pPage, "TabPage nicht gefunden!")
			Size aPageSize(pPageInfo->pPage->GetSizePixel());
			Size aGBSize(aHiddenGB.GetSizePixel());
			Point aPagePos( aGBPos.X() + ( aGBSize.Width() - aPageSize.Width() ) / 2,
							nDiff * 2 );
			pPageInfo->pPage->SetPosPixel( aPagePos );
			if ( RID_SVXPAGE_COLOR == pPageInfo->nPageId )
			{
				pPageInfo->pPage->Reset( *pColorPageItemSet );
				pPageInfo->pPage->ActivatePage( *pColorPageItemSet );
			}
			else
			{
				pPageInfo->pPage->Reset( *pGroupInfo->pInItemSet );
			}
		}
		if(RID_SVXPAGE_COLOR != pPageInfo->nPageId &&
							pPageInfo->pPage->HasExchangeSupport())
		{
			pPageInfo->pPage->ActivatePage(*pGroupInfo->pOutItemSet);
		}
		pPageInfo->pPage->Show();
		String sTmpTitle = sTitle;
		sTmpTitle += String::CreateFromAscii(" - ");
		sTmpTitle += aTreeLB.GetEntryText(pParent);
		sTmpTitle += String::CreateFromAscii(" - ");
		sTmpTitle += aTreeLB.GetEntryText(pEntry);
		SetText(sTmpTitle);
		pCurrentPageEntry = pEntry;
		if(!bForgetSelection)
			nLastDialogPageId = pPageInfo->nPageId;
		StartHint( pPageInfo, sTmpTitle );
	}
	else
	{
		static const sal_uInt16 _aGlobalHelpIds[] =
		{
			HID_OFADLG_TREE_GENERAL			,
            HID_OFADLG_TREE_LANGUAGE        ,
            HID_OFADLG_TREE_INTERNET        ,
			HID_OFADLG_TREE_TEXT            ,
			HID_OFADLG_TREE_HTML            ,
			HID_OFADLG_TREE_CALC            ,
			HID_OFADLG_TREE_PRESENTATION    ,
			HID_OFADLG_TREE_DRAWING         ,
			HID_OFADLG_TREE_FORMULA			,
			HID_OFADLG_TREE_CHART			,
			HID_OFADLG_TREE_BASE			,
            HID_OFADLG_TREE_FILTER
		};

		DBG_ASSERT( aHelpTextsArr.Count() ==
					sizeof( _aGlobalHelpIds ) / sizeof(_aGlobalHelpIds[0]),
					"fehlende HelpIds!!" );

		if(!aTreeLB.IsInCollapse())
			pBox->Expand(pEntry);
		OptionsGroupInfo* pTGInfo = (OptionsGroupInfo *)pEntry->GetUserData();
		//hier den Hilfetext anzeigen
		for(sal_uInt16 i = 0; i < aHelpTextsArr.Count(); i++)
		{
			if(aHelpTextsArr.GetValue(i) == pTGInfo->nDialogId)
			{
				aHelpFT.SetText(aHelpTextsArr.GetString(i));
                aHelpImg.SetImage(aPageImages.GetImage(pTGInfo->nDialogId));
			}
		}
		aHelpFT.Show();
		aLine1FL.Show();
		aPageTitleFT.Show();
		aHelpImg.Show();

		//auf die Groesse der Bitmap anpassen
        if(!bImageResized)
		{
            const long nCtrlDist = 2;
            bImageResized = sal_True;
            Point aImgPos(aHelpImg.GetPosPixel());
            Size aImgSize(aHelpImg.GetSizePixel());
            Point aTitlePos(aPageTitleFT.GetPosPixel());
            Point aLinePos(aLine1FL.GetPosPixel());
            Point aHelpPos(aHelpFT.GetPosPixel());
            Size aHelpSize(aHelpFT.GetSizePixel());
            long nXDiff = 0;
            long nYDiff = 0;
            if(aTitlePos.X() <= (aImgPos.X() + aImgSize.Width() + nCtrlDist))
            {
                nXDiff = aImgPos.X() + aImgSize.Width() + nCtrlDist - aTitlePos.X();
            }
            if(aLinePos.Y() <= (aImgPos.Y() + aImgSize.Height() + nCtrlDist))
            {
                nYDiff = aImgPos.Y() + aImgSize.Height() + nCtrlDist - aLinePos.Y();
            }
            aLinePos.Y() += nYDiff;
            aLine1FL.SetPosPixel(aLinePos);

            aTitlePos.X() += nXDiff;
            aPageTitleFT.SetPosPixel(aTitlePos);

            aHelpPos.X() += nXDiff;
            aHelpPos.Y() += nYDiff;
            aHelpSize.Width() -= nXDiff;
            aHelpSize.Height() -= nYDiff;
            aHelpFT.SetPosSizePixel(aHelpPos, aHelpSize);

            Font aFont = aHelpFT.GetFont();
			Size aSz = aFont.GetSize();
			aSz.Height() = (aSz.Height() * 14 ) / 10;
			aFont.SetSize(aSz);
			aPageTitleFT.SetFont(aFont);

		}
		aHelpImg.Show();
		String sTmpTitle = sTitle;
		sTmpTitle += String::CreateFromAscii(" - ");
		aPageTitleFT.SetText(aTreeLB.GetEntryText(pEntry));
		sTmpTitle += aPageTitleFT.GetText();
		SetText(sTmpTitle);
		pCurrentPageEntry = 0;
	}
	return 0;
}
/* -----------------11.02.99 10:49-------------------
 *
 * --------------------------------------------------*/
IMPL_LINK( OfaTreeOptionsDialog, BackHdl_Impl, PushButton*, EMPTYARG )
{
	if ( pCurrentPageEntry )
	{
		OptionsPageInfo* pPageInfo = (OptionsPageInfo*)pCurrentPageEntry->GetUserData();
		OptionsGroupInfo* pGroupInfo =
			(OptionsGroupInfo*)aTreeLB.GetParent( pCurrentPageEntry )->GetUserData();
		if ( RID_SVXPAGE_COLOR == pPageInfo->nPageId )
			pPageInfo->pPage->Reset( *pColorPageItemSet );
		else
			pPageInfo->pPage->Reset( *pGroupInfo->pInItemSet );
	}
	return 0;
}
/* -----------------11.02.99 16:45-------------------
 *
 * --------------------------------------------------*/
IMPL_LINK( OfaTreeOptionsDialog, OKHdl_Impl, Button *, EMPTRARG )
{
	aTreeLB.EndSelection();
	if(pCurrentPageEntry)
	{
		OptionsPageInfo *pPageInfo = (OptionsPageInfo *)pCurrentPageEntry->GetUserData();
		OptionsGroupInfo* pGroupInfo = (OptionsGroupInfo *)aTreeLB.GetParent(pCurrentPageEntry)->GetUserData();
		if(RID_SVXPAGE_COLOR != pPageInfo->nPageId &&
					pPageInfo->pPage->HasExchangeSupport())
		{
			int nLeave = pPageInfo->pPage->DeactivatePage(pGroupInfo->pOutItemSet);
			if(nLeave == SfxTabPage::KEEP_PAGE)
			{
				//die Seite darf nicht verlassen werden!
				aTreeLB.Select(pCurrentPageEntry);
				return 0;
			}
		}
		pPageInfo->pPage->Hide();
	}
	SvLBoxEntry* pEntry = aTreeLB.First();
	while(pEntry)
	{
		if(aTreeLB.GetParent(pEntry))
		{
			OptionsPageInfo *pPageInfo = (OptionsPageInfo *)pEntry->GetUserData();
			if(pPageInfo->pPage && !pPageInfo->pPage->HasExchangeSupport())
			{
				OptionsGroupInfo* pGroupInfo = (OptionsGroupInfo *)
										aTreeLB.GetParent(pEntry)->GetUserData();
				pPageInfo->pPage->FillItemSet(*pGroupInfo->pOutItemSet);
			}
		}
		pEntry = aTreeLB.Next(pEntry);
	}
	EndDialog(RET_OK);
	return 0;
}
/* -----------------17.02.99 09:15-------------------
 * Eine aufgeklappte Gruppe soll vollstaendig sichtbar sein
 * --------------------------------------------------*/
IMPL_LINK(OfaTreeOptionsDialog, ExpandedHdl_Impl, SvTreeListBox*, pBox )
{
	pBox->Update();
	pBox->InitStartEntry();
	SvLBoxEntry* pEntry = pBox->GetHdlEntry();
	if(pEntry && pBox->IsExpanded(pEntry))
	{
		sal_uInt32 nChildCount = pBox->GetChildCount( pEntry );

		SvLBoxEntry* pNext = pEntry;
		for(sal_uInt32 i = 0; i < nChildCount;i++)
		{
			pNext = pBox->GetNextEntryInView(pNext);
			if(!pNext)
			{
				pBox->ScrollOutputArea( -(short)(nChildCount - i + 1) );
				break;
			}
			else
			{
				Size aSz(pBox->GetOutputSizePixel());
				int nHeight = pBox->GetEntryHeight();
				Point aPos(pBox->GetEntryPos(pNext));
				if(aPos.Y()+nHeight > aSz.Height())
				{
					pBox->ScrollOutputArea( -(short)(nChildCount - i + 1) );
					break;
				}
			}
		}
	}
	return 0;
}

/* -----------------11.02.99 10:49-------------------
 *
 * --------------------------------------------------*/
void OfaTreeOptionsDialog::ApplyItemSets()
{
	SvLBoxEntry* pEntry = aTreeLB.First();
	while(pEntry)
	{
		if(!aTreeLB.GetParent(pEntry))
		{
			OptionsGroupInfo* pGroupInfo = (OptionsGroupInfo *)pEntry->GetUserData();
			if(pGroupInfo->pOutItemSet)
			{
				if(pGroupInfo->pShell)
					pGroupInfo->pShell->ApplyItemSet( pGroupInfo->nDialogId, *pGroupInfo->pOutItemSet);
				else
					OFF_APP()->ApplyItemSet( pGroupInfo->nDialogId, *pGroupInfo->pOutItemSet);
			}
		}
		pEntry = aTreeLB.Next(pEntry);
	}
}
/* -----------------17.02.99 09:51-------------------
 *
 * --------------------------------------------------*/
void	OfaTreeOptionsDialog::ActivatePage(sal_uInt16 nResId)
{
	bForgetSelection = sal_True;
	sal_uInt16 nTemp = nLastDialogPageId;
	nLastDialogPageId = nResId;
	ActivateLastSelection();
	nLastDialogPageId = nTemp;
}

/* -----------------16.02.99 13:17-------------------
 *
 * --------------------------------------------------*/
void	OfaTreeOptionsDialog::ActivateLastSelection()
{
	SvLBoxEntry* pEntry = 0;
	if(nLastDialogPageId == USHRT_MAX)
	{
		pEntry = aTreeLB.First();
		pEntry = aTreeLB.Next(pEntry);
	}
	else
	{
		SvLBoxEntry* pTemp = aTreeLB.First();
		while(!pEntry && pTemp)
		{
			//wenn Child, dann OptionsPageInfo
			if(aTreeLB.GetParent(pTemp))
			{
				OptionsPageInfo *pPageInfo = (OptionsPageInfo *)pTemp->GetUserData();
				if(pPageInfo->nPageId == nLastDialogPageId)
					pEntry = pTemp;
			}
			pTemp = aTreeLB.Next(pTemp);
		}
	}
	if(pEntry)
	{
		SvLBoxEntry* pParent = aTreeLB.GetParent(pEntry);
		aTreeLB.Expand(pParent);
		aTreeLB.MakeVisible(pParent); // damit dieser (wenn m"oglich) auch sichtbar ist
		aTreeLB.MakeVisible(pEntry);
		aTreeLB.Select(pEntry);
	}
    aTreeLB.GrabFocus();
}
/* -----------------22.02.99 08:52-------------------
 *
 * --------------------------------------------------*/
long	OfaTreeOptionsDialog::Notify( NotifyEvent& rNEvt )
{
	if ( rNEvt.GetType() == EVENT_KEYINPUT )
	{
		const KeyEvent* pKEvt = rNEvt.GetKeyEvent();
		const KeyCode aKeyCode = pKEvt->GetKeyCode();
		const sal_uInt16 nModifier = aKeyCode.GetModifier();

		if( aKeyCode.GetCode() == KEY_PAGEUP ||
				aKeyCode.GetCode() == KEY_PAGEDOWN)
		{
			SvLBoxEntry* pCurEntry = aTreeLB.FirstSelected();
			SvLBoxEntry*  pTemp = 0;
			if(aKeyCode.GetCode() == KEY_PAGEDOWN)
			{
				pTemp =  aTreeLB.Next( pCurEntry ) ;
				if(pTemp && !aTreeLB.GetParent(pTemp))
				{
					pTemp =  aTreeLB.Next( pTemp ) ;
					aTreeLB.Select(pTemp);
				}
			}
			else
			{
				pTemp =  aTreeLB.Prev( pCurEntry ) ;
				if(pTemp && !aTreeLB.GetParent(pTemp))
				{
					pTemp =  aTreeLB.Prev( pTemp ) ;
				}
			}
			if(pTemp)
			{
				if(!aTreeLB.IsExpanded(aTreeLB.GetParent(pTemp)))
					aTreeLB.Expand(aTreeLB.GetParent(pTemp));
				aTreeLB.MakeVisible(pTemp);
				aTreeLB.Select(pTemp);
			}
		}
	}
	return SfxModalDialog::Notify(rNEvt);
}

/*-----------------01.04.99 15:52-------------------
 *  ggf. einen Hinweis zum externen Browser ausgeben
 * --------------------------------------------------*/

void OfaTreeOptionsDialog::StartHint( const OptionsPageInfo* pInfo, const XubString& rTitle )
{
	if ( bExternBrowserActive )
	{
		switch ( pInfo->nPageId )
		{
			case RID_SVXPAGE_INET_PROXY:
			case RID_SVXPAGE_INET_SCRIPTING:
			case RID_SVXPAGE_BROWSER_OTHER:
			case RID_SW_TP_HTML_CONTENT_OPT:
			case RID_SW_TP_HTML_OPTPRINT_PAGE:
			case RID_SW_TP_OPTSRCVIEW:
			case RID_SW_TP_BACKGROUND:
				pHintInfo = pInfo;
				sHintTitle = rTitle;
				aHintTimer.Start();
				break;
		}
	}
}

void OfaTreeOptionsDialog::ShowHint()
{
/* (pb) obsolete
*/
}

IMPL_LINK(OfaTreeOptionsDialog, HintHdl_Impl, Timer*, EMPTYARG )
{
	ShowHint();
	return 0;
}

/* -----------------11.02.99 15:51-------------------
 *
 * --------------------------------------------------*/

OfaPageResource::OfaPageResource() :
	Resource(OffResId(RID_OFADLG_OPTIONS_TREE_PAGES)),
	aGeneralDlgAry(ResId(SID_GENERAL_OPTIONS)),
    aLangDlgAry(ResId(SID_LANGUAGE_OPTIONS)),
    aInetDlgAry(ResId(SID_INET_DLG)),
    aTextDlgAry(ResId(SID_SW_EDITOPTIONS)),
	aHTMLDlgAry(ResId(SID_SW_ONLINEOPTIONS)),
	aCalcDlgAry(ResId(SID_SC_EDITOPTIONS)),
	aStarMathDlgAry(ResId(SID_SM_EDITOPTIONS)),
	aImpressDlgAry(ResId(SID_SD_EDITOPTIONS)),
	aDrawDlgAry(ResId(SID_SD_GRAPHIC_OPTIONS)),
	aChartDlgAry(ResId(SID_SCH_EDITOPTIONS)),
    aFilterDlgAry(ResId(SID_FILTER_DLG)),
	aDatasourcesDlgAry(ResId(SID_SB_STARBASEOPTIONS))
{
	FreeResource();
}

