/*************************************************************************
 *
 *  $RCSfile: ConvertOfn.c,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: tra $ $Date: 2001/04/12 13:40:24 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _CONVERTOFN_H_
#include "ConvertOfn.h"
#endif

#ifndef _STRCONVERT_H_
#include <systools/win32/StrConvert.h>
#endif

#include <assert.h>

//--------------------------------------------------------------
// Precondition:	
//
// Postcondition: the caller must free the space allocated for
//				  the ascii strings
//
void WINAPI OfnW2OfnA( LPOPENFILENAMEW lpofnW, LPOPENFILENAMEA lpofnA )
{
	LPSTR lpstrFilterA        = NULL;
	LPSTR lpstrCustomFilterA  = NULL;
	LPSTR lpstrFileA          = NULL;
	LPSTR lpstrFileTitleA     = NULL;
	LPSTR lpstrInitialDirA    = NULL;
	LPSTR lpstrTitleA         = NULL;
	LPSTR lpstrDefExtA        = NULL;
	LPSTR lpTemplateNameA     = NULL;
	size_t lenFilterStr;

	assert( ( NULL != lpofnW ) && ( NULL != lpofnA ) );

	ZeroMemory( lpofnA, sizeof( OPENFILENAME ) );

	// filter is a special case because it is a buffer with a double 
	// null termination
	lenFilterStr = CalcLenDblNullTerminatedWStr( lpofnW->lpstrFilter );
	if ( lenFilterStr > 0 )
		AllocSpaceAndCopyWStr2Str( lpofnW->lpstrFilter, lenFilterStr, &lpstrFilterA );
	
	// custom filter is also a special case
	AllocSpaceAndCopyWStr2Str( lpofnW->lpstrCustomFilter, lpofnW->nMaxCustFilter, &lpstrCustomFilterA );
	
	// special case
	AllocSpaceAndCopyWStr2Str( lpofnW->lpstrFile, lpofnW->nMaxFile, &lpstrFileA );
	
	// special case because the length of the string is specified in 
	// nMaxFileTitle
	if ( ( NULL != lpofnW->lpstrFileTitle ) && ( lpofnW->nMaxFileTitle > 0 ) )
		AllocSpaceAndCopyWStr2Str( lpofnW->lpstrFileTitle, lpofnW->nMaxFileTitle, &lpstrFileTitleA );

	AllocNecessarySpaceAndCopyWStr2Str( lpofnW->lpstrInitialDir, &lpstrInitialDirA );
	AllocNecessarySpaceAndCopyWStr2Str( lpofnW->lpstrTitle, &lpstrTitleA );
	AllocNecessarySpaceAndCopyWStr2Str( lpofnW->lpstrDefExt, &lpstrDefExtA );
	//AllocNecessarySpaceAndCopyWStr2Str( lpofnW->lpTemplateName, &lpTemplateNameA );

	lpofnA->lStructSize		  = sizeof( OPENFILENAME );
	lpofnA->hwndOwner		  = lpofnW->hwndOwner;
	lpofnA->hInstance		  = lpofnW->hInstance;
	lpofnA->lpstrFilter       = lpstrFilterA;
	lpofnA->lpstrCustomFilter = lpstrCustomFilterA;
	lpofnA->nMaxCustFilter    = lpofnW->nMaxCustFilter;
	lpofnA->nFilterIndex      = lpofnW->nFilterIndex;
	lpofnA->lpstrFile         = lpstrFileA;
	lpofnA->nMaxFile          = lpofnW->nMaxFile;
	lpofnA->lpstrFileTitle    = lpstrFileTitleA;
	lpofnA->nMaxFileTitle     = lpofnW->nMaxFileTitle;
	lpofnA->lpstrInitialDir   = lpstrInitialDirA;
	lpofnA->lpstrTitle        = lpstrTitleA;
	lpofnA->Flags             = lpofnW->Flags;
	lpofnA->nFileOffset       = lpofnW->nFileOffset;
	lpofnA->nFileExtension    = lpofnW->nFileExtension;
	lpofnA->lpstrDefExt       = lpstrDefExtA;
	lpofnA->lCustData         = lpofnW->lCustData;
	lpofnA->lpfnHook          = lpofnW->lpfnHook;
	lpofnA->lpTemplateName    = (LPSTR)lpofnW->lpTemplateName;
}

//--------------------------------------------------------------
// synopsis: this function copies back only variables which
//			 may have changed after a call of GetOpenFileName
//			 or GetSaveFileName
//
// precondition: this function should be called after a call to
//				 GetOpenFileName or GetSaveFileName else the
//				 result is undefined
//				 we assume the necessary buffer do exist in the 
//				 ofn struct lpofnW points to
//
void WINAPI OfnA2OfnW( LPOPENFILENAMEA lpofnA, LPOPENFILENAMEW lpofnW )
{
	assert( ( NULL != lpofnW ) && ( NULL != lpofnA ) );

	// copy the strings back 

	assert( lpofnA->nMaxCustFilter == lpofnW->nMaxCustFilter );
	MultiByteToWideChar( CP_ACP, 
					     0, 
						 lpofnA->lpstrCustomFilter, 
						 lpofnA->nMaxCustFilter * sizeof( char ), 
						 lpofnW->lpstrCustomFilter, 
						 lpofnW->nMaxCustFilter );
	
	assert( lpofnA->nMaxFile == lpofnW->nMaxFile );
	MultiByteToWideChar( CP_ACP,
						 0,
						 lpofnA->lpstrFile,
						 lpofnA->nMaxFile * sizeof( char ),
						 lpofnW->lpstrFile,
						 lpofnW->nMaxFile );

	assert( lpofnA->nMaxFile == lpofnW->nMaxFile );
	MultiByteToWideChar( CP_ACP,
						 0,
						 lpofnA->lpstrFileTitle,
						 lpofnA->nMaxFileTitle * sizeof( char ),
						 lpofnW->lpstrFileTitle,
						 lpofnW->nMaxFileTitle );

	lpofnW->nFilterIndex      = lpofnA->nFilterIndex;
	lpofnW->nFileOffset       = lpofnA->nFileOffset;
	lpofnW->nFileExtension    = lpofnA->nFileExtension;
}





