/************************************************************************* 
# 
#   $RCSfile: osl_apitest_file.cxx,v $ 
# 
#   $Revision: 1.19 $ 
# 
#   last change: $Author: ganaya $ $Date: 2001/06/26 21:11:42 $ 
# 
#   The Contents of this file are made available subject to the terms of 
#   either of the following licenses 
# 
#          - GNU Lesser General Public License Version 2.1 
#          - Sun Industry Standards Source License Version 1.1 
# 
#   Sun Microsystems Inc., October, 2000 
# 
#   GNU Lesser General Public License Version 2.1 
#   ============================================= 
#   Copyright 2000 by Sun Microsystems, Inc. 
#   901 San Antonio Road, Palo Alto, CA 94303, USA 
# 
#   This library is free software; you can redistribute it and/or 
#   modify it under the terms of the GNU Lesser General Public 
#   License version 2.1, as published by the Free Software Foundation. 
# 
#   This library is distributed in the hope that it will be useful, 
#   but WITHOUT ANY WARRANTY; without even the implied warranty of 
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
#   Lesser General Public License for more details. 
# 
#   You should have received a copy of the GNU Lesser General Public 
#   License along with this library; if not, write to the Free Software 
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
#   MA  02111-1307  USA 
# 
# 
#   Sun Industry Standards Source License Version 1.1 
#   ================================================= 
#   The contents of this file are subject to the Sun Industry Standards 
#   Source License Version 1.1 (the "License"); You may not use this file 
#   except in compliance with the License. You may obtain a copy of the 
#   License at http://www.openoffice.org/license.html. 
# 
#   Software provided under this License is provided on an "AS IS" basis, 
#   WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, 
#   WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS, 
#   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING. 
#   See the License for the specific provisions governing your rights and 
#   obligations concerning the Software. 
# 
#   The Initial Developer of the Original Code is: Sun Microsystems, Inc. 
# 
#   Copyright: 2000 by Sun Microsystems, Inc. 
# 
#   All Rights Reserved. 
# 
#   Contributor(s): _______________________________________ 
# 
# 
# 
#*************************************************************************/

#ifndef _TESTS_TRES_HXX_
#include <rtl/tres.hxx>
#endif

#ifndef _OSL_FILE_H_
#include <osl/file.h>
#endif

#ifndef _OSL_FILE_HXX_ 
#include <osl/file.hxx>
#endif

#include <iostream.h>

using namespace rtl;


//oslFileError SAL_CALL osl_openDirectory( rtl_uString *strDirectoryPath,
//                                         oslDirectory *pDirectory); 

extern "C" void SAL_CALL test_osl_file_osl_openDirectory(TestResult *oRes)
{
    oslDirectory pDir = NULL;
    rtl_uString *strPath = NULL;
    rtl_uString *sysPath = NULL;

    rtl_uString_newFromAscii(&strPath, "/tmp");

    if (strPath &&
        (osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None)) {
        oRes->state(osl_openDirectory(sysPath, &pDir) == osl_File_E_None);
    } else {
        oRes->state(0);
    }
    
    if (strPath) {
        rtl_uString_release(strPath);
    }
    if (sysPath) {
        rtl_uString_release(sysPath);
    }
    if (pDir) {
        osl_closeDirectory(pDir);
    }
}


//oslFileError SAL_CALL osl_getNextDirectoryItem( oslDirectory Directory, 
//                                                oslDirectoryItem *pItem, 
//                                                sal_uInt32       uHint ); 

extern "C" void SAL_CALL test_osl_file_osl_getNextDirectoryItem(TestResult *oRes)
{
    oslDirectory pDir = NULL;
    oslDirectoryItem pItem = NULL;
    rtl_uString *strPath = NULL;
    rtl_uString *sysPath = NULL;
    sal_uInt32 uHint = 1;

    rtl_uString_newFromAscii(&strPath, "/");

    if ((strPath) &&
        (osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None) &&
	(osl_openDirectory(sysPath, &pDir) == osl_File_E_None)) {
        oRes->state(osl_getNextDirectoryItem(pDir, &pItem, uHint) == osl_File_E_None);
    } else {
        oRes->state(0);
    }

    if (strPath) {
        rtl_uString_release(strPath);
    }
    if (sysPath) {
        rtl_uString_release(sysPath);
    }
    if (pDir) {
        osl_closeDirectory(pDir);
    }
    if (pItem) {
        osl_releaseDirectoryItem(pItem);
    }
}


//oslFileError SAL_CALL osl_closeDirectory( oslDirectory Directory );

extern "C" void SAL_CALL test_osl_file_osl_closeDirectory(TestResult *oRes)
{
    oslDirectory pDir = NULL;
    rtl_uString *strPath = NULL;
    rtl_uString *sysPath = NULL;

    rtl_uString_newFromAscii(&strPath, "/");

    if ((strPath) &&
        (osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None) &&
	(osl_openDirectory(sysPath, &pDir) == osl_File_E_None)) {
        oRes->state((osl_closeDirectory(pDir) == osl_File_E_None) &&
		    (osl_closeDirectory(NULL) == osl_File_E_INVAL));
    } else {
        oRes->state(0);
    }

    if (strPath) {
        rtl_uString_release(strPath);
    }
    if (sysPath) {
        rtl_uString_release(sysPath);
    }
    if (pDir) {
        osl_closeDirectory(pDir);
    }
}


//oslFileError SAL_CALL osl_getDirectoryItem( rtl_uString *strFilePath,  
//                                            oslDirectoryItem *pItem );

extern "C" void SAL_CALL test_osl_file_osl_getDirectoryItem(TestResult *oRes)
{
    oslDirectoryItem pItem = NULL;
    rtl_uString *strPath = NULL;
    rtl_uString *sysPath = NULL;

    rtl_uString_newFromAscii(&strPath, "/");

    if ((strPath) &&
	(osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None)) {
        oRes->state(osl_getDirectoryItem(sysPath, &pItem) == osl_File_E_None);
    } else {
        oRes->state(0);
    }

    if (strPath) {
        rtl_uString_release(strPath);
    }
    if (sysPath) {
        rtl_uString_release(sysPath);
    }
    if (pItem) {
	osl_releaseDirectoryItem(pItem);
    }
}


//oslFileError SAL_CALL osl_acquireDirectoryItem( oslDirectoryItem Item );

extern "C" void SAL_CALL test_osl_file_osl_acquireDirectoryItem(TestResult *oRes)
{
    oslDirectoryItem pItem = NULL;
    rtl_uString *strPath = NULL;
    rtl_uString *sysPath = NULL;

    rtl_uString_newFromAscii(&strPath, "/");

    if (strPath &&
	(osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None) &&
	(osl_getDirectoryItem(sysPath, &pItem) == osl_File_E_None)) {
        oRes->state(osl_acquireDirectoryItem(pItem) == osl_File_E_None);
    } else {
        oRes->state(0);
    }

    if (strPath) {
        rtl_uString_release(strPath);
    }
    if (sysPath) {
        rtl_uString_release(sysPath);
    }
    if (pItem) {
	osl_releaseDirectoryItem(pItem);
    }
}


//oslFileError SAL_CALL osl_releaseDirectoryItem( oslDirectoryItem Item ); 

extern "C" void SAL_CALL test_osl_file_osl_releaseDirectoryItem(TestResult *oRes)
{
    oslDirectoryItem pItem = NULL;
    rtl_uString *strPath = NULL;
    rtl_uString *sysPath = NULL;

    rtl_uString_newFromAscii(&strPath, "/");

    if (strPath &&
	(osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None) &&
	(osl_getDirectoryItem(sysPath, &pItem) == osl_File_E_None)) {
        oRes->state(osl_releaseDirectoryItem(pItem) == osl_File_E_None);
    } else {
        oRes->state(0);
    }

    if (strPath) {
        rtl_uString_release(strPath);
    }
    if (sysPath) {
        rtl_uString_release(sysPath);
    }
}


//oslFileError SAL_CALL osl_getFileStatus( oslDirectoryItem Item,
//                                         oslFileStatus *pStatus,
//                                         sal_uInt32 uFieldMask );

extern "C" void SAL_CALL test_osl_file_osl_getFileStatus(TestResult *oRes)
{
    oslDirectoryItem pItem = NULL;
    oslFileStatus *pFileStatus = NULL;
    rtl_uString *strPath = NULL;
    rtl_uString *sysPath = NULL;

    rtl_uString_newFromAscii(&strPath, "/tmp/");
    pFileStatus = (oslFileStatus *)calloc(sizeof(oslFileStatus), 1);
    pFileStatus->uStructSize = sizeof(oslFileStatus);

    if ((pFileStatus && strPath) &&
	(osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None) &&
	(osl_getDirectoryItem(sysPath, &pItem) == osl_File_E_None)) {
        oRes->state(osl_getFileStatus(pItem, pFileStatus, osl_FileStatus_Mask_All) == osl_File_E_None);
    } else {
        oRes->state(0);
    }

    if (strPath) {
        rtl_uString_release(strPath);
    }
    if (sysPath) {
        rtl_uString_release(sysPath);
    }
    if (pFileStatus) {
        free(pFileStatus);
    }
    if (pItem) {
	osl_releaseDirectoryItem(pItem);
    }
}


//oslFileError SAL_CALL osl_unmountVolumeDevice(oslVolumeDeviceHandle Handle);

extern "C" void SAL_CALL test_osl_file_osl_unmountVolumeDevice(TestResult *oRes)
{
    oRes->state(0, "This test is not implemented");
}


//oslFileError SAL_CALL osl_automountVolumeDevice(oslVolumeDeviceHandle Handle);

extern "C" void SAL_CALL test_osl_file_osl_automountVolumeDevice(TestResult *oRes)
{
    oRes->state(0, "This test is not implemented");
}
 

//oslFileError SAL_CALL osl_releaseVolumeDeviceHandle( oslVolumeDeviceHandle Handle );

extern "C" void SAL_CALL test_osl_file_osl_releaseVolumeDeviceHandle(TestResult *oRes)
{
    oRes->state(0, "This test is not implemented");
}


//oslFileError SAL_CALL osl_acquireVolumeDeviceHandle( oslVolumeDeviceHandle Handle );

extern "C" void SAL_CALL test_osl_file_osl_acquireVolumeDeviceHandle(TestResult *oRes)
{
    oRes->state(0, "This test is not implemented");
}


//oslFileError SAL_CALL osl_getVolumeDeviceMountPath( oslVolumeDeviceHandle Handle, rtl_uString **pstrPath );

extern "C" void SAL_CALL test_osl_file_osl_getVolumeDeviceMountPath(TestResult *oRes)
{
    rtl_uString *strPath = NULL;
    rtl_uString *sysPath = NULL;
    rtl_uString *strMountPath = NULL;
    oslVolumeInfo *pInfo = NULL;
    oslDirectoryItem pItem = NULL;
    oslFileStatus *pFileStatus = NULL;

    rtl_uString_newFromAscii(&strPath, "/"); 
    pFileStatus = (oslFileStatus *)calloc(sizeof(oslFileStatus), 1);
    pFileStatus->uStructSize = sizeof(oslFileStatus);
    pInfo = (oslVolumeInfo *)calloc(sizeof(oslVolumeInfo), 1);

    if (strPath &&
	(osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None) &&
	(osl_getVolumeInformation(sysPath, pInfo, osl_VolumeInfo_Mask_Attributes) == osl_File_E_None)) {
      //This should be asking for osl_VolumeInfo_Mask_DeviceHandle, but that dumps core!
        oRes->state(osl_getVolumeDeviceMountPath((pInfo->pDeviceHandle), &strMountPath) == osl_File_E_INVAL, "This test is partially valid");
	//This should be *(pInfo->pDeviceHandle), but it is currently NULL, and that dumps core!
    } else {
        oRes->state(0);
    }

    if (strPath) {
        rtl_uString_release(strPath);
    }
    if (sysPath) {
        rtl_uString_release(sysPath);
    }
    if (pFileStatus) {
        free(pFileStatus);
    }
    if (pInfo) {
        free(pInfo);
    }
}


//oslFileError SAL_CALL osl_getVolumeInformation( rtl_uString *strDirectory,
//                               oslVolumeInfo *pInfo, sal_uInt32 uFieldMask );

extern "C" void SAL_CALL test_osl_file_osl_getVolumeInformation(TestResult *oRes)
{
    rtl_uString *strPath = NULL;
    rtl_uString *sysPath = NULL;
    oslVolumeInfo *pInfo = NULL;
    oslDirectoryItem pItem = NULL;
    oslFileStatus *pFileStatus = NULL;

    rtl_uString_newFromAscii(&strPath, "/"); 
    pFileStatus = (oslFileStatus *)calloc(sizeof(oslFileStatus), 1);
    pFileStatus->uStructSize = sizeof(oslFileStatus);
    pInfo = (oslVolumeInfo *)calloc(sizeof(oslVolumeInfo), 1);

    if (strPath &&
	(osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None)) {

//These lines are commented out because osl_getFileStatus() returns osl_File_E_NOENT when passed "/"
      //(osl_getDirectoryItem(sysPath, &pItem) == osl_File_E_None) &&
      //(osl_getFileStatus(pItem, pFileStatus, osl_FileStatus_Mask_All) == osl_File_E_None) &&
      //(pFileStatus->eType == osl_File_Type_Volume)) {

        oRes->state(osl_getVolumeInformation(sysPath, pInfo, osl_VolumeInfo_Mask_TotalSpace) == osl_File_E_None);
	//This dumps core if passed osl_VolumeInfo_Mask_DeviceHandle!
    } else {
        oRes->state(0);
    }

    if (strPath) {
        rtl_uString_release(strPath);
    }
    if (sysPath) {
        rtl_uString_release(sysPath);
    }
    if (pFileStatus) {
        free(pFileStatus);
    }
    if (pInfo) {
        free(pInfo);
    }
}


//oslFileError SAL_CALL osl_openFile( rtl_uString *strPath,
//                                 oslFileHandle *pHandle, sal_uInt32 uFlags );

extern "C" void SAL_CALL test_osl_file_osl_openFile(TestResult *oRes)
{
    rtl_uString *strPath = NULL; 
    rtl_uString *sysPath = NULL; 
    oslFileHandle pHandle;

    rtl_uString_newFromAscii(&strPath, "/tmp/test");

    if (strPath &&
	(osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None)) {
        oRes->state(osl_openFile(sysPath, &pHandle, osl_File_OpenFlag_Create) == osl_File_E_None); 
        osl_closeFile(pHandle);
	osl_removeFile(sysPath);
    } else { 
        oRes->state(0); 
    }

    if (strPath) {
        rtl_uString_release(strPath);
    }
    if (sysPath) {
        rtl_uString_release(sysPath);
    }
}


//oslFileError SAL_CALL osl_setFilePos( oslFileHandle Handle,
//                                      sal_uInt32 uHow, sal_uInt64 uPos );

extern "C" void SAL_CALL test_osl_file_osl_setFilePos(TestResult *oRes)
{
    rtl_uString *strPath = NULL; 
    rtl_uString *sysPath = NULL; 
    oslFileHandle pHandle;

    rtl_uString_newFromAscii(&strPath, "/tmp/test"); 

    if (strPath &&
	(osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None) &&
	(osl_openFile(sysPath, &pHandle, osl_File_OpenFlag_Create) == osl_File_E_None)) {
        oRes->state(osl_setFilePos(pHandle, 1, 0) == osl_File_E_None);
        osl_closeFile(pHandle);
	osl_removeFile(sysPath);
    } else { 
        oRes->state(0); 
    }

    if (strPath) {
        rtl_uString_release(strPath); 
    }
    if (sysPath) {
        rtl_uString_release(sysPath); 
    }
}


//oslFileError SAL_CALL osl_getFilePos( oslFileHandle Handle,
//                                      sal_uInt64 *pPos );

extern "C" void SAL_CALL test_osl_file_osl_getFilePos(TestResult *oRes)
{
    rtl_uString *strPath = NULL; 
    rtl_uString *sysPath = NULL; 
    sal_uInt64 pRes = 0;
    oslFileHandle pHandle;

    rtl_uString_newFromAscii(&strPath, "/tmp/test"); 

    if (strPath &&
	(osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None) &&
	(osl_openFile(sysPath, &pHandle, osl_File_OpenFlag_Create) == osl_File_E_None)) {
        oRes->state(osl_getFilePos(pHandle, &pRes) == osl_File_E_None);
        osl_closeFile(pHandle);
	osl_removeFile(sysPath);
    } else { 
        oRes->state(0); 
    } 

    if (strPath) {
        rtl_uString_release(strPath); 
    }
    if (sysPath) {
        rtl_uString_release(sysPath); 
    }
}


//oslFileError SAL_CALL osl_setFileSize( oslFileHandle Handle,
//                                       sal_uInt64 uSize );

extern "C" void SAL_CALL test_osl_file_osl_setFileSize(TestResult *oRes)
{
    rtl_uString *strPath = NULL; 
    rtl_uString *sysPath = NULL; 
    oslFileHandle pHandle;

    rtl_uString_newFromAscii(&strPath, "/tmp/test");

    if (strPath &&
	(osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None) &&
	(osl_openFile(sysPath, &pHandle, osl_File_OpenFlag_Create) == osl_File_E_None)) {
        oRes->state(osl_setFileSize(pHandle, 1024) == osl_File_E_None);
        osl_closeFile(pHandle);
	osl_removeFile(sysPath);
    } else { 
        oRes->state(0); 
    } 

    if (strPath) {
        rtl_uString_release(strPath); 
    }
    if (sysPath) {
        rtl_uString_release(sysPath); 
    }
}


//oslFileError SAL_CALL osl_readFile( oslFileHandle Handle, void *pBuffer,
//                        sal_uInt64 uBytesRequested, sal_uInt64 *pBytesRead );

extern "C" void SAL_CALL test_osl_file_osl_readFile(TestResult *oRes)
{
    rtl_uString *strPath = NULL; 
    rtl_uString *sysPath = NULL; 
    oslFileHandle pHandle;
    char pBuffer[24] = "Hi there";
    char pReadBuffer[1024];
    sal_uInt64 pRead = 0;
    sal_uInt64 pWritten = 0;

    rtl_uString_newFromAscii(&strPath, "/tmp/test");

    if (strPath &&
	(osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None) &&
	(osl_openFile(sysPath, &pHandle, osl_File_OpenFlag_Create) == osl_File_E_None) &&
	(osl_writeFile(pHandle, pBuffer, 16, &pWritten) == osl_File_E_None) &&
        (osl_closeFile(pHandle) == osl_File_E_None) &&
        (osl_openFile(sysPath, &pHandle, osl_File_OpenFlag_Read) == osl_File_E_None)) {
	oRes->state(osl_readFile(pHandle, pReadBuffer, 8, &pRead) == osl_File_E_None);
        osl_closeFile(pHandle);
	osl_removeFile(sysPath);
    } else { 
        oRes->state(0); 
    } 

    if (strPath) {
        rtl_uString_release(strPath); 
    }
    if (sysPath) {
        rtl_uString_release(sysPath); 
    }
}


//oslFileError SAL_CALL osl_writeFile( oslFileHandle Handle,
//  const void *pBuffer, sal_uInt64 uBytesToWrite, sal_uInt64 *pBytesWritten );

extern "C" void SAL_CALL test_osl_file_osl_writeFile(TestResult *oRes)
{
    rtl_uString *strPath = NULL; 
    rtl_uString *sysPath = NULL; 
    oslFileHandle pHandle;
    sal_uInt64 pWritten = 0;
    char pBuffer[24] = "Hi there";

    rtl_uString_newFromAscii(&strPath, "/tmp/test");

    if (strPath &&
	(osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None) &&
	(osl_openFile(sysPath, &pHandle, osl_File_OpenFlag_Create) == osl_File_E_None)) {
        oRes->state(osl_writeFile(pHandle, pBuffer, 16, &pWritten) == osl_File_E_None);
        osl_closeFile(pHandle);
	osl_removeFile(sysPath);
    } else { 
        oRes->state(0); 
    } 

    if (strPath) {
        rtl_uString_release(strPath); 
    }
    if (sysPath) {
        rtl_uString_release(sysPath); 
    }
}


//oslFileError SAL_CALL osl_readLine( oslFileHandle Handle,
//                                    sal_Sequence** ppSequence );

extern "C" void SAL_CALL test_osl_file_osl_readLine(TestResult *oRes)
{
    rtl_uString *strPath = NULL; 
    rtl_uString *sysPath = NULL; 
    oslFileHandle pHandle;
    char pBuffer[24] = "Hi\nthere\ntester";
    sal_Sequence *pOutBuffer = NULL;
    sal_uInt64 pWritten = 0;

    rtl_uString_newFromAscii(&strPath, "/tmp/test.rl1");

    if (strPath &&
	(osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None) &&
	(osl_openFile(sysPath, &pHandle, osl_File_OpenFlag_Create) == osl_File_E_None) &&
        (osl_writeFile(pHandle, pBuffer, 24, &pWritten) == osl_File_E_None) &&
	(osl_closeFile(pHandle) == osl_File_E_None) &&
	(osl_openFile(sysPath, &pHandle, osl_File_OpenFlag_Read) == osl_File_E_None)) {
        oRes->state(osl_readLine(pHandle, &pOutBuffer) == osl_File_E_None);
        osl_closeFile(pHandle);
	osl_removeFile(sysPath);
    } else { 
        oRes->state(0); 
    } 

    if (strPath) {
        rtl_uString_release(strPath); 
    }
    if (sysPath) {
        rtl_uString_release(sysPath); 
    }
}


//oslFileError SAL_CALL osl_closeFile( oslFileHandle Handle ); 

extern "C" void SAL_CALL test_osl_file_osl_closeFile(TestResult *oRes)
{
    rtl_uString *strPath = NULL; 
    rtl_uString *sysPath = NULL; 
    oslFileHandle pHandle;

    rtl_uString_newFromAscii(&strPath, "/tmp/test"); 

    if (strPath &&
	(osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None) &&
	(osl_openFile(sysPath, &pHandle, osl_File_OpenFlag_Create) == osl_File_E_None)) {
        oRes->state(osl_closeFile(pHandle) == osl_File_E_None);
	osl_removeFile(sysPath);
    } else { 
        oRes->state(0); 
    } 

    if (strPath) {
        rtl_uString_release(strPath); 
    }
    if (sysPath) {
        rtl_uString_release(sysPath); 
    }
}


//oslFileError SAL_CALL osl_createDirectory( rtl_uString* strPath );

extern "C" void SAL_CALL test_osl_file_osl_createDirectory(TestResult *oRes)
{
    rtl_uString *strPath = NULL;
    rtl_uString *sysPath = NULL;
    oslDirectory pDir = NULL;

    rtl_uString_newFromAscii(&strPath, "/tmp/test");

    if (strPath &&
	(osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None)) {
        oRes->state(osl_createDirectory(sysPath) == osl_File_E_None);
	osl_removeDirectory(sysPath);
    }

    if (strPath) {
        rtl_uString_release(strPath); 
    }
    if (sysPath) {
        rtl_uString_release(sysPath); 
    }
}


//oslFileError SAL_CALL osl_removeDirectory( rtl_uString* strPath );

extern "C" void SAL_CALL test_osl_file_osl_removeDirectory(TestResult *oRes)
{
    rtl_uString *strPath = NULL;
    rtl_uString *sysPath = NULL;
    oslDirectory pDir = NULL;

    rtl_uString_newFromAscii(&strPath, "/tmp/test");

    if (strPath &&
	(osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None) &&
	(osl_createDirectory(sysPath) == osl_File_E_None)) {
        oRes->state(osl_removeDirectory(sysPath) == osl_File_E_None);
    } else {
        oRes->state(0);
    }

    if (strPath) {
        rtl_uString_release(strPath); 
    }
    if (sysPath) {
        rtl_uString_release(sysPath); 
    }
}


//oslFileError SAL_CALL osl_removeFile( rtl_uString* strPath );

extern "C" void SAL_CALL test_osl_file_osl_removeFile(TestResult *oRes)
{
    rtl_uString *strPath = NULL; 
    rtl_uString *sysPath = NULL; 
    oslFileHandle pHandle;

    rtl_uString_newFromAscii(&strPath, "/tmp/test"); 

    if (strPath &&
	(osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None) &&
	(osl_openFile(sysPath, &pHandle, osl_File_OpenFlag_Create) == osl_File_E_None)) {
        osl_closeFile(pHandle);
	oRes->state(osl_removeFile(sysPath) == osl_File_E_None);
    } else { 
        oRes->state(0); 
    } 

    if (strPath) {
        rtl_uString_release(strPath); 
    }
    if (sysPath) {
        rtl_uString_release(sysPath); 
    }
}


//oslFileError SAL_CALL osl_copyFile( rtl_uString* strPath,
//                                    rtl_uString *strDestPath );

extern "C" void SAL_CALL test_osl_file_osl_copyFile(TestResult *oRes)
{
    rtl_uString *strSrcPath = NULL; 
    rtl_uString *strDstPath = NULL; 
    rtl_uString *sysSrcPath = NULL; 
    rtl_uString *sysDstPath = NULL; 
    oslFileHandle pSrcHandle;

    rtl_uString_newFromAscii(&strSrcPath, "/tmp/test.src"); 
    rtl_uString_newFromAscii(&strDstPath, "/tmp/test.dst"); 


    if (strSrcPath && strDstPath &&
	(osl_getFileURLFromSystemPath(strSrcPath, &sysSrcPath) == osl_File_E_None) &&
	(osl_getFileURLFromSystemPath(strDstPath, &sysDstPath) == osl_File_E_None) &&
	(osl_openFile(sysSrcPath, &pSrcHandle, osl_File_OpenFlag_Create) == osl_File_E_None) &&
        (osl_closeFile(pSrcHandle) == osl_File_E_None)) {
	oRes->state(osl_copyFile(sysSrcPath, sysDstPath) == osl_File_E_None);
//This test appears correct when checking the file system, not sure why it returns osl_File_E_INVAL
	osl_removeFile(sysSrcPath);
	osl_removeFile(sysDstPath);
    } else { 
        oRes->state(0); 
    } 

    if (strSrcPath) {
        rtl_uString_release(strSrcPath); 
    }
    if (sysSrcPath) {
        rtl_uString_release(sysSrcPath); 
    }
    if (strDstPath) {
        rtl_uString_release(strDstPath); 
    }
    if (sysDstPath) {
        rtl_uString_release(sysDstPath); 
    }
}


//oslFileError SAL_CALL osl_moveFile( rtl_uString* strPath,
//                                    rtl_uString *strDestPath );

extern "C" void SAL_CALL test_osl_file_osl_moveFile(TestResult *oRes)
{
    rtl_uString *strSrcPath = NULL; 
    rtl_uString *strDstPath = NULL; 
    rtl_uString *sysSrcPath = NULL; 
    rtl_uString *sysDstPath = NULL; 
    oslFileHandle pSrcHandle;

    rtl_uString_newFromAscii(&strSrcPath, "/tmp/test.src"); 
    rtl_uString_newFromAscii(&strDstPath, "/tmp/test.dst"); 

    if (strSrcPath && strDstPath &&
	(osl_getFileURLFromSystemPath(strSrcPath, &sysSrcPath) == osl_File_E_None) &&
	(osl_getFileURLFromSystemPath(strDstPath, &sysDstPath) == osl_File_E_None) &&
	(osl_openFile(sysSrcPath, &pSrcHandle, osl_File_OpenFlag_Create) == osl_File_E_None) &&
        (osl_closeFile(pSrcHandle) == osl_File_E_None)) {
	oRes->state(osl_moveFile(sysSrcPath, sysDstPath) == osl_File_E_None);
	osl_removeFile(sysDstPath);
    } else { 
        oRes->state(0); 
    } 

    if (strSrcPath) {
        rtl_uString_release(strSrcPath); 
    }
    if (sysSrcPath) {
        rtl_uString_release(sysSrcPath); 
    }
    if (strDstPath) {
        rtl_uString_release(strDstPath); 
    }
    if (sysDstPath) {
        rtl_uString_release(sysDstPath); 
    }
}


//oslFileError SAL_CALL osl_getCanonicalName( rtl_uString *strRequested,
//                                            rtl_uString **strValid);

extern "C" void SAL_CALL test_osl_file_osl_getCanonicalName(TestResult *oRes)
{
    rtl_uString *strRequested = NULL;
    rtl_uString *strValid = NULL;
    rtl_uString *sysPath = NULL;

    rtl_uString_newFromAscii(&strRequested, "/tmp/test");

    if (strRequested &&
	(osl_getFileURLFromSystemPath(strRequested, &sysPath) == osl_File_E_None)) {
        oRes->state(osl_getCanonicalName(sysPath, &strValid) == osl_File_E_None);
    } else {
        oRes->state(0);
    }

    if (strRequested) {
        rtl_uString_release(strRequested);
    }
    if (strValid) {
        rtl_uString_release(strValid);
    }
    if (sysPath) {
        rtl_uString_release(sysPath);
    }
}


//oslFileError SAL_CALL osl_getAbsoluteFileURL( rtl_uString* strDirBase,
//                   rtl_uString *strRelative, rtl_uString **strAbsolute ); 

extern "C" void SAL_CALL test_osl_file_osl_getAbsoluteFileURL(TestResult *oRes)
{
    rtl_uString *strDirBase = NULL;
    rtl_uString *strRel = NULL;
    rtl_uString *sysPath = NULL;

    rtl_uString_newFromAscii(&strDirBase, "/tmp");
    rtl_uString_newFromAscii(&strRel, "test");

    if (strDirBase && strRel) {
        oRes->state(osl_getAbsoluteFileURL(strDirBase, strRel, &sysPath) == osl_File_E_NOENT, "This test is partiallly valid");
    } else {
        oRes->state(0);
    }

    if (strDirBase) {
        rtl_uString_release(strDirBase);
    }
    if (strRel) {
        rtl_uString_release(strRel);
    }
    if (sysPath) {
        rtl_uString_release(sysPath);
    }
}


//oslFileError SAL_CALL osl_getFileURLFromSystemPath( rtl_uString *ustrSystemPath, rtl_uString **pustrFileURL); 

extern "C" void SAL_CALL test_osl_file_osl_getFileURLFromSystemPath(TestResult *oRes)
{
    rtl_uString *strPath = NULL; 
    rtl_uString *sysPath = NULL; 

    rtl_uString_newFromAscii(&strPath, "/tmp/test"); 

    if (strPath) {
        oRes->state(osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None);
    } else {
        oRes->state(0);
    }

    if (strPath) {
        rtl_uString_release(strPath); 
    }
    if (sysPath) {
        rtl_uString_release(sysPath); 
    }
}


//oslFileError SAL_CALL osl_searchFileURL( rtl_uString *ustrFileName,
//            rtl_uString *ustrSearchPath, rtl_uString **pustrFileURL );  

extern "C" void SAL_CALL test_osl_file_osl_searchFileURL(TestResult *oRes)
{
    rtl_uString *strFileName = NULL;
    rtl_uString *strSearchPath = NULL;
    rtl_uString *strFileURL = NULL;

    rtl_uString_newFromAscii(&strFileName, "test");
    rtl_uString_newFromAscii(&strSearchPath, "/tmp");

    if (strFileName && strSearchPath) {
        oRes->state(osl_searchFileURL(strFileName, strSearchPath, &strFileURL) == osl_File_E_None);
    } else {
        oRes->state(0);
    }

    if (strFileName) {
        rtl_uString_release(strFileName);
    }
    if (strSearchPath) {
        rtl_uString_release(strSearchPath);
    }
    if (strFileURL) {
        rtl_uString_release(strFileURL);
    }

}

//oslFileError SAL_CALL osl_getSystemPathFromFileURL( rtl_uString *ustrFileURL,
//                                              rtl_uString **pustrSystemPath);

extern "C" void SAL_CALL test_osl_file_osl_getSystemPathFromFileURL(TestResult *oRes)
{
    rtl_uString *strPath = NULL; 
    rtl_uString *strFileURL = NULL;
    rtl_uString *sysPath = NULL; 

    rtl_uString_newFromAscii(&strPath, "/tmp/test"); 

    if (strPath &&
        (osl_getFileURLFromSystemPath(strPath, &strFileURL) == osl_File_E_None)) {
        oRes->state(osl_getSystemPathFromFileURL(strFileURL, &sysPath) == osl_File_E_None);
    } else {
        oRes->state(0);
    }

    if (strPath) {
        rtl_uString_release(strPath); 
    }
    if (sysPath) {
        rtl_uString_release(sysPath); 
    }
    if (strFileURL) {
        rtl_uString_release(strFileURL); 
    }
}


//oslFileError SAL_CALL osl_setFileAttributes( rtl_uString *filePath,
//                                             sal_uInt64 uAttributes );

extern "C" void SAL_CALL test_osl_file_osl_setFileAttributes(TestResult *oRes)
{
    rtl_uString *strPath = NULL; 
    rtl_uString *sysPath = NULL; 
    oslFileHandle pHandle;

    rtl_uString_newFromAscii(&strPath, "/tmp/test");

    if (strPath &&
	(osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None) &&
	(osl_openFile(sysPath, &pHandle, osl_File_OpenFlag_Create) == osl_File_E_None)) {
        osl_closeFile(pHandle);
	oRes->state(osl_setFileAttributes(sysPath, osl_File_Attribute_OwnExe & osl_File_Attribute_OwnRead) == osl_File_E_None, "This test is partially valid");
//This call does not appear to modify the file system
	osl_removeFile(sysPath);
    } else {
        oRes->state(0);
    }

    if (strPath) {
        rtl_uString_release(strPath); 
    }
    if (sysPath) {
        rtl_uString_release(sysPath); 
    }
}


//oslFileError SAL_CALL osl_setFileTime( rtl_uString *filePath,
//                                       TimeValue *aCreationTime,
//          TimeValue *aLastAccessTime, TimeValue *aLastWriteTime);  

extern "C" void SAL_CALL test_osl_file_osl_setFileTime(TestResult *oRes)
{
    rtl_uString *strPath = NULL; 
    rtl_uString *sysPath = NULL; 
    oslFileHandle pHandle;
    TimeValue *pTV = NULL;

    rtl_uString_newFromAscii(&strPath, "/tmp/test.time"); 

    if (strPath &&
	(osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None) &&
	((pTV = (TimeValue*)malloc(sizeof(TimeValue))) != NULL) &&
        (osl_openFile(sysPath, &pHandle, osl_File_OpenFlag_Create) == osl_File_E_None) &&
        (osl_closeFile(pHandle) == osl_File_E_None)) {
	pTV->Seconds = 1;
	pTV->Nanosec = 2;
	oRes->state(osl_setFileTime(sysPath, pTV, pTV, pTV) == osl_File_E_None);
	osl_removeFile(sysPath);
    } else {
        oRes->state(0);
    }

    if (strPath) {
        rtl_uString_release(strPath); 
    }
    if (sysPath) {
        rtl_uString_release(sysPath); 
    }
    if (pTV) {
        free(pTV);
    }
}


using namespace osl;

//static inline RC getCanonicalName( const ::rtl::OUString& strRequested,
//                                         ::rtl::OUString& strValid )

extern "C" void SAL_CALL test_osl_file_FileBase_getCanonicalName(TestResult *oRes)
{
    ::rtl::OUString *strRequested1 = NULL;
    ::rtl::OUString strRequested2;
    ::rtl::OUString strValid1;
    ::rtl::OUString strValid2;
    rtl_uString *strPath = NULL;
    rtl_uString *sysPath = NULL;

    rtl_uString_newFromAscii(&strPath, "/tmp/test");

    if (strPath && (strRequested1 = new ::rtl::OUString()) &&
	(osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None)) {
        strRequested2.pData = sysPath;
	oRes->state((FileBase::getCanonicalName(*strRequested1, strValid1) ==:: osl::FileBase::E_INVAL) && (FileBase::getCanonicalName(strRequested2, strValid2) == ::osl::FileBase::E_None));
    } else {
        oRes->state(0);
    }

    if (strRequested1) {
        delete strRequested1;
    }
    if (strPath) {
        rtl_uString_release(strPath);
    }
}


//static inline RC getAbsoluteFileURL( const ::rtl::OUString& strDirBase,
//      const ::rtl::OUString& strRelative, ::rtl::OUString& strAbsolute )

extern "C" void SAL_CALL test_osl_file_FileBase_getAbsoluteFileURL(TestResult *oRes)
{
    rtl_uString *strDirBase = NULL;
    rtl_uString *strRel = NULL;
    ::rtl::OUString oustrDirBase;
    ::rtl::OUString oustrRel;
    ::rtl::OUString oustrAbs;

    rtl_uString_newFromAscii(&strDirBase, "/");
    rtl_uString_newFromAscii(&strRel, "tmp");

    if (strDirBase && strRel) {
        oustrDirBase.pData = strDirBase;
	oustrRel.pData = strRel;
        oRes->state(FileBase::getAbsoluteFileURL(oustrDirBase, oustrRel, oustrAbs) == ::osl::FileBase::E_None);
    } else {
        oRes->state(0);
    }
}


//static inline RC getSystemPathFromFileURL( const ::rtl::OUString& strFileURL,
//                                             ::rtl::OUString& strSystemPath )

extern "C" void SAL_CALL test_osl_file_FileBase_getSystemPathFromFileURL(TestResult *oRes)
{
    rtl_uString *strPath = NULL; 
    rtl_uString *strFileURL = NULL;
    rtl_uString *sysPath = NULL; 
    ::rtl::OUString oustrFileURL;
    ::rtl::OUString oustrSysPath;

    rtl_uString_newFromAscii(&strPath, "/tmp/test"); 

    if (strPath &&
        (osl_getFileURLFromSystemPath(strPath, &strFileURL) == osl_File_E_None)) {
        oustrFileURL.pData = strFileURL;
	oRes->state(FileBase::getSystemPathFromFileURL(oustrFileURL, oustrSysPath) == ::osl::FileBase::E_None);
    } else {
        oRes->state(0);
    }

    if (strPath) {
        rtl_uString_release(strPath);
    }
}


//static inline RC getFileURLFromSystemPath( const ::rtl::OUString& strSystemPath, ::rtl::OUString& strFileURL )

extern "C" void SAL_CALL test_osl_file_FileBase_getFileURLFromSystemPath(TestResult *oRes)
{
    rtl_uString *strPath = NULL;
    ::rtl::OUString oustrPath;
    ::rtl::OUString oustrFileURL;

    rtl_uString_newFromAscii(&strPath, "/tmp/test");

    if (strPath) {
        oustrPath.pData = strPath;
	oRes->state(FileBase::getFileURLFromSystemPath(oustrPath, oustrFileURL) == ::osl::FileBase::E_None);
    } else {
        oRes->state(0);
    }
}


//static inline RC searchFileURL( const ::rtl::OUString& strFileName,
//    const ::rtl::OUString& strSystemSearchPath, ::rtl::OUString& strFileURL )

extern "C" void SAL_CALL test_osl_file_FileBase_searchFileURL(TestResult *oRes)
{
    rtl_uString *strFileName = NULL;
    rtl_uString *strSearchPath = NULL;
    ::rtl::OUString oustrFileName;
    ::rtl::OUString oustrSearchPath;
    ::rtl::OUString oustrFileURL;

    rtl_uString_newFromAscii(&strFileName, "test");
    rtl_uString_newFromAscii(&strSearchPath, "/tmp");

    if (strFileName && strSearchPath) {
        oustrFileName.pData = strFileName;
	oustrSearchPath.pData = strSearchPath;
	oRes->state(FileBase::searchFileURL(oustrFileName, oustrSearchPath, oustrFileURL) == ::osl::FileBase::E_None);
    } else {
        oRes->state(0);
    }
}


//VolumeDevice()

extern "C" void SAL_CALL test_osl_file_VolumeDevice_ctor_01(TestResult *oRes)
{
    VolumeDevice *pVD = NULL;

    pVD = new VolumeDevice;

    if (pVD) {
        oRes->state(1);
    } else {
        oRes->state(0);
    }

    if (pVD) {
	delete pVD;
    }
}


//VolumeDevice( const VolumeDevice & rDevice )

extern "C" void SAL_CALL test_osl_file_VolumeDevice_ctor_02(TestResult *oRes)
{
    VolumeDevice *pVD1 = NULL;
    VolumeDevice *pVD2 = NULL;

    pVD1 = new VolumeDevice;

    if (pVD1 && (pVD2 = new VolumeDevice(*pVD1))) {
        oRes->state(1);
    } else {
        oRes->state(0);
    }

    if (pVD1) {
	delete pVD1;
    }
    if (pVD2) {
	delete pVD2;
    }
}


//~VolumeDevice()

extern "C" void SAL_CALL test_osl_file_VolumeDevice_dtor(TestResult *oRes)
{
    VolumeDevice *pVD = NULL;

    pVD = new VolumeDevice;

    if (pVD) {
        delete pVD;
        oRes->state(1);
    } else {
        oRes->state(0);
    }
}


//inline VolumeDevice & operator =( const VolumeDevice & rDevice ) 

extern "C" void SAL_CALL test_osl_file_VolumeDevice_equal(TestResult *oRes)
{
    VolumeDevice pVD1;
    VolumeDevice pVD2;

    pVD2 = pVD1;

    oRes->state(1);
}


//inline RC automount() 

extern "C" void SAL_CALL test_osl_file_VolumeDevice_automount(TestResult *oRes)
{
    VolumeDevice *pVD = NULL;

    pVD = new VolumeDevice;

    if (pVD) {
        oRes->state(pVD->automount() == osl_File_E_INVAL, "This test is partially valid");
    } else {
        oRes->state(0);
    }

    if (pVD) {
        delete pVD;
    }
}


//inline RC unmount() 

extern "C" void SAL_CALL test_osl_file_VolumeDevice_unmount(TestResult *oRes)
{
    VolumeDevice *pVD = NULL;

    pVD = new VolumeDevice;

    if (pVD) {
        oRes->state(pVD->unmount() == osl_File_E_INVAL, "This test is partially valid");
    } else {
        oRes->state(0);
    }

    if (pVD) {
        delete pVD;
    }

}


//inline rtl::OUString getMountPath()

extern "C" void SAL_CALL test_osl_file_VolumeDevice_getMountPath(TestResult *oRes)
{
    VolumeDevice *pVD = NULL;

    pVD = new VolumeDevice;

    if (pVD) {
	pVD->getMountPath();
        oRes->state(1, "This test is partially valid");
    } else {
        oRes->state(0);
    }

    if (pVD) {
        delete pVD;
    }
}


//VolumeInfo( sal_uInt32 nMask ): _nMask( nMask ) 

extern "C" void SAL_CALL test_osl_file_VolumeInfo_ctor(TestResult *oRes)
{
    VolumeInfo *pVI = NULL;

    pVI = new VolumeInfo(VolumeInfoMask_Attributes);

    if (pVI) {
        oRes->state(1);
    } else {
        oRes->state(0);
    }

    if (pVI) {
        delete pVI;
    }
}


//~VolumeInfo()

extern "C" void SAL_CALL test_osl_file_VolumeInfo_dtor(TestResult *oRes)
{
    VolumeInfo *pVI = NULL;

    pVI = new VolumeInfo(VolumeInfoMask_Attributes);

    if (pVI) {
        delete pVI;
        oRes->state(1);
    } else {
        oRes->state(0);
    }
}


//inline sal_Bool isValid( sal_uInt32 nMask ) const

extern "C" void SAL_CALL test_osl_file_VolumeInfo_isValid(TestResult *oRes)
{
    VolumeInfo *pVI = NULL;

    pVI = new VolumeInfo(VolumeInfoMask_Attributes);

    if (pVI) {
        oRes->state(pVI->isValid(VolumeInfoMask_Attributes) == sal_False, "This test is partially valid");
    } else {
        oRes->state(0);
    }

    if (pVI) {
        delete pVI;
    }
}


//inline sal_Bool getRemoteFlag() const 

extern "C" void SAL_CALL test_osl_file_VolumeInfo_getRemoteFlag(TestResult *oRes)
{
    VolumeInfo *pVI = NULL;

    pVI = new VolumeInfo(VolumeInfoMask_Attributes);

    if (pVI) {
        oRes->state(pVI->getRemoteFlag() == sal_False, "This test is partially valid");
    } else {
        oRes->state(0);
    }

    if (pVI) {
        delete pVI;
    }
}


//inline sal_Bool getRemoveableFlag() const 

extern "C" void SAL_CALL test_osl_file_VolumeInfo_getRemoveableFlag(TestResult *oRes)
{
    VolumeInfo *pVI = NULL;

    pVI = new VolumeInfo(VolumeInfoMask_Attributes);

    if (pVI) {
        oRes->state(pVI->getRemoveableFlag() == sal_False, "This test is partially valid");
    } else {
        oRes->state(0);
    }

    if (pVI) {
        delete pVI;
    }
}


//inline sal_uInt64 getTotalSpace() const

extern "C" void SAL_CALL test_osl_file_VolumeInfo_getTotalSpace(TestResult *oRes)
{
    VolumeInfo *pVI = NULL;

    pVI = new VolumeInfo(VolumeInfoMask_Attributes);

    if (pVI) {
        oRes->state(pVI->getTotalSpace() == 0, "This test is partially valid");
    } else {
        oRes->state(0);
    }

    if (pVI) {
        delete pVI;
    }
}


//inline sal_uInt64 getFreeSpace() const

extern "C" void SAL_CALL test_osl_file_VolumeInfo_getFreeSpace(TestResult *oRes)
{
    VolumeInfo *pVI = NULL;

    pVI = new VolumeInfo(VolumeInfoMask_Attributes);

    if (pVI) {
        oRes->state(pVI->getFreeSpace() == 0, "This test is partially valid");
    } else {
        oRes->state(0);
    }

    if (pVI) {
        delete pVI;
    }
}


//inline sal_uInt64 getUsedSpace() const

extern "C" void SAL_CALL test_osl_file_VolumeInfo_getUsedSpace(TestResult *oRes)
{
    VolumeInfo *pVI = NULL;

    pVI = new VolumeInfo(VolumeInfoMask_Attributes);

    if (pVI) {
        oRes->state(pVI->getUsedSpace() == 0, "This test is partially valid");
    } else {
        oRes->state(0);
    }

    if (pVI) {
        delete pVI;
    }
}


//inline sal_uInt64 getMaxNameLength() const

extern "C" void SAL_CALL test_osl_file_VolumeInfo_getMaxNameLength(TestResult *oRes)
{
    VolumeInfo *pVI = NULL;

    pVI = new VolumeInfo(VolumeInfoMask_Attributes);

    if (pVI) {
        oRes->state(pVI->getMaxNameLength() == 0, "This test is partially valid");
    } else {
        oRes->state(0);
    }

    if (pVI) {
        delete pVI;
    }
}


//inline sal_uInt64 getMaxPathLength() const

extern "C" void SAL_CALL test_osl_file_VolumeInfo_getMaxPathLength(TestResult *oRes)
{
    VolumeInfo *pVI = NULL;

    pVI = new VolumeInfo(VolumeInfoMask_Attributes);

    if (pVI) {
        oRes->state(pVI->getMaxPathLength() == 0, "This test is partially valid");
    } else {
        oRes->state(0);
    }

    if (pVI) {
        delete pVI;
    }
}


//inline sal_uInt64 getFileSystemName() const

extern "C" void SAL_CALL test_osl_file_VolumeInfo_getFileSystemName(TestResult *oRes)
{
    VolumeInfo *pVI = NULL;
    ::rtl::OUString oustrRet;

    pVI = new VolumeInfo(VolumeInfoMask_Attributes);

    if (pVI) {
        oustrRet = pVI->getFileSystemName();
        oRes->state(1, "This test is partially valid");
    } else {
        oRes->state(0);
    }

    if (pVI) {
        delete pVI;
    }
}


//inline sal_uInt64 getDeviceHandle() const

extern "C" void SAL_CALL test_osl_file_VolumeInfo_getDeviceHandle(TestResult *oRes)
{
    VolumeInfo *pVI = NULL;
    VolumeDevice vdRet;

    pVI = new VolumeInfo(VolumeInfoMask_Attributes);

    if (pVI) {
        vdRet = pVI->getDeviceHandle();
        oRes->state(1, "This test is partially valid");
    } else {
        oRes->state(0);
    }

    if (pVI) {
        delete pVI;
    }
}


//FileStatus( sal_uInt32 nMask ): _nMask( nMask ), _strLinkTargetURL( NULL ),
//                              _strFileURL( NULL ) 

extern "C" void SAL_CALL test_osl_file_FileStatus_ctor(TestResult *oRes)
{
    FileStatus *pFS = NULL;

    pFS = new FileStatus(osl_FileStatus_Mask_All);

    if (pFS) {
        oRes->state(1);
    } else {
        oRes->state(0);
    }

    if (pFS) {
        delete pFS;
    }
}

//~FileStatus( );

extern "C" void SAL_CALL test_osl_file_FileStatus_dtor(TestResult *oRes)
{
    FileStatus *pFS = NULL;

    pFS = new FileStatus(osl_FileStatus_Mask_All);

    if (pFS) {
        delete pFS;
        oRes->state(1);
    } else {
        oRes->state(0);
    }
}


//inline sal_Bool isValid( sal_uInt32 nMask ) const

extern "C" void SAL_CALL test_osl_file_FileStatus_isValid(TestResult *oRes)
{
    FileStatus *pFS = NULL;

    pFS = new FileStatus(osl_FileStatus_Mask_All);

    if (pFS) {
        oRes->state(pFS->isValid(FileStatusMask_Attributes) == sal_False, "This test is partially valid");
    } else {
        oRes->state(0);
    }

    if (pFS) {
        delete pFS;
    }
}


//inline Type getFileType() const

extern "C" void SAL_CALL test_osl_file_FileStatus_getFileType(TestResult *oRes)
{
    FileStatus *pFS = NULL;

    pFS = new FileStatus(osl_FileStatus_Mask_All);

    if (pFS) {
        oRes->state(pFS->getFileType() == osl_File_Type_Unknown, "This test is partially valid");
    } else {
        oRes->state(0);
    }

    if (pFS) {
        delete pFS;
    }
}


//inline sal_uInt64 getAttributes() const

extern "C" void SAL_CALL test_osl_file_FileStatus_getAttributes(TestResult *oRes)
{
    FileStatus *pFS = NULL;

    pFS = new FileStatus(osl_FileStatus_Mask_All);

    if (pFS) {
	pFS->getAttributes();
	oRes->state(1, "This test is partially valid");
    } else {
        oRes->state(0);
    }

    if (pFS) {
        delete pFS;
    }
}


//inline TimeValue getCreationTime() const

extern "C" void SAL_CALL test_osl_file_FileStatus_getCreationTime(TestResult *oRes)
{
    FileStatus *pFS = NULL;

    pFS = new FileStatus(osl_FileStatus_Mask_All);

    if (pFS) {
	pFS->getCreationTime();
	oRes->state(1, "This test is partially valid");
    } else {
        oRes->state(0);
    }

    if (pFS) {
        delete pFS;
    }
}


//inline TimeValue getAccessTime() const

extern "C" void SAL_CALL test_osl_file_FileStatus_getAccessTime(TestResult *oRes)
{
    FileStatus *pFS = NULL;

    pFS = new FileStatus(osl_FileStatus_Mask_All);

    if (pFS) {
	pFS->getAccessTime();
	oRes->state(1, "This test is partially valid");
    } else {
        oRes->state(0);
    }

    if (pFS) {
        delete pFS;
    }
}


//inline TimeValue getModifyTime() const

extern "C" void SAL_CALL test_osl_file_FileStatus_getModifyTime(TestResult *oRes)
{
    FileStatus *pFS = NULL;

    pFS = new FileStatus(osl_FileStatus_Mask_All);

    if (pFS) {
	pFS->getModifyTime();
	oRes->state(1, "This test is partially valid");
    } else {
        oRes->state(0);
    }

    if (pFS) {
        delete pFS;
    }
}


//inline sal_uInt64 getFileSize() const

extern "C" void SAL_CALL test_osl_file_FileStatus_getFileSize(TestResult *oRes)
{
    FileStatus *pFS = NULL;

    pFS = new FileStatus(osl_FileStatus_Mask_All);

    if (pFS) {
	pFS->getFileSize();
	oRes->state(1, "This test is partially valid");
    } else {
        oRes->state(0);
    }

    if (pFS) {
        delete pFS;
    }
}


//inline ::rtl::OUString getFileName() const

extern "C" void SAL_CALL test_osl_file_FileStatus_getFileName(TestResult *oRes)
{
    FileStatus *pFS = NULL;

    pFS = new FileStatus(osl_FileStatus_Mask_All);

    if (pFS) {
	pFS->getFileName();
	oRes->state(1, "This test is partially valid");
    } else {
        oRes->state(0);
    }

    if (pFS) {
        delete pFS;
    }
}


//inline ::rtl::OUString getFileURL() const

extern "C" void SAL_CALL test_osl_file_FileStatus_getFileURL(TestResult *oRes)
{
    FileStatus *pFS = NULL;

    pFS = new FileStatus(osl_FileStatus_Mask_All);

    if (pFS) {
	pFS->getFileURL();
	oRes->state(1, "This test is partially valid");
    } else {
        oRes->state(0);
    }

    if (pFS) {
        delete pFS;
    }
}


//inline ::rtl::OUString getLinkTargetURL() const

extern "C" void SAL_CALL test_osl_file_FileStatus_getLinkTargetURL(TestResult *oRes)
{
    FileStatus *pFS = NULL;

    pFS = new FileStatus(osl_FileStatus_Mask_All);

    if (pFS) {
	pFS->getLinkTargetURL();
	oRes->state(1, "This test is partially valid");
    } else {
        oRes->state(0);
    }

    if (pFS) {
        delete pFS;
    }
}


//File( const ::rtl::OUString& strPath ): _pData( 0 ), _aPath( strPath ) {};

extern "C" void SAL_CALL test_osl_file_File_ctor(TestResult *oRes)
{
    File *pF = NULL;
    rtl_uString *strPath = NULL; 
    ::rtl::OUString strOUPath;

    rtl_uString_newFromAscii(&strPath, "/tmp/test"); 

    if (strPath && (strOUPath.pData = strPath) && (pF = new File(strOUPath))) {
        oRes->state(1);
    } else {
        oRes->state(0);
    }

    if (pF) {
        delete pF;
    }
}


//~File()

extern "C" void SAL_CALL test_osl_file_File_dtor(TestResult *oRes)
{
    File *pF = NULL;
    rtl_uString *strPath = NULL; 
    ::rtl::OUString strOUPath;

    rtl_uString_newFromAscii(&strPath, "/tmp/test"); 

    if (strPath && (strOUPath.pData = strPath) && (pF = new File(strOUPath))) {
        delete pF;
	oRes->state(1);
    } else {
        oRes->state(0);
    }

    if (pF) {
        delete pF;
    }
}


//inline RC open( sal_uInt32 uFlags )

extern "C" void SAL_CALL test_osl_file_File_open(TestResult *oRes)
{
    File *pF = NULL;
    rtl_uString *strPath = NULL; 
    rtl_uString *sysPath = NULL;
    ::rtl::OUString strOUPath;

    rtl_uString_newFromAscii(&strPath, "/tmp/test");

    if (strPath &&
	(osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None) &&
	(strOUPath.pData = sysPath) &&
	(pF = new File(strOUPath))) {
        oRes->state(pF->open(osl_File_OpenFlag_Create) == ::osl::FileBase::E_None);
	pF->remove(strOUPath);
    } else {
        oRes->state(0);
    }

    if (strPath) {
        rtl_uString_release(strPath);
    }
    if (pF) {
        delete pF;
    }
}


//inline RC close()

extern "C" void SAL_CALL test_osl_file_File_close(TestResult *oRes)
{
    File *pF = NULL;
    rtl_uString *strPath = NULL; 
    rtl_uString *sysPath = NULL;
    ::rtl::OUString strOUPath;

    rtl_uString_newFromAscii(&strPath, "/tmp/test");

    if (strPath &&
	(osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None) &&
	(strOUPath.pData = sysPath) &&
	(pF = new File(strOUPath)) &&
        (pF->open(osl_File_OpenFlag_Create) == ::osl::FileBase::E_None)) {
        oRes->state(pF->close() == ::osl::FileBase::E_None);
	pF->remove(strOUPath);
    } else {
        oRes->state(0);
    }

    if (strPath) {
        rtl_uString_release(strPath);
    }
    if (pF) {
        delete pF;
    }
}


//inline RC setPos( sal_uInt32 uHow, sal_Int64 uPos )

extern "C" void SAL_CALL test_osl_file_File_setPos(TestResult *oRes)
{
    File *pF = NULL;
    rtl_uString *strPath = NULL; 
    rtl_uString *sysPath = NULL;
    ::rtl::OUString strOUPath;

    rtl_uString_newFromAscii(&strPath, "/tmp/test");

    if (strPath &&
	(osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None) &&
	(strOUPath.pData = sysPath) && (pF = new File(strOUPath)) &&
        (pF->open(osl_File_OpenFlag_Create) == ::osl::FileBase::E_None)) {
        oRes->state(pF->setPos(1, 0) == ::osl::FileBase::E_None);
	pF->remove(strOUPath);
    } else {
        oRes->state(0);
    }

    if (strPath) {
        rtl_uString_release(strPath);
    }
    if (pF) {
        delete pF;
    }
}


//inline RC getPos( sal_uInt64& uPos )

extern "C" void SAL_CALL test_osl_file_File_getPos(TestResult *oRes)
{
    File *pF = NULL;
    rtl_uString *strPath = NULL; 
    rtl_uString *sysPath = NULL;
    ::rtl::OUString strOUPath;
    sal_uInt64 pRes = 0;

    rtl_uString_newFromAscii(&strPath, "/tmp/test");

    if (strPath &&
	(osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None) &&
	(strOUPath.pData = sysPath) && (pF = new File(strOUPath)) &&
        (pF->open(osl_File_OpenFlag_Create) == ::osl::FileBase::E_None)) {
        oRes->state(pF->getPos(pRes) == ::osl::FileBase::E_None);
	pF->remove(strOUPath);
    } else {
        oRes->state(0);
    }

    if (strPath) {
        rtl_uString_release(strPath);
    }
    if (pF) {
        delete pF;
    }
}


//inline RC setSize( sal_uInt64 uSize )

extern "C" void SAL_CALL test_osl_file_File_setSize(TestResult *oRes)
{
    File *pF = NULL;
    rtl_uString *strPath = NULL; 
    rtl_uString *sysPath = NULL;
    ::rtl::OUString strOUPath;
 
    rtl_uString_newFromAscii(&strPath, "/tmp/test");

    if (strPath &&
	(osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None) &&
	(strOUPath.pData = sysPath) && (pF = new File(strOUPath)) &&
        (pF->open(osl_File_OpenFlag_Create) == ::osl::FileBase::E_None)) {
        oRes->state(pF->setSize(1025) == ::osl::FileBase::E_None);
	pF->remove(strOUPath);
    } else {
        oRes->state(0);
    }

    if (strPath) {
        rtl_uString_release(strPath);
    }
    if (pF) {
        delete pF;
    }
}


//inline RC read( void *pBuffer, sal_uInt64 uBytesRequested,
//                sal_uInt64& rBytesRead )

extern "C" void SAL_CALL test_osl_file_File_read(TestResult *oRes)
{
    File *pF = NULL;
    rtl_uString *strPath = NULL; 
    rtl_uString *sysPath = NULL;
    ::rtl::OUString strOUPath;
    char pBuffer[24] = "Hi there";
    char pReadBuffer[1024];
    sal_uInt64 pRead = 0;
    sal_uInt64 pWritten = 0;
 
    rtl_uString_newFromAscii(&strPath, "/tmp/test");

    if (strPath &&
	(osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None) &&
	(strOUPath.pData = sysPath) && (pF = new File(strOUPath)) &&
        (pF->open(osl_File_OpenFlag_Create) == ::osl::FileBase::E_None) &&
	(pF->write(pBuffer, 16, pWritten) == ::osl::FileBase::E_None) &&
        (pF->close() == ::osl::FileBase::E_None) &&
	(pF->open(osl_File_OpenFlag_Read) == ::osl::FileBase::E_None)) {
        oRes->state(pF->read(pReadBuffer, 8, pRead) == ::osl::FileBase::E_None);
	pF->remove(strOUPath);
    } else {
        oRes->state(0);
    }

    if (strPath) {
        rtl_uString_release(strPath);
    }
    if (pF) {
        delete pF;
    }
}


//inline RC write(const void *pBuffer, sal_uInt64 uBytesToWrite,
//                sal_uInt64& rBytesWritten)


extern "C" void SAL_CALL test_osl_file_File_write(TestResult *oRes)
{
    File *pF = NULL;
    rtl_uString *strPath = NULL; 
    rtl_uString *sysPath = NULL;
    ::rtl::OUString strOUPath;
    char pBuffer[24] = "Hi there";
    sal_uInt64 pWritten = 0;
 
    rtl_uString_newFromAscii(&strPath, "/tmp/test");

    if (strPath &&
	(osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None) &&
	(strOUPath.pData = sysPath) && (pF = new File(strOUPath)) &&
        (pF->open(osl_File_OpenFlag_Create) == ::osl::FileBase::E_None)) {
        oRes->state(pF->write(pBuffer, 16, pWritten) == ::osl::FileBase::E_None);
        pF->close();
	pF->remove(strOUPath);
    } else {
        oRes->state(0);
    }

    if (strPath) {
        rtl_uString_release(strPath);
    }
    if (pF) {
        delete pF;
    }
}


//inline RC readLine( ::rtl::ByteSequence& aSeq )

extern "C" void SAL_CALL test_osl_file_File_readLine(TestResult *oRes)
{
    File *pF = NULL;
    rtl_uString *strPath = NULL; 
    rtl_uString *sysPath = NULL;
    ::rtl::OUString strOUPath;
    char pBuffer[24] = "Hi\nthere\ntester";
    ::rtl::ByteSequence pBSBuffer;
    sal_uInt64 pWritten = 0;
 
    rtl_uString_newFromAscii(&strPath, "/tmp/test.rl2");

    if (strPath &&
	(osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None) &&
	(strOUPath.pData = sysPath) && (pF = new File(strOUPath)) &&
        (pF->open(osl_File_OpenFlag_Create) == ::osl::FileBase::E_None) &&
	(pF->write(pBuffer, 24, pWritten) == ::osl::FileBase::E_None) &&
        (pF->close() == ::osl::FileBase::E_None) &&
	(pF->open(osl_File_OpenFlag_Read) == ::osl::FileBase::E_None)) {
        oRes->state(pF->readLine(pBSBuffer) == ::osl::FileBase::E_None);
	pF->remove(strOUPath);
    } else {
        oRes->state(0);
    }

    if (strPath) {
        rtl_uString_release(strPath);
    }
    if (pF) {
        delete pF;
    }
}


//inline static RC copy( const ::rtl::OUString& strPath,
//                       const ::rtl::OUString& strDestPath )

extern "C" void SAL_CALL test_osl_file_File_copy(TestResult *oRes)
{
    File *pF = NULL;
    rtl_uString *strSrcPath = NULL; 
    rtl_uString *strDstPath = NULL; 
    rtl_uString *sysSrcPath = NULL;
    rtl_uString *sysDstPath = NULL;
    ::rtl::OUString strOUSrcPath;
    ::rtl::OUString strOUDstPath;

    rtl_uString_newFromAscii(&strSrcPath, "/tmp/test.src");
    rtl_uString_newFromAscii(&strDstPath, "/tmp/test.dst");

    if (strSrcPath && strDstPath &&
	(osl_getFileURLFromSystemPath(strSrcPath, &sysSrcPath) == osl_File_E_None) &&
	(osl_getFileURLFromSystemPath(strDstPath, &sysDstPath) == osl_File_E_None) &&
	(strOUSrcPath.pData = sysSrcPath) && (strOUDstPath.pData = sysDstPath) &&
	(pF = new File(strOUSrcPath)) &&
        (pF->open(osl_File_OpenFlag_Create) == ::osl::FileBase::E_None) &&
	(pF->close() == ::osl::FileBase::E_None)) {
        oRes->state(pF->copy(strOUSrcPath, strOUDstPath) == ::osl::FileBase::E_None);
//This test appears correct when checking the file system, not sure why it returns osl_File_E_INVAL
	pF->remove(strOUSrcPath);
	pF->remove(strOUDstPath);
    } else {
        oRes->state(0);
    }

    if (strSrcPath) {
        rtl_uString_release(strSrcPath);
    }
    if (strDstPath) {
        rtl_uString_release(strDstPath);
    }
    if (pF) {
        delete pF;
    }
}


//inline static RC move( const ::rtl::OUString& strPath,
//                       const ::rtl::OUString& strDestPath )

extern "C" void SAL_CALL test_osl_file_File_move(TestResult *oRes)
{
    File *pF = NULL;
    rtl_uString *strSrcPath = NULL; 
    rtl_uString *strDstPath = NULL; 
    rtl_uString *sysSrcPath = NULL;
    rtl_uString *sysDstPath = NULL;
    ::rtl::OUString strOUSrcPath;
    ::rtl::OUString strOUDstPath;

    rtl_uString_newFromAscii(&strSrcPath, "/tmp/test.src");
    rtl_uString_newFromAscii(&strDstPath, "/tmp/test.dst");

    if (strSrcPath && strDstPath &&
	(osl_getFileURLFromSystemPath(strSrcPath, &sysSrcPath) == osl_File_E_None) &&
	(osl_getFileURLFromSystemPath(strDstPath, &sysDstPath) == osl_File_E_None) &&
	(strOUSrcPath.pData = sysSrcPath) && (strOUDstPath.pData = sysDstPath) &&
	(pF = new File(strOUSrcPath)) &&
        (pF->open(osl_File_OpenFlag_Create) == ::osl::FileBase::E_None) &&
	(pF->close() == ::osl::FileBase::E_None)) {
        oRes->state(pF->move(strOUSrcPath, strOUDstPath) == ::osl::FileBase::E_None);
	pF->remove(strOUDstPath);
    } else {
        oRes->state(0);
    }

    if (strSrcPath) {
        rtl_uString_release(strSrcPath);
    }
    if (strDstPath) {
        rtl_uString_release(strDstPath);
    }
    if (pF) {
        delete pF;
    }
}


//inline static RC remove( const ::rtl::OUString& strPath )

extern "C" void SAL_CALL test_osl_file_File_remove(TestResult *oRes)
{
    File *pF = NULL;
    rtl_uString *strPath = NULL; 
    rtl_uString *sysPath = NULL;
    ::rtl::OUString strOUPath;

    rtl_uString_newFromAscii(&strPath, "/tmp/test");

    if (strPath &&
	(osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None) &&
	(strOUPath.pData = sysPath) && (pF = new File(strOUPath)) &&
        (pF->open(osl_File_OpenFlag_Create) == ::osl::FileBase::E_None)) {
        oRes->state(pF->remove(strOUPath) == ::osl::FileBase::E_None);
    } else {
        oRes->state(0);
    }

    if (strPath) {
        rtl_uString_release(strPath);
    }
    if (pF) {
        delete pF;
    }
}


//inline static RC setAttributes( const ::rtl::OUString& strPath,
//                                sal_uInt64 uAttributes ) 

extern "C" void SAL_CALL test_osl_file_File_setAttributes(TestResult *oRes)
{
    File *pF = NULL;
    rtl_uString *strPath = NULL; 
    rtl_uString *sysPath = NULL;
    ::rtl::OUString strOUPath;
 
    rtl_uString_newFromAscii(&strPath, "/tmp/test");

    if (strPath &&
	(osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None) &&
	(strOUPath.pData = sysPath) && (pF = new File(strOUPath)) &&
        (pF->open(osl_File_OpenFlag_Create) == ::osl::FileBase::E_None)) {
        oRes->state(pF->setAttributes(strOUPath,Attribute_Executable) == ::osl::FileBase::E_None);
        pF->close();
	pF->remove(strOUPath);
    } else {
        oRes->state(0);
    }

    if (strPath) {
        rtl_uString_release(strPath);
    }
    if (pF) {
        delete pF;
    }
}


//inline static RC setTime( const ::rtl::OUString& strPath,
//                          TimeValue& rCreationTime,
//    TimeValue& rLastAccessTime, TimeValue& rLastWriteTime )

extern "C" void SAL_CALL test_osl_file_File_setTime(TestResult *oRes)
{
    File *pF = NULL;
    rtl_uString *strPath = NULL; 
    rtl_uString *sysPath = NULL;
    ::rtl::OUString strOUPath;
    TimeValue *pTV = NULL;
 
    rtl_uString_newFromAscii(&strPath, "/tmp/test");

    if (strPath &&
	(osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None) &&
	(strOUPath.pData = sysPath) && (pF = new File(strOUPath)) &&
	((pTV = (TimeValue*)malloc(sizeof(TimeValue))) != NULL) &&
        (pF->open(osl_File_OpenFlag_Create) == ::osl::FileBase::E_None) &&
	(pF->close() == ::osl::FileBase::E_None)) {
        oRes->state(pF->setTime(strOUPath, *pTV, *pTV, *pTV) == ::osl::FileBase::E_None);
	pF->remove(strOUPath);
    } else {
        oRes->state(0);
    }

    if (strPath) {
        rtl_uString_release(strPath);
    }
    if (pF) {
        delete pF;
    }
    if (pTV) {
        free(pTV);
    }
}


//DirectoryItem(): _pData( NULL )

extern "C" void SAL_CALL test_osl_file_DirectoryItem_ctor(TestResult *oRes)
{
    DirectoryItem *pDI = NULL;

    pDI = new DirectoryItem();

    if (pDI) {
        oRes->state(1, "This test is partially valid");
    } else {
        oRes->state(0);
    }

    if (pDI) {
        delete pDI;
    }
}

//DirectoryItem( DirectoryItem& rItem ): _pData( rItem._pData)

extern "C" void SAL_CALL test_osl_file_DirectoryItem_ctor_02(TestResult *oRes)
{
    DirectoryItem *pDI = NULL;
    DirectoryItem *pDI2 = NULL;

    pDI = new DirectoryItem();

    if (pDI) {
        oRes->state((pDI2 = new DirectoryItem(*pDI)) != NULL, "This test is partially valid");
    } else {
        oRes->state(0);
    }

    if (pDI) {
        delete pDI;
    }
    if (pDI2) {
        delete pDI2;
    }
}


//~DirectoryItem()

extern "C" void SAL_CALL test_osl_file_DirectoryItem_dtor(TestResult *oRes)
{
    DirectoryItem *pDI = NULL;

    pDI = new DirectoryItem();

    if (pDI) {
        delete pDI;
        oRes->state(1, "This test is partially valid");
    } else {
        oRes->state(0);
    }
}


//DirectoryItem& operator = ( DirectoryItem& rItem ) 

extern "C" void SAL_CALL test_osl_file_DirectoryItem_operator_equal(TestResult *oRes)
{
    DirectoryItem pDI1;
    DirectoryItem pDI2;

    pDI2 = pDI1;

    oRes->state(1);
}


//inline sal_Bool is()

extern "C" void SAL_CALL test_osl_file_DirectoryItem_is(TestResult *oRes)
{
    DirectoryItem *pDI = NULL;

    pDI = new DirectoryItem();

    if(pDI) {
        oRes->state(pDI->is() == NULL, "This test is partially valid");
    } else {
        oRes->state(0);
    }

    if (pDI) {
        delete pDI;
    }
}


//static inline RC get( const ::rtl::OUString& strPath, DirectoryItem& rItem )

extern "C" void SAL_CALL test_osl_file_DirectoryItem_get(TestResult *oRes)
{
    DirectoryItem DI;
    rtl_uString *strPath = NULL;
    rtl_uString *sysPath = NULL;
    ::rtl::OUString oustrPath;
    
    rtl_uString_newFromAscii(&strPath, "/");

    if (strPath &&
	(osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None)) {
        oustrPath.pData = sysPath;
	oRes->state(DirectoryItem::get(oustrPath, DI) == ::osl::FileBase::E_None);
    } else {
        oRes->state(0);
    }

    if (strPath) {
        rtl_uString_release(strPath);
    }
}


//inline RC getFileStatus( FileStatus& rStatus )

extern "C" void SAL_CALL test_osl_file_DirectoryItem_getFileStatus(TestResult *oRes)
{
    FileStatus pFS(osl_FileStatus_Mask_All);
    DirectoryItem pDI;

    oRes->state(pDI.getFileStatus(pFS) == ::osl::FileBase::E_INVAL, "This test is partially valid");
}


//Directory( const ::rtl::OUString& strPath ): _pData( 0 ), _aPath( strPath )

extern "C" void SAL_CALL test_osl_file_Directory_ctor(TestResult *oRes)
{
    rtl_uString *strPath = NULL; 
    rtl_uString *sysPath = NULL;
    ::rtl::OUString strOUPath;
    Directory *pDir = NULL;

    rtl_uString_newFromAscii(&strPath, "/tmp/testdir");

    if (strPath &&
	(osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None) &&
	(strOUPath.pData = sysPath) &&
        (pDir = new Directory(strOUPath))) {
        oRes->state(1);
    } else {
        oRes->state(0);
    }

    if (strPath) {
        rtl_uString_release(strPath);
    }
    if (pDir) {
        delete pDir;
    }
}


//~Directory()

extern "C" void SAL_CALL test_osl_file_Directory_dtor(TestResult *oRes)
{
    rtl_uString *strPath = NULL; 
    rtl_uString *sysPath = NULL;
    ::rtl::OUString strOUPath;
    Directory *pDir = NULL;

    rtl_uString_newFromAscii(&strPath, "/tmp/testdir");

    if (strPath &&
	(osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None) &&
	(strOUPath.pData = sysPath) &&
        (pDir = new Directory(strOUPath))) {
        delete pDir;
        oRes->state(1);
    } else {
        oRes->state(0);
    }

    if (strPath) {
        rtl_uString_release(strPath);
    }
}


//inline RC open()
 
extern "C" void SAL_CALL test_osl_file_Directory_open(TestResult *oRes) 
{ 
    rtl_uString *strPath = NULL; 
    rtl_uString *sysPath = NULL;
    ::rtl::OUString strOUPath;
    Directory *pDir = NULL;

    rtl_uString_newFromAscii(&strPath, "/tmp");

    if (strPath &&
	(osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None) &&
	(strOUPath.pData = sysPath) &&
        (pDir = new Directory(strOUPath))) {
        oRes->state(pDir->open() == ::osl::FileBase::E_None);
	pDir->close();
    } else {
        oRes->state(0);
    }

    if (strPath) {
        rtl_uString_release(strPath);
    }
    if (pDir) {
        delete pDir;
    }
} 


//inline RC isOpen()
 
extern "C" void SAL_CALL test_osl_file_Directory_isOpen(TestResult *oRes) 
{ 
    rtl_uString *strPath = NULL; 
    rtl_uString *sysPath = NULL;
    ::rtl::OUString strOUPath;
    Directory *pDir = NULL;
    Directory *pDir2 = NULL;

    rtl_uString_newFromAscii(&strPath, "/tmp");

    if (strPath &&
	(osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None) &&
	(strOUPath.pData = sysPath) &&
        (pDir = new Directory(strOUPath)) &&
	(pDir2 = new Directory(strOUPath)) &&
	(pDir->open() == ::osl::FileBase::E_None)) {
        oRes->state((pDir->isOpen() == sal_True) &&
		    (pDir2->isOpen() == sal_False));
	pDir->close();
    } else {
        oRes->state(0);
    }

    if (strPath) {
        rtl_uString_release(strPath);
    }
    if (pDir) {
        delete pDir;
    }
} 


//inline RC close()
 
extern "C" void SAL_CALL test_osl_file_Directory_close(TestResult *oRes) 
{ 
    rtl_uString *strPath = NULL; 
    rtl_uString *sysPath = NULL;
    ::rtl::OUString strOUPath;
    Directory *pDir = NULL;

    rtl_uString_newFromAscii(&strPath, "/tmp");

    if (strPath &&
	(osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None) &&
	(strOUPath.pData = sysPath) &&
        (pDir = new Directory(strOUPath)) &&
        (pDir->open() == ::osl::FileBase::E_None)) {
        oRes->state(pDir->close() == ::osl::FileBase::E_None);
    } else {
        oRes->state(0);
    }

    if (strPath) {
        rtl_uString_release(strPath);
    }
    if (pDir) {
        delete pDir;
    }
} 


//inline RC reset()
 
extern "C" void SAL_CALL test_osl_file_Directory_reset(TestResult *oRes) 
{ 
    rtl_uString *strPath = NULL; 
    rtl_uString *sysPath = NULL;
    ::rtl::OUString strOUPath;
    Directory *pDir = NULL;

    rtl_uString_newFromAscii(&strPath, "/tmp");

    if (strPath &&
	(osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None) &&
	(strOUPath.pData = sysPath) &&
        (pDir = new Directory(strOUPath)) &&
        (pDir->open() == ::osl::FileBase::E_None)) {
        oRes->state(pDir->reset() == ::osl::FileBase::E_None);
    } else {
        oRes->state(0);
    }

    if (strPath) {
        rtl_uString_release(strPath);
    }
    if (pDir) {
        delete pDir;
    }
} 


//inline RC getNextItem()
 
extern "C" void SAL_CALL test_osl_file_Directory_getNextItem(TestResult *oRes) 
{ 
    rtl_uString *strPath = NULL; 
    rtl_uString *sysPath = NULL;
    ::rtl::OUString strOUPath;
    Directory *pDir = NULL;
    DirectoryItem rDI;

    rtl_uString_newFromAscii(&strPath, "/tmp");

    if (strPath &&
	(osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None) &&
	(strOUPath.pData = sysPath) &&
        (pDir = new Directory(strOUPath)) &&
        (pDir->open() == ::osl::FileBase::E_None)) {
        oRes->state(pDir->getNextItem(rDI) == ::osl::FileBase::E_None);
    } else {
        oRes->state(0);
    }

    if (strPath) {
        rtl_uString_release(strPath);
    }
    if (pDir) {
        delete pDir;
    }
} 


//inline RC getVolumeInfo()
 
extern "C" void SAL_CALL test_osl_file_Directory_getVolumeInfo(TestResult *oRes) 
{ 
  oRes->state(0, "This test is not implemted"); 
} 


//inline RC create()
 
extern "C" void SAL_CALL test_osl_file_Directory_create(TestResult *oRes) 
{ 
    rtl_uString *strPath = NULL; 
    rtl_uString *sysPath = NULL;
    ::rtl::OUString strOUPath;

    rtl_uString_newFromAscii(&strPath, "/tmp/testdir");

    if (strPath &&
	(osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None) &&
	(strOUPath.pData = sysPath)) {
        oRes->state(Directory::create(strOUPath) == ::osl::FileBase::E_None);
	Directory::remove(strOUPath);
    } else {
        oRes->state(0);
    }

    if (strPath) {
        rtl_uString_release(strPath);
    }
} 


//inline RC remove()
 
extern "C" void SAL_CALL test_osl_file_Directory_remove(TestResult *oRes) 
{ 
    rtl_uString *strPath = NULL; 
    rtl_uString *sysPath = NULL;
    ::rtl::OUString strOUPath;

    rtl_uString_newFromAscii(&strPath, "/tmp/testdir");

    if (strPath &&
	(osl_getFileURLFromSystemPath(strPath, &sysPath) == osl_File_E_None) &&
	(strOUPath.pData = sysPath) &&
        (Directory::create(strOUPath) == ::osl::FileBase::E_None)) {
        oRes->state(Directory::remove(strOUPath) == ::osl::FileBase::E_None);
    } else {
        oRes->state(0);
    }

    if (strPath) {
        rtl_uString_release(strPath);
    }
} 
