/************************************************************************* 
# 
#   $RCSfile: osl_apitest_time.cxx,v $ 
# 
#   $Revision: 1.2 $ 
# 
#   last change: $Author: ganaya $ $Date: 2001/05/25 21:39:11 $ 
# 
#   The Contents of this file are made available subject to the terms of 
#   either of the following licenses 
# 
#          - GNU Lesser General Public License Version 2.1 
#          - Sun Industry Standards Source License Version 1.1 
# 
#   Sun Microsystems Inc., October, 2000 
# 
#   GNU Lesser General Public License Version 2.1 
#   ============================================= 
#   Copyright 2000 by Sun Microsystems, Inc. 
#   901 San Antonio Road, Palo Alto, CA 94303, USA 
# 
#   This library is free software; you can redistribute it and/or 
#   modify it under the terms of the GNU Lesser General Public 
#   License version 2.1, as published by the Free Software Foundation. 
# 
#   This library is distributed in the hope that it will be useful, 
#   but WITHOUT ANY WARRANTY; without even the implied warranty of 
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
#   Lesser General Public License for more details. 
# 
#   You should have received a copy of the GNU Lesser General Public 
#   License along with this library; if not, write to the Free Software 
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
#   MA  02111-1307  USA 
# 
# 
#   Sun Industry Standards Source License Version 1.1 
#   ================================================= 
#   The contents of this file are subject to the Sun Industry Standards 
#   Source License Version 1.1 (the "License"); You may not use this file 
#   except in compliance with the License. You may obtain a copy of the 
#   License at http://www.openoffice.org/license.html. 
# 
#   Software provided under this License is provided on an "AS IS" basis, 
#   WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, 
#   WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS, 
#   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING. 
#   See the License for the specific provisions governing your rights and 
#   obligations concerning the Software. 
# 
#   The Initial Developer of the Original Code is: Sun Microsystems, Inc. 
# 
#   Copyright: 2000 by Sun Microsystems, Inc. 
# 
#   All Rights Reserved. 
# 
#   Contributor(s): _______________________________________ 
# 
# 
# 
#*************************************************************************/

#ifndef _TESTS_TRES_HXX_
#include <rtl/tres.hxx>
#endif

#ifndef _OSL_TIME_H_
#include <osl/time.h>
#endif


using namespace rtl;



//sal_Bool SAL_CALL osl_getSystemTime( TimeValue* pTimeVal ); 

extern "C" void SAL_CALL test_osl_time_osl_getSystemTime(TestResult *oRes)
{
    TimeValue *pTV = NULL;

    pTV = (TimeValue*)malloc(sizeof(TimeValue));

    if (pTV) {
        oRes->state(osl_getSystemTime(pTV) == sal_True);
    } else {
        oRes->state(0);
    }

    if(pTV) {
        free(pTV);
    }
}


//sal_Bool SAL_CALL osl_getDateTimeFromTimeValue( TimeValue* pTimeVal,
//                                                oslDateTime* pDateTime );

extern "C" void SAL_CALL test_osl_time_osl_getDateTimeFromTimeValue(TestResult *oRes)
{
    TimeValue *pTV = NULL;
    oslDateTime *pDT = NULL;

    pTV = (TimeValue *)malloc(sizeof(TimeValue));

    if (pTV &&
	(pDT = (oslDateTime *)malloc(sizeof(oslDateTime)))) {
        oRes->state(osl_getDateTimeFromTimeValue(pTV, pDT) == sal_True);
    } else {
        oRes->state(0);
    }

    if (pTV) {
        free(pTV);
    }
    if (pDT) {
        free(pDT);
    }
}


//sal_Bool SAL_CALL osl_getTimeValueFromDateTime( TimeValue* pTimeVal,
//                                                oslDateTime* pDateTime );

extern "C" void SAL_CALL test_osl_time_osl_getTimeValueFromDateTime(TestResult *oRes)
{
    TimeValue *pTV = NULL;
    TimeValue *pTV2 = NULL;
    oslDateTime *pDT = NULL;

    pTV = (TimeValue *)malloc(sizeof(TimeValue));

    if (pTV &&
	(osl_getSystemTime(pTV) == sal_True) &&
	(pDT = (oslDateTime *)malloc(sizeof(oslDateTime))) &&
	(osl_getDateTimeFromTimeValue(pTV, pDT) == sal_True) &&
	(pTV2 = (TimeValue*)malloc(sizeof(TimeValue)))) {
        oRes->state(osl_getTimeValueFromDateTime(pDT, pTV2) == sal_True);
    } else {
        oRes->state(0);
    }

    if (pTV) {
        free(pTV);
    }
    if (pTV2) {
        free(pTV2);
    }
    if (pDT) {
        free(pDT);
    }
}


//sal_Bool SAL_CALL osl_getLocalTimeFromSystemTime( TimeValue* pSystemTimeVal,
//                                                  TimeValue* pLocalTimeVal );

extern "C" void SAL_CALL test_osl_time_osl_getLocalTimeFromSystemTime(TestResult *oRes)
{
    TimeValue *pST = NULL;
    TimeValue *pLT = NULL;

    pST = (TimeValue *)malloc(sizeof(TimeValue));
    if (pST &&
	(osl_getSystemTime(pST) == sal_True) &&
	(pLT = (TimeValue *)malloc(sizeof(TimeValue)))) {
        oRes->state(osl_getLocalTimeFromSystemTime(pST, pLT) == sal_True);
    } else {
        oRes->state(0);
    }

    if (pST) {
        free(pST);
    }
    if (pLT) {
        free(pLT);
    }
}


//sal_Bool SAL_CALL osl_getSystemTimeFromLocalTime( TimeValue* pLocalTimeVal,
//                                                 TimeValue* pSystemTimeVal );

extern "C" void SAL_CALL test_osl_time_osl_getSystemTimeFromLocalTime(TestResult *oRes)
{
    TimeValue *pTV_local = NULL;
    TimeValue *pTV_sys = NULL;

    pTV_local = (TimeValue *)malloc(sizeof(TimeValue));

    if (pTV_local &&
        (osl_getSystemTime(pTV_local) == sal_True) &&
	(pTV_sys = (TimeValue *)malloc(sizeof(TimeValue)))) {
        oRes->state(osl_getSystemTimeFromLocalTime(pTV_local, pTV_sys) == sal_True);
    } else {
        oRes->state(0);
    }

    if (pTV_local) {
        free(pTV_local);
    }
    if (pTV_sys) {
        free(pTV_sys);
    }
}


//sal_uInt32 SAL_CALL osl_getGlobalTimer(); 

extern "C" void SAL_CALL test_osl_time_osl_getGlobalTimer(TestResult *oRes)
{
    oRes->state(osl_getGlobalTimer());
}
