/*************************************************************************
 *
 *  $RCSfile: DispatcherAdapterFactory.java,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: kr $ $Date: 2000/10/27 09:24:31 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.star.lib.sandbox.generic;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

import java.net.URL;
import java.net.MalformedURLException;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

import com.sun.star.lib.sandbox.ClassContext; 
import com.sun.star.lib.sandbox.ClassContextProxy;
import com.sun.star.lib.sandbox.ResourceProxy;

/**
 * Es knnen Java-Klassen erzeugt werden, die alle Methoden zu einem angegebenen
 * Interface implementieren und aufbereitet an das JavaCallee Interface
 * weitergeben.
 * <BR>
 * @version     $Version: 1.1 $
 * @author      Markus Meyer
 * @see			com.sun.star.lib.sandbox.generic.Dispatcher
 * @see			com.sun.star.lib.sandbox.generic.DispatcherAdapterBase
 */
public class DispatcherAdapterFactory {
    static private final short ACC_PUBLIC = 0x0001;
    static private final short ACC_PRIVATE = 0x0002;
    static private final short ACC_SUPER = 0x0020;

    static private final int iMagic = 0xCAFEBABE;
    static private final short sMinorVersion = 3;
    static private final short sMajorVersion = 45;
    static private final short sAccessFlags =(short)(ACC_PUBLIC | ACC_SUPER);
    static private final Class aObjClass = (new Object()).getClass();

    private Class aInterface;
    private ConstantPool  aPool;
    private short sCodeUtf8;
    private short sThisUtf8;
    private short sThisClass;
    private short sSuperClass;
    private short sInterface;
    private short sSuperCtorMeth;
	private String baseClass;

    /**
     * Dem Konstruktor wird ein Interface bergeben, zu dem ein
     * Java- nach JavaScript-Wrapper generiert werden soll. Normalerweise 
     * holt man sich eine Wrapperklasse ber getJavaJSWrapperClass, da diese
     * generierte Klassen cached.
     *
     * @param aInterface    Zu diesem Interface wird der Wrapper generiert.
     *
     * @see	#write(java.io.DataOutput)
     * @see #getJavaJSWrapperClass(java.lang.Class)
     */
    public DispatcherAdapterFactory(Class aInterface_, String baseClass, String aClassName ) {
        initClassLoader();
        aInterface = aInterface_;
		this.baseClass = baseClass;

        aPool = new ConstantPool();
        // Benutzte Stings
        sCodeUtf8 = aPool.getUtf8( "Code" );

        String aIfaceName = aInterface.getName().replace('.', '/');

        sThisUtf8 = aPool.getUtf8( aClassName );
        sThisClass = aPool.getClass( aClassName );
        sSuperClass = aPool.getClass( baseClass );
//          sSuperClass = aPool.getClass( "com/sun/star/lib/sandbox/generic/DispatcherAdapterBase" );
        sInterface = aPool.getClass( aIfaceName );
        // MethodRef Object.<init>
        short sNT = aPool.getNameAndType( "<init>", "()V" );
        sSuperCtorMeth = aPool.getMethodRef( sSuperClass, sNT );
    }


    /**
     * Aus dem uebergebenen Interface wird ein Java- nach JavaScript-Wrapper 
     * generiert. Der Name der neuen Klasse wird mit JSGen geprefixet, z.B.
     * wrde aus Broadcast JSGenBroadcast oder aus mypackage.Broadcast 
     * JSGenmypackage.Broadcast. Die Namenskonvention kann sich jederzeit
     * ndern. Pro Interface wird nur eine Wrapper-Klasse
     * generiert. Wird die Methode mit demselben Interface mehrmals gerufen,
     * wird die gleiche Wrapperklasse zurckgegeben.<BR>
     * <B> Da die Wrapperklassen ber den SjClassLoader geladen werden,
     * unterliegen sie der gleichen Sicherheitsstufe wie Applets.</B>
     *
     * @param aInterface    Zu diesem Interface wird der Wrapper generiert.
     *
     * @see #Dispatcher(java.lang.Class)
     * @see stardiv.security#SjClassLoader()
     */
	
	static ClassContext aLoader;
	static synchronized void initClassLoader() {
        if( aLoader == null )
    		try {
    		
    			
    		
	    		aLoader = ClassContextProxy.create(new URL("http:/"), null, null, true);
    		}
	    	catch(MalformedURLException malformedURLException) {
		    	System.err.println("##### DispatcherAdapterFactory.<class init>:" + malformedURLException);
		    }
	}


    synchronized public static Class createDispatcherAdapter(Class aInterface, String baseClass) {
        initClassLoader();

        Class pClass = null;
        String aIfaceName = aInterface.getName();
        String aClassName = ("JSGen" + aIfaceName + baseClass).replace('.', '_').replace('/', '_').replace('$', '_');

        try {
            pClass = aLoader.findClass(aClassName);
        } 
		catch(ClassNotFoundException e0) {
		}

		if(pClass == null) {
            ByteArrayOutputStream aTmpStm = new ByteArrayOutputStream();
            DataOutputStream aDestStm = new DataOutputStream( aTmpStm );
    		DispatcherAdapterFactory aCB = new DispatcherAdapterFactory( aInterface, baseClass, aClassName );

            try { 
				aCB.write( aDestStm ); 

				byte aClassdata[] = aTmpStm.toByteArray();

				ResourceProxy resource = ResourceProxy.create(new URL("http:/" + aClassName.replace('.', '/') + ".class"), 
															  aClassdata, 
															  null);
				pClass = aLoader.loadClass(aClassName);
			} 
			catch(MalformedURLException malformedURLException) {
				System.err.println("#### com.sun.star.lib.sandbox.generic.DispatcherAdapterFactory - malformedURLException: " + malformedURLException);
			} 
			catch(IOException iOException) {
				System.err.println("#### com.sun.star.lib.sandbox.generic.DispatcherAdapterFactory: " + iOException);
			} 
			catch(ClassNotFoundException classNotFoundException) {
				System.err.println("#### com.sun.star.lib.sandbox.generic.DispatcherAdapterFactory - classNotFoundException: " + classNotFoundException);
			} 
			catch(Throwable exception) {
				System.err.println("#### com.sun.star.lib.sandbox.generic.DispatcherAdapterFactory - exception: " + exception);
				exception.printStackTrace();
			}
        }
        
        return pClass;
    }

    /**
     * Diese Methode schreibt ein Classfile mit der Implementation
     * des im Konstruktor bergebenen Interfaces. Zu dem Interface<BR>
     * <pre>
     * public interface Broadcast {
     *   public void changeName( String aNewName );
     *   public int  getNumber();
     * }
     * </pre>
     * wrde die folgende Klasse generiert:
     * <pre>
     * public class JSGenBroadcast 
     *   extends JavaJSWrapper
     *   implements Broadcast
     * {
     *   public void showDocument( String aName )
     *   {
     *       Object [] aParams = new Object[ 1 ];
     *       aParams[0] = aName;
     *       invokeV( "showDocument", aParams );
     *   }
     *   public int getNumber()
     *   {
     *       Object [] aParams = new Object[0];
     *       return invokeI( "getNumber", aParams );
     *   }
     * }
     * </pre>
     * 
     * @param aStm  in diesen Stream wird das Classfile geschrieben.
     */
    public void write( DataOutput aStm ) throws IOException {
        // Version
        aStm.writeInt( iMagic );
        aStm.writeShort( sMinorVersion );
        aStm.writeShort( sMajorVersion );

        // In Extra-Stream, damit der Pool gefllt wird
        ByteArrayOutputStream aTmpStm = new ByteArrayOutputStream();
        DataOutputStream aDestStm = new DataOutputStream( aTmpStm );

        //
        aDestStm.writeShort( sAccessFlags );
        aDestStm.writeShort( sThisClass );
        aDestStm.writeShort( sSuperClass );

        // Interfaces
        aDestStm.writeShort( (short)1 );
        aDestStm.writeShort( sInterface );

        // Fields
        aDestStm.writeShort( (short)0 );

        // Neue Methode schreiben
        Method[] aMethods = aInterface.getMethods();

		int nMethods = aMethods.length;

        for( int i = 0; i < aMethods.length; i++ ) {
			if (Modifier.isStatic(aMethods[i].getModifiers()))
				nMethods--;
        }

        aDestStm.writeShort( (short)1 + nMethods );

        // Method <init>
        aDestStm.writeShort( ACC_PUBLIC );
        aDestStm.writeShort( aPool.getUtf8( "<init>" ) );
        aDestStm.writeShort( aPool.getUtf8( "()V" ) );
        aDestStm.writeShort( (short)1 ); // AttributCount
        // Code Attribut
        aDestStm.writeShort( sCodeUtf8 );
        aDestStm.writeInt( 17 ); // Lnge des CodeAttr -6
        aDestStm.writeShort( 1 );// max_stack
        aDestStm.writeShort( 1 );// max_locals
        aDestStm.writeInt( 5 );// Code length
        // Code
        aDestStm.writeByte( (byte)0x2a ); //aload_0
        aDestStm.writeByte( (byte)0xb7 ); //invokespecial
        aDestStm.writeByte( (byte)(sSuperCtorMeth >> 8) );
        aDestStm.writeByte( (byte)sSuperCtorMeth );
        aDestStm.writeByte( (byte)0xb1 ); //return
        aDestStm.writeShort( 0 );// exception table
        aDestStm.writeShort( 0 );// code attributes

        for( int i = 0; i < aMethods.length; i++ ) {
			if (!Modifier.isStatic(aMethods[i].getModifiers()))
	            writeMethod( aDestStm, aMethods[ i ].getName(),
	                        aMethods[ i ].getParameterTypes(),
	                        aMethods[ i ].getReturnType() );
        }
        
        // ConstantPool
        aPool.write( aStm );
        byte [] aBuffer = aTmpStm.toByteArray();
        aStm.write( aBuffer );
        // class attributes
        aStm.writeShort( 0 );// code attributes
    }

    private void astore( DataOutput aStm, short sLocalIdx ) throws IOException {
        if( sLocalIdx < 4 )
            aStm.writeByte( (byte)(0x4b + sLocalIdx) ); //astore_ + len
        else if( sLocalIdx < 256 ) {
            aStm.writeByte( (byte)0x3a );      //astore
            aStm.writeByte( (byte)sLocalIdx );
        }
//        else
//            throw new Exception( "too many Locals" );
    }

    /*
     * Die Methode ldt eine lokale Variable auf den Stack. In Abhngigkeit
     * vom Index wird die lurze oder lange Form des Zugriffs verwendet.
     * Der Paramert bLoadType mu entweder iload_0 = 0x1a, lload_0 = 0x1e,
     * fload_0 = 0x22, dload_0 = 0x26 oder aload_0 == 0x2a sein.
     iload = 0x15
     lload = 0x16
     fload = 0x17
     dload = 0x18
     aload = 0x19
     */
    private void load( DataOutput aStm, int bLoadType, short sLocalIdx ) 
        throws IOException 
    {
        if( sLocalIdx < 4 )
            aStm.writeByte( (byte)((byte)bLoadType + sLocalIdx) ); //*load_0 + len
        else if( sLocalIdx < 256 ) {
            // die *load Typen berechnen
            bLoadType = ((bLoadType - 0x1a) / 4) + 0x15;
            aStm.writeByte( (byte)bLoadType );  //*load
            aStm.writeByte( (byte)sLocalIdx );
        }
    }
    
    private void ldc( DataOutput aStm, String aConst )
        throws IOException
    {
        short sMN = aPool.getString( aConst );
        if( sMN < 256 )
            aStm.writeByte( (byte)0x12 );      //ldc
        else {
            aStm.writeByte( (byte)0x13 );      //ldc_w
            aStm.writeByte( (byte)(sMN >> 8) );//hibyte
        }
        aStm.writeByte( (byte)sMN );       //lowbyte
    }

    private String getSig( Class aClass ) {
        String aStr = "";
        if ( aClass.isArray() ) {
    		aStr = "[" + getSig(aClass.getComponentType());
    	} else if( aClass.isPrimitive() ) {
            if( aClass == Boolean.TYPE )
                aStr = "Z";
            else if( aClass == Byte.TYPE )
                aStr = "B";
            else if( aClass == Short.TYPE )
                aStr = "S";
            else if( aClass == Character.TYPE )
                aStr = "C";
            else if( aClass == Integer.TYPE )
                aStr = "I";
            else if( aClass == Long.TYPE )
                aStr = "J";
            else if( aClass == Float.TYPE )
                aStr = "F";
            else if( aClass == Double.TYPE )
                aStr = "D";
            else //if( aClass == Void.TYPE )
                aStr = "V";
        } else
            aStr += 'L' + aClass.getName().replace( '.', '/' ) + ';';
        return aStr;
    }
    
    private void writeMethod(DataOutput aStm, String aMethodName, 
                             Class[] aTypes, Class aRetType)
        throws IOException
    {
        // In Extra-Stream, damit der Pool gefllt wird
        ByteArrayOutputStream aTmpStm = new ByteArrayOutputStream();
        DataOutputStream aDestStm = new DataOutputStream( aTmpStm );
        
        // Method setObject
        aStm.writeShort( ACC_PUBLIC );
        aStm.writeShort( aPool.getUtf8( aMethodName ) );
        short sExtraStack = 0;
        if( !aRetType.isPrimitive() && aRetType != aObjClass )
            // Weil invokeL einen Parameter mehr hat
            sExtraStack = 1;
        short sParams = 0;
        String aMethSig = "(";
        
        for( int i = 0; i < aTypes.length; i++ ) {
            sParams++;
            if( aTypes[i].isPrimitive() ) {
                if( aTypes[i] == Double.TYPE || aTypes[i] == Long.TYPE ) {
                    // double und long belegen zwei Locals
                    sParams++;
                    sExtraStack = 3;
                } else if( sExtraStack < 2 )
                    sExtraStack = 2;
            }
            aMethSig += getSig( aTypes[i] );
        }
        aMethSig += ")";
        aMethSig += getSig( aRetType );
        aStm.writeShort( aPool.getUtf8( aMethSig ) );
        aStm.writeShort( (short)1 ); // AttributCount
        // Code Attribut
        aStm.writeShort( sCodeUtf8 );
        writeMethod_Impl( aDestStm, aMethodName, aTypes, aRetType, sParams );
        byte [] aBuffer = aTmpStm.toByteArray();
        aStm.writeInt( 8 + aBuffer.length + 4 ); // Lnge des CodeAttr -6
        aStm.writeShort( 3 + sExtraStack );// max_stack
        aStm.writeShort( (short)(2 + sParams) );// max_locals
        aStm.writeInt( aBuffer.length );// Code length
        aStm.write( aBuffer );
        aStm.writeShort( 0 );// exception table
        aStm.writeShort( 0 );// code attributes
    }        

    private void writeMethod_Impl(DataOutput aStm, String aMethodName, 
                                  Class[] aTypes, Class aRetType,
                                  short sParamCount)
        throws IOException
    {
        // Gre des Arrays auf den Stack
        if ( aTypes.length < 6 )
            aStm.writeByte( (byte)(0x3 + aTypes.length) ); //i_const_ + len
        else if ( aTypes.length < 128 ) {
            aStm.writeByte( (byte)0x10 );  //bipush
            aStm.writeByte( (byte)aTypes.length ); //Konstante
        }

        // Object [] erzeugen und auf den Stack
        aStm.writeByte( (byte)0xbd );  //anewarray
        short sC = aPool.getClass( "java/lang/Object" );
        aStm.writeShort( sC );

        // StackTop == Array in lokale Variable speichern
        short sPreUsed = (short)(1 + sParamCount); // Erste Variablen von this und den Parametern belegt
        astore( aStm, sPreUsed ); //erste Methodenvariable

        // Parameter in das Array kopieren
        // this ist lokale Variable 0!
        short sLocalPos = 1;
        for ( short i = 0; i < aTypes.length; i++ ) {
            // Array auf den Stack
            load( aStm, 0x2a, sPreUsed );

            // Index auf den Stack
            if( i < 6 )
                aStm.writeByte( (byte)(0x3 + i) ); //i_const_ + i
            else if( i < 128 ) {
                aStm.writeByte( (byte)0x10 );  //bipush
                aStm.writeByte( (byte)i );     //Konstante
            }

            if( aTypes[i].isPrimitive() ) {
                short aDoubleLongInc = 0;
                short sClass;
                byte bLoadType = 0x1a;
                String aClassName;
                String aTypeName;
                if ( aTypes[i] == Boolean.TYPE ) {
                    aClassName = "java/lang/Boolean";
                    aTypeName = "(Z)V";
                } else if( aTypes[i] == Byte.TYPE ) {
                    aClassName = "java/lang/Byte";
                    aTypeName = "(B)V";
                } else if( aTypes[i] == Short.TYPE ) {
                    aClassName = "java/lang/Short";
                    aTypeName = "(S)V";
                } else if( aTypes[i] == Character.TYPE ) {
                    aClassName = "java/lang/Character";
                    aTypeName = "(C)V";
                }
                else if( aTypes[i] == Integer.TYPE ) {
                    aClassName = "java/lang/Integer";
                    aTypeName = "(I)V";
                }
                else if( aTypes[i] == Long.TYPE ) {
                    aClassName = "java/lang/Long";
                    aTypeName = "(J)V";
                    bLoadType = 0x1e;
                    // double und long belegen zwei Locals
                    aDoubleLongInc++;
                }
                else if( aTypes[i] == Float.TYPE ) {
                    aClassName = "java/lang/Float";
                    aTypeName = "(F)V";
                    bLoadType = 0x22;
                } 
                else //if( aTypes[i] == Double.TYPE )
                {
                    aClassName = "java/lang/Double";
                    aTypeName = "(D)V";
                    bLoadType = 0x26;
                    // double und long belegen zwei Locals
                    aDoubleLongInc++;
                }

                sClass = aPool.getClass( aClassName );
                // Primitive-Konstruktor
                aStm.writeByte( (byte)0xbb );  //new
                aStm.writeShort( sClass );
                aStm.writeByte( (byte)0x59 ); //dup
                load( aStm, bLoadType, (short)(sLocalPos++) ); // iload_0 +
                aStm.writeByte( (byte)0xb7 ); //invokespecial
                short sNameType = aPool.getNameAndType( "<init>", aTypeName );
                aStm.writeShort( aPool.getMethodRef( sClass, sNameType ) );
                sLocalPos += aDoubleLongInc;
            } else
                // Parameter i auf den Stack
                load( aStm, 0x2a, (short)(sLocalPos++) );

            // In das Array eintragen
            aStm.writeByte( (byte)0x53 );  //aastor
        }

        // This auf den Stack
        aStm.writeByte( (byte)0x2a );  //aload_0

        String aType;
        if( !aRetType.isPrimitive() && aRetType != aObjClass ) {
            aType = "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)";
            // Weil invokeL den Return-Klassennamen bergibt
            // Returntyp-Namen mit "." auf den Stack
            ldc( aStm, aRetType.getName() );
        } else
            aType = "(Ljava/lang/String;[Ljava/lang/Object;)";
        // aMethodName auf den Stack
        ldc( aStm, aMethodName );
        // Array auf den Stack
        load( aStm, 0x2a, sPreUsed );

        // Callee rufen
        // *MethodRef invoke
        String aInvokeName = "invoke";
        String aSig = getSig( aRetType );
        if ( aRetType.isPrimitive() ) {
	        aInvokeName += aSig.charAt( 0 );
            aType += aSig;
    	} else {
	        aInvokeName += "L";
            aType += "Ljava/lang/Object;";
    	}
    	
        short sNT = aPool.getNameAndType( aInvokeName, aType );
        short sClass = aPool.getClass( baseClass );
//          short sClass = aPool.getClass( "com/sun/star/lib/sandbox/generic/DispatcherAdapterBase" );
        //short sMR = aPool.getInterfaceMethodRef( sClass, sNT );
        short sMR = aPool.getMethodRef( sClass, sNT ); //invokevirtual
        //invokeinterface
        //aStm.writeByte( (byte)0xb9 );      
        aStm.writeByte( (byte)0xb6 );    //invokevirtual
        aStm.writeShort( sMR );
        //aStm.writeByte( (byte)0x04);       //Anzahl der Parameter + this
        //aStm.writeByte( (byte)0);          //0
        
        // return
        if ( aRetType.isPrimitive() ) {
            if ( aRetType == Long.TYPE )
                aStm.writeByte( (byte)0xad );  //lreturn
            else if( aRetType == Float.TYPE )
                aStm.writeByte( (byte)0xae );  //freturn
            else if( aRetType == Double.TYPE )
                aStm.writeByte( (byte)0xaf );  //dreturn
            else if( aRetType == Void.TYPE )
                aStm.writeByte( (byte)0xb1 );  //return
            else
                aStm.writeByte( (byte)0xac );  //ireturn
        } else {
            if( aRetType != aObjClass ) {
                aStm.writeByte( (byte)0xc0 );  //checkcast
                String aName = aRetType.getName().replace( '.', '/' );
                aStm.writeShort( aPool.getClass( aName ) );
            }
            aStm.writeByte( (byte)0xb0);       //areturn
        }
    }
}

