/*************************************************************************
 *
 *  $RCSfile: FilterApiHelper.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: dr $ $Date: 2001/11/23 19:37:18 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef PCH
#include "filt_pch.hxx"
#endif

#pragma hdrstop

//------------------------------------------------------------------------

#ifndef _SC_FILTERAPIHELPER_HXX
#include "FilterApiHelper.hxx"
#endif


using namespace ::rtl;
using namespace ::com::sun::star;


//___________________________________________________________________

void setPropAny( const uno::Reference< beans::XPropertySet >& xProp, const OUString& rName, const uno::Any& rAny )
{
    DBG_ASSERT( xProp.is(), "::setPropAny() - XPropertySet not valid" );
	try
	{
        uno::Reference< beans::XPropertySetInfo > xInfo = xProp->getPropertySetInfo();
        if( xInfo.is() && xInfo->hasPropertyByName( rName ) )
            xProp->setPropertyValue( rName, rAny );
	}
	catch( uno::Exception& )
	{
	}
}


//___________________________________________________________________

sal_Bool getPropAny( uno::Any& rAny, const uno::Reference< beans::XPropertySet >& xProp, const OUString& rName )
{
    DBG_ASSERT( xProp.is(), "::getPropAny() - XPropertySet not valid" );
    sal_Bool bSuccess = sal_False;
	try
	{
        uno::Reference< beans::XPropertySetInfo > xInfo = xProp->getPropertySetInfo();
        if( xInfo.is() && xInfo->hasPropertyByName( rName ) )
            rAny = xProp->getPropertyValue( rName );
        bSuccess = sal_True;
	}
	catch( uno::Exception& )
	{
	}
    return bSuccess;
}


//___________________________________________________________________
// class ScfMultiPSHelper

ScfMultiPSHelper::ScfMultiPSHelper( const sal_Char** ppPropNames, sal_Int32 nPropCount ) :
    aNameSeq( nPropCount ),
    aValueSeq( nPropCount )
{
    DBG_ASSERT( nPropCount > 0, "ScfMultiPSHelper::ScfMultiPSHelper - invalid sequence size" );
    DBG_ASSERT( ppPropNames && *ppPropNames, "ScfMultiPSHelper::ScfMultiPSHelper - no strings found" );

    const sal_Char** ppCurrName = ppPropNames;
    for( sal_Int32 nIndex = 0; nIndex < nPropCount; ++nIndex )
        aNameSeq[ nIndex ] = OUString::createFromAscii( *ppCurrName++ );
}

sal_Bool ScfMultiPSHelper::getPropertyValues(
        const uno::Reference< beans::XMultiPropertySet >& xMultiPS,
        const CSS::uno::Reference< CSS::beans::XPropertySet >& xPropSet )
{
    sal_Bool bSuccess = sal_False;
    try
    {
        if( xMultiPS.is() )         // first try the XMultiPropertySet
        {
            aValueSeq = xMultiPS->getPropertyValues( aNameSeq );
            bSuccess = sal_True;
        }
        else if( xPropSet.is() )    // then try the XPropertySet
        {
            for( sal_Int32 nIndex = 0; nIndex < aNameSeq.getLength(); ++nIndex )
                aValueSeq[ nIndex ] = xPropSet->getPropertyValue( aNameSeq[ nIndex ] );
            bSuccess = sal_True;
        }
    }
    catch( uno::Exception& )
    {
    }
    return bSuccess;
}

sal_Bool ScfMultiPSHelper::setPropertyValues(
        const uno::Reference< beans::XMultiPropertySet >& xMultiPS,
        const CSS::uno::Reference< CSS::beans::XPropertySet >& xPropSet )
{
    sal_Bool bSuccess = sal_False;
    try
    {
        if( xMultiPS.is() )
        {
            xMultiPS->setPropertyValues( aNameSeq, aValueSeq );
            bSuccess = sal_True;
        }
        else if( xPropSet.is() )
        {
            for( sal_Int32 nIndex = 0; nIndex < aNameSeq.getLength(); ++nIndex )
                xPropSet->setPropertyValue( aNameSeq[ nIndex ], aValueSeq[ nIndex ] );
            bSuccess = sal_True;
        }
    }
    catch( uno::Exception& )
    {
    }
    return bSuccess;
}


//___________________________________________________________________

