/*************************************************************************
 *
 *  $RCSfile: FilterProgressBar.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: dr $ $Date: 2001/11/19 13:42:06 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef PCH
#include "filt_pch.hxx"
#endif

#pragma hdrstop

//___________________________________________________________________

#ifndef _SC_FILTERPROGRESSBAR_HXX
#include "FilterProgressBar.hxx"
#endif

#ifndef SC_SCGLOB_HXX
#include "global.hxx"
#endif
#ifndef SC_PROGRESS_HXX
#include "progress.hxx"
#endif


//___________________________________________________________________
// struct ScfProgressSegment

ScfProgressBar::ScfProgressSegment::ScfProgressSegment( sal_uInt32 _nSize ) :
    pProgress( NULL ),
    nSize( _nSize ),
    nPos( 0 )
{
}

ScfProgressBar::ScfProgressSegment::~ScfProgressSegment()
{
    if( pProgress )
        delete pProgress;
}


//___________________________________________________________________
// class ScfProgressBar

ScfProgressBar::ScfProgressBar( sal_uInt16 nResStrId ) :
    pSysProgress( NULL ),
    pParentProgress( NULL ),
    pParentSegment( NULL ),
    pCurrSegment( NULL ),
    nTotalSize( 0 ),
    nTotalPos( 0 ),
    nUnitSize( 0 ),
    nNextUnitPos( 0 ),
    nResId( nResStrId ),
    bInProgress( sal_False )
{
}

ScfProgressBar::ScfProgressBar( ScfProgressBar* pParProgress, ScfProgressSegment* pParSegment ) :
    pSysProgress( NULL ),
    pParentProgress( pParProgress ),
    pParentSegment( pParSegment ),
    pCurrSegment( NULL ),
    nTotalSize( 0 ),
    nTotalPos( 0 ),
    nUnitSize( 0 ),
    nNextUnitPos( 0 ),
    nResId( 0 ),
    bInProgress( sal_False )
{
}

ScfProgressBar::~ScfProgressBar()
{
    if( pSysProgress )
        delete pSysProgress;
}

ScfProgressBar::ScfProgressSegment* ScfProgressBar::GetSegment( sal_uInt32 nSegment ) const
{
    if( nSegment == ~0UL )
        return NULL;
    DBG_ASSERT( aSegments.GetObject( nSegment ), "ScfProgressBar::GetSegment - invalid segment index" );
    return aSegments.GetObject( nSegment );
}

void ScfProgressBar::SetCurrSegment( ScfProgressSegment* pSegment )
{
    if( pCurrSegment != pSegment )
    {
        pCurrSegment = pSegment;

        if( pParentProgress && pParentSegment )
            pParentProgress->SetCurrSegment( pParentSegment );
        else if( !pSysProgress && nTotalSize )
            pSysProgress = new ScProgress( NULL, ScGlobal::GetRscString( nResId ), nTotalSize );

        if( !bInProgress && pCurrSegment && nTotalSize )
        {
            nUnitSize = nTotalSize / 256 + 1;   // at most 256 calls of system progress
            nNextUnitPos = 0;
            bInProgress = sal_True;
        }
    }
}

void ScfProgressBar::IncreaseProgressBar( sal_uInt32 nDelta )
{
    sal_uInt32 nNewPos = nTotalPos + nDelta;

    // call back to parent progress bar
    if( pParentProgress && pParentSegment )
    {
        // calculate new position of parent progress bar
        sal_uInt32 nParentPos = static_cast< sal_uInt32 >(
            static_cast< double >( nNewPos ) * pParentSegment->nSize / nTotalSize );
        pParentProgress->Progress( nParentPos );
    }
    // modify system progress bar
    else if( pSysProgress )
    {
        if( nNewPos >= nNextUnitPos )
        {
            nNextUnitPos = nNewPos + nUnitSize;
            pSysProgress->SetState( nNewPos );
        }
    }
    else
        DBG_ERROR( "ScfProgressBar::IncreaseProgressBar - no progress bar found" );

    nTotalPos = nNewPos;
}

sal_uInt32 ScfProgressBar::AddSegment( sal_uInt32 nSize )
{
    DBG_ASSERT( !bInProgress, "ScfProgressBar::AddSegment - already in progress mode" );
    if( !nSize )
        return ~0UL;

    aSegments.Append( new ScfProgressSegment( nSize ) );
    nTotalSize += nSize;
    return aSegments.Count() - 1;
}

ScfProgressBar& ScfProgressBar::GetSegmentProgressBar( sal_uInt32 nSegment )
{
    ScfProgressSegment* pSegment = GetSegment( nSegment );
    if( pSegment && !pSegment->pProgress )
        pSegment->pProgress = new ScfProgressBar( this, pSegment );
    return pSegment ? *pSegment->pProgress : *this;
}

void ScfProgressBar::ActivateSegment( sal_uInt32 nSegment )
{
    DBG_ASSERT( nTotalSize, "ScfProgressBar::ActivateSegment - progress range is zero" );
    if( nTotalSize )
        SetCurrSegment( GetSegment( nSegment ) );
}

void ScfProgressBar::Progress( sal_uInt32 nPos )
{
    DBG_ASSERT( bInProgress && pCurrSegment, "ScfProgressBar::Progress - no segment started" );
    if( pCurrSegment )
    {
        DBG_ASSERT( pCurrSegment->nPos <= nPos, "ScfProgressBar::Progress - delta pos < 0" );
        DBG_ASSERT( nPos <= pCurrSegment->nSize, "ScfProgressBar::Progress - segment overflow" );
        if( (pCurrSegment->nPos < nPos) && (nPos <= pCurrSegment->nSize) )
        {
            IncreaseProgressBar( nPos - pCurrSegment->nPos );
            pCurrSegment->nPos = nPos;
        }
    }
}


//___________________________________________________________________

