/*************************************************************************
 *
 *  $RCSfile: XclChartsApiHelper.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: dr $ $Date: 2001/11/28 16:38:09 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef PCH
#include "filt_pch.hxx"
#endif

#pragma hdrstop

//------------------------------------------------------------------------

#ifndef _SC_XCLCHARTSAPIHELPER_HXX
#include "XclChartsApiHelper.hxx"
#endif

#ifndef _COM_SUN_STAR_AWT_FONTUNDERLINE_HPP_
#include <com/sun/star/awt/FontUnderline.hpp>
#endif
#ifndef _COM_SUN_STAR_AWT_FONTSLANT_HPP_
#include <com/sun/star/awt/FontSlant.hpp>
#endif

#ifndef _COMPHELPER_TYPES_HXX_
#include <comphelper/types.hxx>
#endif
#ifndef _TOOLKIT_HELPER_VCLUNOHELPER_HXX_
#include <toolkit/unohlp.hxx>
#endif

#ifndef _SC_XCLTOOLS_HXX
#include "XclTools.hxx"
#endif
#ifndef _CHRTDEFS_HXX
#include "chrtdefs.hxx"
#endif

using namespace ::rtl;
using namespace ::com::sun::star;


//_____________________________________________________________________________
// class XclLineMultiPSHelper - line properties

// ----- property names for line style - without dash -----

// MUST be sorted alphabetically
const sal_Char* ppLineMultiPSNames_NoDash[] =
{
    "LineColor",
    "LineStyle",
    "LineTransparence",
    "LineWidth"
};

const sal_Int32 nLineMultiPSSize_NoDash = sizeof( ppLineMultiPSNames_NoDash ) / sizeof( sal_Char* );

#define PROPINDEX_LINECOLOR_NODASH          0
#define PROPINDEX_LINESTYLE_NODASH          1
#define PROPINDEX_LINETRANSP_NODASH         2
#define PROPINDEX_LINEWIDTH_NODASH          3


// ----- property names for line style - with dash -----

// MUST be sorted alphabetically
const sal_Char* ppLineMultiPSNames_Dash[] =
{
    "LineColor",
    "LineDash",
    "LineStyle",
    "LineTransparence",
    "LineWidth"
};

const sal_Int32 nLineMultiPSSize_Dash = sizeof( ppLineMultiPSNames_Dash ) / sizeof( sal_Char* );

#define PROPINDEX_LINECOLOR_DASH            0
#define PROPINDEX_LINEDASH_DASH             1
#define PROPINDEX_LINESTYLE_DASH            2
#define PROPINDEX_LINETRANSP_DASH           3
#define PROPINDEX_LINEWIDTH_DASH            4



// ----- class XclLineMultiPSHelper -----

XclLineMultiPSHelper::XclLineMultiPSHelper() :
    aMultiPSHelper_NoDash( ppLineMultiPSNames_NoDash, nLineMultiPSSize_NoDash ),
    aMultiPSHelper_Dash( ppLineMultiPSNames_Dash, nLineMultiPSSize_Dash )
{
}

sal_Bool XclLineMultiPSHelper::setProperties(
        const uno::Reference< beans::XMultiPropertySet >& xMultiPS,
        const uno::Reference< beans::XPropertySet >& xPropSet,
        drawing::LineStyle eStyle,
        const drawing::LineDash* pDash,
        sal_Int32 nWidth,
        sal_Int16 nTransp,
        sal_Int32 nRGBColor )
{
    if( !xMultiPS.is() && !xPropSet.is() )
        return sal_False;

    sal_Bool bRet;
    if( (eStyle == drawing::LineStyle_DASH) && pDash )
    {
        aMultiPSHelper_Dash.getAny( PROPINDEX_LINESTYLE_DASH )  <<= eStyle;
        aMultiPSHelper_Dash.getAny( PROPINDEX_LINEWIDTH_DASH )  <<= nWidth;
        aMultiPSHelper_Dash.getAny( PROPINDEX_LINECOLOR_DASH )  <<= nRGBColor;
        aMultiPSHelper_Dash.getAny( PROPINDEX_LINETRANSP_DASH ) <<= nTransp;
        aMultiPSHelper_Dash.getAny( PROPINDEX_LINEDASH_DASH )   <<= *pDash;
        bRet = aMultiPSHelper_Dash.setPropertyValues( xMultiPS, xPropSet );
    }
    else
    {
        aMultiPSHelper_NoDash.getAny( PROPINDEX_LINESTYLE_NODASH )  <<= eStyle;
        aMultiPSHelper_NoDash.getAny( PROPINDEX_LINEWIDTH_NODASH )  <<= nWidth;
        aMultiPSHelper_NoDash.getAny( PROPINDEX_LINECOLOR_NODASH )  <<= nRGBColor;
        aMultiPSHelper_NoDash.getAny( PROPINDEX_LINETRANSP_NODASH ) <<= nTransp;
        bRet = aMultiPSHelper_NoDash.setPropertyValues( xMultiPS, xPropSet );
    }

    return bRet;
}



//_____________________________________________________________________________
// class XclAreaMultiPSHelper - area properties

// ----- property names for solid area style -----

// MUST be sorted alphabetically
const sal_Char* ppAreaMultiPSNames_Solid[] =
{
    "FillColor",
    "FillStyle"
};

const sal_Int32 nAreaMultiPSSize_Solid = sizeof( ppAreaMultiPSNames_Solid ) / sizeof( sal_Char* );

#define PROPINDEX_FILLCOLOR_SOLID           0
#define PROPINDEX_FILLSTYLE_SOLID           1



// ----- property names for gradient area style -----

// MUST be sorted alphabetically
const sal_Char* ppAreaMultiPSNames_Gradient[] =
{
    "FillGradient",
    "FillGradientStepCount",
    "FillStyle"
};

const sal_Int32 nAreaMultiPSSize_Gradient = sizeof( ppAreaMultiPSNames_Gradient ) / sizeof( sal_Char* );

#define PROPINDEX_FILLGRADIENT_GRADIENT     0
#define PROPINDEX_FILLGRADIENTST_GRADIENT   1
#define PROPINDEX_FILLSTYLE_GRADIENT        2



// ----- class XclAraeMultiPSHelper -----

XclAreaMultiPSHelper::XclAreaMultiPSHelper() :
    aMultiPSHelper_Solid( ppAreaMultiPSNames_Solid, nAreaMultiPSSize_Solid ),
    aMultiPSHelper_Gradient( ppAreaMultiPSNames_Gradient, nAreaMultiPSSize_Gradient )
{
}

sal_Bool XclAreaMultiPSHelper::setProperties(
        const uno::Reference< beans::XMultiPropertySet >& xMultiPS,
        const uno::Reference< beans::XPropertySet >& xPropSet,
        drawing::FillStyle eStyle,
        sal_Int32 nRGBColor )
{
    if( !xMultiPS.is() && !xPropSet.is() )
        return sal_False;

    aMultiPSHelper_Solid.getAny( PROPINDEX_FILLSTYLE_SOLID ) <<= eStyle;
    aMultiPSHelper_Solid.getAny( PROPINDEX_FILLCOLOR_SOLID ) <<= nRGBColor;

    return aMultiPSHelper_Solid.setPropertyValues( xMultiPS, xPropSet );
}

sal_Bool XclAreaMultiPSHelper::setProperties(
        const uno::Reference< beans::XMultiPropertySet >& xMultiPS,
        const uno::Reference< beans::XPropertySet >& xPropSet,
        const awt::Gradient& rGradient )
{
    if( !xMultiPS.is() && !xPropSet.is() )
        return sal_False;

    aMultiPSHelper_Gradient.getAny( PROPINDEX_FILLSTYLE_GRADIENT )      <<= drawing::FillStyle_GRADIENT;
    aMultiPSHelper_Gradient.getAny( PROPINDEX_FILLGRADIENT_GRADIENT )   <<= rGradient;
    aMultiPSHelper_Gradient.getAny( PROPINDEX_FILLGRADIENTST_GRADIENT ) <<= rGradient.StepCount;

    return aMultiPSHelper_Gradient.setPropertyValues( xMultiPS, xPropSet );
}



//_____________________________________________________________________________
// class XclFontMultiPSHelper - converting font settings

/// Converts Excel character weight to API character weight.
float lcl_GetApiFontWeight( sal_uInt16 nXclWeight )
{
    FontWeight eWeight;

    if( !nXclWeight )
        eWeight = WEIGHT_DONTKNOW;
    else if( nXclWeight <= EXC_FONTWGHT_THIN )
        eWeight = WEIGHT_THIN;
    else if( nXclWeight <= EXC_FONTWGHT_ULTRALIGHT )
        eWeight = WEIGHT_ULTRALIGHT;
    else if( nXclWeight <= EXC_FONTWGHT_LIGHT )
        eWeight = WEIGHT_LIGHT;
    else if( nXclWeight <= EXC_FONTWGHT_SEMILIGHT )
        eWeight = WEIGHT_SEMILIGHT;
    else if( nXclWeight <= EXC_FONTWGHT_NORMAL )
        eWeight = WEIGHT_NORMAL;
    else if( nXclWeight <= EXC_FONTWGHT_MEDIUM )
        eWeight = WEIGHT_MEDIUM;
    else if( nXclWeight <= EXC_FONTWGHT_SEMIBOLD )
        eWeight = WEIGHT_SEMIBOLD;
    else if( nXclWeight <= EXC_FONTWGHT_BOLD )
        eWeight = WEIGHT_BOLD;
    else if( nXclWeight <= EXC_FONTWGHT_ULTRABOLD )
        eWeight = WEIGHT_ULTRABOLD;
    else
        eWeight = WEIGHT_BLACK;

    return VCLUnoHelper::ConvertFontWeight( eWeight );
}

/// Converts Excel underline style to API underline style.
sal_uInt16 lcl_GetApiUnderline( XclUnderline eXclUnderl )
{
    switch( eXclUnderl )
    {
        case xlUnderlNone:          return awt::FontUnderline::NONE;
        case xlUnderlSingle:
        case xlUnderlSingleAcc:     return awt::FontUnderline::SINGLE;
        case xlUnderlDouble:
        case xlUnderlDoubleAcc:     return awt::FontUnderline::DOUBLE;
    }
    return awt::FontUnderline::NONE;
}



// ----- property names for font settings -----

// MUST be sorted alphabetically
const sal_Char* ppFontMultiPSNames[] =
{
    "CharContoured",
    "CharCrossedOut",
    "CharFontName",
    "CharHeight",
    "CharPosture",
    "CharShadowed",
    "CharUnderline",
    "CharWeight"
};

const sal_Int32 nFontMultiPSSize = sizeof( ppFontMultiPSNames ) / sizeof( sal_Char* );

#define PROPINDEX_CHARCOUNTOURED            0
#define PROPINDEX_CHARCROSSEDOUT            1
#define PROPINDEX_CHARFONTNAME              2
#define PROPINDEX_CHARHEIGHT                3
#define PROPINDEX_CHARPOSTURE               4
#define PROPINDEX_CHARSHADOWED              5
#define PROPINDEX_CHARUNDERLINE             6
#define PROPINDEX_CHARWEIGHT                7



// ----- class XclFontMultiPSHelper -----

XclFontMultiPSHelper::XclFontMultiPSHelper() :
    ScfMultiPSHelper( ppFontMultiPSNames, nFontMultiPSSize )
{
}

sal_Bool XclFontMultiPSHelper::setProperties(
        const uno::Reference< beans::XMultiPropertySet >& xMultiPS,
        const uno::Reference< beans::XPropertySet >& xPropSet,
        const XclFontData& rFontData )
{
    if( !xMultiPS.is() && !xPropSet.is() )
        return sal_False;

    getAny( PROPINDEX_CHARFONTNAME )    <<= OUString( rFontData.aName );
    getAny( PROPINDEX_CHARHEIGHT )      <<= static_cast< float >( rFontData.nHeight / 20.0 );
    getAny( PROPINDEX_CHARPOSTURE )     <<= rFontData.bItalic ? awt::FontSlant_ITALIC : awt::FontSlant_NONE;
    getAny( PROPINDEX_CHARUNDERLINE )   <<= lcl_GetApiUnderline( rFontData.eUnderline );
    getAny( PROPINDEX_CHARWEIGHT )      <<= lcl_GetApiFontWeight( rFontData.nWeight );

    ::comphelper::setBOOL( getAny( PROPINDEX_CHARCOUNTOURED ), rFontData.bOutline );
    ::comphelper::setBOOL( getAny( PROPINDEX_CHARCROSSEDOUT ), rFontData.bStrikeout );
    ::comphelper::setBOOL( getAny( PROPINDEX_CHARSHADOWED ), rFontData.bShadow );

    return setPropertyValues( xMultiPS, xPropSet );
}



//_____________________________________________________________________________

